/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.server;

import com.perforce.p4java.server.AbstractAuthHelper;
import com.perforce.p4java.server.AuthTicket;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.lang3.StringUtils;

public class AuthTicketsHelper
extends AbstractAuthHelper {
    private static final AuthTicket[] EMPTY = new AuthTicket[0];
    private static final Map<String, String> ticketsMap = new ConcurrentHashMap<String, String>();

    public static String getTicketValue(String userName, String serverAddress, String ticketsFilePath) throws IOException {
        String ticketValue = null;
        AuthTicket ticket = AuthTicketsHelper.getTicket(userName, serverAddress, ticketsFilePath);
        if (Objects.nonNull(ticket)) {
            ticketValue = ticket.getTicketValue();
        }
        return ticketValue;
    }

    public static AuthTicket getTicket(String userName, String serverAddress, String ticketsFilePath) throws IOException {
        Object p4Port = serverAddress;
        AuthTicket foundTicket = null;
        if (Objects.nonNull(serverAddress)) {
            if (serverAddress.indexOf(58) == -1) {
                p4Port = "localhost:" + serverAddress;
            }
            for (AuthTicket ticket : AuthTicketsHelper.getTickets(ticketsFilePath)) {
                if (!((String)p4Port).equals(ticket.getServerAddress()) || !StringUtils.isBlank((CharSequence)userName) && !userName.equals(ticket.getUserName())) continue;
                foundTicket = ticket;
                break;
            }
        }
        return foundTicket;
    }

    public static AuthTicket[] getTickets(String ticketsFilePath) throws IOException {
        File file = StringUtils.isNotBlank((CharSequence)ticketsFilePath) ? new File(ticketsFilePath) : null;
        return AuthTicketsHelper.getTickets(file);
    }

    public static AuthTicket[] getTickets(File ticketsFile) throws IOException {
        List<Map<String, String>> authList;
        AuthTicket[] tickets = EMPTY;
        List<Map<String, String>> list = authList = Objects.nonNull(ticketsFile) ? AuthTicketsHelper.getFileEntries(ticketsFile) : AuthTicketsHelper.getMemoryEntries(ticketsMap);
        if (Objects.nonNull(authList)) {
            CopyOnWriteArrayList<AuthTicket> ticketList = new CopyOnWriteArrayList<AuthTicket>();
            for (Map<String, String> map : authList) {
                if (!Objects.nonNull(map)) continue;
                String serverAddress = map.get("serverAddress");
                String userName = map.get("userName");
                String ticketValue = map.get("authValue");
                AuthTicket ticket = new AuthTicket(serverAddress, userName, ticketValue);
                ticketList.add(ticket);
            }
            tickets = ticketList.toArray(new AuthTicket[ticketList.size()]);
        }
        return tickets;
    }

    public static AuthTicket getTicket(String serverAddress, String ticketsFilePath) throws IOException {
        return AuthTicketsHelper.getTicket(null, serverAddress, ticketsFilePath);
    }

    public static void saveTicket(AuthTicket ticket, String ticketsFilePath) throws IOException {
        File file = StringUtils.isNotBlank((CharSequence)ticketsFilePath) ? new File(ticketsFilePath) : null;
        AuthTicketsHelper.saveTicket(ticket, file);
    }

    public static void saveTicket(AuthTicket ticket, File ticketsFile) throws IOException {
        if (Objects.nonNull(ticket)) {
            AuthTicketsHelper.saveTicket(ticket.getUserName(), ticket.getServerAddress(), ticket.getTicketValue(), ticketsFile);
        }
    }

    public static void saveTicket(String userName, String serverAddress, String ticketValue, String ticketsFilePath) throws IOException {
        File file = StringUtils.isNotBlank((CharSequence)ticketsFilePath) ? new File(ticketsFilePath) : null;
        AuthTicketsHelper.saveTicket(userName, serverAddress, ticketValue, file);
    }

    public static void saveTicket(String userName, String serverAddress, String ticketValue, File ticketsFile) throws IOException {
        AuthTicketsHelper.saveTicket(userName, serverAddress, ticketValue, ticketsFile, 0, 0L, 0L);
    }

    public static void saveTicket(String userName, String serverAddress, String ticketValue, String ticketsFilePath, int lockTry, long lockDelay, long lockWait) throws IOException {
        File file = StringUtils.isNotBlank((CharSequence)ticketsFilePath) ? new File(ticketsFilePath) : null;
        AuthTicketsHelper.saveTicket(userName, serverAddress, ticketValue, file, lockTry, lockDelay, lockWait);
    }

    public static void saveTicket(String userName, String serverAddress, String ticketValue, File ticketsFile, int lockTry, long lockDelay, long lockWait) throws IOException {
        if (Objects.nonNull(ticketsFile)) {
            AuthTicketsHelper.saveFileEntry(userName, serverAddress, ticketValue, ticketsFile, lockTry, lockDelay, lockWait);
        } else {
            AuthTicketsHelper.saveMemoryEntry(userName, serverAddress, ticketValue, ticketsMap);
        }
    }
}

