/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.server.cmd;

import com.perforce.p4java.core.IFix;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.exception.RequestException;
import com.perforce.p4java.impl.generic.core.Fix;
import com.perforce.p4java.impl.mapbased.server.Parameters;
import com.perforce.p4java.impl.mapbased.server.cmd.BaseDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.ResultListBuilder;
import com.perforce.p4java.option.server.GetFixesOptions;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.delegator.IFixesDelegator;
import java.util.List;
import java.util.Map;

public class FixesDelegator
extends BaseDelegator
implements IFixesDelegator {
    public FixesDelegator(IOptionsServer server) {
        super(server);
    }

    @Override
    public List<IFix> getFixList(List<IFileSpec> fileSpecs, int changeListId, String jobId, boolean includeIntegrations, int maxFixes) throws ConnectionException, RequestException, AccessException {
        try {
            int resolvedChangelistId = changeListId;
            if (changeListId == 0) {
                resolvedChangelistId = -1;
            }
            GetFixesOptions getFixesOptions = new GetFixesOptions().setChangelistId(resolvedChangelistId).setIncludeIntegrations(includeIntegrations).setJobId(jobId).setMaxFixes(maxFixes);
            return this.getFixes(fileSpecs, getFixesOptions);
        }
        catch (AccessException | ConnectionException | RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public List<IFix> getFixes(List<IFileSpec> fileSpecs, GetFixesOptions opts) throws P4JavaException {
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.FIXES, Parameters.processParameters(opts, fileSpecs, this.server), null);
        return ResultListBuilder.buildNonNullObjectListFromCommandResultMaps(resultMaps, map -> new Fix((Map<String, Object>)map));
    }
}

