/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.packet;

import com.perforce.p4java.CharsetDefs;
import com.perforce.p4java.Log;
import com.perforce.p4java.exception.NullPointerError;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.exception.ProtocolError;
import com.perforce.p4java.impl.mapbased.rpc.connection.RpcConnection;
import com.perforce.p4java.impl.mapbased.rpc.packet.RpcPacket;
import com.perforce.p4java.impl.mapbased.rpc.packet.RpcPacketFieldType;
import com.perforce.p4java.impl.mapbased.rpc.packet.helper.RpcPacketFieldRule;
import java.io.UnsupportedEncodingException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class RpcPacketField {
    public static final String TRACE_PREFIX = "RpcPacketField";
    public static final int NUM_ELEMENTS = 2;
    public static final int NAME_FIELD = 0;
    public static final int VALUE_FIELD = 1;
    private String name = null;
    private Object value = null;

    public RpcPacketField(String name, Object value) {
        this.name = name;
        this.value = value;
    }

    public static Object[] retrievePacketField(ByteBuffer buf, boolean isUnicodeServer, Charset charset) {
        return RpcPacketField.retrievePacketField(buf, isUnicodeServer, charset, null);
    }

    public static Object[] retrievePacketField(ByteBuffer buf, boolean isUnicodeServer, Charset charset, RpcPacketFieldRule fieldRule) {
        int remaining;
        if (buf == null) {
            throw new NullPointerError("Null byte buffer passed to RpcPacketField.retrievePacketField()");
        }
        Object[] retVal = new Object[]{null, null};
        int INITIAL_BYTEARRAY_SIZE = 128;
        byte[] bytes = new byte[128];
        int i = 0;
        while ((bytes[i] = buf.get()) != 0) {
            if (++i < bytes.length) continue;
            byte[] newBytes = new byte[bytes.length + 128];
            System.arraycopy(bytes, 0, newBytes, 0, bytes.length);
            bytes = newBytes;
        }
        if (i > 0) {
            try {
                retVal[0] = new String(bytes, 0, i, charset == null ? RpcConnection.NON_UNICODE_SERVER_CHARSET_NAME : (isUnicodeServer ? CharsetDefs.UTF8_NAME : charset.name()));
            }
            catch (UnsupportedEncodingException e) {
                Log.exception(e);
            }
        }
        if ((remaining = buf.remaining()) < 4) {
            throw new ProtocolError("Insufficient bytes in buffer to retrieve text value field length");
        }
        byte[] lengthBytes = new byte[4];
        buf.get(lengthBytes);
        int valLength = RpcPacket.decodeInt4(lengthBytes);
        if (valLength < 0) {
            throw new ProtocolError("Negative text field value length in P4JRpcTextField initializer: " + valLength);
        }
        if (remaining < valLength) {
            throw new ProtocolError("Insufficient bytes in buffer to retrieve text value field");
        }
        byte[] valBytes = new byte[valLength];
        buf.get(valBytes);
        String fieldName = (String)retVal[0];
        boolean skipConversion = false;
        if (fieldRule != null) {
            fieldRule.update(fieldName);
            skipConversion = fieldRule.isSkipConversion();
        }
        if (!skipConversion && RpcPacketFieldType.getFieldType((String)retVal[0]) == RpcPacketFieldType.TEXT) {
            try {
                retVal[1] = new String(valBytes, charset == null ? RpcConnection.NON_UNICODE_SERVER_CHARSET_NAME : (isUnicodeServer ? CharsetDefs.UTF8_NAME : charset.name()));
            }
            catch (UnsupportedEncodingException e) {
                Log.exception(e);
            }
        } else {
            retVal[1] = valBytes;
        }
        buf.get();
        return retVal;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public static void marshal(ByteBuffer buf, String name, String value, Charset charset) throws BufferOverflowException, UnsupportedEncodingException {
        RpcPacketField.marshal(buf, name, value == null ? null : value.getBytes(charset == null ? CharsetDefs.DEFAULT.name() : charset.name()));
    }

    public static void marshal(ByteBuffer buf, String name, StringBuffer value, Charset charset) throws BufferOverflowException, UnsupportedEncodingException {
        RpcPacketField.marshal(buf, name, value == null ? null : value.toString().getBytes(charset == null ? CharsetDefs.DEFAULT.name() : charset.name()));
    }

    public static void marshal(ByteBuffer buf, String name, byte[] value) throws BufferOverflowException {
        if (buf == null) {
            throw new NullPointerError("Null byte buffer passed to RpcPacketField.marshal()");
        }
        try {
            if (name != null) {
                buf.put(name.getBytes(CharsetDefs.DEFAULT.name()));
            }
            buf.put((byte)0);
            int valLength = 0;
            if (value != null) {
                valLength = value.length;
            }
            buf.put(RpcPacket.encodeInt4(valLength));
            if (value != null) {
                buf.put(value);
            }
            buf.put((byte)0);
        }
        catch (BufferOverflowException boe) {
            throw boe;
        }
        catch (Throwable thr) {
            Log.error("Unexpected exception: " + thr.getLocalizedMessage(), new Object[0]);
            Log.exception(thr);
            throw new P4JavaError(thr.getLocalizedMessage());
        }
    }

    public static void marshal(ByteBuffer buf, String name, ByteBuffer value) throws BufferOverflowException {
        if (buf == null) {
            throw new NullPointerError("Null byte buffer passed to RpcPacketField.marshal()");
        }
        try {
            if (name != null) {
                buf.put(name.getBytes(CharsetDefs.DEFAULT.name()));
            }
            buf.put((byte)0);
            int valLength = 0;
            if (value != null) {
                valLength = value.limit();
            }
            buf.put(RpcPacket.encodeInt4(valLength));
            if (value != null) {
                buf.put(value);
            }
            buf.put((byte)0);
        }
        catch (Throwable thr) {
            Log.error("Unexpected exception: " + thr.getLocalizedMessage(), new Object[0]);
            Log.exception(thr);
            throw new P4JavaError("Unexpected exception in RpcPacketField.marshal(ByteBuffer): " + thr.getLocalizedMessage(), thr);
        }
    }

    public static void marshal(byte[] buf, String name, byte[] value) throws BufferOverflowException {
        throw new P4JavaError("Called unimplemented marshall method");
    }
}

