/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.common.base;

import org.apache.commons.lang3.StringUtils;

public class StringHelper {
    private StringHelper() {
    }

    public static String format(String template, Object ... args) {
        int placeholderStart;
        template = String.valueOf(template);
        StringBuilder builder = new StringBuilder(template.length() + 16 * args.length);
        int templateStart = 0;
        int i = 0;
        while (i < args.length && (placeholderStart = template.indexOf("%s", templateStart)) != -1) {
            builder.append(template.substring(templateStart, placeholderStart));
            builder.append(args[i++]);
            templateStart = placeholderStart + 2;
        }
        builder.append(template.substring(templateStart));
        if (i < args.length) {
            builder.append(" [");
            builder.append(args[i++]);
            while (i < args.length) {
                builder.append(", ");
                builder.append(args[i++]);
            }
            builder.append(']');
        }
        return builder.toString();
    }

    public static String firstNonBlank(String first, String second) {
        return StringUtils.isNotBlank((CharSequence)first) ? first : second;
    }

    public static String firstConditionIsTrue(boolean expression, String first, String second) {
        return expression ? first : second;
    }
}

