/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.server.cmd;

import com.perforce.p4java.admin.IProperty;
import com.perforce.p4java.common.function.Function;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.impl.generic.admin.Property;
import com.perforce.p4java.impl.mapbased.server.Parameters;
import com.perforce.p4java.impl.mapbased.server.cmd.BaseDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.ResultListBuilder;
import com.perforce.p4java.impl.mapbased.server.cmd.ResultMapParser;
import com.perforce.p4java.option.Options;
import com.perforce.p4java.option.server.GetPropertyOptions;
import com.perforce.p4java.option.server.PropertyOptions;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.IServer;
import com.perforce.p4java.server.delegator.IPropertyDelegator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class PropertyDelegator
extends BaseDelegator
implements IPropertyDelegator {
    public PropertyDelegator(IOptionsServer server) {
        super(server);
    }

    @Override
    public String setProperty(String name, String value, PropertyOptions opts) throws P4JavaException {
        if (StringUtils.isBlank((CharSequence)name) && (opts == null || StringUtils.isBlank((CharSequence)opts.getName()))) {
            throw new IllegalArgumentException("Property/option name shouldn't null or empty");
        }
        if (StringUtils.isBlank((CharSequence)value) && (opts == null || StringUtils.isBlank((CharSequence)opts.getValue()))) {
            throw new IllegalArgumentException("Property/option value shouldn't null or empty");
        }
        PropertyOptions propertyOptions = opts;
        if (Objects.isNull(opts)) {
            propertyOptions = new PropertyOptions();
        }
        if (StringUtils.isNotBlank((CharSequence)name)) {
            propertyOptions.setName(name);
        }
        if (StringUtils.isNotBlank((CharSequence)value)) {
            propertyOptions.setValue(value);
        }
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.PROPERTY, Parameters.processParameters((Options)propertyOptions, null, new String[]{"-a"}, (IServer)this.server), null);
        return ResultMapParser.parseCommandResultMapAsString(resultMaps);
    }

    @Override
    public List<IProperty> getProperty(GetPropertyOptions opts) throws P4JavaException {
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.PROPERTY, Parameters.processParameters((Options)opts, null, new String[]{"-l"}, (IServer)this.server), null);
        return ResultListBuilder.buildNonNullObjectListFromCommandResultMaps(resultMaps, new Function<Map, IProperty>(){

            @Override
            public IProperty apply(Map map) {
                return new Property(map);
            }
        });
    }

    @Override
    public String deleteProperty(String name, PropertyOptions opts) throws P4JavaException {
        String error = "Property/option name shouldn't null or empty";
        if (StringUtils.isBlank((CharSequence)name) && (opts == null || StringUtils.isBlank((CharSequence)opts.getName()))) {
            throw new IllegalArgumentException(error);
        }
        PropertyOptions propertyOptions = opts;
        if (Objects.isNull(opts)) {
            propertyOptions = new PropertyOptions();
        }
        if (StringUtils.isNotBlank((CharSequence)name)) {
            propertyOptions.setName(name);
        }
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.PROPERTY, Parameters.processParameters((Options)propertyOptions, null, new String[]{"-d"}, (IServer)this.server), null);
        return ResultMapParser.parseCommandResultMapAsString(resultMaps);
    }
}

