/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.server.cmd;

import com.perforce.p4java.common.base.P4JavaExceptions;
import com.perforce.p4java.core.IUser;
import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.ConfigException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.exception.RequestException;
import com.perforce.p4java.impl.mapbased.server.Parameters;
import com.perforce.p4java.impl.mapbased.server.cmd.BaseDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.ResultMapParser;
import com.perforce.p4java.option.Options;
import com.perforce.p4java.option.server.LoginOptions;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.IServer;
import com.perforce.p4java.server.delegator.ILoginDelegator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class LoginDelegator
extends BaseDelegator
implements ILoginDelegator {
    public LoginDelegator(IOptionsServer server) {
        super(server);
    }

    @Override
    public String getLoginStatus() throws P4JavaException {
        Map<String, Object> firstResultMap;
        String statusStr = "";
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.LOGIN, new String[]{"-s"}, null);
        if (Objects.nonNull(resultMaps) && !resultMaps.isEmpty() && StringUtils.isBlank((CharSequence)(statusStr = ResultMapParser.getInfoStr(firstResultMap = resultMaps.get(0))))) {
            statusStr = ResultMapParser.getErrorStr(firstResultMap);
        }
        return StringUtils.isBlank((CharSequence)statusStr) ? "" : statusStr;
    }

    @Override
    public void login(String password) throws ConnectionException, RequestException, AccessException, ConfigException {
        this.login(password, false);
    }

    @Override
    public void login(String password, boolean allHosts) throws ConnectionException, RequestException, AccessException, ConfigException {
        try {
            this.login(password, new LoginOptions().setAllHosts(allHosts));
        }
        catch (AccessException | ConnectionException | RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public boolean isDontWriteTicket(String cmd, String[] cmdArgs) {
        if (StringUtils.isNotBlank((CharSequence)cmd) && CmdSpec.LOGIN.toString().equalsIgnoreCase(cmd) && Objects.nonNull(cmdArgs)) {
            for (String arg : cmdArgs) {
                if (!StringUtils.isNotBlank((CharSequence)arg) || !"-p".equals(arg)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void login(String password, LoginOptions opts) throws P4JavaException {
        this.login(password, null, opts);
    }

    @Override
    public void login(String password, StringBuffer ticket, LoginOptions opts) throws P4JavaException {
        String actualPassword = password;
        if (StringUtils.isNotBlank((CharSequence)password)) {
            actualPassword = password + "\n";
        }
        LoginOptions actualOpts = opts;
        if (Objects.isNull(opts)) {
            actualOpts = new LoginOptions();
        }
        HashMap<String, Object> pwdMap = new HashMap<String, Object>();
        pwdMap.put("password", actualPassword);
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.LOGIN, Parameters.processParameters(actualOpts, this.server), pwdMap);
        String authTicket = null;
        String retVal = "";
        if (Objects.nonNull(resultMaps) && !resultMaps.isEmpty()) {
            Map<String, Object> firstResultMap = resultMaps.get(0);
            if (Objects.nonNull(firstResultMap) && !ResultMapParser.handleErrorStr(firstResultMap) && ResultMapParser.isInfoMessage(firstResultMap)) {
                retVal = ResultMapParser.getInfoStr(firstResultMap);
            } else if (firstResultMap.containsKey("ticket")) {
                authTicket = (String)firstResultMap.get("ticket");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)actualPassword) && StringUtils.isNotBlank((CharSequence)retVal)) {
            P4JavaExceptions.throwAccessExceptionIfConditionFails(!this.server.isLoginNotRequired(retVal), retVal, new Object[0]);
        }
        if (StringUtils.isBlank(authTicket)) {
            authTicket = this.server.getAuthTicket();
        }
        if (Objects.nonNull(ticket) && StringUtils.isNotBlank((CharSequence)authTicket)) {
            ticket.append(authTicket);
        }
    }

    @Override
    public void login(@Nonnull IUser user, StringBuffer ticket, LoginOptions opts) throws P4JavaException {
        Validate.notNull((Object)user);
        Validate.notBlank((CharSequence)user.getLoginName(), (String)"Login name shouldn't null or empty", (Object[])new Object[0]);
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.LOGIN, Parameters.processParameters((Options)opts, null, user.getLoginName(), (IServer)this.server), null);
        String authTicket = null;
        if (Objects.nonNull(resultMaps) && !resultMaps.isEmpty()) {
            for (Map<String, Object> map : resultMaps) {
                if (!Objects.nonNull(map)) continue;
                if (map.containsKey("ticket")) {
                    authTicket = (String)map.get("ticket");
                    continue;
                }
                ResultMapParser.handleErrorStr(map);
            }
        }
        if (StringUtils.isBlank(authTicket)) {
            authTicket = this.server.getAuthTicket(user.getLoginName());
        }
        if (Objects.nonNull(ticket) && StringUtils.isNotBlank(authTicket)) {
            ticket.append(authTicket);
        }
    }
}

