/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.server.cmd;

import com.perforce.p4java.Log;
import com.perforce.p4java.common.base.ObjectUtils;
import com.perforce.p4java.core.IStreamlog;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.impl.generic.core.Streamlog;
import com.perforce.p4java.impl.mapbased.server.Parameters;
import com.perforce.p4java.impl.mapbased.server.cmd.BaseDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.ResultMapParser;
import com.perforce.p4java.option.Options;
import com.perforce.p4java.option.server.StreamlogOptions;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.IServer;
import com.perforce.p4java.server.delegator.IStreamlogDelegator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class StreamlogDelegator
extends BaseDelegator
implements IStreamlogDelegator {
    public StreamlogDelegator(IOptionsServer server) {
        super(server);
    }

    @Override
    public Map<String, List<IStreamlog>> getStreamlog(List<String> streamPaths, StreamlogOptions opts) throws P4JavaException {
        String[] args = new String[]{};
        if (ObjectUtils.nonNull(streamPaths)) {
            args = streamPaths.toArray(new String[streamPaths.size()]);
        }
        HashMap<String, List<IStreamlog>> streamlogMap = new HashMap<String, List<IStreamlog>>();
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.STREAMLOG, Parameters.processParameters((Options)opts, null, args, (IServer)this.server), null);
        if (ObjectUtils.isNull(resultMaps)) {
            return streamlogMap;
        }
        for (Map<String, Object> StreamlogMap : resultMaps) {
            String errStr = ResultMapParser.handleFileErrorStr(StreamlogMap);
            if (StringUtils.isNotBlank((CharSequence)errStr)) {
                Log.error(errStr, new Object[0]);
                return streamlogMap;
            }
            ArrayList<Streamlog> streamlogList = new ArrayList<Streamlog>();
            int i = 0;
            while (StreamlogMap.containsKey("time" + i)) {
                streamlogList.add(new Streamlog(StreamlogMap, i));
                ++i;
            }
            String streamName = ((IStreamlog)streamlogList.get(0)).getStream();
            streamlogMap.put(streamName, streamlogList);
        }
        return streamlogMap;
    }
}

