/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.func.client;

import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.impl.mapbased.rpc.CommandEnv;
import com.perforce.p4java.impl.mapbased.server.Parameters;
import com.perforce.p4java.option.client.ParallelSyncOptions;
import com.perforce.p4java.option.client.SyncOptions;
import com.perforce.p4java.server.IServer;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;

public class ClientHelper {
    private ClientHelper() {
    }

    public static long sendBackWrittenDataBytes(CommandEnv cmdEnv, String filePath, long fileSize, long currentSize, long bytesRead) {
        long totalReadSize = currentSize;
        if (cmdEnv.getProtocolSpecs().isEnableProgress() && fileSize > 0L && bytesRead > 0L) {
            totalReadSize += bytesRead;
            HashMap<String, Object> dataSizeMap = new HashMap<String, Object>();
            dataSizeMap.put("path", filePath);
            dataSizeMap.put("fileSize", fileSize);
            dataSizeMap.put("currentSize", totalReadSize);
            cmdEnv.handleResult(dataSizeMap);
        }
        return totalReadSize;
    }

    public static String[] buildParallelOptions(IServer serverImpl, List<IFileSpec> fileSpecs, SyncOptions syncOpts, ParallelSyncOptions pSyncOpts) throws P4JavaException {
        StringBuilder parallelOptionsBuilder = new StringBuilder();
        parallelOptionsBuilder.append("--parallel=");
        if (pSyncOpts.getNumberOfThreads() > 0) {
            parallelOptionsBuilder.append("threads=" + pSyncOpts.getNumberOfThreads());
        } else {
            parallelOptionsBuilder.append("threads=0");
        }
        if (pSyncOpts.getMinimum() > 0) {
            parallelOptionsBuilder.append(",min=" + pSyncOpts.getMinimum());
        }
        if (pSyncOpts.getMinumumSize() > 0) {
            parallelOptionsBuilder.append(",minsize=" + pSyncOpts.getMinumumSize());
        }
        if (pSyncOpts.getBatch() > 0) {
            parallelOptionsBuilder.append(",batch=" + pSyncOpts.getBatch());
        }
        if (pSyncOpts.getBatchSize() > 0) {
            parallelOptionsBuilder.append(",batchSize=" + pSyncOpts.getBatchSize());
        }
        Object[] syncOptions = Parameters.processParameters(syncOpts, fileSpecs, serverImpl);
        Object[] po = new String[]{parallelOptionsBuilder.toString()};
        String[] mergedOptions = (String[])ArrayUtils.addAll((Object[])po, (Object[])syncOptions);
        return mergedOptions;
    }
}

