/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.server.cmd;

import com.perforce.p4java.Log;
import com.perforce.p4java.common.base.P4JavaExceptions;
import com.perforce.p4java.common.function.FunctionWithException;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.exception.RequestException;
import com.perforce.p4java.impl.mapbased.server.Parameters;
import com.perforce.p4java.impl.mapbased.server.cmd.BaseDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.ResultListBuilder;
import com.perforce.p4java.option.Options;
import com.perforce.p4java.option.server.MoveFileOptions;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.IServer;
import com.perforce.p4java.server.delegator.IMoveDelegator;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.Validate;

public class MoveDelegator
extends BaseDelegator
implements IMoveDelegator {
    public MoveDelegator(IOptionsServer server) {
        super(server);
    }

    @Override
    public List<IFileSpec> moveFile(int changelistId, boolean listOnly, boolean noClientMove, String fileType, @Nonnull IFileSpec fromFile, @Nonnull IFileSpec toFile) throws ConnectionException, RequestException, AccessException {
        Validate.notNull((Object)fromFile);
        Validate.notNull((Object)fromFile.getPreferredPath());
        Validate.notNull((Object)toFile);
        Validate.notNull((Object)toFile.getPreferredPath());
        int MIN_SUPPORTED_SERVER_VERSION = 20091;
        int MIN_SUPPORTED_SERVER__VERSION_OPTION_K = 20092;
        P4JavaExceptions.throwRequestExceptionIfPerforceServerVersionOldThanExpected(this.server.getServerVersion() >= 20091, "command requires a Perforce server version 2009.1 or later", new Object[0]);
        P4JavaExceptions.throwRequestExceptionIfPerforceServerVersionOldThanExpected(this.server.getServerVersion() >= 20092 || !noClientMove, "command option noClientMove requires a Perforce server version 2009.2 or later", new Object[0]);
        try {
            MoveFileOptions moveFileOptions = new MoveFileOptions().setChangelistId(changelistId).setFileType(fileType).setForce(false).setListOnly(listOnly).setNoClientMove(noClientMove);
            return this.moveFile(fromFile, toFile, moveFileOptions);
        }
        catch (AccessException | ConnectionException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            Log.warn("Unexpected exception in IServer.moveFile: " + exc, new Object[0]);
            return Collections.emptyList();
        }
    }

    @Override
    public List<IFileSpec> moveFile(@Nonnull IFileSpec fromFile, @Nonnull IFileSpec toFile, @Nullable MoveFileOptions opts) throws P4JavaException {
        Validate.notNull((Object)fromFile);
        Validate.notNull((Object)fromFile.getPreferredPath());
        Validate.notNull((Object)toFile);
        Validate.notNull((Object)toFile.getPreferredPath());
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.MOVE, Parameters.processParameters((Options)opts, null, new String[]{fromFile.getPreferredPath().toString(), toFile.getPreferredPath().toString()}, (IServer)this.server), null);
        return ResultListBuilder.buildNonNullObjectListFromCommandResultMaps(resultMaps, P4JavaExceptions.rethrowFunction(new FunctionWithException<Map, IFileSpec>(){

            @Override
            public IFileSpec apply(Map map) throws P4JavaException {
                return ResultListBuilder.handleFileReturn(map, MoveDelegator.this.server);
            }
        }));
    }
}

