/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.server.cmd;

import com.perforce.p4java.core.IExtension;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.impl.generic.core.Extension;
import com.perforce.p4java.impl.generic.core.InputMapper;
import com.perforce.p4java.impl.mapbased.server.cmd.BaseDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.ResultMapParser;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.delegator.IExtensionDelegator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class ExtensionDelegator
extends BaseDelegator
implements IExtensionDelegator {
    public ExtensionDelegator(IOptionsServer server) {
        super(server);
    }

    @Override
    public String sampleExtension(String extnName) throws P4JavaException {
        String[] args = new String[]{"--sample", extnName};
        List<Map<String, Object>> result = this.server.execMapCmdList(CmdSpec.EXTENSION, args, null);
        return ResultMapParser.parseCommandResultMapAsString(result);
    }

    @Override
    public String packageExtension(String dirName) throws P4JavaException {
        String[] args = new String[]{"--package", dirName};
        List<Map<String, Object>> resultsMap = this.server.execMapCmdList(CmdSpec.EXTENSION, args, null);
        return ResultMapParser.parseCommandResultMapAsString(resultsMap);
    }

    @Override
    public String installExtension(String extnPackageName, boolean allowUnsigned) throws P4JavaException {
        String[] args = allowUnsigned ? new String[]{"-y", "--allow-unsigned", "--install", extnPackageName} : new String[]{"-y", "--install", extnPackageName};
        List<Map<String, Object>> result = this.server.execMapCmdList(CmdSpec.EXTENSION, args, null);
        return ResultMapParser.parseCommandResultMapAsString(result);
    }

    @Override
    public String createExtensionConfig(IExtension extension, String namespace, @Nullable String instanceConfig) throws P4JavaException {
        return this.updateExtensionConfig(extension, namespace, instanceConfig);
    }

    @Override
    public String updateExtensionConfig(IExtension extension, String namespace, @Nullable String instanceConfig) throws P4JavaException {
        String[] args = StringUtils.isNotEmpty((CharSequence)instanceConfig) ? new String[]{"--configure", namespace + "::" + extension.getExtName(), "--name", instanceConfig, "-i"} : new String[]{"--configure", namespace + "::" + extension.getExtName(), "-i"};
        List<Map<String, Object>> result = this.server.execMapCmdList(CmdSpec.EXTENSION, args, InputMapper.map(extension));
        return ResultMapParser.parseCommandResultMapIfIsInfoMessageAsString(result);
    }

    @Override
    public List<Map<String, Object>> listExtensions(String type) throws P4JavaException {
        String[] args = new String[]{"--list", "--type", type};
        List<Map<String, Object>> result = this.server.execMapCmdList(CmdSpec.EXTENSION, args, null);
        return result;
    }

    @Override
    public String deleteExtension(String namespace, String extnName) throws P4JavaException {
        String[] args = new String[]{"-y", "--delete", namespace + "::" + extnName};
        List<Map<String, Object>> result = this.server.execMapCmdList(CmdSpec.EXTENSION, args, null);
        return ResultMapParser.parseCommandResultMapAsString(result);
    }

    @Override
    public Extension getExtension(String namespace, String name, String instanceName) throws P4JavaException {
        String[] args = StringUtils.isBlank((CharSequence)instanceName) ? new String[]{"--configure", namespace + "::" + name, "-o"} : new String[]{"--configure", namespace + "::" + name, "--name", instanceName, "-o"};
        List<Map<String, Object>> result = this.server.execMapCmdList("extension", args, null);
        Extension extension = new Extension(result.get(0));
        return extension;
    }
}

