/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.server;

import com.perforce.p4java.CharsetDefs;
import com.perforce.p4java.Log;
import com.perforce.p4java.admin.IDbSchema;
import com.perforce.p4java.admin.IDiskSpace;
import com.perforce.p4java.admin.ILogTail;
import com.perforce.p4java.admin.IProperty;
import com.perforce.p4java.admin.IProtectionEntry;
import com.perforce.p4java.admin.ITriggerEntry;
import com.perforce.p4java.admin.ServerConfigurationValue;
import com.perforce.p4java.client.IClient;
import com.perforce.p4java.client.IClientSummary;
import com.perforce.p4java.common.base.ObjectUtils;
import com.perforce.p4java.common.base.P4JavaExceptions;
import com.perforce.p4java.core.IBranchSpec;
import com.perforce.p4java.core.IBranchSpecSummary;
import com.perforce.p4java.core.IChangelist;
import com.perforce.p4java.core.IChangelistSummary;
import com.perforce.p4java.core.IDepot;
import com.perforce.p4java.core.IExtension;
import com.perforce.p4java.core.IFileDiff;
import com.perforce.p4java.core.IFileLineMatch;
import com.perforce.p4java.core.IFix;
import com.perforce.p4java.core.IJob;
import com.perforce.p4java.core.IJobSpec;
import com.perforce.p4java.core.ILabel;
import com.perforce.p4java.core.ILabelSummary;
import com.perforce.p4java.core.ILicense;
import com.perforce.p4java.core.ILicenseLimits;
import com.perforce.p4java.core.IRepo;
import com.perforce.p4java.core.IReviewChangelist;
import com.perforce.p4java.core.IServerProcess;
import com.perforce.p4java.core.IStream;
import com.perforce.p4java.core.IStreamIntegrationStatus;
import com.perforce.p4java.core.IStreamSummary;
import com.perforce.p4java.core.IUser;
import com.perforce.p4java.core.IUserGroup;
import com.perforce.p4java.core.IUserSummary;
import com.perforce.p4java.core.file.DiffType;
import com.perforce.p4java.core.file.FileSpecOpStatus;
import com.perforce.p4java.core.file.FileStatAncilliaryOptions;
import com.perforce.p4java.core.file.FileStatOutputOptions;
import com.perforce.p4java.core.file.IExtendedFileSpec;
import com.perforce.p4java.core.file.IFileAnnotation;
import com.perforce.p4java.core.file.IFileRevisionData;
import com.perforce.p4java.core.file.IFileSize;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.core.file.IObliterateResult;
import com.perforce.p4java.env.PerforceEnvironment;
import com.perforce.p4java.env.SystemInfo;
import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.ConfigException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.exception.RequestException;
import com.perforce.p4java.graph.ICommit;
import com.perforce.p4java.graph.IGraphListTree;
import com.perforce.p4java.graph.IGraphObject;
import com.perforce.p4java.graph.IGraphRef;
import com.perforce.p4java.graph.IRevListCommit;
import com.perforce.p4java.impl.generic.core.Extension;
import com.perforce.p4java.impl.generic.core.ListData;
import com.perforce.p4java.impl.mapbased.rpc.RpcPropertyDefs;
import com.perforce.p4java.impl.mapbased.server.IServerControl;
import com.perforce.p4java.impl.mapbased.server.cmd.AttributeDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.BranchDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.BranchesDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.ChangeDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.ChangesDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.ClientDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.ClientsDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.CommitDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.ConfigureDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.CounterDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.CountersDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.DBSchemaDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.DepotDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.DepotsDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.DescribeDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.Diff2Delegator;
import com.perforce.p4java.impl.mapbased.server.cmd.DirsDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.DiskspaceDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.DuplicateDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.ExportDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.ExtensionDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.FileAnnotateDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.FileLogDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.FilesDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.FixDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.FixesDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.FstatDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.GraphListTreeDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.GraphReceivePackDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.GraphRevListDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.GraphShowRefDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.GrepDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.GroupDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.GroupsDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.IListDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.InfoDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.IntegratedDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.InterchangesDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.JobDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.JobSpecDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.JobsDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.JournalWaitDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.KeyDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.KeysDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.LabelDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.LabelsDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.LicenseDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.ListDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.LogTailDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.Login2Delegator;
import com.perforce.p4java.impl.mapbased.server.cmd.LoginDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.LogoutDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.MonitorDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.MoveDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.ObliterateDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.OpenedDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.PasswdDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.PrintDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.PropertyDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.ProtectDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.ProtectsDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.ReloadDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.RenameUserDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.ReposDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.ResultListBuilder;
import com.perforce.p4java.impl.mapbased.server.cmd.ReviewDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.ReviewsDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.SearchDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.SizesDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.SpecDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.StatDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.StreamDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.StreamsDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.TagDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.TriggersDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.UnloadDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.UserDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.UsersDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.VerifyDelegator;
import com.perforce.p4java.option.UsageOptions;
import com.perforce.p4java.option.server.ChangelistOptions;
import com.perforce.p4java.option.server.CounterOptions;
import com.perforce.p4java.option.server.DeleteBranchSpecOptions;
import com.perforce.p4java.option.server.DeleteClientOptions;
import com.perforce.p4java.option.server.DeleteLabelOptions;
import com.perforce.p4java.option.server.DescribeOptions;
import com.perforce.p4java.option.server.DuplicateRevisionsOptions;
import com.perforce.p4java.option.server.ExportRecordsOptions;
import com.perforce.p4java.option.server.FixJobsOptions;
import com.perforce.p4java.option.server.GetBranchSpecOptions;
import com.perforce.p4java.option.server.GetBranchSpecsOptions;
import com.perforce.p4java.option.server.GetChangelistDiffsOptions;
import com.perforce.p4java.option.server.GetChangelistsOptions;
import com.perforce.p4java.option.server.GetClientTemplateOptions;
import com.perforce.p4java.option.server.GetClientsOptions;
import com.perforce.p4java.option.server.GetCountersOptions;
import com.perforce.p4java.option.server.GetDepotFilesOptions;
import com.perforce.p4java.option.server.GetDepotsOptions;
import com.perforce.p4java.option.server.GetDirectoriesOptions;
import com.perforce.p4java.option.server.GetExtendedFilesOptions;
import com.perforce.p4java.option.server.GetFileAnnotationsOptions;
import com.perforce.p4java.option.server.GetFileContentsOptions;
import com.perforce.p4java.option.server.GetFileDiffsOptions;
import com.perforce.p4java.option.server.GetFileSizesOptions;
import com.perforce.p4java.option.server.GetFixesOptions;
import com.perforce.p4java.option.server.GetInterchangesOptions;
import com.perforce.p4java.option.server.GetJobsOptions;
import com.perforce.p4java.option.server.GetKeysOptions;
import com.perforce.p4java.option.server.GetLabelsOptions;
import com.perforce.p4java.option.server.GetPropertyOptions;
import com.perforce.p4java.option.server.GetProtectionEntriesOptions;
import com.perforce.p4java.option.server.GetReviewChangelistsOptions;
import com.perforce.p4java.option.server.GetReviewsOptions;
import com.perforce.p4java.option.server.GetRevisionHistoryOptions;
import com.perforce.p4java.option.server.GetServerProcessesOptions;
import com.perforce.p4java.option.server.GetStreamOptions;
import com.perforce.p4java.option.server.GetStreamsOptions;
import com.perforce.p4java.option.server.GetSubmittedIntegrationsOptions;
import com.perforce.p4java.option.server.GetUserGroupsOptions;
import com.perforce.p4java.option.server.GetUsersOptions;
import com.perforce.p4java.option.server.GraphCommitLogOptions;
import com.perforce.p4java.option.server.GraphReceivePackOptions;
import com.perforce.p4java.option.server.GraphRevListOptions;
import com.perforce.p4java.option.server.GraphShowRefOptions;
import com.perforce.p4java.option.server.JournalWaitOptions;
import com.perforce.p4java.option.server.KeyOptions;
import com.perforce.p4java.option.server.ListOptions;
import com.perforce.p4java.option.server.LogTailOptions;
import com.perforce.p4java.option.server.Login2Options;
import com.perforce.p4java.option.server.LoginOptions;
import com.perforce.p4java.option.server.MatchingLinesOptions;
import com.perforce.p4java.option.server.MoveFileOptions;
import com.perforce.p4java.option.server.ObliterateFilesOptions;
import com.perforce.p4java.option.server.OpenedFilesOptions;
import com.perforce.p4java.option.server.PropertyOptions;
import com.perforce.p4java.option.server.ReloadOptions;
import com.perforce.p4java.option.server.ReposOptions;
import com.perforce.p4java.option.server.SearchJobsOptions;
import com.perforce.p4java.option.server.SetFileAttributesOptions;
import com.perforce.p4java.option.server.StreamIntegrationStatusOptions;
import com.perforce.p4java.option.server.StreamOptions;
import com.perforce.p4java.option.server.SwitchClientViewOptions;
import com.perforce.p4java.option.server.TagFilesOptions;
import com.perforce.p4java.option.server.UnloadOptions;
import com.perforce.p4java.option.server.UpdateClientOptions;
import com.perforce.p4java.option.server.UpdateUserGroupOptions;
import com.perforce.p4java.option.server.UpdateUserOptions;
import com.perforce.p4java.option.server.VerifyFilesOptions;
import com.perforce.p4java.server.CustomSpec;
import com.perforce.p4java.server.HelixCommandExecutor;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.IServerAddress;
import com.perforce.p4java.server.IServerInfo;
import com.perforce.p4java.server.P4Charset;
import com.perforce.p4java.server.PerforceCharsets;
import com.perforce.p4java.server.ServerStatus;
import com.perforce.p4java.server.callback.DefaultBrowserCallback;
import com.perforce.p4java.server.callback.IBrowserCallback;
import com.perforce.p4java.server.callback.ICommandCallback;
import com.perforce.p4java.server.callback.IProgressCallback;
import com.perforce.p4java.server.callback.ISSOCallback;
import com.perforce.p4java.server.callback.IStreamingCallback;
import com.perforce.p4java.server.delegator.IAttributeDelegator;
import com.perforce.p4java.server.delegator.IBranchDelegator;
import com.perforce.p4java.server.delegator.IBranchesDelegator;
import com.perforce.p4java.server.delegator.IChangeDelegator;
import com.perforce.p4java.server.delegator.IChangesDelegator;
import com.perforce.p4java.server.delegator.IClientDelegator;
import com.perforce.p4java.server.delegator.IClientsDelegator;
import com.perforce.p4java.server.delegator.ICommitDelegator;
import com.perforce.p4java.server.delegator.IConfigureDelegator;
import com.perforce.p4java.server.delegator.ICounterDelegator;
import com.perforce.p4java.server.delegator.ICountersDelegator;
import com.perforce.p4java.server.delegator.IDBSchemaDelegator;
import com.perforce.p4java.server.delegator.IDepotDelegator;
import com.perforce.p4java.server.delegator.IDepotsDelegator;
import com.perforce.p4java.server.delegator.IDiff2Delegator;
import com.perforce.p4java.server.delegator.IDirsDelegator;
import com.perforce.p4java.server.delegator.IDiskspaceDelegator;
import com.perforce.p4java.server.delegator.IDuplicateDelegator;
import com.perforce.p4java.server.delegator.IExportDelegator;
import com.perforce.p4java.server.delegator.IExtensionDelegator;
import com.perforce.p4java.server.delegator.IFileAnnotateDelegator;
import com.perforce.p4java.server.delegator.IFileLogDelegator;
import com.perforce.p4java.server.delegator.IFilesDelegator;
import com.perforce.p4java.server.delegator.IFixDelegator;
import com.perforce.p4java.server.delegator.IFixesDelegator;
import com.perforce.p4java.server.delegator.IFstatDelegator;
import com.perforce.p4java.server.delegator.IGraphListTreeDelegator;
import com.perforce.p4java.server.delegator.IGraphReceivePackDelegator;
import com.perforce.p4java.server.delegator.IGraphRevListDelegator;
import com.perforce.p4java.server.delegator.IGraphShowRefDelegator;
import com.perforce.p4java.server.delegator.IGrepDelegator;
import com.perforce.p4java.server.delegator.IInfoDelegator;
import com.perforce.p4java.server.delegator.IIntegratedDelegator;
import com.perforce.p4java.server.delegator.IJobDelegator;
import com.perforce.p4java.server.delegator.IJobSpecDelegator;
import com.perforce.p4java.server.delegator.IJobsDelegator;
import com.perforce.p4java.server.delegator.IJournalWaitDelegator;
import com.perforce.p4java.server.delegator.IKeyDelegator;
import com.perforce.p4java.server.delegator.IKeysDelegator;
import com.perforce.p4java.server.delegator.ILabelDelegator;
import com.perforce.p4java.server.delegator.ILabelsDelegator;
import com.perforce.p4java.server.delegator.ILicenseDelegator;
import com.perforce.p4java.server.delegator.ILogTailDelegator;
import com.perforce.p4java.server.delegator.ILogin2Delegator;
import com.perforce.p4java.server.delegator.ILoginDelegator;
import com.perforce.p4java.server.delegator.ILogoutDelegator;
import com.perforce.p4java.server.delegator.IMonitorDelegator;
import com.perforce.p4java.server.delegator.IMoveDelegator;
import com.perforce.p4java.server.delegator.IObliterateDelegator;
import com.perforce.p4java.server.delegator.IOpenedDelegator;
import com.perforce.p4java.server.delegator.IPasswdDelegator;
import com.perforce.p4java.server.delegator.IPrintDelegator;
import com.perforce.p4java.server.delegator.IPropertyDelegator;
import com.perforce.p4java.server.delegator.IProtectDelegator;
import com.perforce.p4java.server.delegator.IProtectsDelegator;
import com.perforce.p4java.server.delegator.IReloadDelegator;
import com.perforce.p4java.server.delegator.IRenameUserDelegator;
import com.perforce.p4java.server.delegator.IReposDelegator;
import com.perforce.p4java.server.delegator.IReviewDelegator;
import com.perforce.p4java.server.delegator.IReviewsDelegator;
import com.perforce.p4java.server.delegator.ISearchDelegator;
import com.perforce.p4java.server.delegator.ISizesDelegator;
import com.perforce.p4java.server.delegator.ISpecDelegator;
import com.perforce.p4java.server.delegator.IStatDelegator;
import com.perforce.p4java.server.delegator.IStreamDelegator;
import com.perforce.p4java.server.delegator.IStreamsDelegator;
import com.perforce.p4java.server.delegator.ITagDelegator;
import com.perforce.p4java.server.delegator.ITriggersDelegator;
import com.perforce.p4java.server.delegator.IUnloadDelegator;
import com.perforce.p4java.server.delegator.IUserDelegator;
import com.perforce.p4java.server.delegator.IUsersDelegator;
import com.perforce.p4java.server.delegator.IVerifyDelegator;
import com.perforce.p4java.util.PropertiesHelper;
import java.io.InputStream;
import java.nio.charset.UnsupportedCharsetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public abstract class Server
extends HelixCommandExecutor
implements IServerControl,
IOptionsServer {
    public static final String SCREEN_NAME_FIELD_NAME = "SCREEN_NAME";
    public static final String IMPL_COMMENTS_FIELD_NAME = "IMPL_COMMENTS";
    public static final String IMPL_TYPE_FIELD_NAME = "IMPL_TYPE";
    public static final String MINIMUM_SUPPORTED_SERVER_LEVEL_FIELD_NAME = "MINIMUM_SUPPORTED_SERVER_LEVEL";
    public static final String PROTOCOL_NAME_FIELD_NAME = "PROTOCOL_NAME";
    public static final String DEFAULT_STATUS_FIELD_NAME = "DEFAULT_STATUS";
    public static final String P4TICKETS_ENV_VAR = "P4TICKETS";
    public static final String P4TICKETS_DEFAULT_WINDOWS = "p4tickets.txt";
    public static final String P4TICKETS_DEFAULT_OTHER = ".p4tickets";
    public static final String P4TRUST_ENV_VAR = "P4TRUST";
    public static final String P4TRUST_DEFAULT_WINDOWS = "p4trust.txt";
    public static final String P4TRUST_DEFAULT_OTHER = ".p4trust";
    public static final String P4IGNORE_ENV_VAR = "P4IGNORE";
    protected static final String CORE_AUTH_FAIL_STRING_1 = "Perforce password (P4PASSWD)";
    protected static final String CORE_AUTH_FAIL_STRING_2 = "Access for user";
    protected static final String CORE_AUTH_FAIL_STRING_3 = "Your session has expired";
    protected static final String CORE_AUTH_FAIL_STRING_4 = "Your session was logged out";
    protected static final int UNKNOWN_SERVER_VERSION = -1;
    protected static final String UNKNOWN_SERVER_HOST = null;
    protected static final int UNKNOWN_SERVER_PORT = -1;
    protected static boolean runningOnWindows = SystemInfo.isWindows();
    protected UsageOptions usageOptions = null;
    protected ServerStatus status = ServerStatus.UNKNOWN;
    protected Properties props = null;
    protected IServerInfo serverInfo = null;
    protected String serverAddress = null;
    protected boolean caseSensitive = true;
    protected int serverVersion = -1;
    protected String serverHost = UNKNOWN_SERVER_HOST;
    protected int serverPort = -1;
    protected IServerAddress.Protocol serverProtocol = null;
    protected String userName = null;
    protected String password = null;
    protected Map<String, String> authTickets = new HashMap<String, String>();
    protected IClient client = null;
    protected String clientName = null;
    protected String clientPath = null;
    protected String clientUnsetName = "_____CLIENT_UNSET_____";
    protected boolean setupOnConnect = false;
    protected boolean loginOnConnect = false;
    protected ICommandCallback commandCallback = null;
    protected IProgressCallback progressCallback = null;
    protected ISSOCallback ssoCallback = null;
    protected IBrowserCallback browserCallback = new DefaultBrowserCallback();
    protected String ssoKey = null;
    protected String charsetName = null;
    protected P4Charset p4Charset = null;
    protected boolean connected = false;
    protected int minimumSupportedServerVersion = 20052;
    protected String tmpDirName = null;
    protected AtomicInteger nextCmdCallBackKey = new AtomicInteger();
    protected AtomicInteger nextProgressCallbackKey = new AtomicInteger();
    protected boolean nonCheckedSyncs = false;
    protected boolean enableStreams = true;
    protected boolean enableAndmaps = false;
    protected boolean enableGraph = false;
    protected boolean enableTracking = false;
    protected boolean enableProgress = false;
    protected boolean quietMode = false;
    protected boolean secure = false;
    protected boolean useAuthMemoryStore = false;
    protected String ignoreFileName = null;
    protected String rsh = null;
    protected Object browserVersion = null;
    private IAttributeDelegator attributeDelegator = null;
    private IBranchDelegator branchDelegator = null;
    private IBranchesDelegator branchesDelegator = null;
    private IChangeDelegator changeDelegator = null;
    private IChangesDelegator changesDelegator = null;
    private IClientDelegator clientDelegator = null;
    private IClientsDelegator clientsDelegator = null;
    private IConfigureDelegator configureDelegator = null;
    private ICounterDelegator counterDelegator = null;
    private ICountersDelegator countersDelegator = null;
    private IDBSchemaDelegator dbSchemaDelegator = null;
    private IDepotDelegator depotDelegator = null;
    private IDepotsDelegator depotsDelegator = null;
    private IReposDelegator reposDelegator = null;
    private DescribeDelegator describeDelegator = null;
    private IDiff2Delegator diff2Delegator = null;
    private IDirsDelegator dirsDelegator = null;
    private IDiskspaceDelegator diskspaceDelegator = null;
    private IDuplicateDelegator duplicateDelegator = null;
    private IExportDelegator exportDelegator = null;
    private IFileAnnotateDelegator fileAnnotateDelegator = null;
    private IFileLogDelegator fileLogDelegator = null;
    private IFilesDelegator filesDelegator = null;
    private IFixDelegator fixDelegator = null;
    private IFixesDelegator fixesDelegator = null;
    private IFstatDelegator fstatDelegator = null;
    private IGrepDelegator grepDelegator = null;
    private GroupDelegator groupDelegator = null;
    private GroupsDelegator groupsDelegator = null;
    private IInfoDelegator infoDelegator = null;
    private IIntegratedDelegator integratedDelegator = null;
    private InterchangesDelegator interchangesDelegator = null;
    private IJobDelegator jobDelegator = null;
    private IJobsDelegator jobsDelegator = null;
    private IJobSpecDelegator jobSpecDelegator = null;
    private IKeyDelegator keyDelegator = null;
    private IKeysDelegator keysDelegator = null;
    private ILabelDelegator labelDelegator = null;
    private ILabelsDelegator labelsDelegator = null;
    private IMonitorDelegator monitorDelegator = null;
    private IMoveDelegator moveDelegator = null;
    private IStatDelegator statDelegator = null;
    private IJournalWaitDelegator journalWaitDelegator = null;
    private ILoginDelegator loginDelegator;
    private ILogin2Delegator login2Delegator;
    private ILogoutDelegator logoutDelegator;
    private ILogTailDelegator logTailDelegator;
    private IObliterateDelegator obliterateDelegator;
    private IOpenedDelegator openedDelegator;
    private IPasswdDelegator passwdDelegator;
    private IPrintDelegator printDelegator;
    private IPropertyDelegator propertyDelegator;
    private IProtectDelegator protectDelegator;
    private IProtectsDelegator protectsDelegator;
    private IReloadDelegator reloadDelegator;
    private IRenameUserDelegator renameUserDelegator;
    private IReviewDelegator reviewDelegator;
    private IReviewsDelegator reviewsDelegator;
    private ISearchDelegator searchDelegator;
    private ISizesDelegator sizesDelegator;
    private IStreamDelegator streamDelegator;
    private IStreamsDelegator streamsDelegator;
    private ITagDelegator tagDelegator;
    private ITriggersDelegator triggersDelegator;
    private IUnloadDelegator unloadDelegator;
    private IUserDelegator userDelegator;
    private IUsersDelegator usersDelegator;
    private IVerifyDelegator verifyDelegator;
    private IGraphListTreeDelegator graphListTreeDelegator;
    private ICommitDelegator graphCommitDelegator;
    private IGraphRevListDelegator graphRevListDelegator;
    private IGraphReceivePackDelegator graphReceivePackDelegator;
    private IListDelegator listDelegator;
    private IGraphShowRefDelegator graphShowRefDelegator;
    private ISpecDelegator specDelegator;
    private ILicenseDelegator licenseDelegator;
    private IExtensionDelegator extensionDelegator;
    protected Random rand = new Random(System.currentTimeMillis());

    public static String guardNull(String str) {
        String nullStr = "<null>";
        return str == null ? "<null>" : str;
    }

    public static String[] getPreferredPathArray(String[] preamble, List<IFileSpec> specList) {
        return Server.getPreferredPathArray(preamble, specList, true);
    }

    public static String[] getPreferredPathArray(String[] preamble, List<IFileSpec> specList, boolean annotate) {
        int pathArraySize = (ObjectUtils.isNull(preamble) ? 0 : preamble.length) + (ObjectUtils.isNull(specList) ? 0 : specList.size());
        String[] pathArray = new String[pathArraySize];
        int i = 0;
        if (ObjectUtils.nonNull(preamble)) {
            for (String str : preamble) {
                pathArray[i++] = str;
            }
        }
        if (ObjectUtils.nonNull(specList)) {
            for (IFileSpec fSpec : specList) {
                if (ObjectUtils.nonNull(fSpec) && fSpec.getOpStatus() == FileSpecOpStatus.VALID) {
                    if (annotate) {
                        pathArray[i++] = fSpec.getAnnotatedPreferredPathString();
                        continue;
                    }
                    pathArray[i++] = fSpec.getPreferredPathString();
                    continue;
                }
                pathArray[i++] = null;
            }
        }
        return pathArray;
    }

    public static String[] populatePathArray(String[] pathArray, int start, List<IFileSpec> fileSpecList) {
        if (ObjectUtils.isNull(pathArray)) {
            return null;
        }
        if (ObjectUtils.isNull(fileSpecList)) {
            return pathArray;
        }
        P4JavaExceptions.throwP4JavaErrorIfConditionFails(start >= 0, "negative start index in populatePathArray: %s", start);
        P4JavaExceptions.throwP4JavaErrorIfConditionFails(start <= pathArray.length && start + fileSpecList.size() <= pathArray.length, "pathArray too small in populatePathArray", new Object[0]);
        int i = start;
        for (IFileSpec fSpec : fileSpecList) {
            pathArray[i] = ObjectUtils.nonNull(fSpec) && fSpec.getOpStatus() == FileSpecOpStatus.VALID ? fSpec.getAnnotatedPreferredPathString() : null;
            ++i;
        }
        return pathArray;
    }

    public static boolean isRunningOnWindows() {
        return runningOnWindows;
    }

    @Override
    public String getCharsetName() {
        return this.charsetName;
    }

    public String getClientName() {
        return this.clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public String getClientPath() {
        return this.clientPath;
    }

    @Override
    public void setClientPath(String clientPath) {
        this.clientPath = clientPath;
    }

    public String getIgnoreFileName() {
        return this.ignoreFileName;
    }

    public void setIgnoreFileName(String ignoreFileName) {
        this.ignoreFileName = ignoreFileName;
    }

    @Override
    public ServerStatus getStatus() {
        return this.status;
    }

    @Override
    public UsageOptions getUsageOptions() {
        return this.usageOptions;
    }

    @Override
    public Server setUsageOptions(UsageOptions usageOptions) {
        this.usageOptions = usageOptions;
        return this;
    }

    @Override
    public List<IRevListCommit> getGraphRevList(GraphRevListOptions options) throws P4JavaException {
        return this.graphRevListDelegator.getGraphRevList(options);
    }

    @Override
    public List<ICommit> getGraphCommitLogList(GraphCommitLogOptions options) throws P4JavaException {
        return this.graphCommitDelegator.getGraphCommitLogList(options);
    }

    @Override
    public void doGraphReceivePack(GraphReceivePackOptions options) throws P4JavaException {
        this.graphReceivePackDelegator.doGraphReceivePack(options);
    }

    @Override
    public ListData getListData(List<IFileSpec> fileSpecs, ListOptions options) throws P4JavaException {
        return this.listDelegator.getListData(fileSpecs, options);
    }

    @Override
    public ListData getListData(List<IFileSpec> fileSpecs, ListOptions options, String clientName) throws P4JavaException {
        return this.listDelegator.getListData(fileSpecs, options, clientName);
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public void setUserName(String userName) {
        this.userName = userName;
        this.setAuthTicket(this.getAuthTicket(userName));
    }

    @Override
    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    public boolean isEnableProgress() {
        return this.enableProgress;
    }

    public void setEnableProgress(boolean enableProgress) {
        this.enableProgress = enableProgress;
    }

    public boolean isEnableTracking() {
        return this.enableTracking;
    }

    public void setEnableTracking(boolean enableTracking) {
        this.enableTracking = enableTracking;
    }

    public boolean isNonCheckedSyncs() {
        return this.nonCheckedSyncs;
    }

    public void setNonCheckedSyncs(boolean nonCheckedSyncs) {
        this.nonCheckedSyncs = nonCheckedSyncs;
    }

    public boolean isQuietMode() {
        return this.quietMode;
    }

    public void setQuietMode(boolean quietMode) {
        this.quietMode = quietMode;
    }

    protected boolean isSecure() {
        return this.secure;
    }

    protected void setSecure(boolean secure) {
        this.secure = secure;
    }

    @Override
    public int getServerVersion() throws ConnectionException {
        if (this.serverVersion != -1) {
            return this.serverVersion;
        }
        try {
            this.serverInfo = this.getServerInfo();
            if (ObjectUtils.nonNull(this.serverInfo)) {
                String currentServerVersion;
                if (StringUtils.isNotBlank((CharSequence)this.serverInfo.getServerAddress())) {
                    this.serverAddress = this.serverInfo.getServerAddress();
                }
                if (StringUtils.isNotBlank((CharSequence)(currentServerVersion = this.serverInfo.getServerVersion()))) {
                    this.serverVersion = this.parseVersionString(currentServerVersion);
                    return this.serverVersion;
                }
            }
        }
        catch (Exception exc) {
            Log.exception(exc);
            throw new ConnectionException(exc.getLocalizedMessage(), exc);
        }
        return -1;
    }

    @Override
    public void setCurrentServerInfo(IServerInfo info) {
        this.serverInfo = info;
    }

    @Override
    public IServerInfo getCurrentServerInfo() {
        return this.serverInfo;
    }

    @Override
    public void connect() throws ConnectionException, AccessException, RequestException, ConfigException {
        this.connected = true;
        this.status = ServerStatus.READY;
        Log.info("connected to Perforce server at %s:%s", this.serverHost, this.serverPort);
        int serverVersion = this.getServerVersion();
        P4JavaExceptions.throwConnectionExceptionIfConditionFails(serverVersion != -1, "Unable to determine Perforce server version for connection; check network connection, connection character set setting, and / or server status", new Object[0]);
        P4JavaExceptions.throwConnectionExceptionIfConditionFails(serverVersion >= this.minimumSupportedServerVersion, "Attempted to connect to an unsupported Perforce server version; target server version: %s; minimum supported version: %s", serverVersion, this.minimumSupportedServerVersion);
        if (this.loginOnConnect && StringUtils.isNotBlank((CharSequence)this.userName) && StringUtils.isNotBlank((CharSequence)this.password)) {
            this.login(this.password);
        }
        if (this.setupOnConnect && StringUtils.isNotBlank((CharSequence)this.clientName)) {
            this.client = this.getClient(this.clientName);
        }
        if (this.serverInfo.isUnicodeEnabled() && (this.p4Charset == null || this.p4Charset.getCharset() == null)) {
            String p4CharsetStr = PerforceEnvironment.getP4Charset();
            if (StringUtils.isBlank((CharSequence)p4CharsetStr) || "none".equalsIgnoreCase(p4CharsetStr) || "auto".equalsIgnoreCase(p4CharsetStr)) {
                String p4CharsetName = PerforceCharsets.getP4CharsetName(CharsetDefs.DEFAULT_NAME);
                if (StringUtils.isNotBlank((CharSequence)p4CharsetName)) {
                    this.charsetName = p4CharsetName;
                    this.p4Charset = P4Charset.getDefault();
                } else {
                    this.charsetName = "utf8";
                    this.p4Charset = P4Charset.getUTF8();
                }
            } else {
                this.setCharsetName(p4CharsetStr);
            }
        }
    }

    @Override
    public void disconnect() throws ConnectionException, AccessException {
        this.connected = false;
        this.status = ServerStatus.DISCONNECTED;
        Log.info("disconnected from Perforce server at %s:%s", this.serverHost, this.serverPort);
    }

    @Override
    public String getAuthTicket() {
        return this.getAuthTicket(this.userName);
    }

    @Override
    public void setAuthTicket(String authTicket) {
        if (StringUtils.isNotBlank((CharSequence)this.userName)) {
            this.setAuthTicket(this.userName, authTicket);
        }
    }

    @Override
    public String[] getKnownCharsets() {
        return PerforceCharsets.getKnownCharsets();
    }

    @Override
    public Properties getProperties() {
        return this.props;
    }

    @Override
    public int getServerVersionNumber() {
        return this.serverVersion;
    }

    @Override
    public String getWorkingDirectory() {
        if (ObjectUtils.nonNull(this.usageOptions)) {
            return this.usageOptions.getWorkingDirectory();
        }
        return null;
    }

    @Override
    public void setWorkingDirectory(String dirPath) {
        if (ObjectUtils.nonNull(this.usageOptions)) {
            this.usageOptions.setWorkingDirectory(dirPath);
        }
    }

    @Override
    public IClient getCurrentClient() {
        return this.client;
    }

    @Override
    public void setCurrentClient(IClient client) {
        this.client = client;
        this.clientName = ObjectUtils.nonNull(client) ? client.getName() : null;
    }

    @Override
    public ICommandCallback registerCallback(ICommandCallback callback) {
        ICommandCallback oldCallback = this.commandCallback;
        this.commandCallback = callback;
        return oldCallback;
    }

    @Override
    public IProgressCallback registerProgressCallback(IProgressCallback progressCallback) {
        IProgressCallback oldCallback = this.progressCallback;
        this.progressCallback = progressCallback;
        return oldCallback;
    }

    @Override
    public void registerSSOCallback(ISSOCallback callback, String ssoKey) {
        this.ssoCallback = callback;
        this.ssoKey = ssoKey;
    }

    @Override
    public void registerBrowserCallback(IBrowserCallback browserCallback) {
        this.browserCallback = browserCallback;
    }

    @Override
    public boolean setCharsetName(String charsetName) throws UnsupportedCharsetException {
        if (charsetName == null) {
            this.p4Charset = null;
            this.charsetName = null;
            return true;
        }
        this.p4Charset = new P4Charset(charsetName);
        this.charsetName = this.p4Charset.getCharsetName();
        return ObjectUtils.nonNull(this.p4Charset.getCharset());
    }

    @Override
    public boolean supportsUnicode() throws ConnectionException, RequestException, AccessException {
        if (ObjectUtils.isNull(this.serverInfo)) {
            this.serverInfo = this.getServerInfo();
        }
        return ObjectUtils.nonNull(this.serverInfo) && this.serverInfo.isUnicodeEnabled();
    }

    @Override
    public ServerStatus init(String host, int port, Properties properties, UsageOptions opts, boolean secure) throws ConfigException, ConnectionException {
        this.serverHost = host;
        this.serverPort = port;
        this.secure = secure;
        this.props = (Properties)org.apache.commons.lang3.ObjectUtils.firstNonNull((Object[])new Properties[]{properties, new Properties()});
        this.usageOptions = (UsageOptions)org.apache.commons.lang3.ObjectUtils.firstNonNull((Object[])new UsageOptions[]{opts, new UsageOptions(this.props)});
        this.tmpDirName = RpcPropertyDefs.getProperty(this.props, "com.perforce.p4java.tmpDir", System.getProperty("java.io.tmpdir"));
        if (StringUtils.isBlank((CharSequence)this.tmpDirName)) {
            this.tmpDirName = "/tmp";
            Log.warn("Unable to get tmp name from P4 properties or System; using %s instead", this.tmpDirName);
        }
        Log.info("Using program name: '%s'; program version: '%s'", this.usageOptions.getProgramName(), this.usageOptions.getProgramVersion());
        Log.info("Using tmp file directory: %s", this.tmpDirName);
        this.setUserName(PropertiesHelper.getPropertyByKeys(this.props, "userName", "com.perforce.p4java.userName", PerforceEnvironment.getP4User()));
        this.password = PropertiesHelper.getPropertyByKeys(this.props, "password", "com.perforce.p4java.password", null);
        this.clientName = PropertiesHelper.getPropertyByKeys(this.props, "clientName", "com.perforce.p4java.clientName", PerforceEnvironment.getP4Client());
        this.clientPath = PropertiesHelper.getPropertyByKeys(this.props, "clientPath", "com.perforce.p4java.clientPath", null);
        this.setupOnConnect = PropertiesHelper.isExistProperty(this.props, "autoConnect", "com.perforce.p4java.autoConnect", this.setupOnConnect);
        this.loginOnConnect = PropertiesHelper.isExistProperty(this.props, "autoLogin", "com.perforce.p4java.autoLogin", this.loginOnConnect);
        this.nonCheckedSyncs = PropertiesHelper.isExistProperty(this.props, "nonCheckedSync", "com.perforce.p4java.nonCheckedSync", this.nonCheckedSyncs);
        this.enableStreams = PropertiesHelper.isExistProperty(this.props, "enableStreams", "com.perforce.p4java.enableStreams", this.enableStreams);
        this.enableAndmaps = PropertiesHelper.isExistProperty(this.props, "expandAndmaps", "com.perforce.p4java.expandAndmaps", this.enableAndmaps);
        this.enableGraph = PropertiesHelper.isExistProperty(this.props, "enableGraph", "com.perforce.p4java.enableGraph", this.enableGraph);
        this.enableTracking = PropertiesHelper.isExistProperty(this.props, "enableTracking", "com.perforce.p4java.enableTracking", this.enableTracking);
        this.enableProgress = PropertiesHelper.isExistProperty(this.props, "enableProgress", "com.perforce.p4java.enableProgress", this.enableProgress);
        this.quietMode = PropertiesHelper.isExistProperty(this.props, "quietMode", "com.perforce.p4java.quietMode", this.quietMode);
        this.useAuthMemoryStore = PropertiesHelper.isExistProperty(this.props, "useAuthMemoryStore", "com.perforce.p4java.useAuthMemoryStore", this.useAuthMemoryStore);
        this.ignoreFileName = PropertiesHelper.getPropertyByKeys(this.props, "ignoreFileName", "com.perforce.p4java.ignoreFileName", System.getenv(P4IGNORE_ENV_VAR));
        this.attributeDelegator = new AttributeDelegator(this);
        this.branchDelegator = new BranchDelegator(this);
        this.branchesDelegator = new BranchesDelegator(this);
        this.changeDelegator = new ChangeDelegator(this);
        this.changesDelegator = new ChangesDelegator(this);
        this.clientDelegator = new ClientDelegator(this);
        this.clientsDelegator = new ClientsDelegator(this);
        this.configureDelegator = new ConfigureDelegator(this);
        this.counterDelegator = new CounterDelegator(this);
        this.countersDelegator = new CountersDelegator(this);
        this.dbSchemaDelegator = new DBSchemaDelegator(this);
        this.depotDelegator = new DepotDelegator(this);
        this.depotsDelegator = new DepotsDelegator(this);
        this.reposDelegator = new ReposDelegator(this);
        this.describeDelegator = new DescribeDelegator(this);
        this.diff2Delegator = new Diff2Delegator(this);
        this.dirsDelegator = new DirsDelegator(this);
        this.diskspaceDelegator = new DiskspaceDelegator(this);
        this.duplicateDelegator = new DuplicateDelegator(this);
        this.exportDelegator = new ExportDelegator(this);
        this.fileAnnotateDelegator = new FileAnnotateDelegator(this);
        this.fileLogDelegator = new FileLogDelegator(this);
        this.filesDelegator = new FilesDelegator(this);
        this.fixDelegator = new FixDelegator(this);
        this.fixesDelegator = new FixesDelegator(this);
        this.fstatDelegator = new FstatDelegator(this);
        this.grepDelegator = new GrepDelegator(this);
        this.groupDelegator = new GroupDelegator(this);
        this.groupsDelegator = new GroupsDelegator(this);
        this.infoDelegator = new InfoDelegator(this);
        this.integratedDelegator = new IntegratedDelegator(this);
        this.interchangesDelegator = new InterchangesDelegator(this);
        this.jobDelegator = new JobDelegator(this);
        this.jobsDelegator = new JobsDelegator(this);
        this.jobSpecDelegator = new JobSpecDelegator(this);
        this.keyDelegator = new KeyDelegator(this);
        this.keysDelegator = new KeysDelegator(this);
        this.labelDelegator = new LabelDelegator(this);
        this.labelsDelegator = new LabelsDelegator(this);
        this.monitorDelegator = new MonitorDelegator(this);
        this.moveDelegator = new MoveDelegator(this);
        this.statDelegator = new StatDelegator(this);
        this.journalWaitDelegator = new JournalWaitDelegator(this);
        this.loginDelegator = new LoginDelegator(this);
        this.login2Delegator = new Login2Delegator(this);
        this.logoutDelegator = new LogoutDelegator(this);
        this.logTailDelegator = new LogTailDelegator(this);
        this.obliterateDelegator = new ObliterateDelegator(this);
        this.openedDelegator = new OpenedDelegator(this);
        this.passwdDelegator = new PasswdDelegator(this);
        this.printDelegator = new PrintDelegator(this);
        this.propertyDelegator = new PropertyDelegator(this);
        this.protectDelegator = new ProtectDelegator(this);
        this.protectsDelegator = new ProtectsDelegator(this);
        this.reloadDelegator = new ReloadDelegator(this);
        this.renameUserDelegator = new RenameUserDelegator(this);
        this.reviewDelegator = new ReviewDelegator(this);
        this.reviewsDelegator = new ReviewsDelegator(this);
        this.searchDelegator = new SearchDelegator(this);
        this.sizesDelegator = new SizesDelegator(this);
        this.streamDelegator = new StreamDelegator(this);
        this.streamsDelegator = new StreamsDelegator(this);
        this.tagDelegator = new TagDelegator(this);
        this.triggersDelegator = new TriggersDelegator(this);
        this.unloadDelegator = new UnloadDelegator(this);
        this.userDelegator = new UserDelegator(this);
        this.usersDelegator = new UsersDelegator(this);
        this.verifyDelegator = new VerifyDelegator(this);
        this.graphListTreeDelegator = new GraphListTreeDelegator(this);
        this.graphCommitDelegator = new CommitDelegator(this);
        this.graphRevListDelegator = new GraphRevListDelegator(this);
        this.graphReceivePackDelegator = new GraphReceivePackDelegator(this);
        this.listDelegator = new ListDelegator(this);
        this.graphShowRefDelegator = new GraphShowRefDelegator(this);
        this.specDelegator = new SpecDelegator(this);
        this.licenseDelegator = new LicenseDelegator(this);
        this.extensionDelegator = new ExtensionDelegator(this);
        return this.status;
    }

    @Override
    public ServerStatus init(String host, int port, Properties props, UsageOptions opts) throws ConfigException, ConnectionException {
        return this.init(host, port, props, opts, false);
    }

    @Override
    public ServerStatus init(String host, int port, Properties props) throws ConfigException, ConnectionException {
        return this.init(host, port, props, null);
    }

    protected String getDefaultP4TicketsFile() {
        StringBuilder sb = new StringBuilder();
        sb.append(SystemInfo.getUserHome()).append(SystemInfo.getFileSeparator());
        if (SystemInfo.isWindows()) {
            sb.append(P4TICKETS_DEFAULT_WINDOWS);
        } else {
            sb.append(P4TICKETS_DEFAULT_OTHER);
        }
        return sb.toString();
    }

    protected String getDefaultP4TrustFile() {
        StringBuilder sb = new StringBuilder();
        sb.append(SystemInfo.getUserHome()).append(SystemInfo.getFileSeparator());
        if (SystemInfo.isWindows()) {
            sb.append(P4TRUST_DEFAULT_WINDOWS);
        } else {
            sb.append(P4TRUST_DEFAULT_OTHER);
        }
        return sb.toString();
    }

    protected String getInfoServerAddress() {
        if (StringUtils.isNotBlank((CharSequence)this.serverAddress)) {
            return this.serverAddress;
        }
        try {
            this.serverInfo = this.getServerInfo();
            if (ObjectUtils.nonNull(this.serverInfo)) {
                String serverInfoServerVersion;
                String serverInfoServerAddress = this.serverInfo.getServerAddress();
                if (StringUtils.isNotBlank((CharSequence)serverInfoServerAddress)) {
                    this.serverAddress = serverInfoServerAddress;
                }
                if (StringUtils.isNotBlank((CharSequence)(serverInfoServerVersion = this.serverInfo.getServerVersion()))) {
                    this.serverVersion = this.parseVersionString(serverInfoServerVersion);
                }
            }
        }
        catch (Exception exc) {
            Log.exception(exc);
        }
        return this.serverAddress;
    }

    protected int parseVersionString(String versionString) {
        String candidate;
        String[] candidateParts;
        String[] subStrings;
        if (StringUtils.isNotBlank((CharSequence)versionString) && (subStrings = versionString.split("/")).length >= 3 && (candidateParts = (candidate = subStrings[2]).split("\\.")).length >= 2) {
            try {
                return Integer.parseInt(candidateParts[0] + candidateParts[1]);
            }
            catch (NumberFormatException nfe) {
                Log.error("Unexpected exception in P4CmdServerImpl.parseVersionString: %s", nfe);
            }
        }
        return -1;
    }

    protected int getRandomInt() {
        return Math.abs(this.rand.nextInt(Integer.MAX_VALUE));
    }

    public ISSOCallback getSSOCallback() {
        return this.ssoCallback;
    }

    public String getSSOKey() {
        return this.ssoKey;
    }

    public IBrowserCallback getBrowserCallback() {
        return this.browserCallback;
    }

    protected boolean isUnicode() {
        return StringUtils.isNotBlank((CharSequence)this.charsetName);
    }

    @Override
    public List<IFileSpec> setFileAttributes(List<IFileSpec> files, Map<String, String> attributes, SetFileAttributesOptions opts) throws P4JavaException {
        return this.attributeDelegator.setFileAttributes(files, attributes, opts);
    }

    @Override
    public List<IFileSpec> setFileAttributes(List<IFileSpec> files, @Nonnull String attributeName, @Nonnull InputStream inStream, SetFileAttributesOptions opts) throws P4JavaException {
        return this.attributeDelegator.setFileAttributes(files, attributeName, inStream, opts);
    }

    @Override
    public List<IBranchSpecSummary> getBranchSpecs(GetBranchSpecsOptions opts) throws P4JavaException {
        return this.branchesDelegator.getBranchSpecs(opts);
    }

    @Override
    public List<IBranchSpecSummary> getBranchSpecs(String userName, String nameFilter, int maxReturns) throws ConnectionException, RequestException, AccessException {
        return this.branchesDelegator.getBranchSpecs(userName, nameFilter, maxReturns);
    }

    @Override
    public IBranchSpec getBranchSpec(String name, GetBranchSpecOptions opts) throws P4JavaException {
        return this.branchDelegator.getBranchSpec(name, opts);
    }

    @Override
    public String deleteBranchSpec(String branchSpecName, DeleteBranchSpecOptions opts) throws P4JavaException {
        return this.branchDelegator.deleteBranchSpec(branchSpecName, opts);
    }

    @Override
    public IBranchSpec getBranchSpec(String name) throws ConnectionException, RequestException, AccessException {
        return this.branchDelegator.getBranchSpec(name);
    }

    @Override
    public String createBranchSpec(@Nonnull IBranchSpec branchSpec) throws ConnectionException, RequestException, AccessException {
        return this.branchDelegator.createBranchSpec(branchSpec);
    }

    @Override
    public String updateBranchSpec(@Nonnull IBranchSpec branchSpec) throws ConnectionException, RequestException, AccessException {
        return this.branchDelegator.updateBranchSpec(branchSpec);
    }

    @Override
    public String deleteBranchSpec(String branchSpecName, boolean force) throws ConnectionException, RequestException, AccessException {
        try {
            return this.branchDelegator.deleteBranchSpec(branchSpecName, new DeleteBranchSpecOptions(force));
        }
        catch (P4JavaException p4je) {
            throw new RequestException(p4je);
        }
    }

    @Override
    public String deletePendingChangelist(int id) throws ConnectionException, RequestException, AccessException {
        return this.changeDelegator.deletePendingChangelist(id);
    }

    @Override
    public IChangelist getChangelist(int id) throws ConnectionException, RequestException, AccessException {
        return this.changeDelegator.getChangelist(id);
    }

    @Override
    public String deletePendingChangelist(int id, ChangelistOptions opts) throws P4JavaException {
        return this.changeDelegator.deletePendingChangelist(id, opts);
    }

    @Override
    public IChangelist getChangelist(int id, ChangelistOptions opts) throws P4JavaException {
        return this.changeDelegator.getChangelist(id, opts);
    }

    @Override
    public List<IChangelistSummary> getChangelists(int maxMostRecent, List<IFileSpec> fileSpecs, String clientName, String userName, boolean includeIntegrated, IChangelist.Type type, boolean longDesc) throws ConnectionException, RequestException, AccessException {
        return this.changesDelegator.getChangelists(maxMostRecent, fileSpecs, clientName, userName, includeIntegrated, type, longDesc);
    }

    @Override
    public List<IChangelistSummary> getChangelists(int maxMostRecent, List<IFileSpec> fileSpecs, String clientName, String userName, boolean includeIntegrated, boolean submittedOnly, boolean pendingOnly, boolean longDesc) throws ConnectionException, RequestException, AccessException {
        return this.changesDelegator.getChangelists(maxMostRecent, fileSpecs, clientName, userName, includeIntegrated, submittedOnly, pendingOnly, longDesc);
    }

    @Override
    public List<IChangelistSummary> getChangelists(List<IFileSpec> fileSpecs, GetChangelistsOptions opts) throws P4JavaException {
        return this.changesDelegator.getChangelists(fileSpecs, opts);
    }

    @Override
    public InputStream getChangelistDiffs(int id, GetChangelistDiffsOptions opts) throws P4JavaException {
        return this.describeDelegator.getChangelistDiffs(id, opts);
    }

    @Override
    public InputStream getChangelistDiffsStream(int id, DescribeOptions options) throws ConnectionException, RequestException, AccessException {
        return this.describeDelegator.getChangelistDiffsStream(id, options);
    }

    @Override
    public List<IFileSpec> getShelvedFiles(int changelistId) throws P4JavaException {
        return this.describeDelegator.getShelvedFiles(changelistId);
    }

    @Override
    public List<IFileSpec> getShelvedFiles(int changelistId, int max) throws P4JavaException {
        return this.describeDelegator.getShelvedFiles(changelistId, max);
    }

    @Override
    public InputStream getChangelistDiffs(int id, DiffType diffType) throws ConnectionException, RequestException, AccessException {
        return this.describeDelegator.getChangelistDiffs(id, diffType);
    }

    @Override
    public List<IFileSpec> getChangelistFiles(int id) throws ConnectionException, RequestException, AccessException {
        return this.describeDelegator.getChangelistFiles(id);
    }

    @Override
    public List<IFileSpec> getChangelistFiles(int id, int max) throws ConnectionException, RequestException, AccessException {
        return this.describeDelegator.getChangelistFiles(id, max);
    }

    @Override
    public List<IExtendedFileSpec> getChangelistExtendedFiles(int id) throws ConnectionException, RequestException, AccessException {
        return this.describeDelegator.getChangelistExtendedFiles(id);
    }

    @Override
    public List<IExtendedFileSpec> getChangelistExtendedFiles(int id, int max) throws ConnectionException, RequestException, AccessException {
        return this.describeDelegator.getChangelistExtendedFiles(id, max);
    }

    @Override
    public List<IFileSpec> getCommitFiles(String repo, String commit) throws ConnectionException, RequestException, AccessException {
        return this.describeDelegator.getCommitFiles(repo, commit);
    }

    @Override
    public String setOrUnsetServerConfigurationValue(@Nonnull String name, @Nullable String value) throws P4JavaException {
        return this.configureDelegator.setOrUnsetServerConfigurationValue(name, value);
    }

    @Override
    public List<ServerConfigurationValue> showServerConfiguration(String serverName, String variableName) throws P4JavaException {
        return this.configureDelegator.showServerConfiguration(serverName, variableName);
    }

    @Override
    public List<IDbSchema> getDbSchema(List<String> tableSpecs) throws P4JavaException {
        return this.dbSchemaDelegator.getDbSchema(tableSpecs);
    }

    @Override
    public IClient getClient(String clientName) throws ConnectionException, RequestException, AccessException {
        return this.clientDelegator.getClient(clientName);
    }

    @Override
    public IClient getClient(@Nonnull IClientSummary clientSummary) throws ConnectionException, RequestException, AccessException {
        return this.clientDelegator.getClient(clientSummary);
    }

    @Override
    public IClient getClientTemplate(String clientName) throws ConnectionException, RequestException, AccessException {
        return this.clientDelegator.getClientTemplate(clientName);
    }

    @Override
    public IClient getClientTemplate(String clientName, boolean allowExistent) throws ConnectionException, RequestException, AccessException {
        return this.clientDelegator.getClientTemplate(clientName, allowExistent);
    }

    @Override
    public IClient getClientTemplate(String clientName, GetClientTemplateOptions opts) throws P4JavaException {
        return this.clientDelegator.getClientTemplate(clientName, opts);
    }

    @Override
    public List<IChangelist> getInterchanges(IFileSpec fromFile, IFileSpec toFile, GetInterchangesOptions opts) throws P4JavaException {
        return this.interchangesDelegator.getInterchanges(fromFile, toFile, opts);
    }

    @Override
    public List<IChangelist> getInterchanges(String branchSpecName, List<IFileSpec> fromFileList, List<IFileSpec> toFileList, GetInterchangesOptions opts) throws P4JavaException {
        return this.interchangesDelegator.getInterchanges(branchSpecName, fromFileList, toFileList, opts);
    }

    @Override
    public List<IChangelist> getInterchanges(IFileSpec fromFile, IFileSpec toFile, boolean showFiles, boolean longDesc, int maxChangelistId) throws ConnectionException, RequestException, AccessException {
        return this.interchangesDelegator.getInterchanges(fromFile, toFile, showFiles, longDesc, maxChangelistId);
    }

    @Override
    public List<IChangelist> getInterchanges(String branchSpecName, List<IFileSpec> fromFileList, List<IFileSpec> toFileList, boolean showFiles, boolean longDesc, int maxChangelistId, boolean reverseMapping, boolean biDirectional) throws ConnectionException, RequestException, AccessException {
        return this.interchangesDelegator.getInterchanges(branchSpecName, fromFileList, toFileList, showFiles, longDesc, maxChangelistId, reverseMapping, biDirectional);
    }

    @Override
    public String createClient(@Nonnull IClient newClient) throws ConnectionException, RequestException, AccessException {
        return this.clientDelegator.createClient(newClient);
    }

    @Override
    public void createTempClient(@Nonnull IClient newClient) throws ConnectionException, RequestException, AccessException {
        this.clientDelegator.createTempClient(newClient);
    }

    @Override
    public String updateClient(@Nonnull IClient client) throws ConnectionException, RequestException, AccessException {
        return this.clientDelegator.updateClient(client);
    }

    @Override
    public String updateClient(IClient client, boolean force) throws ConnectionException, RequestException, AccessException {
        return this.clientDelegator.updateClient(client, force);
    }

    @Override
    public String updateClient(IClient client, UpdateClientOptions opts) throws P4JavaException {
        return this.clientDelegator.updateClient(client, opts);
    }

    @Override
    public String deleteClient(String clientName, boolean force) throws ConnectionException, RequestException, AccessException {
        return this.clientDelegator.deleteClient(clientName, force);
    }

    @Override
    public String deleteClient(String clientName, DeleteClientOptions opts) throws P4JavaException {
        return this.clientDelegator.deleteClient(clientName, opts);
    }

    @Override
    public String switchClientView(String templateClientName, String targetClientName, SwitchClientViewOptions opts) throws P4JavaException {
        return this.clientDelegator.switchClientView(templateClientName, targetClientName, opts);
    }

    @Override
    public String switchStreamView(String streamPath, String targetClientName, SwitchClientViewOptions opts) throws P4JavaException {
        return this.clientDelegator.switchStreamView(streamPath, targetClientName, opts);
    }

    @Override
    public List<IClientSummary> getClients(GetClientsOptions opts) throws P4JavaException {
        return this.clientsDelegator.getClients(opts);
    }

    @Override
    public List<IClientSummary> getClients(String userName, String nameFilter, int maxResults) throws ConnectionException, RequestException, AccessException {
        return this.clientsDelegator.getClients(userName, nameFilter, maxResults);
    }

    @Override
    public String getCounter(String counterName) throws ConnectionException, RequestException, AccessException {
        return this.counterDelegator.getCounter(counterName);
    }

    @Override
    public String getCounter(String counterName, CounterOptions opts) throws P4JavaException {
        return this.counterDelegator.getCounter(counterName, opts);
    }

    @Override
    public void setCounter(String counterName, String value, boolean perforceCounter) throws ConnectionException, RequestException, AccessException {
        this.counterDelegator.setCounter(counterName, value, perforceCounter);
    }

    @Override
    public String setCounter(String counterName, String value, CounterOptions opts) throws P4JavaException {
        return this.counterDelegator.setCounter(counterName, value, opts);
    }

    @Override
    public void deleteCounter(String counterName, boolean perforceCounter) throws ConnectionException, RequestException, AccessException {
        this.counterDelegator.deleteCounter(counterName, perforceCounter);
    }

    @Override
    public Map<String, String> getCounters(GetCountersOptions opts) throws P4JavaException {
        return this.countersDelegator.getCounters(opts);
    }

    @Override
    public Map<String, String> getCounters(CounterOptions opts) throws P4JavaException {
        return this.countersDelegator.getCounters(opts);
    }

    @Override
    public Map<String, String> getCounters() throws ConnectionException, RequestException, AccessException {
        return this.countersDelegator.getCounters();
    }

    @Override
    public ServerStatus init(String host, int port, Properties props, UsageOptions opts, boolean secure, String rsh) throws ConfigException, ConnectionException {
        return null;
    }

    @Override
    public String createDepot(@Nonnull IDepot newDepot) throws P4JavaException {
        return this.depotDelegator.createDepot(newDepot);
    }

    @Override
    public String deleteDepot(String name) throws P4JavaException {
        return this.depotDelegator.deleteDepot(name);
    }

    @Override
    public IDepot getDepot(String name) throws P4JavaException {
        return this.depotDelegator.getDepot(name);
    }

    @Override
    public List<IDepot> getDepots() throws ConnectionException, RequestException, AccessException {
        return this.depotsDelegator.getDepots();
    }

    @Override
    public List<IDepot> getDepots(GetDepotsOptions opts) throws P4JavaException {
        return this.depotsDelegator.getDepots(opts);
    }

    @Override
    public List<IRepo> getRepos() throws ConnectionException, RequestException, AccessException {
        return this.reposDelegator.getRepos();
    }

    @Override
    public List<IRepo> getRepos(ReposOptions options) throws P4JavaException {
        return this.reposDelegator.getRepos(options);
    }

    @Override
    public List<IRepo> getRepos(String clientName) throws ConnectionException, RequestException, AccessException {
        return this.reposDelegator.getRepos(clientName);
    }

    @Override
    public List<IFileDiff> getFileDiffs(IFileSpec file1, IFileSpec file2, String branchSpecName, GetFileDiffsOptions opts) throws P4JavaException {
        return this.diff2Delegator.getFileDiffs(file1, file2, branchSpecName, opts);
    }

    @Override
    public InputStream getFileDiffsStream(IFileSpec file1, IFileSpec file2, String branchSpecName, GetFileDiffsOptions opts) throws P4JavaException {
        return this.diff2Delegator.getFileDiffsStream(file1, file2, branchSpecName, opts);
    }

    @Override
    public List<IFileDiff> getFileDiffs(IFileSpec file1, IFileSpec file2, String branchSpecName, DiffType diffType, boolean quiet, boolean includeNonTextDiffs, boolean gnuDiffs) throws ConnectionException, RequestException, AccessException {
        return this.diff2Delegator.getFileDiffs(file1, file2, branchSpecName, diffType, quiet, includeNonTextDiffs, gnuDiffs);
    }

    @Override
    public InputStream getServerFileDiffs(IFileSpec file1, IFileSpec file2, String branchSpecName, DiffType diffType, boolean quiet, boolean includeNonTextDiffs, boolean gnuDiffs) throws ConnectionException, RequestException, AccessException {
        return this.diff2Delegator.getServerFileDiffs(file1, file2, branchSpecName, diffType, quiet, includeNonTextDiffs, gnuDiffs);
    }

    @Override
    public List<IDiskSpace> getDiskSpace(List<String> filesystems) throws P4JavaException {
        return this.diskspaceDelegator.getDiskSpace(filesystems);
    }

    @Override
    public List<IFileSpec> duplicateRevisions(IFileSpec fromFile, IFileSpec toFile, DuplicateRevisionsOptions opts) throws P4JavaException {
        return this.duplicateDelegator.duplicateRevisions(fromFile, toFile, opts);
    }

    @Override
    public List<Map<String, Object>> getExportRecords(ExportRecordsOptions opts) throws P4JavaException {
        return this.exportDelegator.getExportRecords(opts);
    }

    @Override
    public void getStreamingExportRecords(ExportRecordsOptions opts, @Nonnull IStreamingCallback callback, int key) throws P4JavaException {
        this.exportDelegator.getStreamingExportRecords(opts, callback, key);
    }

    @Override
    public List<Map<String, Object>> getExportRecords(boolean useJournal, long maxRecs, int sourceNum, long offset, boolean format, String journalPrefix, String filter) throws ConnectionException, RequestException, AccessException {
        return this.exportDelegator.getExportRecords(useJournal, maxRecs, sourceNum, offset, format, journalPrefix, filter);
    }

    @Override
    public List<IFileAnnotation> getFileAnnotations(List<IFileSpec> fileSpecs, @Nonnull DiffType wsOpts, boolean allResults, boolean useChangeNumbers, boolean followBranches) throws ConnectionException, RequestException, AccessException {
        return this.fileAnnotateDelegator.getFileAnnotations(fileSpecs, wsOpts, allResults, useChangeNumbers, followBranches);
    }

    @Override
    public List<IFileAnnotation> getFileAnnotations(List<IFileSpec> fileSpecs, GetFileAnnotationsOptions opts) throws P4JavaException {
        return this.fileAnnotateDelegator.getFileAnnotations(fileSpecs, opts);
    }

    @Override
    public Map<IFileSpec, List<IFileRevisionData>> getRevisionHistory(List<IFileSpec> fileSpecs, GetRevisionHistoryOptions opts) throws P4JavaException {
        return this.fileLogDelegator.getRevisionHistory(fileSpecs, opts);
    }

    @Override
    public Map<IFileSpec, List<IFileRevisionData>> getRevisionHistory(List<IFileSpec> fileSpecs, int maxRevs, boolean contentHistory, boolean includeInherited, boolean longOutput, boolean truncatedLongOutput) throws ConnectionException, AccessException {
        return this.fileLogDelegator.getRevisionHistory(fileSpecs, maxRevs, contentHistory, includeInherited, longOutput, truncatedLongOutput);
    }

    @Override
    public List<IFileSpec> getDirectories(@Nonnull List<IFileSpec> fileSpecs, boolean clientOnly, boolean deletedOnly, boolean haveListOnly) throws ConnectionException, AccessException {
        return this.dirsDelegator.getDirectories(fileSpecs, clientOnly, deletedOnly, haveListOnly);
    }

    @Override
    public List<IFileSpec> getDirectories(List<IFileSpec> fileSpecs, GetDirectoriesOptions opts) throws P4JavaException {
        return this.dirsDelegator.getDirectories(fileSpecs, opts);
    }

    @Override
    public List<IFileSpec> getDepotFiles(@Nonnull List<IFileSpec> fileSpecs, boolean allRevs) throws ConnectionException, AccessException {
        return this.filesDelegator.getDepotFiles(fileSpecs, allRevs);
    }

    @Override
    public List<IFileSpec> getDepotFiles(@Nonnull List<IFileSpec> fileSpecs, GetDepotFilesOptions opts) throws P4JavaException {
        return this.filesDelegator.getDepotFiles(fileSpecs, opts);
    }

    @Override
    public List<IFix> fixJobs(List<String> jobIds, int changeListId, String status, boolean delete) throws ConnectionException, RequestException, AccessException {
        return this.fixDelegator.fixJobs(jobIds, changeListId, status, delete);
    }

    @Override
    public List<IFix> fixJobs(@Nonnull List<String> jobIds, int changeListId, FixJobsOptions opts) throws P4JavaException {
        return this.fixDelegator.fixJobs(jobIds, changeListId, opts);
    }

    @Override
    public List<IFix> getFixList(List<IFileSpec> fileSpecs, int changeListId, String jobId, boolean includeIntegrations, int maxFixes) throws ConnectionException, RequestException, AccessException {
        return this.fixesDelegator.getFixList(fileSpecs, changeListId, jobId, includeIntegrations, maxFixes);
    }

    @Override
    public List<IFix> getFixes(List<IFileSpec> fileSpecs, GetFixesOptions opts) throws P4JavaException {
        return this.fixesDelegator.getFixes(fileSpecs, opts);
    }

    @Override
    public List<IExtendedFileSpec> getExtendedFiles(List<IFileSpec> fileSpecs, int maxFiles, int sinceChangelist, int affectedByChangelist, FileStatOutputOptions outputOptions, FileStatAncilliaryOptions ancilliaryOptions) throws ConnectionException, AccessException {
        return this.fstatDelegator.getExtendedFiles(fileSpecs, maxFiles, sinceChangelist, affectedByChangelist, outputOptions, ancilliaryOptions);
    }

    @Override
    public List<IExtendedFileSpec> getExtendedFiles(List<IFileSpec> fileSpecs, GetExtendedFilesOptions opts) throws P4JavaException {
        return this.fstatDelegator.getExtendedFiles(fileSpecs, opts);
    }

    @Override
    public List<IFileLineMatch> getMatchingLines(List<IFileSpec> fileSpecs, String pattern, MatchingLinesOptions options) throws P4JavaException {
        return this.grepDelegator.getMatchingLines(fileSpecs, pattern, options);
    }

    @Override
    public List<IFileLineMatch> getMatchingLines(@Nonnull List<IFileSpec> fileSpecs, @Nonnull String pattern, @Nullable List<String> infoLines, MatchingLinesOptions options) throws P4JavaException {
        return this.grepDelegator.getMatchingLines(fileSpecs, pattern, infoLines, options);
    }

    @Override
    public IServerInfo getServerInfo() throws ConnectionException, RequestException, AccessException {
        return this.infoDelegator.getServerInfo();
    }

    @Override
    public String createUserGroup(IUserGroup group) throws ConnectionException, RequestException, AccessException {
        return this.groupDelegator.createUserGroup(group);
    }

    @Override
    public String createUserGroup(IUserGroup group, UpdateUserGroupOptions opts) throws P4JavaException {
        return this.groupDelegator.createUserGroup(group, opts);
    }

    @Override
    public String deleteUserGroup(IUserGroup group) throws ConnectionException, RequestException, AccessException {
        return this.groupDelegator.deleteUserGroup(group);
    }

    @Override
    public String deleteUserGroup(IUserGroup group, UpdateUserGroupOptions opts) throws P4JavaException {
        return this.groupDelegator.deleteUserGroup(group, opts);
    }

    @Override
    public IUserGroup getUserGroup(String name) throws ConnectionException, RequestException, AccessException {
        return this.groupDelegator.getUserGroup(name);
    }

    @Override
    public String updateUserGroup(IUserGroup group, boolean updateIfOwner) throws ConnectionException, RequestException, AccessException {
        return this.groupDelegator.updateUserGroup(group, updateIfOwner);
    }

    @Override
    public String updateUserGroup(IUserGroup group, UpdateUserGroupOptions opts) throws P4JavaException {
        return this.groupDelegator.updateUserGroup(group, opts);
    }

    @Override
    public List<IUserGroup> getUserGroups(String userOrGroupName, GetUserGroupsOptions opts) throws P4JavaException {
        return this.groupsDelegator.getUserGroups(userOrGroupName, opts);
    }

    @Override
    public List<IUserGroup> getUserGroups(String userOrGroupName, boolean indirect, boolean displayValues, int maxGroups) throws ConnectionException, RequestException, AccessException {
        return this.groupsDelegator.getUserGroups(userOrGroupName, indirect, displayValues, maxGroups);
    }

    @Override
    public List<IFileSpec> getSubmittedIntegrations(List<IFileSpec> fileSpecs, String branchSpec, boolean reverseMappings) throws ConnectionException, RequestException, AccessException {
        return this.integratedDelegator.getSubmittedIntegrations(fileSpecs, branchSpec, reverseMappings);
    }

    @Override
    public List<IFileSpec> getSubmittedIntegrations(List<IFileSpec> fileSpecs, GetSubmittedIntegrationsOptions opts) throws P4JavaException {
        return this.integratedDelegator.getSubmittedIntegrations(fileSpecs, opts);
    }

    @Override
    public IStreamIntegrationStatus getStreamIntegrationStatus(String stream, StreamIntegrationStatusOptions opts) throws P4JavaException {
        return this.statDelegator.getStreamIntegrationStatus(stream, opts);
    }

    @Override
    public IJob createJob(@Nonnull Map<String, Object> fieldMap) throws ConnectionException, RequestException, AccessException {
        return this.jobDelegator.createJob(fieldMap);
    }

    @Override
    public String deleteJob(String jobId) throws ConnectionException, RequestException, AccessException {
        return this.jobDelegator.deleteJob(jobId);
    }

    @Override
    public IJob getJob(String jobId) throws ConnectionException, RequestException, AccessException {
        return this.jobDelegator.getJob(jobId);
    }

    @Override
    public String updateJob(@Nonnull IJob job) throws ConnectionException, RequestException, AccessException {
        return this.jobDelegator.updateJob(job);
    }

    @Override
    public List<IJob> getJobs(List<IFileSpec> fileSpecs, int maxJobs, boolean longDescriptions, boolean reverseOrder, boolean includeIntegrated, String jobView) throws ConnectionException, RequestException, AccessException {
        return this.jobsDelegator.getJobs(fileSpecs, maxJobs, longDescriptions, reverseOrder, includeIntegrated, jobView);
    }

    @Override
    public List<IJob> getJobs(List<IFileSpec> fileSpecs, GetJobsOptions opts) throws P4JavaException {
        return this.jobsDelegator.getJobs(fileSpecs, opts);
    }

    @Override
    public IJobSpec getJobSpec() throws ConnectionException, RequestException, AccessException {
        return this.jobSpecDelegator.getJobSpec();
    }

    @Override
    public String deleteKey(String keyName) throws P4JavaException {
        return this.keyDelegator.deleteKey(keyName);
    }

    @Override
    public String setKey(String keyName, String value, KeyOptions opts) throws P4JavaException {
        return this.keyDelegator.setKey(keyName, value, opts);
    }

    @Override
    public String getKey(String keyName) throws P4JavaException {
        return this.keyDelegator.getKey(keyName);
    }

    @Override
    public Map<String, String> getKeys(GetKeysOptions opts) throws P4JavaException {
        return this.keysDelegator.getKeys(opts);
    }

    @Override
    public String createLabel(@Nonnull ILabel label) throws ConnectionException, RequestException, AccessException {
        return this.labelDelegator.createLabel(label);
    }

    @Override
    public String deleteLabel(String labelName, boolean force) throws ConnectionException, RequestException, AccessException {
        return this.labelDelegator.deleteLabel(labelName, force);
    }

    @Override
    public String deleteLabel(String labelName, DeleteLabelOptions opts) throws P4JavaException {
        return this.labelDelegator.deleteLabel(labelName, opts);
    }

    @Override
    public ILabel getLabel(String labelName) throws ConnectionException, RequestException, AccessException {
        return this.labelDelegator.getLabel(labelName);
    }

    @Override
    public String updateLabel(@Nonnull ILabel label) throws ConnectionException, RequestException, AccessException {
        return this.labelDelegator.updateLabel(label);
    }

    @Override
    public List<ILabelSummary> getLabels(String user, int maxLabels, String nameFilter, List<IFileSpec> fileList) throws ConnectionException, RequestException, AccessException {
        return this.labelsDelegator.getLabels(user, maxLabels, nameFilter, fileList);
    }

    @Override
    public List<ILabelSummary> getLabels(List<IFileSpec> fileList, GetLabelsOptions opts) throws P4JavaException {
        return this.labelsDelegator.getLabels(fileList, opts);
    }

    @Override
    public void journalWait(JournalWaitOptions opts) throws P4JavaException {
        this.journalWaitDelegator.journalWait(opts);
    }

    @Override
    public String getLoginStatus() throws P4JavaException {
        return this.loginDelegator.getLoginStatus();
    }

    @Override
    public void login(String password) throws ConnectionException, RequestException, AccessException, ConfigException {
        this.loginDelegator.login(password);
    }

    @Override
    public void login(String password, boolean allHosts) throws ConnectionException, RequestException, AccessException, ConfigException {
        this.loginDelegator.login(password, allHosts);
    }

    @Override
    public void login(String password, LoginOptions opts) throws P4JavaException {
        this.loginDelegator.login(password, opts);
    }

    @Override
    public void login(String password, StringBuffer ticket, LoginOptions opts) throws P4JavaException {
        this.loginDelegator.login(password, ticket, opts);
    }

    @Override
    public void login(@Nonnull IUser user, StringBuffer ticket, LoginOptions opts) throws P4JavaException {
        this.loginDelegator.login(user, ticket, opts);
    }

    @Override
    public boolean isDontWriteTicket(String cmd, String[] cmdArgs) {
        return this.loginDelegator.isDontWriteTicket(cmd, cmdArgs);
    }

    @Override
    public List<Map<String, Object>> login2(Login2Options opts, String user) throws P4JavaException {
        return this.login2Delegator.login2(opts, user);
    }

    @Override
    public String getLogin2Status() throws P4JavaException {
        return this.login2Delegator.getLogin2Status();
    }

    @Override
    public String getLogin2Status(IUser user) throws P4JavaException {
        return this.login2Delegator.getLogin2Status(user);
    }

    @Override
    public Map<String, String> login2ListMethods() throws P4JavaException {
        return this.login2Delegator.login2ListMethods();
    }

    @Override
    public String login2InitAuth(String method) throws P4JavaException {
        return this.login2Delegator.login2InitAuth(method);
    }

    @Override
    public String login2CheckAuth(String auth, boolean persist) throws P4JavaException {
        return this.login2Delegator.login2CheckAuth(auth, persist);
    }

    @Override
    public String login2(IUser user, Login2Options opts) throws P4JavaException {
        return this.login2Delegator.login2(user, opts);
    }

    @Override
    public void logout() throws ConnectionException, RequestException, AccessException, ConfigException {
        this.logoutDelegator.logout();
    }

    @Override
    public void logout(LoginOptions opts) throws P4JavaException {
        this.logoutDelegator.logout(opts);
    }

    @Override
    public List<IServerProcess> getServerProcesses() throws ConnectionException, RequestException, AccessException {
        return this.monitorDelegator.getServerProcesses();
    }

    @Override
    public List<IServerProcess> getServerProcesses(GetServerProcessesOptions opts) throws P4JavaException {
        return this.monitorDelegator.getServerProcesses(opts);
    }

    @Override
    public ILogTail getLogTail(LogTailOptions opts) throws P4JavaException {
        return this.logTailDelegator.getLogTail(opts);
    }

    @Override
    public List<IFileSpec> getOpenedFiles(List<IFileSpec> fileSpecs, boolean allClients, String clientName, int maxFiles, int changeListId) throws ConnectionException, AccessException {
        return this.openedDelegator.getOpenedFiles(fileSpecs, allClients, clientName, maxFiles, changeListId);
    }

    @Override
    public List<IFileSpec> getOpenedFiles(List<IFileSpec> fileSpecs, OpenedFilesOptions opts) throws P4JavaException {
        return this.openedDelegator.getOpenedFiles(fileSpecs, opts);
    }

    @Override
    public List<IFileSpec> moveFile(int changelistId, boolean listOnly, boolean noClientMove, String fileType, @Nonnull IFileSpec fromFile, @Nonnull IFileSpec toFile) throws ConnectionException, RequestException, AccessException {
        return this.moveDelegator.moveFile(changelistId, listOnly, noClientMove, fileType, fromFile, toFile);
    }

    @Override
    public List<IFileSpec> moveFile(@Nonnull IFileSpec fromFile, @Nonnull IFileSpec toFile, @Nullable MoveFileOptions opts) throws P4JavaException {
        return this.moveDelegator.moveFile(fromFile, toFile, opts);
    }

    @Override
    public List<IObliterateResult> obliterateFiles(@Nonnull List<IFileSpec> fileSpecs, ObliterateFilesOptions opts) throws P4JavaException {
        return this.obliterateDelegator.obliterateFiles(fileSpecs, opts);
    }

    @Override
    public String changePassword(String oldPassword, String newPassword, String userName) throws P4JavaException {
        return this.passwdDelegator.changePassword(oldPassword, newPassword, userName);
    }

    @Override
    public InputStream getFileContents(List<IFileSpec> fileSpecs, GetFileContentsOptions opts) throws P4JavaException {
        return this.printDelegator.getFileContents(fileSpecs, opts);
    }

    @Override
    public InputStream getFileContents(List<IFileSpec> fileSpecs, boolean allrevs, boolean noHeaderLine) throws ConnectionException, RequestException, AccessException {
        return this.printDelegator.getFileContents(fileSpecs, allrevs, noHeaderLine);
    }

    @Override
    public String setProperty(String name, String value, PropertyOptions opts) throws P4JavaException {
        return this.propertyDelegator.setProperty(name, value, opts);
    }

    @Override
    public List<IProperty> getProperty(GetPropertyOptions opts) throws P4JavaException {
        return this.propertyDelegator.getProperty(opts);
    }

    @Override
    public String deleteProperty(String name, PropertyOptions opts) throws P4JavaException {
        return this.propertyDelegator.deleteProperty(name, opts);
    }

    @Override
    public String createProtectionEntries(@Nonnull List<IProtectionEntry> entryList) throws P4JavaException {
        return this.protectDelegator.createProtectionEntries(entryList);
    }

    @Override
    public String updateProtectionEntries(@Nonnull List<IProtectionEntry> entryList) throws P4JavaException {
        return this.protectDelegator.updateProtectionEntries(entryList);
    }

    @Override
    public InputStream getProtectionsTable() throws P4JavaException {
        return this.protectDelegator.getProtectionsTable();
    }

    @Override
    public List<IProtectionEntry> getProtectionEntries(List<IFileSpec> fileList, GetProtectionEntriesOptions opts) throws P4JavaException {
        return this.protectsDelegator.getProtectionEntries(fileList, opts);
    }

    @Override
    public List<IProtectionEntry> getProtectionEntries(boolean allUsers, String hostName, String userName, String groupName, List<IFileSpec> fileList) throws ConnectionException, RequestException, AccessException {
        return this.protectsDelegator.getProtectionEntries(allUsers, hostName, userName, groupName, fileList);
    }

    @Override
    public String reload(ReloadOptions opts) throws P4JavaException {
        return this.reloadDelegator.reload(opts);
    }

    @Override
    public String renameUser(String oldUserName, String newUserName) throws P4JavaException {
        return this.renameUserDelegator.renameUser(oldUserName, newUserName);
    }

    @Override
    public List<IReviewChangelist> getReviewChangelists(GetReviewChangelistsOptions opts) throws P4JavaException {
        return this.reviewDelegator.getReviewChangelists(opts);
    }

    @Override
    public List<IUserSummary> getReviews(int changelistId, List<IFileSpec> fileSpecs) throws ConnectionException, RequestException, AccessException {
        return this.reviewsDelegator.getReviews(changelistId, fileSpecs);
    }

    @Override
    public List<IUserSummary> getReviews(List<IFileSpec> fileSpecs, GetReviewsOptions opts) throws P4JavaException {
        return this.reviewsDelegator.getReviews(fileSpecs, opts);
    }

    @Override
    public List<String> searchJobs(String words, SearchJobsOptions opts) throws P4JavaException {
        return this.searchDelegator.searchJobs(words, opts);
    }

    @Override
    public List<IFileSize> getFileSizes(List<IFileSpec> fileSpecs, GetFileSizesOptions opts) throws P4JavaException {
        return this.sizesDelegator.getFileSizes(fileSpecs, opts);
    }

    @Override
    public String createStream(@Nonnull IStream stream) throws P4JavaException {
        return this.streamDelegator.createStream(stream);
    }

    @Override
    public IStream getStream(@Nonnull String streamPath) throws P4JavaException {
        return this.streamDelegator.getStream(streamPath);
    }

    @Override
    public IStream getStream(String streamPath, GetStreamOptions opts) throws P4JavaException {
        return this.streamDelegator.getStream(streamPath, opts);
    }

    @Override
    public String updateStream(IStream stream, StreamOptions opts) throws P4JavaException {
        return this.streamDelegator.updateStream(stream, opts);
    }

    @Override
    public String deleteStream(String streamPath, StreamOptions opts) throws P4JavaException {
        return this.streamDelegator.deleteStream(streamPath, opts);
    }

    @Override
    public List<IStreamSummary> getStreams(List<String> streamPaths, GetStreamsOptions opts) throws P4JavaException {
        return this.streamsDelegator.getStreams(streamPaths, opts);
    }

    @Override
    public List<IFileSpec> tagFiles(List<IFileSpec> fileSpecs, String labelName, boolean listOnly, boolean delete) throws ConnectionException, RequestException, AccessException {
        return this.tagDelegator.tagFiles(fileSpecs, labelName, listOnly, delete);
    }

    @Override
    public List<IFileSpec> tagFiles(List<IFileSpec> fileSpecs, String labelName, TagFilesOptions opts) throws P4JavaException {
        return this.tagDelegator.tagFiles(fileSpecs, labelName, opts);
    }

    @Override
    public String createTriggerEntries(@Nonnull List<ITriggerEntry> entryList) throws P4JavaException {
        return this.triggersDelegator.createTriggerEntries(entryList);
    }

    @Override
    public List<ITriggerEntry> getTriggerEntries() throws P4JavaException {
        return this.triggersDelegator.getTriggerEntries();
    }

    @Override
    public String updateTriggerEntries(@Nonnull List<ITriggerEntry> entryList) throws P4JavaException {
        return this.triggersDelegator.updateTriggerEntries(entryList);
    }

    @Override
    public InputStream getTriggersTable() throws P4JavaException {
        return this.triggersDelegator.getTriggersTable();
    }

    @Override
    public String createUser(@Nonnull IUser user, boolean force) throws ConnectionException, RequestException, AccessException {
        return this.userDelegator.createUser(user, force);
    }

    @Override
    public String createUser(@Nonnull IUser user, UpdateUserOptions opts) throws P4JavaException {
        return this.userDelegator.createUser(user, opts);
    }

    @Override
    public String updateUser(@Nonnull IUser user, UpdateUserOptions opts) throws P4JavaException {
        return this.userDelegator.updateUser(user, opts);
    }

    @Override
    public String updateUser(@Nonnull IUser user, boolean force) throws ConnectionException, RequestException, AccessException {
        return this.userDelegator.updateUser(user, force);
    }

    @Override
    public String deleteUser(String userName, boolean force) throws ConnectionException, RequestException, AccessException {
        return this.userDelegator.deleteUser(userName, force);
    }

    @Override
    public String deleteUser(String userName, UpdateUserOptions opts) throws P4JavaException {
        return this.userDelegator.deleteUser(userName, opts);
    }

    @Override
    public IUser getUser(String userName) throws ConnectionException, RequestException, AccessException {
        return this.userDelegator.getUser(userName);
    }

    @Override
    public List<IUserSummary> getUsers(List<String> userList, int maxUsers) throws ConnectionException, RequestException, AccessException {
        return this.usersDelegator.getUsers(userList, maxUsers);
    }

    @Override
    public List<IUserSummary> getUsers(List<String> userList, GetUsersOptions opts) throws P4JavaException {
        return this.usersDelegator.getUsers(userList, opts);
    }

    @Override
    public String unload(UnloadOptions opts) throws P4JavaException {
        return this.unloadDelegator.unload(opts);
    }

    @Override
    public List<IExtendedFileSpec> verifyFiles(List<IFileSpec> fileSpecs, VerifyFilesOptions opts) throws P4JavaException {
        return this.verifyDelegator.verifyFiles(fileSpecs, opts);
    }

    @Override
    public List<IGraphListTree> getGraphListTree(String sha) throws P4JavaException {
        return this.graphListTreeDelegator.getGraphListTree(sha);
    }

    @Override
    public List<IGraphRef> getGraphShowRefs(GraphShowRefOptions opts) throws P4JavaException {
        return this.graphShowRefDelegator.getGraphShowRefs(opts);
    }

    @Override
    public Map<String, Object> getSpec(CustomSpec type) throws P4JavaException {
        return this.specDelegator.getSpec(type);
    }

    @Override
    public String updateSpec(CustomSpec type, Map<String, Object> spec) throws P4JavaException {
        return this.specDelegator.updateSpec(type, spec);
    }

    @Override
    public String updateSpecString(CustomSpec type, String spec) throws P4JavaException {
        return this.specDelegator.updateSpecString(type, spec);
    }

    @Override
    public ILicenseLimits getLimits() throws P4JavaException {
        return this.licenseDelegator.getLimits();
    }

    @Override
    public ILicense getLicense() throws P4JavaException {
        return this.licenseDelegator.getLicense();
    }

    @Override
    public String updateLicense(ILicense license) throws P4JavaException {
        return this.licenseDelegator.updateLicense(license);
    }

    @Override
    public String sampleExtension(String extnName) throws P4JavaException {
        return this.extensionDelegator.sampleExtension(extnName);
    }

    @Override
    public String packageExtension(String dirName) throws P4JavaException {
        return this.extensionDelegator.packageExtension(dirName);
    }

    @Override
    public String installExtension(String extnPackageName, boolean allowUnsigned) throws P4JavaException {
        return this.extensionDelegator.installExtension(extnPackageName, allowUnsigned);
    }

    @Override
    public String createExtensionConfig(IExtension extension, String namespace, String instanceConfig) throws P4JavaException {
        return this.extensionDelegator.createExtensionConfig(extension, namespace, instanceConfig);
    }

    @Override
    public String updateExtensionConfig(IExtension extension, String namespace, String instanceConfig) throws P4JavaException {
        return this.extensionDelegator.updateExtensionConfig(extension, namespace, instanceConfig);
    }

    @Override
    public List<Map<String, Object>> listExtensions(String type) throws P4JavaException {
        return this.extensionDelegator.listExtensions(type);
    }

    @Override
    public String deleteExtension(String namespace, String extnName) throws P4JavaException {
        return this.extensionDelegator.deleteExtension(namespace, extnName);
    }

    @Override
    public Extension getExtension(String namespace, String name, String instanceName) throws P4JavaException {
        return this.extensionDelegator.getExtension(namespace, name, instanceName);
    }

    @Override
    public ICommit getCommitObject(String sha) throws P4JavaException {
        return this.graphCommitDelegator.getCommitObject(sha);
    }

    @Override
    public ICommit getCommitObject(String sha, String repo) throws P4JavaException {
        return this.graphCommitDelegator.getCommitObject(sha, repo);
    }

    @Override
    public InputStream getBlobObject(String repo, String sha) throws P4JavaException {
        return this.graphCommitDelegator.getBlobObject(repo, sha);
    }

    @Override
    public IGraphObject getGraphObject(String sha) throws P4JavaException {
        return this.graphCommitDelegator.getGraphObject(sha);
    }

    @Deprecated
    public IFileSpec handleFileReturn(Map<String, Object> map) throws AccessException, ConnectionException {
        return ResultListBuilder.handleFileReturn(map, this);
    }

    @Deprecated
    public IFileSpec handleFileReturn(Map<String, Object> map, IClient client) throws AccessException, ConnectionException {
        return ResultListBuilder.handleFileReturn(map, this);
    }

    public abstract IServerAddress getServerAddressDetails();
}

