/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.server;

import com.perforce.p4java.CharsetDefs;
import com.perforce.p4java.Log;
import com.perforce.p4java.Metadata;
import com.perforce.p4java.common.base.OSUtils;
import com.perforce.p4java.exception.ConfigException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.NoSuchObjectException;
import com.perforce.p4java.exception.NullPointerError;
import com.perforce.p4java.exception.ResourceException;
import com.perforce.p4java.impl.generic.sys.ISystemFileCommandsHelper;
import com.perforce.p4java.impl.mapbased.rpc.NtsServerImpl;
import com.perforce.p4java.impl.mapbased.rpc.OneShotServerImpl;
import com.perforce.p4java.impl.mapbased.rpc.sys.helper.RpcSystemFileCommandsHelper;
import com.perforce.p4java.impl.mapbased.rpc.sys.helper.WindowsRpcSystemFileCommandsHelper;
import com.perforce.p4java.impl.mapbased.server.IServerControl;
import com.perforce.p4java.impl.mapbased.server.Server;
import com.perforce.p4java.impl.mapbased.server.ServerAddress;
import com.perforce.p4java.impl.mapbased.server.ServerAddressBuilder;
import com.perforce.p4java.option.UsageOptions;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.IServer;
import com.perforce.p4java.server.IServerAddress;
import com.perforce.p4java.server.IServerImplMetadata;
import com.perforce.p4java.server.ZeroconfHelper;
import com.perforce.p4java.server.ZeroconfServerInfo;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class ServerFactory {
    public static final String TRACE_PREFIX = "ServerFactory";
    public static final String DEFAULT_PROTOCOL_SPEC = IServerAddress.Protocol.P4JAVA.toString();
    public static final String DEFAULT_PROTOCOL_NAME = OneShotServerImpl.PROTOCOL_NAME;
    public static final String DEFAULT_SSL_PROTOCOL_NAME = OneShotServerImpl.SSL_PROTOCOL_NAME;
    public static final String ZEROCONF_CLASS_NAME = "javax.jmdns.JmDNS";
    private static Map<IServerAddress.Protocol, Class> implMap = new HashMap<IServerAddress.Protocol, Class>();
    private static ISystemFileCommandsHelper rpcFileCommandsHelper = null;
    private static ZeroconfHelper zcHelper = null;

    public static List<IServerImplMetadata> getAvailableImplementationMetadata() {
        HashMap<Class, IServerImplMetadata> implMetadataMap = new HashMap<Class, IServerImplMetadata>();
        for (IServerAddress.Protocol key : implMap.keySet()) {
            Class implClass = implMap.get((Object)key);
            IServerImplMetadata md = ServerFactory.getImplMetadata(implClass);
            if (md == null) continue;
            implMetadataMap.put(implClass, md);
        }
        return new ArrayList<IServerImplMetadata>(implMetadataMap.values());
    }

    public static IServer getServer(String serverUriString, Properties props) throws URISyntaxException, ConnectionException, NoSuchObjectException, ConfigException, ResourceException {
        return ServerFactory.getOptionsServer(serverUriString, props);
    }

    public static IOptionsServer getOptionsServer(String serverUriString, Properties props) throws URISyntaxException, ConnectionException, NoSuchObjectException, ConfigException, ResourceException {
        return ServerFactory.getOptionsServer(serverUriString, props, null);
    }

    public static IOptionsServer getOptionsServer(String serverUriString, Properties props, UsageOptions opts) throws URISyntaxException, ConnectionException, NoSuchObjectException, ConfigException, ResourceException {
        if (serverUriString == null) {
            throw new NullPointerError("Null server serverUriString passed to server factory");
        }
        Log.info("P4Java server factory called for Perforce server URI: " + serverUriString, new Object[0]);
        ServerAddressBuilder addressBuilder = new ServerAddressBuilder(serverUriString);
        ServerAddress serverAddress = addressBuilder.build();
        if (serverAddress == null) {
            throw new NullPointerError("Null server address constructed with Perforce server URI:" + serverUriString);
        }
        if (serverAddress.getProtocol() == null) {
            throw new URISyntaxException(serverUriString, "unknown protocol");
        }
        if (serverAddress.getHost() == null) {
            throw new URISyntaxException(serverUriString, "missing or malformed Perforce server hostname");
        }
        if (serverAddress.getPort() < 0) {
            throw new URISyntaxException(serverUriString, "missing or malformed Perforce server port specifier");
        }
        IServerImplMetadata implMetadata = ServerFactory.getImplMetadata(implMap.get((Object)serverAddress.getProtocol()));
        if (implMetadata == null) {
            throw new NoSuchObjectException("No such server implementation found for protocol '" + serverAddress.getProtocol().toString() + "'");
        }
        if (serverAddress.getProperties() != null) {
            if (props == null) {
                props = new Properties();
            }
            props.putAll((Map<?, ?>)serverAddress.getProperties());
        }
        try {
            Class<?> serverImplClass = Class.forName(implMetadata.getImplClassName());
            Log.info("Using Server implementation class: " + serverImplClass.getCanonicalName(), new Object[0]);
            IServerControl serverImpl = (IServerControl)serverImplClass.newInstance();
            serverImpl.init(serverAddress.getHost(), serverAddress.getPort(), props, opts, serverAddress.getProtocol().isSecure(), serverAddress.getRsh());
            return (IOptionsServer)((Object)serverImpl);
        }
        catch (ClassNotFoundException cnfe) {
            Log.error("Unable to instantiate Perforce server implementation class '" + implMetadata.getImplClassName() + "' (class not found)", new Object[0]);
            Log.exception(cnfe);
            throw new NoSuchObjectException("No such p4j server implementation class found for protocol", cnfe);
        }
        catch (ClassCastException cce) {
            Log.error("Unable to instantiate Perforce server implementation class '" + implMetadata.getImplClassName() + "' (class cast error)", new Object[0]);
            Log.exception(cce);
            throw new ConfigException("Specified Perforce server implementation class does not implement required interface(s)", cce);
        }
        catch (InstantiationException ie) {
            Log.error("Unable to instantiate Perforce server implementation class '" + implMetadata.getImplClassName() + "' (instantiation failed)", new Object[0]);
            Log.exception(ie);
            throw new ConfigException("Unable to instantiate Perforce server implementation class '" + implMetadata.getImplClassName() + "'", ie);
        }
        catch (IllegalAccessException iae) {
            Log.error("Unable to instantiate Perforce server implementation class '" + implMetadata.getImplClassName() + "' (illegal access exception)", new Object[0]);
            Log.exception(iae);
            throw new ConfigException("Unable to instantiate Perforce server class '" + implMetadata.getImplClassName() + "'", iae);
        }
    }

    @Deprecated
    public static IServer getServer(URI serverUrl, Properties props) throws ConnectionException, NoSuchObjectException, ConfigException, ResourceException, URISyntaxException {
        if (serverUrl == null) {
            throw new NullPointerError("Null server URI passed to server factory");
        }
        return ServerFactory.getServer(serverUrl.toString(), props);
    }

    private static IServerImplMetadata getImplMetadata(final Class<Server> implClass) {
        if (implClass == null) {
            return null;
        }
        return new IServerImplMetadata(){

            @Override
            public String getScreenName() {
                try {
                    return (String)implClass.getField("SCREEN_NAME").get(null);
                }
                catch (Exception exc) {
                    Log.error("Unexpected exception in ServerFactory.getImplMetadata: " + exc.getMessage(), new Object[0]);
                    Log.exception(exc);
                    return "Unknown";
                }
            }

            @Override
            public String getComments() {
                try {
                    return (String)implClass.getField("IMPL_COMMENTS").get(null);
                }
                catch (Exception exc) {
                    Log.error("Unexpected exception in ServerFactory.getImplMetadata: " + exc.getMessage(), new Object[0]);
                    Log.exception(exc);
                    return "No comments available";
                }
            }

            @Override
            public IServerImplMetadata.ImplType getImplType() {
                try {
                    return (IServerImplMetadata.ImplType)((Object)implClass.getField("IMPL_TYPE").get(null));
                }
                catch (Exception exc) {
                    Log.error("Unexpected exception in ServerFactory.getImplMetadata: " + exc.getMessage(), new Object[0]);
                    Log.exception(exc);
                    return IServerImplMetadata.ImplType.UNKNOWN;
                }
            }

            @Override
            public int getMinimumServerLevel() {
                try {
                    return (Integer)implClass.getField("MINIMUM_SUPPORTED_SERVER_LEVEL").get(null);
                }
                catch (Exception exc) {
                    Log.error("Unexpected exception in ServerFactory.getImplMetadata: " + exc.getMessage(), new Object[0]);
                    Log.exception(exc);
                    return -1;
                }
            }

            @Override
            public String getUriScheme() {
                try {
                    return (String)implClass.getField("PROTOCOL_NAME").get(null);
                }
                catch (Exception exc) {
                    Log.error("Unexpected exception in ServerFactory.getImplMetadata: " + exc.getMessage(), new Object[0]);
                    Log.exception(exc);
                    return "p4j";
                }
            }

            @Override
            public boolean isDefault() {
                try {
                    return (Boolean)implClass.getField("DEFAULT_STATUS").get(null);
                }
                catch (Exception exc) {
                    Log.error("Unexpected exception in ServerFactory.getImplMetadata: " + exc.getMessage(), new Object[0]);
                    Log.exception(exc);
                    return false;
                }
            }

            @Override
            public String getImplClassName() {
                try {
                    return implClass.getCanonicalName();
                }
                catch (Exception exc) {
                    Log.error("Unexpected exception in ServerFactory.getImplMetadata: " + exc.getMessage(), new Object[0]);
                    Log.exception(exc);
                    return "com.perforce.p4java.NoSuchImplClass";
                }
            }
        };
    }

    public static void setRpcFileSystemHelper(ISystemFileCommandsHelper fsCmdHelper) {
        rpcFileCommandsHelper = fsCmdHelper;
        Log.info("setting RPC system file helper to " + (fsCmdHelper == null ? "null" : "class " + fsCmdHelper.getClass().getCanonicalName()), new Object[0]);
    }

    public static ISystemFileCommandsHelper getRpcFileSystemHelper() {
        return rpcFileCommandsHelper;
    }

    @Deprecated
    public static List<ZeroconfServerInfo> getZeroconfServers() throws ConfigException {
        if (zcHelper == null) {
            zcHelper = new ZeroconfHelper();
        }
        return zcHelper.getZeroconfServers();
    }

    @Deprecated
    public static boolean isZeroConfAvailable() {
        if (zcHelper == null) {
            zcHelper = new ZeroconfHelper();
        }
        return zcHelper.isZeroConfAvailable();
    }

    static {
        implMap.put(IServerAddress.Protocol.P4JAVA, OneShotServerImpl.class);
        implMap.put(IServerAddress.Protocol.P4JAVASSL, OneShotServerImpl.class);
        implMap.put(IServerAddress.Protocol.P4JRPC, OneShotServerImpl.class);
        implMap.put(IServerAddress.Protocol.P4JRPCSSL, OneShotServerImpl.class);
        implMap.put(IServerAddress.Protocol.P4JRPCNTS, NtsServerImpl.class);
        implMap.put(IServerAddress.Protocol.P4JRPCNTSSSL, NtsServerImpl.class);
        implMap.put(IServerAddress.Protocol.P4JRSH, OneShotServerImpl.class);
        implMap.put(IServerAddress.Protocol.P4JRSHNTS, NtsServerImpl.class);
        Log.info("P4Java server factory loaded; version: " + Metadata.getP4JVersionString() + "; date: " + Metadata.getP4JDateString(), new Object[0]);
        Log.info("Using default charset: " + CharsetDefs.DEFAULT + "; JVM charset: " + CharsetDefs.LOCAL, new Object[0]);
        rpcFileCommandsHelper = OSUtils.isWindows() ? new WindowsRpcSystemFileCommandsHelper() : new RpcSystemFileCommandsHelper();
        Log.info("Using default RPC system file command helper: " + rpcFileCommandsHelper.getClass().getCanonicalName(), new Object[0]);
    }
}

