/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.connection;

import com.perforce.p4java.CharsetDefs;
import com.perforce.p4java.Log;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.NullPointerError;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.impl.mapbased.rpc.ServerStats;
import com.perforce.p4java.impl.mapbased.rpc.connection.RpcConnectionFlowControl;
import com.perforce.p4java.impl.mapbased.rpc.func.helper.MD5Digester;
import com.perforce.p4java.impl.mapbased.rpc.packet.RpcPacket;
import com.perforce.p4java.impl.mapbased.rpc.packet.RpcPacketDispatcher;
import com.perforce.p4java.impl.mapbased.rpc.packet.helper.RpcPacketFieldRule;
import com.perforce.p4java.impl.mapbased.rpc.sys.RpcPerforceDigestType;
import com.perforce.p4java.impl.mapbased.rpc.sys.RpcPerforceFileType;
import com.perforce.p4java.impl.mapbased.rpc.sys.helper.SymbolicLinkHelper;
import com.perforce.p4java.server.P4Charset;
import com.perforce.p4java.server.callback.IFilterCallback;
import com.perforce.p4java.util.PropertiesHelper;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;

public abstract class RpcConnection {
    public static final String TRACE_PREFIX = "RpcConnection";
    public static final Charset UNICODE_SERVER_CHARSET = CharsetDefs.UTF8;
    public static final String UNICODE_SERVER_CHARSET_NAME = CharsetDefs.UTF8_NAME;
    public static final Charset NON_UNICODE_SERVER_CHARSET = CharsetDefs.DEFAULT;
    public static final String NON_UNICODE_SERVER_CHARSET_NAME = CharsetDefs.DEFAULT_NAME;
    protected static final String UNKNOWN_SERVER_HOST = null;
    protected static final int UNKNOWN_SERVER_PORT = -1;
    protected Properties props = null;
    protected RpcConnectionFlowControl flowController = new RpcConnectionFlowControl();
    protected ServerStats stats = null;
    protected P4Charset p4Charset = null;
    protected String hostIp = UNKNOWN_SERVER_HOST;
    protected String ourIp = UNKNOWN_SERVER_HOST;
    protected String hostName = UNKNOWN_SERVER_HOST;
    protected int hostPort = -1;
    protected int ourPort = -1;
    protected boolean usingCompression = false;
    protected boolean unicodeServer = false;
    protected boolean secure = false;
    protected String fingerprint = null;
    protected boolean trusted = false;

    public RpcConnection(String serverHost, int serverPort, Properties props, ServerStats stats, P4Charset p4Charset) throws ConnectionException {
        this(serverHost, serverPort, props, stats, p4Charset, false);
    }

    public RpcConnection(@Nonnull String serverHost, int serverPort, Properties props, ServerStats stats, P4Charset p4Charset, boolean secure) throws ConnectionException {
        this.hostName = (String)Validate.notNull((Object)serverHost);
        this.hostPort = serverPort;
        this.secure = secure;
        this.p4Charset = (P4Charset)ObjectUtils.firstNonNull((Object[])new P4Charset[]{p4Charset, P4Charset.getDefault()});
        this.stats = (ServerStats)ObjectUtils.firstNonNull((Object[])new ServerStats[]{stats, new ServerStats()});
        this.props = (Properties)ObjectUtils.firstNonNull((Object[])new Properties[]{props, new Properties()});
        this.stats.serverConnections.incrementAndGet();
        this.unicodeServer = P4Charset.isUnicodeServer(p4Charset);
    }

    public abstract String getServerIpPort();

    public abstract String getClientIpPort();

    public abstract void disconnect(RpcPacketDispatcher var1) throws ConnectionException;

    public abstract long putRpcPacket(RpcPacket var1) throws ConnectionException;

    public abstract long putRpcPackets(RpcPacket[] var1) throws ConnectionException;

    public abstract RpcPacket getRpcPacket() throws ConnectionException;

    public abstract RpcPacket getRpcPacket(RpcPacketFieldRule var1, IFilterCallback var2) throws ConnectionException;

    public abstract int getSystemSendBufferSize();

    public abstract int getSystemRecvBufferSize();

    public byte[] marshalPacketField(String key, Object value) {
        byte[] retBytes = null;
        byte[] keyBytes = null;
        byte[] valBytes = null;
        byte[] valLengthBytes = null;
        if (key != null) {
            keyBytes = this.getNormalizedBytes(key);
        }
        valLengthBytes = RpcPacket.encodeInt4((valBytes = this.marshalPacketValue(value)) == null ? 0 : valBytes.length);
        int fieldLength = 2 + (keyBytes == null ? 0 : keyBytes.length) + valLengthBytes.length + (valBytes == null ? 0 : valBytes.length);
        retBytes = new byte[fieldLength];
        int retBytesPos = 0;
        if (keyBytes != null) {
            System.arraycopy(keyBytes, 0, retBytes, retBytesPos, keyBytes.length);
            retBytesPos += keyBytes.length;
        }
        retBytes[retBytesPos++] = 0;
        System.arraycopy(valLengthBytes, 0, retBytes, retBytesPos, valLengthBytes.length);
        retBytesPos += valLengthBytes.length;
        if (valBytes != null) {
            System.arraycopy(valBytes, 0, retBytes, retBytesPos, valBytes.length);
            retBytesPos += valBytes.length;
        }
        retBytes[retBytesPos++] = 0;
        return retBytes;
    }

    protected byte[] marshalPacketValue(Object value) {
        byte[] valBytes;
        block7: {
            valBytes = null;
            try {
                if (value == null) break block7;
                if (value.getClass() == String.class) {
                    valBytes = this.getNormalizedBytes((String)value);
                    break block7;
                }
                if (value instanceof byte[]) {
                    valBytes = (byte[])value;
                    break block7;
                }
                if (value instanceof StringBuffer) {
                    valBytes = this.getNormalizedBytes(value.toString());
                    break block7;
                }
                if (value instanceof ByteBuffer) {
                    int valLength = ((ByteBuffer)value).limit();
                    valBytes = new byte[valLength];
                    ((ByteBuffer)value).get(valBytes);
                    break block7;
                }
                throw new P4JavaError("Unmarshalable value in RpcStreamConnection.marshal; type: " + value.getClass().getCanonicalName());
            }
            catch (P4JavaError p4jerr) {
                throw p4jerr;
            }
            catch (Throwable thr) {
                Log.error("Unexpected exception in RpcStreamConnection.marshalValue: " + thr.getLocalizedMessage(), new Object[0]);
                Log.exception(thr);
                throw new P4JavaError("Unexpected exception in RpcStreamConnection.marshalValue: " + thr.getLocalizedMessage());
            }
        }
        return valBytes;
    }

    public void useConnectionCompression() throws ConnectionException {
        if (!this.usingCompression) {
            this.usingCompression = true;
        }
    }

    protected byte[] getNormalizedBytes(String str) {
        if (str == null) {
            throw new NullPointerError("null string passed to RpcConnection.getNormalizedBytes");
        }
        try {
            if (this.unicodeServer) {
                return str.getBytes(UNICODE_SERVER_CHARSET_NAME);
            }
            return str.getBytes(this.p4Charset.getCharset().name());
        }
        catch (UnsupportedEncodingException e) {
            Log.exception(e);
            return null;
        }
    }

    protected String getNormalizedString(byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerError("null bytes passed to RpcConnection.getNormalizedString");
        }
        try {
            if (this.unicodeServer) {
                return new String(bytes, UNICODE_SERVER_CHARSET_NAME);
            }
            return new String(bytes, this.p4Charset.getCharset().name());
        }
        catch (UnsupportedEncodingException e) {
            Log.exception(e);
            return null;
        }
    }

    public boolean isUsingCompression() {
        return this.usingCompression;
    }

    public RpcConnectionFlowControl getFlowController() {
        return this.flowController;
    }

    public void setFlowController(RpcConnectionFlowControl flowController) {
        this.flowController = flowController;
    }

    public Properties getProps() {
        return this.props;
    }

    public void setProps(Properties props) {
        this.props = props;
    }

    public Charset getClientCharset() {
        return this.p4Charset.getCharset();
    }

    public P4Charset getP4Charset() {
        return this.p4Charset;
    }

    public void setClientCharset(P4Charset p4Charset) {
        this.p4Charset = p4Charset;
        this.unicodeServer = P4Charset.isUnicodeServer(p4Charset);
    }

    public ServerStats getStats() {
        return this.stats;
    }

    public void setStats(ServerStats stats) {
        this.stats = stats;
    }

    public String getHostIp() {
        return this.hostIp;
    }

    public void setHostIp(String hostIp) {
        this.hostIp = hostIp;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public int getHostPort() {
        return this.hostPort;
    }

    public void setHostPort(int hostPort) {
        this.hostPort = hostPort;
    }

    public void setUsingCompression(boolean usingCompression) {
        this.usingCompression = usingCompression;
    }

    public boolean isUnicodeServer() {
        return this.unicodeServer;
    }

    public void setUnicodeServer(boolean unicodeServer) {
        this.unicodeServer = unicodeServer;
    }

    public int getFilesysUtf8bom() {
        String val = PropertiesHelper.getPropertyByKeys(this.props, "filesys.utf8bom", "com.perforce.p4java.filesys.utf8bom", "1");
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            return 1;
        }
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public void setFingerprint(String fingerprint) {
        this.fingerprint = fingerprint;
    }

    public boolean isTrusted() {
        return this.trusted;
    }

    public void setTrusted(boolean trusted) {
        this.trusted = trusted;
    }

    public RpcPacketDispatcher.RpcPacketDispatcherResult clientConfirm(String confirm, Map<String, Object> resultsMap) throws ConnectionException {
        if (confirm == null) {
            return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
        }
        HashMap<String, Object> respMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : resultsMap.entrySet()) {
            if (entry.getKey() == null || entry.getKey().equalsIgnoreCase("func")) continue;
            respMap.put(entry.getKey(), entry.getValue());
        }
        RpcPacket respPacket = RpcPacket.constructRpcPacket(confirm, respMap, null);
        this.putRpcPacket(respPacket);
        return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
    }

    public String getDigest(RpcPerforceFileType fileType, File file) {
        return this.getDigest(fileType, file, null);
    }

    public String getDigest(RpcPerforceFileType fileType, File file, RpcPerforceDigestType digest) {
        MD5Digester digester = new MD5Digester();
        if (digest == null) {
            digest = RpcPerforceDigestType.MD5;
        }
        Charset digestCharset = null;
        boolean convertLineEndings = false;
        switch (fileType) {
            case FST_SYMLINK: {
                return this.getSymlinkMD5Digest(file);
            }
            case FST_UTF16: {
                digestCharset = CharsetDefs.UTF16;
                break;
            }
            case FST_UTF8: {
                digestCharset = CharsetDefs.UTF8;
                convertLineEndings = true;
                break;
            }
            case FST_UNICODE: {
                digestCharset = this.getClientCharset();
                break;
            }
            case FST_XTEXT: 
            case FST_TEXT: {
                convertLineEndings = true;
                break;
            }
        }
        String digestStr = digester.digestFileAs32ByteHex(file, digestCharset, convertLineEndings);
        return digestStr;
    }

    private String getSymlinkMD5Digest(File file) {
        String targetPath = SymbolicLinkHelper.readSymbolicLink(file.getAbsolutePath());
        String md5 = DigestUtils.md5Hex((String)(targetPath + "\n")).toUpperCase();
        return md5;
    }
}

