/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.handles;

import com.perforce.p4java.impl.mapbased.rpc.CommandEnv;
import com.perforce.p4java.impl.mapbased.rpc.connection.RpcConnection;
import com.perforce.p4java.impl.mapbased.rpc.handles.AbstractHandle;
import com.perforce.p4java.impl.mapbased.rpc.sys.RpcOutputStream;
import com.perforce.p4java.impl.mapbased.rpc.sys.RpcPerforceFile;
import com.perforce.p4java.impl.mapbased.rpc.sys.RpcPerforceFileType;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ClientFile
extends AbstractHandle {
    private static final String FILE_OPEN_TMP_FILE_KEY = "tmpFile";
    private static final String FILE_OPEN_TMP_STREAM_KEY = "tmpFileStream";
    private static final String FILE_OPEN_TARGET_STREAM_KEY = "targetFileStream";
    private static final String FILE_DELETE_ON_ERR_KEY = "deleteOnError";
    private static final String FILE_OPEN_PATH_KEY = "openFilePath";
    private static final String FILE_OPEN_ORIG_ARGS_KEY = "origArgs";
    private static final String FILE_OPEN_MODTIME_KEY = "modTime";
    private static final String FILE_IS_DIFF_KEY = "isDiff";
    private static final String FILE_DIFF_NAME_KEY = "diffName";
    private static final String FILE_DIFF_FLAGS_KEY = "diffFlags";
    private static final String FILE_MATCH_DICT_KEY = "matchDct";
    private static final String FILE_SERVER_DIGEST_KEY = "serverDigest";
    private static final String FILE_INDIRECT_KEY = "indirect";
    private String localDigest;

    @Override
    public String getHandleType() {
        return "ClientFile";
    }

    public ClientFile(CommandEnv.RpcHandler rpcHandler) {
        super(rpcHandler);
    }

    public RpcPerforceFile getFile() {
        return (RpcPerforceFile)this.rpcHandler.getFile();
    }

    public void setFile(RpcPerforceFile file) {
        this.rpcHandler.setFile(file);
    }

    public RpcPerforceFile getTmpFile() {
        return (RpcPerforceFile)this.rpcHandler.getMap().get(FILE_OPEN_TMP_FILE_KEY);
    }

    public RpcOutputStream getStream() {
        return (RpcOutputStream)this.rpcHandler.getMap().get(FILE_OPEN_TARGET_STREAM_KEY);
    }

    public RpcOutputStream getTmpStream() {
        return (RpcOutputStream)this.rpcHandler.getMap().get(FILE_OPEN_TMP_STREAM_KEY);
    }

    public void Close() {
        try {
            if (this.getTmpStream() != null) {
                if (this.getTmpStream().getLocalDigester() != null) {
                    this.localDigest = this.getTmpStream().getLocalDigester().digestAs32ByteHex();
                }
                this.getTmpStream().close();
            }
            if (this.getStream() != null) {
                if (this.getStream().getLocalDigester() != null) {
                    this.localDigest = this.getStream().getLocalDigester().digestAs32ByteHex();
                }
                this.getStream().close();
            }
        }
        catch (IOException e) {
            this.setError(true);
        }
    }

    public boolean hasFile() {
        return this.getFile() != null || this.getTmpFile() != null;
    }

    public long getModTime() {
        if (!this.rpcHandler.getMap().containsKey(FILE_OPEN_MODTIME_KEY)) {
            return 0L;
        }
        return (Long)this.rpcHandler.getMap().get(FILE_OPEN_MODTIME_KEY);
    }

    public long statModTime() {
        return this.getFile().lastModified() / 1000L;
    }

    public void setModTime(long modtime) {
        this.rpcHandler.getMap().put(FILE_OPEN_MODTIME_KEY, modtime);
    }

    public void setModTime(String modTime) {
        try {
            this.rpcHandler.getMap().put(FILE_OPEN_MODTIME_KEY, Long.parseLong(modTime));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void setArgs(Map<String, Object> resultsMap) {
        this.rpcHandler.getMap().put(FILE_OPEN_ORIG_ARGS_KEY, resultsMap);
    }

    public Map<String, Object> getArgs() {
        return (Map)this.rpcHandler.getMap().get(FILE_OPEN_ORIG_ARGS_KEY);
    }

    public void setDiff(int i) {
        this.rpcHandler.getMap().put(FILE_IS_DIFF_KEY, i);
    }

    public void setDeleteOnClose(boolean del) {
    }

    public void setDiffName(String path) {
        this.rpcHandler.getMap().put(FILE_DIFF_NAME_KEY, path);
    }

    public void setDiffFlags(String flags) {
        this.rpcHandler.getMap().put(FILE_DIFF_FLAGS_KEY, flags);
    }

    public boolean isSymlink() {
        return this.getFile().getFileType() == RpcPerforceFileType.FST_SYMLINK;
    }

    public void MakeGlobalTemp() {
    }

    public void setTmpFile(RpcPerforceFile rpcPerforceFile) {
        this.rpcHandler.getMap().put(FILE_OPEN_TMP_FILE_KEY, rpcPerforceFile);
    }

    public void createStream(boolean useLocalDigester, RpcConnection rpcConnection, String digest) throws IOException {
        if (this.getTmpFile() != null) {
            RpcOutputStream tmpStream = new RpcOutputStream(this.getTmpFile(), rpcConnection.getClientCharset(), rpcConnection.isUnicodeServer(), useLocalDigester);
            if (useLocalDigester) {
                tmpStream.setServerDigest(digest);
            }
            this.rpcHandler.getMap().put(FILE_OPEN_TMP_STREAM_KEY, tmpStream);
        } else if (this.getFile() != null) {
            RpcOutputStream targetStream = new RpcOutputStream(this.getFile(), rpcConnection.getClientCharset(), rpcConnection.isUnicodeServer(), useLocalDigester);
            if (useLocalDigester) {
                targetStream.setServerDigest(digest);
            }
            this.rpcHandler.getMap().put(FILE_OPEN_TARGET_STREAM_KEY, targetStream);
        }
    }

    public HashMap<String, String> getMatchDict() {
        if (!this.rpcHandler.getMap().containsKey(FILE_MATCH_DICT_KEY)) {
            HashMap<String, String> dict = new HashMap<String, String>();
            this.rpcHandler.getMap().put(FILE_MATCH_DICT_KEY, dict);
            return dict;
        }
        return (HashMap)this.rpcHandler.getMap().get(FILE_MATCH_DICT_KEY);
    }

    public void setError(boolean error) {
        this.rpcHandler.setError(error);
    }

    public boolean isError() {
        return this.rpcHandler.isError();
    }

    public boolean isDiff() {
        return this.rpcHandler.getMap().containsKey(FILE_IS_DIFF_KEY) && (Boolean)this.rpcHandler.getMap().get(FILE_IS_DIFF_KEY) != false;
    }

    public String getServerDigest() {
        return (String)this.rpcHandler.getMap().get(FILE_SERVER_DIGEST_KEY);
    }

    public void setServerDigest(String digest) {
        this.rpcHandler.getMap().put(FILE_SERVER_DIGEST_KEY, digest);
    }

    public String getDigest() {
        return this.localDigest;
    }

    public boolean isIndirect() {
        return this.rpcHandler.getMap().containsKey(FILE_INDIRECT_KEY) && (Boolean)this.rpcHandler.getMap().get(FILE_INDIRECT_KEY) != false;
    }

    public void setIndirect(boolean indirect) {
        this.rpcHandler.getMap().put(FILE_INDIRECT_KEY, indirect);
    }
}

