/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.func.client;

import com.perforce.p4java.Log;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.FileDecoderException;
import com.perforce.p4java.exception.FileEncoderException;
import com.perforce.p4java.exception.NullPointerError;
import com.perforce.p4java.impl.generic.client.ClientLineEnding;
import com.perforce.p4java.impl.generic.sys.ISystemFileCommandsHelper;
import com.perforce.p4java.impl.mapbased.rpc.CommandEnv;
import com.perforce.p4java.impl.mapbased.rpc.RpcPropertyDefs;
import com.perforce.p4java.impl.mapbased.rpc.connection.RpcConnection;
import com.perforce.p4java.impl.mapbased.rpc.func.client.ClientMergeState;
import com.perforce.p4java.impl.mapbased.rpc.func.client.ClientMessage;
import com.perforce.p4java.impl.mapbased.rpc.func.helper.MD5Digester;
import com.perforce.p4java.impl.mapbased.rpc.msg.RpcMessage;
import com.perforce.p4java.impl.mapbased.rpc.packet.RpcPacket;
import com.perforce.p4java.impl.mapbased.rpc.packet.RpcPacketDispatcher;
import com.perforce.p4java.impl.mapbased.rpc.sys.RpcInputStream;
import com.perforce.p4java.impl.mapbased.rpc.sys.RpcPerforceFile;
import com.perforce.p4java.impl.mapbased.rpc.sys.RpcPerforceFileType;
import com.perforce.p4java.impl.mapbased.rpc.sys.helper.SysFileHelperBridge;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class ClientMerge {
    public static final String MARKER_ORIGINAL = ">>>> ORIGINAL ";
    public static final String MARKER_THEIRS = "==== THEIRS ";
    public static final String MARKER_YOURS = "==== YOURS ";
    public static final String MARKER_BOTH = "==== BOTH ";
    public static final String MARKER_END = "<<<<";
    public static final String DEFAULT_TMPFILE_PFX = "p4j";
    public static final String DEFAULT_TMPFILE_SFX = ".p4j";
    public static final String SYSTEM_TMPDIR_PROPS_KEY = "java.io.tmpdir";
    public static final String SYSTEM_TMPDIR_DEFAULT = "/tmp";
    public static final String TRACE_PREFIX = "ClientMerge";
    protected static final String MERGE_STATE_KEY = "MergeState";
    protected static final String MERGE_BASE_TMP_FILE_KEY = "tmpFileBase";
    protected static final String MERGE_BASE_TMP_STREAM_KEY = "tmpFileBaseStream";
    protected static final String MERGE_THEIRS_TMP_FILE_KEY = "tmpFileTheirs";
    protected static final String MERGE_THEIRS_TMP_STREAM_KEY = "tmpFileTheirsStream";
    protected static final String MERGE_YOURS_TMP_FILE_KEY = "tmpFileYours";
    protected static final String MERGE_YOURS_TMP_STREAM_KEY = "tmpFileYoursStream";
    private Properties props = null;
    private String tmpDirName = null;
    private static final String COPY_MERGE = "copy";
    private static final String SAFE_MERGE = "safe";
    private static final String AUTO_MERGE = "auto";
    private static final String FORCE_MERGE = "force";
    private static final String MERGED_EDITED = "edit";
    private static final String MERGED_FORCE = "force";
    private static final String MERGED_YOURS = "yours";
    private static final String MERGED_THEIRS = "theirs";
    private static final String MERGED_MERGED = "merged";
    private static final String MERGE_UNFORCED = "no";
    private static final int SEL_BASE = 1;
    private static final int SEL_LEG1 = 2;
    private static final int SEL_LEG2 = 4;
    private static final int SEL_RSLT = 8;
    private static final int SEL_ALL = 15;
    private static final int SEL_CONF = 16;

    public ClientMerge(Properties props) {
        this.props = props;
        this.tmpDirName = RpcPropertyDefs.getProperty(this.props, "com.perforce.p4java.tmpDir", System.getProperty(SYSTEM_TMPDIR_PROPS_KEY));
        if (this.tmpDirName == null) {
            this.tmpDirName = SYSTEM_TMPDIR_DEFAULT;
            Log.warn("Unable to get tmp name from P4 props or System; using " + this.tmpDirName + " instead", new Object[0]);
        }
    }

    protected RpcPacketDispatcher.RpcPacketDispatcherResult clientOpenMerge3(RpcConnection rpcConnection, CommandEnv cmdEnv, Map<String, Object> resultsMap, boolean twoWayMerge) throws ConnectionException {
        String clientPath = (String)resultsMap.get("path");
        String handle = (String)resultsMap.get("handle");
        String resultTypeStr = (String)resultsMap.get("type2");
        String clientTypeStr = (String)resultsMap.get("type");
        String digest = (String)resultsMap.get("digest");
        String baseName = (String)resultsMap.get("baseName");
        String theirName = (String)resultsMap.get("theirName");
        String yourName = (String)resultsMap.get("yourName");
        String showAll = (String)resultsMap.get("showAll");
        if (resultTypeStr == null) {
            resultTypeStr = clientTypeStr;
        }
        ClientMergeState mergeState = null;
        CommandEnv.RpcHandler handler = cmdEnv.getHandler(handle);
        if (handler == null) {
            CommandEnv commandEnv = cmdEnv;
            commandEnv.getClass();
            handler = new CommandEnv.RpcHandler(commandEnv, handle, false, null);
            cmdEnv.addHandler(handler);
        } else {
            handler.getMap().remove(MERGE_STATE_KEY);
        }
        handler.setError(false);
        RpcPerforceFileType clientType = RpcPerforceFileType.decodeFromServerString(clientTypeStr);
        ClientLineEnding clientLineEnd = ClientLineEnding.decodeFromServerString(clientTypeStr, clientType);
        RpcPerforceFileType resultType = RpcPerforceFileType.decodeFromServerString(resultTypeStr);
        ClientLineEnding resultLineEnd = ClientLineEnding.decodeFromServerString(resultTypeStr, resultType);
        if (cmdEnv.getCmdSpec().getInMap() != null) {
            String tmpFileName = (String)cmdEnv.getCmdSpec().getInMap().get("P4JMergeTmpFile");
            mergeState = new ClientMergeState(clientPath, true, clientType, clientLineEnd, resultType, resultLineEnd, this.tmpDirName, rpcConnection.getClientCharset());
            mergeState.setExternalTmpFilename(tmpFileName);
            mergeState.setShowAll(false);
            mergeState.setTwoWayMerge(twoWayMerge);
            mergeState.setTheirName(theirName);
            handler.getMap().put(MERGE_STATE_KEY, mergeState);
            return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
        }
        mergeState = new ClientMergeState(clientPath, false, clientType, clientLineEnd, resultType, resultLineEnd, this.tmpDirName, rpcConnection.getClientCharset());
        mergeState.setTwoWayMerge(twoWayMerge);
        mergeState.setBaseDigest(digest);
        handler.getMap().put(MERGE_STATE_KEY, mergeState);
        try {
            mergeState.setBaseName(baseName);
            mergeState.setTheirName(theirName);
            mergeState.setYourName(yourName);
            mergeState.openMergeFiles(rpcConnection.isUnicodeServer());
            mergeState.setShowAll(showAll != null);
        }
        catch (IOException ioexc) {
            handler.setError(true);
            cmdEnv.handleResult(new RpcMessage(ClientMessage.ClientMessageId.CANT_CREATE_FILE, 3, 34, new String[]{clientPath, ioexc.getLocalizedMessage()}).toMap());
            return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
        }
        return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
    }

    protected RpcPacketDispatcher.RpcPacketDispatcherResult clientWriteMerge(RpcConnection rpcConnection, CommandEnv cmdEnv, Map<String, Object> resultsMap) throws ConnectionException {
        String handle = (String)resultsMap.get("handle");
        CommandEnv.RpcHandler handler = cmdEnv.getHandler(handle);
        String bitsStr = (String)resultsMap.get("bits");
        byte[] data = (byte[])resultsMap.get("data");
        ClientMergeState mergeState = null;
        int bits = 0;
        int markersInFile = 0;
        boolean needNewline = false;
        String marker = MARKER_ORIGINAL;
        if (handler == null) {
            throw new NullPointerError("Null client handler in clientWriteMerge");
        }
        if (handler.isError()) {
            return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
        }
        try {
            mergeState = (ClientMergeState)handler.getMap().get(MERGE_STATE_KEY);
        }
        catch (ClassCastException cce) {
            Log.error("Bad client handler class in clientWriteMerge: " + cce.getLocalizedMessage(), new Object[0]);
            Log.exception(cce);
            throw new NullPointerError("Bad client handler class in clientWriteMerge: " + cce.getLocalizedMessage());
        }
        if (mergeState == null) {
            throw new NullPointerError("Null merge state in clientWriteMerge");
        }
        if (mergeState.isExternalStreamMerge()) {
            return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
        }
        if (mergeState.isTwoWayMerge()) {
            try {
                mergeState.writeTheirChunk(data);
            }
            catch (IOException ioexc) {
                Log.error("I/O exception in clientWriteMerge: " + ioexc.getLocalizedMessage(), new Object[0]);
                Log.exception(ioexc);
                handler.setError(true);
            }
            catch (FileDecoderException e) {
                Log.error("Charset converstion exception in clientWriteMerge: " + e.getLocalizedMessage(), new Object[0]);
                Log.exception(e);
                handler.setError(true);
            }
            catch (FileEncoderException e) {
                Log.error("Charset converstion exception in clientWriteMerge: " + e.getLocalizedMessage(), new Object[0]);
                Log.exception(e);
                handler.setError(true);
            }
            return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
        }
        if (bitsStr != null) {
            try {
                bits = new Integer(bitsStr);
            }
            catch (Throwable thr) {
                Log.error("Unexpected exception in clientWriteMerge: " + thr.getLocalizedMessage(), new Object[0]);
                Log.exception(thr);
                handler.setError(true);
            }
        }
        int oldBits = mergeState.getOldBits();
        try {
            if (oldBits != 0 && oldBits != bits) {
                switch (bits) {
                    case 17: {
                        mergeState.incrConflictChunks();
                    }
                    default: {
                        marker = MARKER_ORIGINAL + mergeState.getBaseName();
                        break;
                    }
                    case 10: {
                        mergeState.incrTheirChunks();
                    }
                    case 26: {
                        marker = MARKER_THEIRS + mergeState.getTheirName();
                        break;
                    }
                    case 12: {
                        mergeState.incrYourChunks();
                    }
                    case 28: {
                        marker = MARKER_YOURS + mergeState.getYourName();
                        break;
                    }
                    case 14: {
                        marker = MARKER_BOTH + mergeState.getTheirName() + " " + mergeState.getYourName();
                        mergeState.incrBothChunks();
                        break;
                    }
                    case 15: {
                        marker = MARKER_END;
                    }
                }
                if (mergeState.isShowAll() || (bits & 0x10) != 0 || bits == 15 && (oldBits & 0x10) != 0) {
                    mergeState.writeMarker(needNewline ? "\n" : "" + marker + "\n");
                    ++markersInFile;
                    if (needNewline) {
                        needNewline = false;
                    }
                }
            }
            mergeState.setOldBits(bits);
            if (data != null && data.length > 0) {
                if ((bits & 1) != 0) {
                    mergeState.writeBaseChunk(data);
                }
                if ((bits & 2) != 0) {
                    mergeState.writeTheirChunk(data);
                }
                if ((bits & 4) != 0) {
                    mergeState.writeYourChunk(data);
                }
                if ((bits & 8) != 0 || bits == 17) {
                    mergeState.writeResultChunk(data);
                }
                if (data[data.length - 1] == 10) {
                    needNewline = true;
                }
            }
        }
        catch (IOException ioexc) {
            Log.error("I/O exception in clientWriteMerge: " + ioexc.getLocalizedMessage(), new Object[0]);
            Log.exception(ioexc);
            handler.setError(true);
        }
        catch (FileDecoderException e) {
            Log.error("Charset converstion exception in clientWriteMerge: " + e.getLocalizedMessage(), new Object[0]);
            Log.exception(e);
            handler.setError(true);
        }
        catch (FileEncoderException e) {
            Log.error("Charset converstion exception in clientWriteMerge: " + e.getLocalizedMessage(), new Object[0]);
            Log.exception(e);
            handler.setError(true);
        }
        return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
    }

    protected RpcPacketDispatcher.RpcPacketDispatcherResult clientCloseMerge(RpcConnection rpcConnection, CommandEnv cmdEnv, Map<String, Object> resultsMap) throws ConnectionException {
        String clientPath = (String)resultsMap.get("path");
        String handle = (String)resultsMap.get("handle");
        String mergeConfirm = (String)resultsMap.get("mergeConfirm");
        String mergeDecline = (String)resultsMap.get("mergeDecline");
        String mergePerms = (String)resultsMap.get("mergePerms");
        String mergeAuto = (String)resultsMap.get("mergeAuto");
        String mergeResponse = mergeConfirm;
        String mergeHow = null;
        String mergeForced = null;
        ClientMergeState mergeState = null;
        CommandEnv.RpcHandler handler = cmdEnv.getHandler(handle);
        String digest = null;
        if (handler == null) {
            throw new NullPointerError("Null client handler in clientWriteMerge");
        }
        try {
            mergeState = (ClientMergeState)handler.getMap().get(MERGE_STATE_KEY);
        }
        catch (ClassCastException cce) {
            Log.error("Bad client handler class in clientCloseMerge: " + cce.getLocalizedMessage(), new Object[0]);
            Log.exception(cce);
            throw new NullPointerError("Bad client handler class in clientCloseMerge: " + cce.getLocalizedMessage());
        }
        if (mergeState == null) {
            throw new NullPointerError("Null merge state in clientWriteMerge");
        }
        if (handler != null && handler.isError()) {
            mergeResponse = mergeDecline;
        } else {
            String theirName;
            boolean skip = false;
            if (cmdEnv.getCmdSpec().getInMap() != null && (theirName = mergeState.getTheirName()) != null) {
                int endFromRev;
                int startFromRev;
                int theirRev = Integer.parseInt(theirName.substring(theirName.lastIndexOf("#") + 1));
                if (cmdEnv.getCmdSpec().getInMap().containsKey("P4JMergeStartFromRev") && (startFromRev = ((Integer)cmdEnv.getCmdSpec().getInMap().get("P4JMergeStartFromRev")).intValue()) != -1 && startFromRev > theirRev) {
                    skip = true;
                }
                if (cmdEnv.getCmdSpec().getInMap().containsKey("P4JMergeEndFromRev") && (endFromRev = ((Integer)cmdEnv.getCmdSpec().getInMap().get("P4JMergeEndFromRev")).intValue()) != -1 && endFromRev < theirRev) {
                    skip = true;
                }
            }
            if (skip) {
                mergeResponse = mergeDecline;
            } else if (mergeState.isExternalStreamMerge()) {
                String tmpFileName = (String)cmdEnv.getCmdSpec().getInMap().get("P4JMergeTmpFile");
                if (clientPath != null && tmpFileName != null) {
                    RpcPerforceFile tmpFile = new RpcPerforceFile(tmpFileName, RpcPerforceFileType.FST_TEXT);
                    if (!tmpFile.renameTo(new File(clientPath), true)) {
                        Log.error("Rename failed completely in resolveFile (cause unknown); source file: " + clientPath + "; target file: " + tmpFileName, new Object[0]);
                        cmdEnv.handleResult(new RpcMessage(ClientMessage.ClientMessageId.FILE_MOVE_ERROR, 3, 34, new String[]{clientPath, "(cause unknown)"}).toMap());
                        mergeResponse = mergeDecline;
                    } else {
                        if (mergePerms != null) {
                            ISystemFileCommandsHelper fileCommands = SysFileHelperBridge.getSysFileCommands();
                            if (mergePerms.equalsIgnoreCase("rw")) {
                                fileCommands.setWritable(clientPath, true);
                            } else {
                                fileCommands.setWritable(clientPath, false);
                            }
                        }
                        try {
                            int bytesRead;
                            MD5Digester digester = new MD5Digester();
                            RpcInputStream stream = new RpcInputStream(tmpFile, rpcConnection.getClientCharset());
                            byte[] bytes = new byte[65536];
                            while ((bytesRead = stream.read(bytes)) > 0) {
                                byte[] readBytes = new byte[bytesRead];
                                System.arraycopy(bytes, 0, readBytes, 0, bytesRead);
                                digester.update(readBytes);
                            }
                            stream.close();
                            digest = digester.digestAs32ByteHex();
                        }
                        catch (IOException e) {
                            Log.error("Unexpected I/O exception in digest calculation: " + e.getLocalizedMessage(), new Object[0]);
                            Log.exception(e);
                        }
                        catch (FileEncoderException e) {
                            Log.error("Unexpected Encoding exception in digest calculation: " + e.getLocalizedMessage(), new Object[0]);
                            Log.exception(e);
                        }
                        mergeHow = MERGED_EDITED;
                    }
                }
            } else {
                if (mergeState.isTwoWayMerge()) {
                    String baseDigest = mergeState.getBaseDigest();
                    String yourDigest = mergeState.getYourDigestString();
                    String theirDigest = mergeState.getTheirDigestString();
                    if (baseDigest != null && yourDigest != null && baseDigest.equals(yourDigest)) {
                        if (theirDigest != null && !baseDigest.equals(theirDigest)) {
                            mergeState.setTheirChunks(1);
                        }
                    } else if (baseDigest != null && theirDigest != null && !baseDigest.equals(theirDigest)) {
                        if (yourDigest != null && !yourDigest.equals(theirDigest)) {
                            mergeState.setConflictChunks(1);
                        } else {
                            mergeState.setBothChunks(1);
                        }
                    } else {
                        mergeState.setYourChunks(1);
                    }
                }
                ResolveChoice autoChoice = this.autoResolve(mergeState, mergeAuto);
                if (mergePerms != null) {
                    ISystemFileCommandsHelper fileCommands = SysFileHelperBridge.getSysFileCommands();
                    if (clientPath != null && !fileCommands.setWritable(clientPath, true)) {
                        Log.warn("Unable to set merge target '" + clientPath + "' permissions to writable; merge results should not be affected", new Object[0]);
                    }
                }
                switch (autoChoice) {
                    case SKIP: {
                        mergeResponse = mergeDecline;
                        break;
                    }
                    case YOURS: {
                        mergeHow = MERGED_YOURS;
                        digest = mergeState.getYourDigestString();
                        break;
                    }
                    case THEIRS: {
                        mergeHow = MERGED_THEIRS;
                        mergeForced = MERGE_UNFORCED;
                        digest = mergeState.getTheirDigestString();
                        break;
                    }
                    case MERGED: {
                        mergeHow = MERGED_MERGED;
                        digest = mergeState.getMergeDigestString();
                        break;
                    }
                    case EDIT: {
                        mergeHow = MERGED_EDITED;
                        break;
                    }
                    default: {
                        mergeResponse = mergeDecline;
                    }
                }
                try {
                    if (!mergeState.finishMerge(autoChoice)) {
                        Log.error("Rename failed completely in resolveFile (cause unknown); source file: " + clientPath == null ? "<unknown>" : clientPath, new Object[0]);
                        cmdEnv.handleResult(new RpcMessage(ClientMessage.ClientMessageId.FILE_MOVE_ERROR, 3, 34, new String[]{clientPath == null ? "<unknown>" : clientPath, "(cause unknown)"}).toMap());
                        mergeResponse = mergeDecline;
                    } else {
                        cmdEnv.handleResult(new RpcMessage(ClientMessage.ClientMessageId.MERGE_MESSAGE3, 1, 34, new String[]{"" + mergeState.getYourChunks(), "" + mergeState.getTheirChunks(), "" + mergeState.getBothChunks(), "" + mergeState.getConflictChunks()}).toMap());
                    }
                }
                catch (IOException exc) {
                    mergeResponse = mergeDecline;
                    Log.error("Unexpected I/O exception in closeMerge: " + exc.getLocalizedMessage(), new Object[0]);
                    Log.exception(exc);
                }
                if (mergePerms != null) {
                    ISystemFileCommandsHelper fileCommands = SysFileHelperBridge.getSysFileCommands();
                    if (clientPath != null && !fileCommands.setWritable(clientPath, mergePerms.equalsIgnoreCase("rw"))) {
                        Log.warn("Unable to set merge target '" + clientPath + "' permissions back after merge; merge results should not be affected", new Object[0]);
                    }
                }
            }
            HashMap<String, Object> respMap = new HashMap<String, Object>();
            if (mergeHow != null) {
                respMap.put("mergeHow", mergeHow);
            }
            if (mergeForced != null) {
                respMap.put("force", mergeForced);
            }
            if (digest != null) {
                respMap.put("digest", digest);
            }
            for (Map.Entry<String, Object> entry : resultsMap.entrySet()) {
                if (entry.getKey() == null || entry.getKey().equalsIgnoreCase("func") || entry.getKey().equalsIgnoreCase("type") || entry.getKey().equalsIgnoreCase("status")) continue;
                respMap.put(entry.getKey(), entry.getValue());
            }
            RpcPacket respPacket = RpcPacket.constructRpcPacket(mergeResponse, respMap, null);
            rpcConnection.putRpcPacket(respPacket);
        }
        return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
    }

    private ResolveChoice autoResolve(ClientMergeState mergeState, String mergeAuto) {
        int conflictChunks = mergeState.getConflictChunks();
        int theirChunks = mergeState.getTheirChunks();
        int yourChunks = mergeState.getYourChunks();
        boolean safeMerge = false;
        boolean autoMerge = false;
        boolean forceMerge = false;
        if (mergeAuto != null) {
            if (mergeAuto.equalsIgnoreCase(SAFE_MERGE)) {
                safeMerge = true;
            } else if (mergeAuto.equalsIgnoreCase("force")) {
                forceMerge = true;
            } else if (mergeAuto.equalsIgnoreCase(AUTO_MERGE)) {
                autoMerge = true;
            }
        }
        if (mergeState.isTwoWayMerge()) {
            if (conflictChunks > 0) {
                return ResolveChoice.SKIP;
            }
            if (yourChunks == 0) {
                return ResolveChoice.THEIRS;
            }
            return ResolveChoice.YOURS;
        }
        if (mergeAuto != null) {
            if (mergeAuto.equalsIgnoreCase(SAFE_MERGE)) {
                safeMerge = true;
            } else if (mergeAuto.equalsIgnoreCase("force")) {
                forceMerge = true;
            } else if (mergeAuto.equalsIgnoreCase(AUTO_MERGE)) {
                autoMerge = true;
            }
        }
        if (conflictChunks > 0) {
            if (forceMerge) {
                return ResolveChoice.EDIT;
            }
            return ResolveChoice.SKIP;
        }
        if (theirChunks == 0) {
            return ResolveChoice.YOURS;
        }
        if (yourChunks == 0) {
            return ResolveChoice.THEIRS;
        }
        if (safeMerge) {
            return ResolveChoice.SKIP;
        }
        if (forceMerge || autoMerge) {
            return ResolveChoice.MERGED;
        }
        return ResolveChoice.SKIP;
    }

    public static enum ResolveChoice {
        SKIP,
        YOURS,
        THEIRS,
        EDIT,
        MERGED;

    }
}

