/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.server;

import com.perforce.p4java.Log;
import com.perforce.p4java.exception.ConfigException;
import com.perforce.p4java.server.ZeroconfServerInfo;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

@Deprecated
public class ZeroconfHelper {
    public static final String ZEROCONF_CLASS_NAME = "javax.jmdns.JmDNS";
    public static String P4D_ZEROCONF_TYPE = "_p4._tcp.local.";
    private Object jmdns = null;
    private boolean loggedZeroConfError = false;

    protected ZeroconfHelper() {
    }

    protected boolean isZeroConfAvailable() {
        try {
            Method createMethod;
            Class<?> jmdnsClass;
            if (this.jmdns == null && (jmdnsClass = Class.forName(ZEROCONF_CLASS_NAME)) != null && (createMethod = jmdnsClass.getMethod("create", null)) != null) {
                this.jmdns = createMethod.invoke(null, (Object[])null);
            }
            return true;
        }
        catch (ClassNotFoundException cnfe) {
            return false;
        }
        catch (Throwable thr) {
            Log.warn("Unexpected exception in ServerFactory.zeroConfAvailable: " + thr.getLocalizedMessage(), new Object[0]);
            Log.exception(thr);
            this.loggedZeroConfError = true;
            return false;
        }
    }

    protected List<ZeroconfServerInfo> getZeroconfServers() throws ConfigException {
        if (!this.isZeroConfAvailable()) {
            throw new ConfigException("Zeroconf services are not configured for this instance of P4Java");
        }
        ArrayList<ZeroconfServerInfo> serverList = new ArrayList<ZeroconfServerInfo>();
        try {
            Object[] services;
            Method listMethod;
            if (this.jmdns != null && (listMethod = this.jmdns.getClass().getDeclaredMethod("list", String.class)) != null && (services = (Object[])listMethod.invoke(this.jmdns, P4D_ZEROCONF_TYPE)) != null) {
                Method nameMethod = null;
                Method propMethod = null;
                Method addrMethod = null;
                Method hostNameMethod = null;
                Method portMethod = null;
                for (Object info : services) {
                    if (info == null) continue;
                    if (nameMethod == null) {
                        nameMethod = info.getClass().getDeclaredMethod("getName", null);
                    }
                    if (hostNameMethod == null) {
                        hostNameMethod = info.getClass().getDeclaredMethod("getServer", null);
                    }
                    if (propMethod == null) {
                        propMethod = info.getClass().getDeclaredMethod("getPropertyString", String.class);
                    }
                    if (addrMethod == null) {
                        addrMethod = info.getClass().getDeclaredMethod("getHostAddress", null);
                    }
                    if (portMethod == null) {
                        portMethod = info.getClass().getDeclaredMethod("getPort", null);
                    }
                    serverList.add(new ZeroconfServerInfo((String)nameMethod.invoke(info, (Object[])null), P4D_ZEROCONF_TYPE, (String)propMethod.invoke(info, "description"), (String)propMethod.invoke(info, "version"), (String)addrMethod.invoke(info, (Object[])null), (String)hostNameMethod.invoke(info, (Object[])null), (Integer)portMethod.invoke(info, (Object[])null)));
                }
            }
        }
        catch (Throwable thr) {
            if (!this.loggedZeroConfError) {
                Log.warn("Unexpected exception in ZeroconfHelper.getZeroconfServers: " + thr, new Object[0]);
                Log.exception(thr);
                this.loggedZeroConfError = true;
            }
            throw new ConfigException("Unexpected exception in ZeroconfHelper.getZeroconfServers: " + thr);
        }
        return serverList;
    }
}

