/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.server.cmd;

import com.perforce.p4java.common.base.ObjectUtils;
import com.perforce.p4java.common.base.P4ResultMapUtils;
import com.perforce.p4java.common.function.Function;
import com.perforce.p4java.core.file.FileSpecOpStatus;
import com.perforce.p4java.core.file.IExtendedFileSpec;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.exception.RequestException;
import com.perforce.p4java.impl.generic.core.file.ExtendedFileSpec;
import com.perforce.p4java.impl.generic.core.file.FileSpec;
import com.perforce.p4java.impl.mapbased.server.cmd.ResultMapParser;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.IServer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ResultListBuilder {
    public static <T> List<T> buildNonNullObjectListFromCommandResultMaps(List<Map<String, Object>> resultMaps, Function<Map, T> construct) throws P4JavaException {
        ArrayList<T> objectList = new ArrayList<T>();
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                if (ResultMapParser.handleErrorStr(map)) continue;
                T object = construct.apply(map);
                objectList.add(object);
            }
        }
        return objectList;
    }

    public static <T> List<T> buildNonNullObjectListFromNonMessageCommandResultMaps(List<Map<String, Object>> resultMaps, Function<Map, T> construct) throws P4JavaException {
        ArrayList<T> objectList = new ArrayList<T>();
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                if (ResultMapParser.handleErrorStr(map) || !StringUtils.isBlank((CharSequence)ResultMapParser.getErrorOrInfoStr(map))) continue;
                T object = construct.apply(map);
                objectList.add(object);
            }
        }
        return objectList;
    }

    public static <T> T buildNullableObjectFromNonInfoMessageCommandResultMaps(List<Map<String, Object>> resultMaps, Function<Map, T> construct) throws RequestException, AccessException {
        T obj = null;
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                if (map == null || ResultMapParser.handleErrorStr(map) || ResultMapParser.isInfoMessage(map)) continue;
                obj = construct.apply(map);
            }
        }
        return obj;
    }

    public static List<IExtendedFileSpec> buildNonNullExtendedFileSpecListFromCommandResultMaps(List<Map<String, Object>> resultMaps, IOptionsServer server) throws RequestException, AccessException, ConnectionException {
        ArrayList<IExtendedFileSpec> specList = new ArrayList<IExtendedFileSpec>();
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                String errStr = ResultMapParser.handleFileErrorStr(map);
                if (StringUtils.isBlank((CharSequence)errStr)) {
                    if (!P4ResultMapUtils.isContainsValidRevisionSpecificInformation(map)) continue;
                    specList.add(new ExtendedFileSpec(map, server, -1));
                    continue;
                }
                FileSpecOpStatus fileSpecOpStatus = FileSpecOpStatus.ERROR;
                if (ResultMapParser.isInfoMessage(map)) {
                    fileSpecOpStatus = FileSpecOpStatus.INFO;
                }
                specList.add(new ExtendedFileSpec(fileSpecOpStatus, errStr));
            }
        }
        return specList;
    }

    public static IFileSpec handleIntegrationFileReturn(Map<String, Object> map, IServer server) throws AccessException, ConnectionException {
        return ResultListBuilder.handleIntegrationFileReturn(map, false, server);
    }

    public static IFileSpec handleIntegrationFileReturn(Map<String, Object> map, boolean ignoreInfo, IServer server) throws AccessException, ConnectionException {
        if (ObjectUtils.nonNull(map)) {
            String errStr = ResultMapParser.handleFileErrorStr(map);
            if (StringUtils.isBlank((CharSequence)errStr)) {
                return new FileSpec(map, server, -1);
            }
            String codeStr = P4ResultMapUtils.parseCode0ErrorString(map);
            if (ResultMapParser.isInfoMessage(map)) {
                if (ignoreInfo) {
                    return new FileSpec(map, server, -1);
                }
                return new FileSpec(FileSpecOpStatus.INFO, errStr, codeStr);
            }
            return new FileSpec(FileSpecOpStatus.ERROR, errStr, codeStr);
        }
        return null;
    }

    public static IFileSpec handleFileReturn(Map<String, Object> map, IServer server) throws AccessException, ConnectionException {
        if (ObjectUtils.nonNull(map)) {
            String errStr = ResultMapParser.handleFileErrorStr(map);
            if (StringUtils.isBlank((CharSequence)errStr)) {
                return new FileSpec(map, server, -1);
            }
            FileSpecOpStatus specOpStatus = FileSpecOpStatus.ERROR;
            if (ResultMapParser.isInfoMessage(map)) {
                specOpStatus = FileSpecOpStatus.INFO;
            }
            String codeStr = P4ResultMapUtils.parseCode0ErrorString(map);
            return new FileSpec(specOpStatus, errStr, codeStr);
        }
        return null;
    }
}

