/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.server.cmd;

import com.perforce.p4java.Log;
import com.perforce.p4java.core.file.FileStatAncilliaryOptions;
import com.perforce.p4java.core.file.FileStatOutputOptions;
import com.perforce.p4java.core.file.IExtendedFileSpec;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.impl.mapbased.server.Parameters;
import com.perforce.p4java.impl.mapbased.server.cmd.BaseDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.ResultListBuilder;
import com.perforce.p4java.option.server.GetExtendedFilesOptions;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.delegator.IFstatDelegator;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class FstatDelegator
extends BaseDelegator
implements IFstatDelegator {
    public FstatDelegator(IOptionsServer server) {
        super(server);
    }

    @Override
    public List<IExtendedFileSpec> getExtendedFiles(List<IFileSpec> fileSpecs, int maxFiles, int sinceChangelist, int affectedByChangelist, FileStatOutputOptions outputOptions, FileStatAncilliaryOptions ancilliaryOptions) throws ConnectionException, AccessException {
        try {
            GetExtendedFilesOptions extendedFilesOptions = new GetExtendedFilesOptions().setAncilliaryOptions(ancilliaryOptions).setMaxResults(maxFiles).setOutputOptions(outputOptions).setSinceChangelist(sinceChangelist).setAffectedByChangelist(affectedByChangelist);
            return this.getExtendedFiles(fileSpecs, extendedFilesOptions);
        }
        catch (AccessException | ConnectionException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            Log.warn("Unexpected exception in IServer.getExtendedFiles: %s", exc);
            return Collections.emptyList();
        }
    }

    @Override
    public List<IExtendedFileSpec> getExtendedFiles(List<IFileSpec> fileSpecs, GetExtendedFilesOptions opts) throws P4JavaException {
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.FSTAT, Parameters.processParameters(opts, fileSpecs, this.server), null);
        return ResultListBuilder.buildNonNullExtendedFileSpecListFromCommandResultMaps(resultMaps, this.server);
    }
}

