/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.server.cmd;

import com.perforce.p4java.Log;
import com.perforce.p4java.common.base.ObjectUtils;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.impl.mapbased.server.Parameters;
import com.perforce.p4java.impl.mapbased.server.cmd.BaseDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.ResultListBuilder;
import com.perforce.p4java.option.server.GetDepotFilesOptions;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.delegator.IFilesDelegator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.Validate;

public class FilesDelegator
extends BaseDelegator
implements IFilesDelegator {
    public FilesDelegator(IOptionsServer server) {
        super(server);
    }

    @Override
    public List<IFileSpec> getDepotFiles(@Nonnull List<IFileSpec> fileSpecs, boolean allRevs) throws ConnectionException, AccessException {
        ArrayList<IFileSpec> depotFileSpecs = new ArrayList();
        try {
            depotFileSpecs = this.getDepotFiles(fileSpecs, new GetDepotFilesOptions().setAllRevs(allRevs));
        }
        catch (AccessException | ConnectionException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            Log.warn("Unexpected exception in IServer.getDepotFiles: %s", exc);
        }
        return depotFileSpecs;
    }

    @Override
    public List<IFileSpec> getDepotFiles(@Nonnull List<IFileSpec> fileSpecs, GetDepotFilesOptions opts) throws P4JavaException {
        Validate.notNull(fileSpecs);
        ArrayList<IFileSpec> fileList = new ArrayList<IFileSpec>();
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.FILES, Parameters.processParameters(opts, fileSpecs, this.server), null);
        if (ObjectUtils.nonNull(resultMaps)) {
            for (Map<String, Object> map : resultMaps) {
                fileList.add(ResultListBuilder.handleFileReturn(map, this.server));
            }
        }
        return fileList;
    }
}

