/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.stream;

import com.jcraft.jzlib.ZStream;
import com.perforce.p4java.exception.NullPointerError;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.exception.UnimplementedError;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class RpcGZIPOutputStream
extends FilterOutputStream {
    private static final int ZBITS = 15;
    private static final int ZBUF_SIZE = 10240;
    private ZStream jzOutputSream = new ZStream();
    private byte[] jzBytes = null;

    public RpcGZIPOutputStream(OutputStream out) throws IOException {
        super(out);
        this.jzOutputSream.deflateInit(-1, 15, true);
        this.jzBytes = new byte[10240];
        this.jzOutputSream.next_out = this.jzBytes;
        this.jzOutputSream.next_out_index = 0;
        this.jzOutputSream.avail_out = this.jzBytes.length;
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        if (bytes == null) {
            throw new NullPointerError("null byte array passed to RpcGZIPOutputStream.write()");
        }
        this.write(bytes, 0, bytes.length);
    }

    @Override
    public void write(byte[] bytes, int offset, int len) throws IOException {
        if (bytes == null) {
            throw new NullPointerError("null byte array passed to RpcGZIPOutputStream.write()");
        }
        if (len <= 0 || offset < 0 || offset >= bytes.length || len > bytes.length - offset) {
            throw new P4JavaError("bad length or offset in RpcGZIPOutputStream.write()");
        }
        this.jzOutputSream.next_in = bytes;
        this.jzOutputSream.avail_in = len;
        this.jzOutputSream.next_in_index = offset;
        while (this.jzOutputSream.avail_in != 0) {
            int jzErr;
            if (this.jzOutputSream.avail_out == 0) {
                this.out.write(this.jzBytes);
                this.jzOutputSream.next_out = this.jzBytes;
                this.jzOutputSream.avail_out = this.jzBytes.length;
                this.jzOutputSream.next_out_index = 0;
            }
            if ((jzErr = this.jzOutputSream.deflate(0)) == 0) continue;
            throw new IOException("connection compression error: " + this.getJZlibErrorStr(jzErr));
        }
    }

    @Override
    public void write(int b) throws IOException {
        throw new UnimplementedError("single-byte RpcGZIPOutputStream.write()");
    }

    @Override
    public void flush() throws IOException {
        this.jzOutputSream.avail_in = 0;
        boolean done = false;
        while (true) {
            if (this.jzOutputSream.avail_out == 0 || done) {
                this.out.write(this.jzBytes, 0, this.jzBytes.length - this.jzOutputSream.avail_out);
                this.jzOutputSream.next_out = this.jzBytes;
                this.jzOutputSream.avail_out = this.jzBytes.length;
                this.jzOutputSream.next_out_index = 0;
            }
            if (done) break;
            int jzErr = this.jzOutputSream.deflate(3);
            if (jzErr != 0) {
                throw new IOException("Perforce connection compression error: " + this.getJZlibErrorStr(jzErr));
            }
            if (this.jzOutputSream.avail_out == 0) continue;
            done = true;
        }
    }

    @Override
    public void close() throws IOException {
        this.jzOutputSream.deflateEnd();
    }

    protected String getJZlibErrorStr(int errNum) {
        switch (errNum) {
            case -2: {
                return "stream error";
            }
            case -3: {
                return "data error";
            }
            case -4: {
                return "memory error";
            }
            case -5: {
                return "buffer error";
            }
            case -6: {
                return "version error";
            }
        }
        return "unknown error";
    }
}

