/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.packet;

import com.perforce.p4java.exception.NullPointerError;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.exception.ProtocolError;
import com.perforce.p4java.impl.mapbased.rpc.packet.RpcPacket;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;

public class RpcPacketPreamble {
    public static final int RPC_PREAMBLE_CHKSUM_SIZE = 1;
    public static final int RPC_PREAMBLE_SIZE = 5;
    private byte[] preLengthBytes = null;
    private byte[] preChksumBytes = null;

    public static RpcPacketPreamble constructPreamble(ByteBuffer payload) {
        return new RpcPacketPreamble(payload.position());
    }

    public static RpcPacketPreamble constructPreamble(int payloadLength) {
        return new RpcPacketPreamble(payloadLength);
    }

    public static RpcPacketPreamble retrievePreamble(ByteBuffer payload) {
        if (payload == null) {
            throw new NullPointerError("Null payload buffer passed to RpcPacketPreamble.retrievePreamble()");
        }
        byte[] bytes = new byte[5];
        try {
            payload.get(bytes);
        }
        catch (BufferUnderflowException bue) {
            throw new ProtocolError(bue.getLocalizedMessage(), bue);
        }
        return new RpcPacketPreamble(bytes);
    }

    public static RpcPacketPreamble retrievePreamble(byte[] bytes) {
        return new RpcPacketPreamble(bytes);
    }

    private RpcPacketPreamble(ByteBuffer payload) {
        if (payload == null) {
            throw new NullPointerError("Null payload buffer passed to RpcPacketPreamble constructor");
        }
        this.preChksumBytes = new byte[1];
        this.preLengthBytes = RpcPacket.encodeInt4(payload.position());
        this.preChksumBytes[0] = (byte)(this.preLengthBytes[0] ^ this.preLengthBytes[1] ^ this.preLengthBytes[2] ^ this.preLengthBytes[3]);
    }

    private RpcPacketPreamble(int length) {
        this.preChksumBytes = new byte[1];
        this.preLengthBytes = RpcPacket.encodeInt4(length);
        this.preChksumBytes[0] = (byte)(this.preLengthBytes[0] ^ this.preLengthBytes[1] ^ this.preLengthBytes[2] ^ this.preLengthBytes[3]);
    }

    private RpcPacketPreamble(byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerError("Null payload bytes passed to RpcPacketPreamble constructor");
        }
        if (bytes.length != 5) {
            throw new P4JavaError("Incorrect byte array size passed to RpcPacketPreamble constructor: " + bytes.length);
        }
        this.preChksumBytes = new byte[1];
        this.preChksumBytes[0] = bytes[0];
        this.preLengthBytes = new byte[4];
        for (int i = 0; i < 4; ++i) {
            this.preLengthBytes[i] = bytes[i + 1];
        }
    }

    public int getPayloadSize() {
        return RpcPacket.decodeInt4(this.preLengthBytes);
    }

    public boolean isValidChecksum() {
        return this.preChksumBytes[0] == (this.preLengthBytes[0] ^ this.preLengthBytes[1] ^ this.preLengthBytes[2] ^ this.preLengthBytes[3]);
    }

    public ByteBuffer marshal() {
        return ByteBuffer.allocate(5).put(this.preChksumBytes).put(this.preLengthBytes);
    }

    public byte[] marshalAsBytes() {
        byte[] retVal = new byte[5];
        retVal[0] = this.preChksumBytes[0];
        for (int i = 0; i < 4; ++i) {
            retVal[i + 1] = this.preLengthBytes[i];
        }
        return retVal;
    }
}

