/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.server;

import com.perforce.p4java.charset.PerforceCharsetProvider;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class PerforceCharsets {
    private static final Map<String, String> p4ToJavaCharsets;
    private static PerforceCharsetProvider p4CharsetProvider;

    public static String[] getKnownCharsets() {
        Set<String> keySet = p4ToJavaCharsets.keySet();
        String[] charsets = new String[keySet.size()];
        keySet.toArray(charsets);
        return charsets;
    }

    public static String getP4CharsetName(String javaCharsetName) {
        String p4CharsetName = null;
        if (javaCharsetName != null && !javaCharsetName.isEmpty()) {
            for (Map.Entry<String, String> entry : p4ToJavaCharsets.entrySet()) {
                if (!entry.getValue().equalsIgnoreCase(javaCharsetName) || !entry.getValue().equalsIgnoreCase(javaCharsetName)) continue;
                p4CharsetName = entry.getKey();
                break;
            }
        }
        return p4CharsetName;
    }

    public static Charset getP4Charset(String p4CharsetName) {
        String javaCharsetName = PerforceCharsets.getJavaCharsetName(p4CharsetName);
        Charset charset = null;
        if (javaCharsetName != null && !javaCharsetName.isEmpty() && (charset = p4CharsetProvider.charsetForName(javaCharsetName)) == null) {
            charset = Charset.forName(javaCharsetName);
        }
        return charset;
    }

    public static String getJavaCharsetName(String p4CharsetName) {
        String javaCharsetName = null;
        if (p4CharsetName != null && !p4CharsetName.isEmpty()) {
            javaCharsetName = p4ToJavaCharsets.get(p4CharsetName);
        }
        return javaCharsetName;
    }

    public static boolean isSupported(String p4CharsetName) {
        boolean supported = false;
        if (p4CharsetName != null && !p4CharsetName.isEmpty()) {
            supported = p4ToJavaCharsets.containsKey(p4CharsetName);
        }
        return supported;
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("none", "none");
        map.put("utf8", "UTF-8");
        map.put("iso8859-1", "ISO-8859-1");
        map.put("utf16-nobom", "UTF-16");
        map.put("shiftjis", "P4-ShiftJIS");
        map.put("eucjp", "EUC-JP");
        map.put("winansi", "windows-1252");
        map.put("winoem", "IBM437");
        map.put("macosroman", "x-MacRoman");
        map.put("iso8859-15", "ISO-8859-15");
        map.put("iso8859-5", "ISO-8859-5");
        map.put("koi8-r", "KOI8-R");
        map.put("cp1251", "windows-1251");
        map.put("utf16le", "UTF-16LE");
        map.put("utf16be", "UTF-16BE");
        map.put("utf16le-bom", "UTF-16LE");
        map.put("utf16be-bom", "UTF-16BE");
        map.put("utf16", "UTF-16");
        map.put("utf8-bom", "UTF-8");
        map.put("utf32-nobom", "UTF-32");
        map.put("utf32le", "UTF-32LE");
        map.put("utf32be", "UTF-32BE");
        map.put("utf32le-bom", "UTF-32LE");
        map.put("utf32be-bom", "UTF-32BE");
        map.put("utf32", "UTF-32");
        map.put("utf8unchecked", "UTF-8");
        map.put("utf8unchecked-bom", "UTF-8");
        map.put("cp949", "x-windows-949");
        map.put("cp936", "x-mswin-936");
        map.put("cp950", "x-windows-950");
        map.put("cp850", "IBM850");
        map.put("cp858", "IBM00858");
        map.put("cp1253", "windows-1253");
        map.put("cp737", "x-IBM737");
        map.put("iso8859-7", "ISO-8859-7");
        map.put("cp1250", "windows-1250");
        map.put("cp852", "IBM852");
        map.put("iso8859-2", "ISO-8859-2");
        p4ToJavaCharsets = Collections.unmodifiableMap(map);
        p4CharsetProvider = new PerforceCharsetProvider();
    }
}

