/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.generic.core;

import com.perforce.p4java.core.IJob;
import com.perforce.p4java.core.IJobSpec;
import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.RequestException;
import com.perforce.p4java.impl.generic.core.ServerResource;
import com.perforce.p4java.server.IServer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class Job
extends ServerResource
implements IJob {
    public static int SHORT_DESCR_LENGTH = 128;
    private String jobName = null;
    private Map<String, Object> rawFields = new HashMap<String, Object>(6);
    private String description = null;
    private IJobSpec jobSpec = null;
    private static final String[] DESCRIPTION_FIELD_IDS = new String[]{"Description", "description", "Desc"};
    private static final String[] JOB_ID_FIELD_IDS = new String[]{"Job", "job", "JobId"};

    public static Job newJob(IServer server, Map<String, Object> map) {
        Validate.notNull((Object)server, (String)"null server passed to Job.newJob()", (Object[])new Object[0]);
        Validate.notNull(map, (String)"null map passed to Job.newJob()", (Object[])new Object[0]);
        return new Job(server, map);
    }

    public Job(IServer server, Map<String, Object> map) {
        this(server, map, false);
    }

    public Job(IServer server, Map<String, Object> map, boolean longDescriptions) {
        super(true, true);
        this.server = server;
        if (map != null) {
            this.jobName = this.getJobIdString(map);
            this.description = this.getDescriptionString(map, longDescriptions);
            map.remove("specFormatted");
            this.rawFields.putAll(map);
        }
    }

    @Override
    public void refresh() throws ConnectionException, RequestException, AccessException {
        IJob refreshedJob;
        IServer refreshServer = this.server;
        String refreshId = this.jobName;
        if (refreshServer != null && refreshId != null && (refreshedJob = refreshServer.getJob(refreshId)) != null) {
            this.description = refreshedJob.getDescription();
            if (refreshedJob.getRawFields() != null) {
                this.rawFields.putAll(refreshedJob.getRawFields());
            } else {
                this.rawFields = new HashMap<String, Object>(6);
            }
        }
    }

    @Override
    public String updateOnServer() throws ConnectionException, RequestException, AccessException {
        Validate.notNull((Object)this.server, (String)"Null server field in Job.updateOnServer", (Object[])new Object[0]);
        return this.server.updateJob(this);
    }

    @Override
    public void update() throws ConnectionException, RequestException, AccessException {
        this.server.updateJob(this);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getId() {
        return this.jobName;
    }

    @Override
    public IJobSpec getJobSpec() {
        return this.jobSpec;
    }

    @Override
    public Map<String, Object> getRawFields() {
        return this.rawFields;
    }

    @Override
    public void setId(String id) {
        this.jobName = id;
    }

    @Override
    public void setRawFields(Map<String, Object> rawFields) {
        this.rawFields.putAll(rawFields);
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
        this.addOrUpdateRawFieldValue(DESCRIPTION_FIELD_IDS, description);
    }

    private void addOrUpdateRawFieldValue(String[] possibleKeys, Object value) {
        boolean isPresent = false;
        for (String possibleKey : possibleKeys) {
            if (!this.rawFields.containsKey(possibleKey)) continue;
            this.rawFields.put(possibleKey, value);
            isPresent = true;
            break;
        }
        if (!isPresent) {
            String firstKey = possibleKeys[0];
            this.rawFields.put(firstKey, value);
        }
    }

    @Override
    public void setJobSpec(IJobSpec jobSpec) {
        this.jobSpec = jobSpec;
    }

    protected String getJobIdString(Map<String, Object> map) {
        String candidate = (String)map.get(JOB_ID_FIELD_IDS[0]);
        if (StringUtils.isBlank((CharSequence)candidate) && StringUtils.isBlank((CharSequence)(candidate = (String)map.get(JOB_ID_FIELD_IDS[1])))) {
            candidate = (String)map.get(JOB_ID_FIELD_IDS[2]);
        }
        return candidate;
    }

    protected String getDescriptionString(Map<String, Object> map, boolean longDescriptions) {
        String candidate = (String)map.get(DESCRIPTION_FIELD_IDS[0]);
        if (StringUtils.isBlank((CharSequence)candidate) && StringUtils.isBlank((CharSequence)(candidate = (String)map.get(DESCRIPTION_FIELD_IDS[1])))) {
            candidate = (String)map.get(DESCRIPTION_FIELD_IDS[2]);
        }
        if (StringUtils.isNotBlank((CharSequence)candidate) && !longDescriptions && candidate.length() > SHORT_DESCR_LENGTH) {
            return candidate.substring(0, SHORT_DESCR_LENGTH - 1);
        }
        return candidate;
    }
}

