/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.common.io;

import com.perforce.p4java.common.base.Utf8Utils;
import com.perforce.p4java.common.quantity.Amount;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import javax.annotation.Nonnull;

public class FileEncoderConverter {
    private FileEncoderConverter() {
    }

    public static boolean canBeConvertWellFormedUtf8(@Nonnull byte[] sourceBytes, Charset from) {
        try {
            byte[] bytes = FileEncoderConverter.convertBytesEncode(sourceBytes, from, StandardCharsets.UTF_8);
            return Utf8Utils.isWellFormed(bytes);
        }
        catch (CharacterCodingException e) {
            return false;
        }
    }

    public static boolean canBeConvertWellFormedUtf8(@Nonnull File file, Charset from) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            int bytesRead;
            byte[] buffer = new byte[Amount.DEFAULT_BUFFER_SIZE];
            while ((bytesRead = ((InputStream)fileInputStream).read(buffer)) > 0) {
                byte[] readReadBytes = Arrays.copyOf(buffer, bytesRead);
                boolean convertable = FileEncoderConverter.canBeConvertWellFormedUtf8(readReadBytes, from);
                if (convertable) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }

    public static byte[] convertBytesEncode(@Nonnull byte[] sourceBytes, Charset from, Charset to) throws CharacterCodingException {
        CharsetDecoder sourceDecoder = from.newDecoder();
        ByteBuffer decodedByteBuffer = ByteBuffer.wrap(sourceBytes);
        CharBuffer sourceCharBuffer = sourceDecoder.decode(decodedByteBuffer);
        CharsetEncoder targetEncoder = to.newEncoder();
        targetEncoder.onMalformedInput(CodingErrorAction.REPORT);
        targetEncoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        ByteBuffer encodedByteBuffer = targetEncoder.encode(sourceCharBuffer);
        byte[] targetEncodedBytes = Arrays.copyOf(encodedByteBuffer.array(), encodedByteBuffer.remaining());
        encodedByteBuffer.clear();
        return targetEncodedBytes;
    }
}

