/**
 * Copyright (c) 2008 Perforce Software.  All rights reserved.
 */
package com.perforce.p4java.core.file;

/**
 * Statuses representing the result of a particular Perforce
 * file-based operation.<p>
 * 
 * The intention here is that this enum flags the associated
 * Perforce filespec as either a valid (normal) file operation
 * result (i.e. a file stat, etc.), or an error.
 * 
 * The enums represent statuses that are usually, but not always,
 * generated by the server; CLIENT_ERROR statuses are generated
 * in the P4Java API itself and represent problems it had on the
 * Perforce client under the command of the Perforce server. These
 * errors are typically such things as being unable to open a
 * client-side file, etc.
 *
 *
 */

public enum FileSpecOpStatus {
	
	/**
	 * Error / validity status is unknown; do not use the
	 * associated filespec.
	 */
	UNKNOWN,
	
	/**
	 * Operation completed normally; the associated filespec
	 * contains a valid Perforce filespec.
	 */
	VALID,
	
	/**
	 * The Perforce server or API client has generated a non-error
	 * message; the associated filespec contains the message.
	 */
	INFO,
	
	/**
	 * The Perforce client API detected a client-side error; the
	 * associated filespec contains the relevant error message.
	 */
	CLIENT_ERROR,
	
	/**
	 * The Perforce server has detected an error; the associated
	 * filespec contains the error message.
	 */
	ERROR
}
