/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.generic.core;

import com.perforce.p4java.Log;
import com.perforce.p4java.core.IFileLineMatch;
import com.perforce.p4java.impl.generic.core.file.FileSpec;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileLineMatch
implements IFileLineMatch {
    protected String file = null;
    protected int revision = -1;
    protected int lineNumber = -1;
    protected String line = null;
    protected IFileLineMatch.MatchType type = IFileLineMatch.MatchType.MATCH;

    public FileLineMatch(String file, int revision, String line, IFileLineMatch.MatchType type) {
        this.file = file;
        this.revision = revision;
        this.line = line;
        this.type = type;
    }

    public FileLineMatch(Map<String, Object> map) {
        if (map != null) {
            this.file = (String)map.get("depotFile");
            this.revision = FileSpec.getRevFromString((String)map.get("rev"));
            if (map.get("line") != null) {
                try {
                    this.lineNumber = Integer.parseInt((String)map.get("line"));
                }
                catch (NumberFormatException exc) {
                    Log.warn("NumberFormatException in FileLineMatch map-based constructor: " + exc.getLocalizedMessage());
                }
            }
            this.line = (String)map.get("matchedLine");
            this.type = IFileLineMatch.MatchType.fromServerString((String)map.get("type"));
        }
    }

    @Override
    public String getDepotFile() {
        return this.file;
    }

    @Override
    public String getLine() {
        return this.line;
    }

    @Override
    public int getRevision() {
        return this.revision;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public IFileLineMatch.MatchType getType() {
        return this.type;
    }
}

