/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.server;

import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

public class PerforceCharsets {
    private static final String[] knownCharsets = new String[]{"auto", "none", "utf8", "iso8859-1", "utf16-nobom", "shiftjis", "eucjp", "winansi", "winoem", "macosroman", "iso8859-15", "iso8859-5", "koi8-r", "cp1251", "utf16le", "utf16be", "utf16le-bom", "utf16be-bom", "utf16", "utf8-bom", "utf32-nobom", "utf32le", "utf32be", "utf32le-bom", "utf32be-bom", "utf32", "utf8unchecked", "utf8unchecked-bom", "cp949", "cp936", "cp950", "cp850", "cp858", "cp1253", "cp737", "iso8859-7"};
    private static final Map<String, String> p4ToJavaCharsets = new HashMap<String, String>();

    public static String[] getKnownCharsets() {
        return knownCharsets;
    }

    public static String getP4CharsetName(String javaCharsetName) {
        String p4CharsetName = null;
        if (javaCharsetName != null) {
            for (Map.Entry<String, String> entry : p4ToJavaCharsets.entrySet()) {
                if (entry.getValue() == null || !entry.getValue().equalsIgnoreCase(javaCharsetName)) continue;
                p4CharsetName = entry.getKey();
                break;
            }
        }
        return p4CharsetName;
    }

    public static String getJavaCharsetName(String p4CharsetName) {
        String javaCharsetName = null;
        if (p4CharsetName != null) {
            javaCharsetName = p4ToJavaCharsets.get(p4CharsetName);
        }
        return javaCharsetName;
    }

    public static String getJavaCharsetName(int p4CharsetIndex) {
        String javaCharsetName = null;
        if (p4CharsetIndex >= 0 && p4CharsetIndex < knownCharsets.length) {
            javaCharsetName = p4ToJavaCharsets.get(knownCharsets[p4CharsetIndex]);
        }
        return javaCharsetName;
    }

    public static Charset getJavaCharset(int p4CharsetIndex) {
        Charset javaCharset = null;
        if (p4CharsetIndex >= 0 && p4CharsetIndex < knownCharsets.length) {
            javaCharset = Charset.forName(p4ToJavaCharsets.get(knownCharsets[p4CharsetIndex]));
        }
        return javaCharset;
    }

    public static boolean isSupported(String p4CharsetName) {
        boolean supported = false;
        if (p4CharsetName != null) {
            supported = p4ToJavaCharsets.containsKey(p4CharsetName);
        }
        return supported;
    }

    static {
        int count = 0;
        p4ToJavaCharsets.put(knownCharsets[count++], "auto");
        p4ToJavaCharsets.put(knownCharsets[count++], "none");
        p4ToJavaCharsets.put(knownCharsets[count++], "UTF-8");
        p4ToJavaCharsets.put(knownCharsets[count++], "ISO-8859-1");
        p4ToJavaCharsets.put(knownCharsets[count++], "UTF-16");
        p4ToJavaCharsets.put(knownCharsets[count++], "P4-ShiftJIS");
        p4ToJavaCharsets.put(knownCharsets[count++], "EUC-JP");
        p4ToJavaCharsets.put(knownCharsets[count++], "windows-1252");
        p4ToJavaCharsets.put(knownCharsets[count++], "IBM437");
        p4ToJavaCharsets.put(knownCharsets[count++], "x-MacRoman");
        p4ToJavaCharsets.put(knownCharsets[count++], "ISO-8859-15");
        p4ToJavaCharsets.put(knownCharsets[count++], "ISO-8859-5");
        p4ToJavaCharsets.put(knownCharsets[count++], "KOI8-R");
        p4ToJavaCharsets.put(knownCharsets[count++], "windows-1251");
        p4ToJavaCharsets.put(knownCharsets[count++], "UTF-16LE");
        p4ToJavaCharsets.put(knownCharsets[count++], "UTF-16BE");
        p4ToJavaCharsets.put(knownCharsets[count++], "UTF-16LE");
        p4ToJavaCharsets.put(knownCharsets[count++], "UTF-16BE");
        p4ToJavaCharsets.put(knownCharsets[count++], "UTF-16");
        p4ToJavaCharsets.put(knownCharsets[count++], "UTF-8");
        p4ToJavaCharsets.put(knownCharsets[count++], "UTF-32");
        p4ToJavaCharsets.put(knownCharsets[count++], "UTF-32LE");
        p4ToJavaCharsets.put(knownCharsets[count++], "UTF-32BE");
        p4ToJavaCharsets.put(knownCharsets[count++], "UTF-32LE");
        p4ToJavaCharsets.put(knownCharsets[count++], "UTF-32BE");
        p4ToJavaCharsets.put(knownCharsets[count++], "UTF-32");
        p4ToJavaCharsets.put(knownCharsets[count++], "UTF-8");
        p4ToJavaCharsets.put(knownCharsets[count++], "UTF-8");
        p4ToJavaCharsets.put(knownCharsets[count++], "x-windows-949");
        p4ToJavaCharsets.put(knownCharsets[count++], "x-mswin-936");
        p4ToJavaCharsets.put(knownCharsets[count++], "x-windows-950");
        p4ToJavaCharsets.put(knownCharsets[count++], "IBM850");
        p4ToJavaCharsets.put(knownCharsets[count++], "IBM00858");
        p4ToJavaCharsets.put(knownCharsets[count++], "windows-1253");
        p4ToJavaCharsets.put(knownCharsets[count++], "x-IBM737");
        p4ToJavaCharsets.put(knownCharsets[count++], "ISO-8859-7");
    }
}

