/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.stream;

import com.perforce.p4java.Log;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.NullPointerError;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.exception.ProtocolError;
import com.perforce.p4java.impl.mapbased.rpc.ServerStats;
import com.perforce.p4java.impl.mapbased.rpc.connection.RpcConnection;
import com.perforce.p4java.impl.mapbased.rpc.func.RpcFunctionSpec;
import com.perforce.p4java.impl.mapbased.rpc.func.client.ClientTrust;
import com.perforce.p4java.impl.mapbased.rpc.packet.RpcPacket;
import com.perforce.p4java.impl.mapbased.rpc.packet.RpcPacketDispatcher;
import com.perforce.p4java.impl.mapbased.rpc.packet.RpcPacketPreamble;
import com.perforce.p4java.impl.mapbased.rpc.packet.helper.RpcPacketFieldRule;
import com.perforce.p4java.impl.mapbased.rpc.stream.RpcGZIPInputStream;
import com.perforce.p4java.impl.mapbased.rpc.stream.RpcGZIPOutputStream;
import com.perforce.p4java.impl.mapbased.rpc.stream.RpcRshInputStream;
import com.perforce.p4java.impl.mapbased.rpc.stream.RpcRshOutputStream;
import com.perforce.p4java.impl.mapbased.rpc.stream.RpcSocketInputStream;
import com.perforce.p4java.impl.mapbased.rpc.stream.RpcSocketOutputStream;
import com.perforce.p4java.impl.mapbased.rpc.stream.RpcSocketPool;
import com.perforce.p4java.impl.mapbased.rpc.stream.helper.RpcSocketHelper;
import com.perforce.p4java.impl.mapbased.server.Server;
import com.perforce.p4java.server.callback.IFilterCallback;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;

public class RpcStreamConnection
extends RpcConnection {
    public static final String TRACE_PREFIX = "RpcStreamConnection";
    protected static final int INITIAL_SENDBUF_SIZE = 2048;
    protected static final int SENDBUF_REALLOC_INCR = 1024;
    private RpcSocketPool pool = null;
    private Socket socket = null;
    private InputStream inputStream = null;
    private OutputStream outputStream = null;
    private InputStream topInputStream = null;
    private OutputStream topOutputStream = null;
    private String rsh = null;

    public RpcStreamConnection(String serverHost, int serverPort, Properties props, ServerStats stats, Charset charset) throws ConnectionException {
        this(serverHost, serverPort, props, stats, charset, (Socket)null);
    }

    public RpcStreamConnection(String serverHost, int serverPort, Properties props, ServerStats stats, Charset charset, boolean secure) throws ConnectionException {
        this(serverHost, serverPort, props, stats, charset, (Socket)null, secure);
    }

    public RpcStreamConnection(String serverHost, int serverPort, Properties props, ServerStats stats, Charset charset, Socket socket) throws ConnectionException {
        this(serverHost, serverPort, props, stats, charset, socket, false);
    }

    public RpcStreamConnection(String serverHost, int serverPort, Properties props, ServerStats stats, Charset charset, Socket socket, boolean secure) throws ConnectionException {
        this(serverHost, serverPort, props, stats, charset, socket, null, secure);
    }

    public RpcStreamConnection(String serverHost, int serverPort, Properties props, ServerStats stats, Charset charset, RpcSocketPool pool) throws ConnectionException {
        this(serverHost, serverPort, props, stats, charset, null, pool, false);
    }

    public RpcStreamConnection(String serverHost, int serverPort, Properties props, ServerStats stats, Charset charset, RpcSocketPool pool, boolean secure) throws ConnectionException {
        this(serverHost, serverPort, props, stats, charset, null, pool, secure);
    }

    public RpcStreamConnection(String serverHost, int serverPort, Properties props, ServerStats stats, Charset charset, Socket socket, RpcSocketPool pool, boolean secure) throws ConnectionException {
        this(serverHost, serverPort, props, stats, charset, socket, pool, secure, null);
    }

    public RpcStreamConnection(String serverHost, int serverPort, Properties props, ServerStats stats, Charset charset, Socket socket, RpcSocketPool pool, boolean secure, String rsh) throws ConnectionException {
        super(serverHost, serverPort, props, stats, charset, secure);
        this.socket = socket;
        this.pool = pool;
        this.rsh = rsh;
        this.init();
    }

    private void init() throws ConnectionException {
        if (this.rsh != null) {
            try {
                String[] command = new String[]{Server.isRunningOnWindows() ? "cmd.exe" : "/bin/sh", Server.isRunningOnWindows() ? "/c" : "-c", this.rsh};
                ProcessBuilder builder = new ProcessBuilder(command);
                Process process = builder.start();
                InputStream in = process.getInputStream();
                OutputStream out = process.getOutputStream();
                this.inputStream = new RpcRshInputStream(in, this.stats);
                this.outputStream = new RpcRshOutputStream(out, this.stats);
            }
            catch (Throwable thr) {
                Log.error("Unexpected exception: " + thr.getLocalizedMessage());
                Log.exception(thr);
                throw new ConnectionException(thr.getLocalizedMessage());
            }
        }
        try {
            if (this.socket == null) {
                this.socket = this.pool != null ? this.pool.acquire() : RpcSocketHelper.createSocket(this.hostName, this.hostPort, this.props, this.secure);
            }
        }
        catch (UnknownHostException exc) {
            throw new ConnectionException("Unable to resolve Perforce server host name '" + this.hostName + "' for RPC connection");
        }
        catch (IOException exc) {
            throw new ConnectionException("Unable to connect to Perforce server at " + this.hostName + ":" + this.hostPort);
        }
        catch (Throwable thr) {
            Log.error("Unexpected exception: " + thr.getLocalizedMessage());
            Log.exception(thr);
            throw new ConnectionException(thr.getLocalizedMessage());
        }
        if (this.socket != null && this.socket.getInetAddress() != null) {
            InetAddress address = this.socket.getInetAddress();
            this.hostIp = Inet6Address.class.isAssignableFrom(address.getClass()) ? "[" + this.socket.getInetAddress().getHostAddress() + "]" : this.socket.getInetAddress().getHostAddress();
        }
        if (this.secure) {
            this.initSSL();
        }
        try {
            this.inputStream = new RpcSocketInputStream(this.socket, this.stats);
            this.outputStream = new RpcSocketOutputStream(this.socket, this.stats);
        }
        catch (Throwable thr) {
            Log.error("Unexpected exception: " + thr.getLocalizedMessage());
            Log.exception(thr);
            throw new ConnectionException(thr.getLocalizedMessage());
        }
        this.topInputStream = this.inputStream;
        this.topOutputStream = this.outputStream;
    }

    private void initSSL() throws ConnectionException {
        if (this.socket != null) {
            try {
                SSLSession sslSession = ((SSLSocket)this.socket).getSession();
                if (!sslSession.isValid()) {
                    throw new ConnectionException("Error occurred during the SSL handshake: invalid SSL session");
                }
                Certificate[] serverCerts = sslSession.getPeerCertificates();
                if (serverCerts == null || serverCerts.length == 0 || serverCerts[0] == null) {
                    throw new ConnectionException("Error occurred during the SSL handshake: no certificate retrieved from SSL session");
                }
                try {
                    ((X509Certificate)serverCerts[0]).checkValidity();
                }
                catch (CertificateExpiredException e) {
                    throw new ConnectionException("Error occurred during the SSL handshake: certificate expired: " + e.toString(), e);
                }
                catch (CertificateNotYetValidException e) {
                    throw new ConnectionException("Error occurred during the SSL handshake: certificate not yet valid: " + e.toString(), e);
                }
                PublicKey serverPubKey = serverCerts[0].getPublicKey();
                if (serverPubKey == null) {
                    throw new ConnectionException("Error occurred during the SSL handshake: no public key retrieved from server certificate");
                }
                try {
                    this.fingerprint = ClientTrust.generateFingerprint(serverPubKey);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new ConnectionException("Error occurred while generating the fingerprint for the Perforce SSL connection", e);
                }
            }
            catch (IOException e) {
                String message = "Error occurred during SSL hankshake. Please check the release notes for known SSL issues: " + e.getLocalizedMessage();
                Log.error(message);
                Log.exception(e);
                throw new ConnectionException(message);
            }
        }
    }

    public String getServerIpPort() {
        String serverIpPort = null;
        if (this.hostIp != UNKNOWN_SERVER_HOST) {
            serverIpPort = this.hostIp;
            if (this.hostPort != -1) {
                serverIpPort = serverIpPort + ":" + Integer.toString(this.hostPort);
            }
        } else if (this.hostPort != -1) {
            serverIpPort = Integer.toString(this.hostPort);
        }
        return serverIpPort;
    }

    public void disconnect(final RpcPacketDispatcher dispatcher) throws ConnectionException {
        block8: {
            try {
                RpcSocketPool.ShutdownHandler handler = new RpcSocketPool.ShutdownHandler(){

                    public void shutdown(Socket socket) {
                        if (dispatcher != null) {
                            try {
                                dispatcher.shutdown(RpcStreamConnection.this);
                            }
                            catch (ConnectionException e) {
                                Log.exception(e);
                            }
                        }
                    }
                };
                if (this.rsh != null) {
                    try {
                        dispatcher.shutdown(this);
                    }
                    catch (ConnectionException e) {
                        Log.exception(e);
                    }
                    this.topInputStream.close();
                    this.topOutputStream.close();
                    break block8;
                }
                if (this.pool != null) {
                    this.pool.release(this.socket, handler);
                } else {
                    handler.shutdown(this.socket);
                    this.topInputStream.close();
                    this.topOutputStream.close();
                    if (this.socket != null) {
                        this.socket.close();
                    }
                }
            }
            catch (IOException exc) {
                throw new ConnectionException("RPC disconnection error: " + exc.getLocalizedMessage(), exc);
            }
        }
    }

    public void useConnectionCompression() throws ConnectionException {
        if (!this.usingCompression) {
            super.useConnectionCompression();
            try {
                this.topOutputStream.flush();
                this.putRpcPacket(RpcPacket.constructRpcPacket(RpcFunctionSpec.PROTOCOL_COMPRESS2, "compress2", null, null));
                this.topOutputStream.flush();
                this.topOutputStream = new RpcGZIPOutputStream(this.outputStream);
                this.topInputStream = new RpcGZIPInputStream(this.inputStream);
            }
            catch (IOException exc) {
                Log.error("I/O exception encountered while setting up GZIP streaming: " + exc.getLocalizedMessage());
                Log.exception(exc);
                throw new ConnectionException("unable to set up client compression streaming to Perforce server: " + exc.getLocalizedMessage(), exc);
            }
        }
    }

    public RpcPacket getRpcPacket() throws ConnectionException {
        return this.getRpcPacket(null, null);
    }

    public RpcPacket getRpcPacket(RpcPacketFieldRule fieldRule, IFilterCallback filterCallback) throws ConnectionException {
        byte[] preambleBytes = new byte[5];
        RpcPacket packet = null;
        try {
            int moreBytesRead;
            int packetBytesRead;
            int moreBytesRead2;
            int bytesRead;
            this.stats.streamRecvs.incrementAndGet();
            if (bytesRead < 0) {
                throw new ConnectionException("server connection unexpectedly closed");
            }
            for (bytesRead = this.topInputStream.read(preambleBytes); bytesRead >= 0 && bytesRead < preambleBytes.length; bytesRead += moreBytesRead2) {
                moreBytesRead2 = this.topInputStream.read(preambleBytes, bytesRead, preambleBytes.length - bytesRead);
                this.stats.streamRecvs.incrementAndGet();
                if (moreBytesRead2 >= 0) continue;
                throw new ConnectionException("server connection unexpectedly closed");
            }
            this.stats.totalBytesRecv.getAndAdd(bytesRead);
            if (bytesRead != preambleBytes.length) {
                throw new ConnectionException("Incomplete RPC packet preamble read from Perforce server; connection probably broken. bytes read: " + bytesRead);
            }
            RpcPacketPreamble preamble = RpcPacketPreamble.retrievePreamble(preambleBytes);
            if (preamble == null) {
                throw new ProtocolError("Null RPC packet preamble in byte buffer");
            }
            if (!preamble.isValidChecksum()) {
                throw new ProtocolError("Bad checksum in RPC preamble");
            }
            int payloadLength = preamble.getPayloadSize();
            if (payloadLength <= 0) {
                throw new ProtocolError("Bad payload size in RPC preamble: " + payloadLength);
            }
            byte[] packetBytes = new byte[payloadLength];
            this.stats.streamRecvs.incrementAndGet();
            this.stats.totalBytesRecv.getAndAdd(packetBytesRead);
            if (packetBytesRead <= 0) {
                throw new ConnectionException("Perforce server network connection closed unexpectedly");
            }
            for (packetBytesRead = this.topInputStream.read(packetBytes, 0, payloadLength); packetBytesRead < payloadLength; packetBytesRead += moreBytesRead) {
                this.stats.incompleteReads.incrementAndGet();
                moreBytesRead = this.topInputStream.read(packetBytes, packetBytesRead, payloadLength - packetBytesRead);
                this.stats.streamRecvs.incrementAndGet();
                this.stats.totalBytesRecv.getAndAdd(moreBytesRead);
                if (moreBytesRead >= 0) continue;
                throw new ConnectionException("Perforce server network connection closed unexpectedly");
            }
            if (packetBytesRead != payloadLength) {
                throw new P4JavaError("RPC packet payload read size mismatch; expected: " + payloadLength + "; got: " + packetBytesRead);
            }
            packet = RpcPacket.constructRpcPacket(preamble, packetBytes, this.unicodeServer, this.clientCharset, fieldRule, filterCallback);
            this.stats.packetsRecv.incrementAndGet();
            this.stats.largestRpcPacketRecv.set(Math.max(this.stats.largestRpcPacketRecv.get(), (long)packet.getPacketLength()));
        }
        catch (IOException exc) {
            throw new ConnectionException(exc);
        }
        catch (ConnectionException p4jexc) {
            throw p4jexc;
        }
        catch (P4JavaError p4je) {
            throw p4je;
        }
        catch (Throwable thr) {
            Log.error("Unexpected exception: " + thr.getLocalizedMessage());
            Log.exception(thr);
            throw new P4JavaError(thr.getLocalizedMessage(), thr);
        }
        return packet;
    }

    public long putRpcPacket(RpcPacket packet) throws ConnectionException {
        byte[] nameBytes;
        byte[] sendBytes = new byte[2048];
        int sendPos = 0;
        if (packet == null) {
            throw new NullPointerError("null RPC packet passed to RpcStreamConnection.putPacket");
        }
        if (packet.getFuncNameString() == null) {
            throw new P4JavaError("Unmapped / unmappable function in RpcPacket.put()");
        }
        sendPos += 5;
        Map<String, Object> mapArgs = packet.getMapArgs();
        String[] strArgs = packet.getStrArgs();
        if (mapArgs != null) {
            for (Map.Entry<String, Object> entry : mapArgs.entrySet()) {
                byte[] fieldBytes = this.marshalPacketField(entry.getKey(), entry.getValue());
                if (sendBytes.length - sendPos <= fieldBytes.length) {
                    this.stats.bufferCompacts.getAndIncrement();
                    int newBytesLength = sendBytes.length + fieldBytes.length + 1024;
                    byte[] newBytes = new byte[newBytesLength];
                    System.arraycopy(sendBytes, 0, newBytes, 0, sendPos);
                    sendBytes = newBytes;
                }
                System.arraycopy(fieldBytes, 0, sendBytes, sendPos, fieldBytes.length);
                sendPos += fieldBytes.length;
            }
        }
        if (strArgs != null) {
            for (String arg : strArgs) {
                if (arg == null) continue;
                byte[] fieldBytes = this.marshalPacketField(null, arg);
                if (sendBytes.length - sendPos <= fieldBytes.length) {
                    this.stats.bufferCompacts.getAndIncrement();
                    int newBytesLength = sendBytes.length + fieldBytes.length + 1024;
                    byte[] newBytes = new byte[newBytesLength];
                    System.arraycopy(sendBytes, 0, newBytes, 0, sendPos);
                    sendBytes = newBytes;
                }
                System.arraycopy(fieldBytes, 0, sendBytes, sendPos, fieldBytes.length);
                sendPos += fieldBytes.length;
            }
        }
        if (packet.getEnv() != null) {
            byte[] envBytes = packet.getEnv().marshal();
            if (sendBytes.length - sendPos <= envBytes.length) {
                this.stats.bufferCompacts.getAndIncrement();
                int newBytesLength = sendBytes.length + envBytes.length + 1024;
                byte[] newBytes = new byte[newBytesLength];
                System.arraycopy(sendBytes, 0, newBytes, 0, sendPos);
                sendBytes = newBytes;
            }
            System.arraycopy(envBytes, 0, sendBytes, sendPos, envBytes.length);
            sendPos += envBytes.length;
        }
        if (sendBytes.length - sendPos <= (nameBytes = this.marshalPacketField("func", packet.getFuncNameString())).length) {
            this.stats.bufferCompacts.getAndIncrement();
            int newBytesLength = sendBytes.length + nameBytes.length;
            byte[] newBytes = new byte[newBytesLength];
            System.arraycopy(sendBytes, 0, newBytes, 0, sendPos);
            sendBytes = newBytes;
        }
        System.arraycopy(nameBytes, 0, sendBytes, sendPos, nameBytes.length);
        byte[] preambleBytes = RpcPacketPreamble.constructPreamble((sendPos += nameBytes.length) - 5).marshalAsBytes();
        System.arraycopy(preambleBytes, 0, sendBytes, 0, preambleBytes.length);
        try {
            this.topOutputStream.write(sendBytes, 0, sendPos);
            this.topOutputStream.flush();
            this.stats.streamSends.incrementAndGet();
            this.stats.totalBytesSent.getAndAdd(sendPos);
            this.stats.packetsSent.incrementAndGet();
            if (this.stats.largestRpcPacketSent.get() < (long)sendPos) {
                this.stats.largestRpcPacketSent.set(sendPos);
            }
        }
        catch (IOException exc) {
            Log.exception(exc);
            StringBuilder message = new StringBuilder();
            if (exc instanceof SocketTimeoutException && this.secure) {
                message.append(MessageFormat.format("SSL connect to ssl:{0}:{1,number,#} failed.\nRemove SSL protocol prefix.\n", this.hostName, this.hostPort));
            } else {
                message.append("Unable to send command to Perforce server: ");
            }
            message.append(exc.getMessage());
            throw new ConnectionException(message.toString(), exc);
        }
        return 0L;
    }

    public long putRpcPackets(RpcPacket[] packets) throws ConnectionException {
        int retVal = 0;
        if (packets == null) {
            throw new NullPointerError("Null RPC packets passed to RpcStreamConnection.putPacket");
        }
        for (RpcPacket packet : packets) {
            if (packet == null) continue;
            retVal = (int)((long)retVal + this.putRpcPacket(packet));
        }
        return retVal;
    }

    public int getSystemSendBufferSize() {
        if (this.socket != null) {
            try {
                return this.socket.getSendBufferSize();
            }
            catch (SocketException exc) {
                Log.error("unexpected exception: " + exc.getLocalizedMessage());
                Log.exception(exc);
            }
        }
        return 0;
    }

    public int getSystemRecvBufferSize() {
        if (this.socket != null) {
            try {
                return this.socket.getReceiveBufferSize();
            }
            catch (SocketException exc) {
                Log.error("unexpected exception: " + exc.getLocalizedMessage());
                Log.exception(exc);
            }
        }
        return 0;
    }
}

