/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.server;

import com.perforce.p4java.Log;
import com.perforce.p4java.admin.IDbSchema;
import com.perforce.p4java.admin.IDiskSpace;
import com.perforce.p4java.admin.ILogTail;
import com.perforce.p4java.admin.IProperty;
import com.perforce.p4java.admin.IProtectionEntry;
import com.perforce.p4java.admin.ServerConfigurationValue;
import com.perforce.p4java.charset.PerforceCharsetProvider;
import com.perforce.p4java.client.IClient;
import com.perforce.p4java.client.IClientSummary;
import com.perforce.p4java.core.IBranchSpec;
import com.perforce.p4java.core.IBranchSpecSummary;
import com.perforce.p4java.core.IChangelist;
import com.perforce.p4java.core.IChangelistSummary;
import com.perforce.p4java.core.IDepot;
import com.perforce.p4java.core.IFileDiff;
import com.perforce.p4java.core.IFileLineMatch;
import com.perforce.p4java.core.IFix;
import com.perforce.p4java.core.IJob;
import com.perforce.p4java.core.IJobSpec;
import com.perforce.p4java.core.ILabel;
import com.perforce.p4java.core.ILabelSummary;
import com.perforce.p4java.core.IReviewChangelist;
import com.perforce.p4java.core.IServerProcess;
import com.perforce.p4java.core.IStream;
import com.perforce.p4java.core.IStreamIntegrationStatus;
import com.perforce.p4java.core.IStreamSummary;
import com.perforce.p4java.core.IUser;
import com.perforce.p4java.core.IUserGroup;
import com.perforce.p4java.core.IUserSummary;
import com.perforce.p4java.core.file.DiffType;
import com.perforce.p4java.core.file.FileDiff;
import com.perforce.p4java.core.file.FileSpecOpStatus;
import com.perforce.p4java.core.file.FileStatAncilliaryOptions;
import com.perforce.p4java.core.file.FileStatOutputOptions;
import com.perforce.p4java.core.file.IExtendedFileSpec;
import com.perforce.p4java.core.file.IFileAnnotation;
import com.perforce.p4java.core.file.IFileRevisionData;
import com.perforce.p4java.core.file.IFileSize;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.core.file.IObliterateResult;
import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.ConfigException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.NullPointerError;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.exception.RequestException;
import com.perforce.p4java.exception.UnimplementedError;
import com.perforce.p4java.impl.generic.admin.DbSchema;
import com.perforce.p4java.impl.generic.admin.DiskSpace;
import com.perforce.p4java.impl.generic.admin.LogTail;
import com.perforce.p4java.impl.generic.admin.Property;
import com.perforce.p4java.impl.generic.admin.ProtectionEntry;
import com.perforce.p4java.impl.generic.core.BranchSpec;
import com.perforce.p4java.impl.generic.core.BranchSpecSummary;
import com.perforce.p4java.impl.generic.core.Changelist;
import com.perforce.p4java.impl.generic.core.ChangelistSummary;
import com.perforce.p4java.impl.generic.core.Depot;
import com.perforce.p4java.impl.generic.core.FileLineMatch;
import com.perforce.p4java.impl.generic.core.Fix;
import com.perforce.p4java.impl.generic.core.InputMapper;
import com.perforce.p4java.impl.generic.core.Job;
import com.perforce.p4java.impl.generic.core.JobSpec;
import com.perforce.p4java.impl.generic.core.Label;
import com.perforce.p4java.impl.generic.core.LabelSummary;
import com.perforce.p4java.impl.generic.core.ReviewChangelist;
import com.perforce.p4java.impl.generic.core.ServerProcess;
import com.perforce.p4java.impl.generic.core.Stream;
import com.perforce.p4java.impl.generic.core.StreamIntegrationStatus;
import com.perforce.p4java.impl.generic.core.StreamSummary;
import com.perforce.p4java.impl.generic.core.User;
import com.perforce.p4java.impl.generic.core.UserGroup;
import com.perforce.p4java.impl.generic.core.UserSummary;
import com.perforce.p4java.impl.generic.core.file.ExtendedFileSpec;
import com.perforce.p4java.impl.generic.core.file.FileAnnotation;
import com.perforce.p4java.impl.generic.core.file.FilePath;
import com.perforce.p4java.impl.generic.core.file.FileRevisionData;
import com.perforce.p4java.impl.generic.core.file.FileSize;
import com.perforce.p4java.impl.generic.core.file.FileSpec;
import com.perforce.p4java.impl.generic.core.file.ObliterateResult;
import com.perforce.p4java.impl.mapbased.client.Client;
import com.perforce.p4java.impl.mapbased.client.ClientSummary;
import com.perforce.p4java.impl.mapbased.rpc.RpcPropertyDefs;
import com.perforce.p4java.impl.mapbased.server.IServerControl;
import com.perforce.p4java.impl.mapbased.server.Parameters;
import com.perforce.p4java.impl.mapbased.server.ServerInfo;
import com.perforce.p4java.option.Options;
import com.perforce.p4java.option.UsageOptions;
import com.perforce.p4java.option.server.ChangelistOptions;
import com.perforce.p4java.option.server.CounterOptions;
import com.perforce.p4java.option.server.DeleteBranchSpecOptions;
import com.perforce.p4java.option.server.DeleteClientOptions;
import com.perforce.p4java.option.server.DeleteLabelOptions;
import com.perforce.p4java.option.server.DescribeOptions;
import com.perforce.p4java.option.server.DuplicateRevisionsOptions;
import com.perforce.p4java.option.server.ExportRecordsOptions;
import com.perforce.p4java.option.server.FixJobsOptions;
import com.perforce.p4java.option.server.GetBranchSpecOptions;
import com.perforce.p4java.option.server.GetBranchSpecsOptions;
import com.perforce.p4java.option.server.GetChangelistDiffsOptions;
import com.perforce.p4java.option.server.GetChangelistsOptions;
import com.perforce.p4java.option.server.GetClientTemplateOptions;
import com.perforce.p4java.option.server.GetClientsOptions;
import com.perforce.p4java.option.server.GetCountersOptions;
import com.perforce.p4java.option.server.GetDepotFilesOptions;
import com.perforce.p4java.option.server.GetDirectoriesOptions;
import com.perforce.p4java.option.server.GetExtendedFilesOptions;
import com.perforce.p4java.option.server.GetFileAnnotationsOptions;
import com.perforce.p4java.option.server.GetFileContentsOptions;
import com.perforce.p4java.option.server.GetFileDiffsOptions;
import com.perforce.p4java.option.server.GetFileSizesOptions;
import com.perforce.p4java.option.server.GetFixesOptions;
import com.perforce.p4java.option.server.GetInterchangesOptions;
import com.perforce.p4java.option.server.GetJobsOptions;
import com.perforce.p4java.option.server.GetKeysOptions;
import com.perforce.p4java.option.server.GetLabelsOptions;
import com.perforce.p4java.option.server.GetPropertyOptions;
import com.perforce.p4java.option.server.GetProtectionEntriesOptions;
import com.perforce.p4java.option.server.GetReviewChangelistsOptions;
import com.perforce.p4java.option.server.GetReviewsOptions;
import com.perforce.p4java.option.server.GetRevisionHistoryOptions;
import com.perforce.p4java.option.server.GetServerProcessesOptions;
import com.perforce.p4java.option.server.GetStreamOptions;
import com.perforce.p4java.option.server.GetStreamsOptions;
import com.perforce.p4java.option.server.GetSubmittedIntegrationsOptions;
import com.perforce.p4java.option.server.GetUserGroupsOptions;
import com.perforce.p4java.option.server.GetUsersOptions;
import com.perforce.p4java.option.server.JournalWaitOptions;
import com.perforce.p4java.option.server.KeyOptions;
import com.perforce.p4java.option.server.LogTailOptions;
import com.perforce.p4java.option.server.LoginOptions;
import com.perforce.p4java.option.server.MatchingLinesOptions;
import com.perforce.p4java.option.server.MoveFileOptions;
import com.perforce.p4java.option.server.ObliterateFilesOptions;
import com.perforce.p4java.option.server.OpenedFilesOptions;
import com.perforce.p4java.option.server.PropertyOptions;
import com.perforce.p4java.option.server.ReloadOptions;
import com.perforce.p4java.option.server.SearchJobsOptions;
import com.perforce.p4java.option.server.SetFileAttributesOptions;
import com.perforce.p4java.option.server.StreamIntegrationStatusOptions;
import com.perforce.p4java.option.server.StreamOptions;
import com.perforce.p4java.option.server.SwitchClientViewOptions;
import com.perforce.p4java.option.server.TagFilesOptions;
import com.perforce.p4java.option.server.TrustOptions;
import com.perforce.p4java.option.server.UnloadOptions;
import com.perforce.p4java.option.server.UpdateClientOptions;
import com.perforce.p4java.option.server.UpdateUserGroupOptions;
import com.perforce.p4java.option.server.UpdateUserOptions;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.Fingerprint;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.IServer;
import com.perforce.p4java.server.IServerInfo;
import com.perforce.p4java.server.PerforceCharsets;
import com.perforce.p4java.server.ServerStatus;
import com.perforce.p4java.server.SystemInfo;
import com.perforce.p4java.server.callback.ICommandCallback;
import com.perforce.p4java.server.callback.IFilterCallback;
import com.perforce.p4java.server.callback.IProgressCallback;
import com.perforce.p4java.server.callback.ISSOCallback;
import com.perforce.p4java.server.callback.IStreamingCallback;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Server
implements IServerControl,
IOptionsServer {
    public static final String SCREEN_NAME_FIELD_NAME = "SCREEN_NAME";
    public static final String IMPL_COMMENTS_FIELD_NAME = "IMPL_COMMENTS";
    public static final String IMPL_TYPE_FIELD_NAME = "IMPL_TYPE";
    public static final String MINIMUM_SUPPORTED_SERVER_LEVEL_FIELD_NAME = "MINIMUM_SUPPORTED_SERVER_LEVEL";
    public static final String PROTOCOL_NAME_FIELD_NAME = "PROTOCOL_NAME";
    public static final String DEFAULT_STATUS_FIELD_NAME = "DEFAULT_STATUS";
    public static final String IN_MAP_USE_TAGS_KEY = "useTags";
    public static final String ATTRIBUTE_STREAM_MAP_KEY = "attributeInstream";
    protected static final String CORE_AUTH_FAIL_STRING_1 = "Perforce password (P4PASSWD)";
    protected static final String CORE_AUTH_FAIL_STRING_2 = "Access for user";
    protected static final String CORE_AUTH_FAIL_STRING_3 = "Your session has expired";
    protected static final String CORE_AUTH_FAIL_STRING_4 = "Your session was logged out";
    public static final String P4TICKETS_ENV_VAR = "P4TICKETS";
    public static final String P4TICKETS_DEFAULT_WINDOWS = "p4tickets.txt";
    public static final String P4TICKETS_DEFAULT_OTHER = ".p4tickets";
    public static final String P4TRUST_ENV_VAR = "P4TRUST";
    public static final String P4TRUST_DEFAULT_WINDOWS = "p4trust.txt";
    public static final String P4TRUST_DEFAULT_OTHER = ".p4trust";
    public static final String P4IGNORE_ENV_VAR = "P4IGNORE";
    protected UsageOptions usageOptions = null;
    protected static final int UNKNOWN_SERVER_VERSION = -1;
    protected static final String UNKNOWN_SERVER_HOST = null;
    protected static final int UNKNOWN_SERVER_PORT = -1;
    protected ServerStatus status = ServerStatus.UNKNOWN;
    protected Properties props = null;
    protected IServerInfo serverInfo = null;
    protected String serverAddress = null;
    protected boolean caseSensitive = true;
    protected int serverVersion = -1;
    protected String serverHost = UNKNOWN_SERVER_HOST;
    protected int serverPort = -1;
    protected String userName = null;
    protected String password = null;
    protected Map<String, String> authTickets = new HashMap<String, String>();
    protected IClient client = null;
    protected String clientName = null;
    protected String clientUnsetName = "noclient";
    protected boolean setupOnConnect = false;
    protected boolean loginOnConnect = false;
    protected ICommandCallback commandCallback = null;
    protected IProgressCallback progressCallback = null;
    protected ISSOCallback ssoCallback = null;
    protected String ssoKey = null;
    protected String charsetName = null;
    protected Charset charset = null;
    protected boolean connected = false;
    protected int minumumSupportedServerVersion = 20052;
    protected String tmpDirName = null;
    protected AtomicInteger nextCmdCallBackKey = new AtomicInteger();
    protected AtomicInteger nextProgressCallbackKey = new AtomicInteger();
    protected static boolean runningOnWindows = SystemInfo.isWindows();
    protected boolean nonCheckedSyncs = false;
    protected boolean enableTracking = false;
    protected boolean enableProgress = false;
    protected boolean quietMode = false;
    protected boolean secure = false;
    protected boolean useAuthMemoryStore = false;
    protected String ignoreFileName = null;
    protected Random rand = new Random(System.currentTimeMillis());

    @Override
    public ICommandCallback registerCallback(ICommandCallback callback) {
        ICommandCallback oldCallback = this.commandCallback;
        this.commandCallback = callback;
        return oldCallback;
    }

    @Override
    public IProgressCallback registerProgressCallback(IProgressCallback progressCallback) {
        IProgressCallback oldCallback = this.progressCallback;
        this.progressCallback = progressCallback;
        return oldCallback;
    }

    @Override
    public ISSOCallback registerSSOCallback(ISSOCallback callback, String ssoKey) {
        ISSOCallback oldCallback = this.ssoCallback;
        this.ssoCallback = callback;
        this.ssoKey = ssoKey;
        return oldCallback;
    }

    @Override
    public ServerStatus getStatus() {
        return this.status;
    }

    @Override
    public int getServerVersionNumber() {
        return this.serverVersion;
    }

    @Override
    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean setCharsetName(String charsetName) throws UnsupportedCharsetException {
        if (charsetName != null && !PerforceCharsets.isSupported(charsetName)) {
            throw new UnsupportedCharsetException(charsetName);
        }
        this.charsetName = charsetName;
        if (this.charsetName != null) {
            charsetName = PerforceCharsets.getJavaCharsetName(charsetName);
            try {
                this.charset = Charset.forName(charsetName);
            }
            catch (UnsupportedCharsetException uce) {
                p4CharsetProvider = new PerforceCharsetProvider();
                this.charset = p4CharsetProvider.charsetForName(charsetName);
                if (this.charset != null) ** GOTO lbl17
                throw uce;
            }
            catch (IllegalCharsetNameException icne) {
                throw new UnsupportedCharsetException(icne.getLocalizedMessage());
            }
        } else {
            this.charset = null;
        }
lbl17:
        // 3 sources

        return this.charset != null;
    }

    @Override
    public String getCharsetName() {
        return this.charsetName;
    }

    @Override
    public boolean supportsUnicode() throws ConnectionException, RequestException, AccessException {
        IServerInfo info = this.getServerInfo();
        if (info != null) {
            return info.isUnicodeEnabled();
        }
        return false;
    }

    @Override
    public String[] getKnownCharsets() {
        return PerforceCharsets.getKnownCharsets();
    }

    @Override
    public Properties getProperties() {
        return this.props;
    }

    @Override
    public ServerStatus init(String host, int port, Properties props) throws ConfigException, ConnectionException {
        return this.init(host, port, props, null);
    }

    @Override
    public ServerStatus init(String host, int port, Properties props, UsageOptions opts) throws ConfigException, ConnectionException {
        return this.init(host, port, props, opts, false);
    }

    @Override
    public ServerStatus init(String host, int port, Properties props, UsageOptions opts, boolean secure) throws ConfigException, ConnectionException {
        this.serverHost = host;
        this.serverPort = port;
        this.secure = secure;
        this.props = props != null ? props : new Properties();
        this.usageOptions = opts == null ? new UsageOptions(this.props) : opts;
        this.tmpDirName = RpcPropertyDefs.getProperty(this.props, "com.perforce.p4java.tmpDir", System.getProperty("java.io.tmpdir"));
        if (this.tmpDirName == null) {
            this.tmpDirName = "/tmp";
            Log.warn("Unable to get tmp name from P4 props or System; using " + this.tmpDirName + " instead");
        }
        Log.info("Using program name: '" + this.getUsageOptions().getProgramName() + "'; program version: '" + this.getUsageOptions().getProgramVersion() + "'");
        Log.info("Using tmp file directory: " + this.tmpDirName);
        this.setUserName(this.props.getProperty("userName", this.props.getProperty("com.perforce.p4java.userName", null)));
        this.password = this.props.getProperty("password", this.props.getProperty("com.perforce.p4java.password", null));
        this.clientName = this.props.getProperty("clientName", this.props.getProperty("com.perforce.p4java.clientName", null));
        this.setupOnConnect = this.props.getProperty("autoConnect", this.props.getProperty("com.perforce.p4java.autoConnect", null)) != null;
        this.loginOnConnect = this.props.getProperty("autoLogin", this.props.getProperty("com.perforce.p4java.autoLogin", null)) != null;
        this.nonCheckedSyncs = this.props.getProperty("nonCheckedSync", this.props.getProperty("com.perforce.p4java.nonCheckedSync", null)) != null;
        this.enableTracking = this.props.getProperty("enableTracking", this.props.getProperty("com.perforce.p4java.enableTracking", null)) != null;
        this.enableProgress = this.props.getProperty("enableProgress", this.props.getProperty("com.perforce.p4java.enableProgress", null)) != null;
        this.quietMode = this.props.getProperty("quietMode", this.props.getProperty("com.perforce.p4java.quietMode", null)) != null;
        this.useAuthMemoryStore = this.props.getProperty("useAuthMemoryStore", this.props.getProperty("com.perforce.p4java.useAuthMemoryStore", null)) != null;
        this.ignoreFileName = this.props.getProperty("ignoreFileName", this.props.getProperty("com.perforce.p4java.ignoreFileName", System.getenv(P4IGNORE_ENV_VAR) != null ? System.getenv(P4IGNORE_ENV_VAR) : null));
        return this.status;
    }

    @Override
    public void connect() throws ConnectionException, AccessException, RequestException, ConfigException {
        this.connected = true;
        this.status = ServerStatus.READY;
        Log.info("connected to Perforce server at " + this.serverHost + ":" + this.serverPort);
        int serverVersion = this.getServerVersion();
        if (serverVersion == -1) {
            throw new ConnectionException("Unable to determine Perforce server version for connection; check network connection, connection character set setting, and / or server status");
        }
        if (serverVersion < this.minumumSupportedServerVersion) {
            throw new ConnectionException("Attempted to connect to an unsupported Perforce server version; target server version: " + serverVersion + "; minimum supported version: " + this.minumumSupportedServerVersion);
        }
        if (this.loginOnConnect && this.userName != null && this.password != null) {
            this.login(this.password);
        }
        if (this.setupOnConnect && this.clientName != null) {
            this.client = this.getClient(this.clientName);
        }
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public void disconnect() throws ConnectionException, AccessException {
        this.connected = false;
        this.status = ServerStatus.DISCONNECTED;
        Log.info("disconnected from Perforce server at " + this.serverHost + ":" + this.serverPort);
    }

    @Override
    public void setUserName(String userName) {
        this.userName = userName;
        this.setAuthTicket(this.getAuthTicket(userName));
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public void setAuthTicket(String authTicket) {
        if (this.userName != null) {
            this.setAuthTicket(this.userName, authTicket);
        }
    }

    @Override
    public String getAuthTicket() {
        return this.getAuthTicket(this.userName);
    }

    @Override
    public IServerInfo getServerInfo() throws ConnectionException, RequestException, AccessException {
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.INFO, new String[0], null);
        if (resultMaps != null) {
            return new ServerInfo(resultMaps.toArray(new HashMap[resultMaps.size()]));
        }
        return new ServerInfo();
    }

    @Override
    public void login(String password) throws ConnectionException, RequestException, AccessException, ConfigException {
        this.login(password, false);
    }

    @Override
    public void login(String password, boolean allHosts) throws ConnectionException, RequestException, AccessException, ConfigException {
        try {
            this.login(password, new LoginOptions().setAllHosts(allHosts));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public String getLoginStatus() throws P4JavaException {
        String statusStr = null;
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.LOGIN, new String[]{"-s"}, null);
        if (resultMaps != null && resultMaps.size() > 0 && (statusStr = this.getInfoStr(resultMaps.get(0))) == null) {
            statusStr = this.getErrorStr(resultMaps.get(0));
        }
        return statusStr == null ? "" : statusStr;
    }

    @Override
    public void login(String password, LoginOptions opts) throws P4JavaException {
        this.login(password, null, opts);
    }

    @Override
    public void login(String password, StringBuffer ticket, LoginOptions opts) throws P4JavaException {
        if (password != null) {
            password = password + "\n";
        }
        if (opts == null) {
            opts = new LoginOptions();
        }
        HashMap<String, Object> pwdMap = new HashMap<String, Object>();
        pwdMap.put("password", password);
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.LOGIN, Parameters.processParameters(opts, this), pwdMap);
        String retVal = null;
        if (resultMaps != null && resultMaps.size() > 0 && resultMaps.get(0) != null) {
            this.handleErrorStr(resultMaps.get(0));
            if (this.isInfoMessage(resultMaps.get(0))) {
                retVal = this.getInfoStr(resultMaps.get(0));
            }
        }
        if (password != null && password.length() > 0 && retVal != null && this.isLoginNotRequired(retVal)) {
            throw new AccessException(retVal);
        }
        if (ticket != null && this.getAuthTicket() != null) {
            ticket.append(this.getAuthTicket());
        }
    }

    @Override
    public void login(IUser user, StringBuffer ticket, LoginOptions opts) throws P4JavaException {
        if (user == null) {
            throw new NullPointerError("null user passed to IOptionsServer.login method");
        }
        if (user.getLoginName() == null) {
            throw new NullPointerError("null user.getLoginName() passed to IOptionsServer.login method");
        }
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.LOGIN, Parameters.processParameters((Options)opts, null, user.getLoginName(), (IServer)this), null);
        if (resultMaps != null && resultMaps.size() > 0 && resultMaps.get(0) != null) {
            this.handleErrorStr(resultMaps.get(0));
        }
        if (ticket != null && this.getAuthTicket(user.getLoginName()) != null) {
            ticket.append(this.getAuthTicket(user.getLoginName()));
        }
    }

    @Override
    public void logout() throws ConnectionException, RequestException, AccessException, ConfigException {
        try {
            this.logout(new LoginOptions());
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public void logout(LoginOptions opts) throws P4JavaException {
        if (this.getAuthTicket() == null) {
            return;
        }
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.LOGOUT, new String[0], null);
        this.setAuthTicket(null);
    }

    @Override
    public String changePassword(String oldPassword, String newPassword, String userName) throws P4JavaException {
        if (oldPassword != null) {
            oldPassword = oldPassword + "\n";
        }
        newPassword = newPassword == null ? "\n" : newPassword + "\n";
        HashMap<String, Object> pwdMap = new HashMap<String, Object>();
        pwdMap.put("oldPassword", oldPassword);
        pwdMap.put("newPassword", newPassword);
        pwdMap.put("newPassword2", newPassword);
        ArrayList<String> args = new ArrayList<String>();
        if (userName != null && userName.trim().length() > 0) {
            args.add(userName);
        }
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.PASSWD, args.toArray(new String[args.size()]), pwdMap);
        String retVal = null;
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                this.handleErrorStr(map);
                if (!this.isInfoMessage(map)) continue;
                if (retVal == null) {
                    retVal = this.getInfoStr(map);
                    continue;
                }
                retVal = retVal + " \n" + this.getInfoStr(map);
            }
        }
        return retVal;
    }

    @Override
    public List<IClientSummary> getClients(String userName, String queryString, int maxResults) throws ConnectionException, RequestException, AccessException {
        if (userName != null && this.getServerVersion() < 20062) {
            throw new RequestException("user restrictions for client lists are not supported by this version of the Perforce server", 37, 3);
        }
        if (queryString != null && this.getServerVersion() < 20081) {
            throw new RequestException("query expressions for client lists are not supported by this version of the Perforce server", 37, 3);
        }
        if (maxResults > 0 && this.getServerVersion() < 20061) {
            throw new RequestException("user restrictions for client lists are not supported by this version of the Perforce server", 37, 3);
        }
        try {
            return this.getClients(new GetClientsOptions().setMaxResults(maxResults).setUserName(userName).setNameFilter(queryString));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public List<IClientSummary> getClients(GetClientsOptions opts) throws P4JavaException {
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.CLIENTS, Parameters.processParameters(opts, this), null);
        if (resultMaps == null) {
            throw new P4JavaError("Null resultMaps in getClientList call");
        }
        ArrayList<IClientSummary> specList = new ArrayList<IClientSummary>();
        for (Map<String, Object> map : resultMaps) {
            String errStr = this.getErrorStr(map);
            if (errStr != null) {
                throw new RequestException(errStr, (String)map.get("code0"));
            }
            specList.add(new ClientSummary(map, true));
        }
        return specList;
    }

    @Override
    public List<ILabelSummary> getLabels(String user, int maxLabels, String nameFilter, List<IFileSpec> fileList) throws ConnectionException, RequestException, AccessException {
        if (user != null && this.getServerVersion() < 20062) {
            throw new RequestException("user restrictions for label lists are not supported by this version of the Perforce server", 37, 3);
        }
        if (maxLabels > 0 && this.getServerVersion() < 20061) {
            throw new RequestException("max limit for label lists are not supported by this version of the Perforce server", 37, 3);
        }
        if (nameFilter != null && this.getServerVersion() < 20081) {
            throw new RequestException("query expressions for label lists are not supported by this version of the Perforce server", 37, 3);
        }
        try {
            return this.getLabels(fileList, new GetLabelsOptions().setMaxResults(maxLabels).setUserName(user).setNameFilter(nameFilter));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public List<ILabelSummary> getLabels(List<IFileSpec> fileList, GetLabelsOptions opts) throws P4JavaException {
        ArrayList<ILabelSummary> labelList = new ArrayList<ILabelSummary>();
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.LABELS, Parameters.processParameters(opts, fileList, this), null);
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                if (map == null || this.handleErrorStr(map)) continue;
                labelList.add(new LabelSummary(map));
            }
        }
        return labelList;
    }

    @Override
    public ILabel getLabel(String labelName) throws ConnectionException, RequestException, AccessException {
        if (labelName == null) {
            throw new NullPointerError("Null label name passed to ServerImpl.labelName");
        }
        String OFLAG = "-o";
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.LABEL, new String[]{"-o", labelName}, null);
        Label label = null;
        if (resultMaps == null) {
            Log.warn("Unexpected null map array returned to ServerImpl.getLabel()");
        } else {
            for (Map<String, Object> map : resultMaps) {
                if (map == null) continue;
                this.handleErrorStr(map);
                if (this.isInfoMessage(map) || !map.containsKey("Update") && !map.containsKey("Access")) continue;
                label = new Label(map, this);
            }
        }
        return label;
    }

    @Override
    public String createLabel(ILabel label) throws ConnectionException, RequestException, AccessException {
        if (label == null) {
            throw new NullPointerError("null label passed to ServerImpl.newLabel()");
        }
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.LABEL, new String[]{"-i"}, InputMapper.map(label));
        String retStr = null;
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                this.handleErrorStr(map);
                if (!this.isInfoMessage(map)) continue;
                if (retStr == null) {
                    retStr = this.getInfoStr(map);
                    continue;
                }
                retStr = retStr + "\n" + this.getInfoStr(map);
            }
        } else {
            Log.warn("null return map array in ServerImpl.newLabel");
        }
        return retStr;
    }

    @Override
    public String deleteLabel(String labelName, boolean force) throws ConnectionException, RequestException, AccessException {
        try {
            return this.deleteLabel(labelName, new DeleteLabelOptions().setForce(force));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public String deleteLabel(String labelName, DeleteLabelOptions opts) throws P4JavaException {
        if (labelName == null) {
            throw new NullPointerError("null label name passed to Server.deleteLabel()");
        }
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.LABEL, Parameters.processParameters((Options)opts, null, new String[]{"-d", labelName}, (IServer)this), null);
        String retStr = null;
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                this.handleErrorStr(map);
                if (!this.isInfoMessage(map)) continue;
                if (retStr == null) {
                    retStr = this.getInfoStr(map);
                    continue;
                }
                retStr = retStr + "\n" + this.getInfoStr(map);
            }
        } else {
            Log.warn("null return map array in Server.deleteLabel");
        }
        return retStr;
    }

    @Override
    public String updateLabel(ILabel label) throws ConnectionException, RequestException, AccessException {
        if (label == null) {
            throw new NullPointerError("null label passed to ServerImpl.updateLabel()");
        }
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.LABEL, new String[]{"-i"}, InputMapper.map(label));
        String retVal = null;
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                this.handleErrorStr(map);
                if (retVal == null) {
                    retVal = this.getInfoStr(map);
                    continue;
                }
                retVal = retVal + "\n" + this.getInfoStr(map);
            }
        } else {
            Log.warn("null return map array in ServerImpl.updateLabel");
        }
        return retVal;
    }

    @Override
    public List<IFileSpec> getDepotFiles(List<IFileSpec> fileSpecs, boolean allRevs) throws ConnectionException, AccessException {
        try {
            return this.getDepotFiles(fileSpecs, new GetDepotFilesOptions().setAllRevs(allRevs));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            Log.warn("Unexpected exception in IServer.getDepotFiles: " + exc);
            return new ArrayList<IFileSpec>();
        }
    }

    @Override
    public List<IFileSpec> getDepotFiles(List<IFileSpec> fileSpecs, GetDepotFilesOptions opts) throws P4JavaException {
        if (fileSpecs == null) {
            throw new NullPointerError("Null file specification list passed to getDepotFiles");
        }
        ArrayList<IFileSpec> fileList = new ArrayList<IFileSpec>();
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.FILES, Parameters.processParameters(opts, fileSpecs, this), null);
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                fileList.add(this.handleFileReturn(map));
            }
        }
        return fileList;
    }

    @Override
    public List<IFileAnnotation> getFileAnnotations(List<IFileSpec> fileSpecs, DiffType wsOpts, boolean allResults, boolean useChangeNumbers, boolean followBranches) throws ConnectionException, RequestException, AccessException {
        if (wsOpts != null && !wsOpts.isWsOption()) {
            throw new RequestException("Bad whitespace option in getFileAnnotations");
        }
        try {
            return this.getFileAnnotations(fileSpecs, new GetFileAnnotationsOptions().setAllResults(allResults).setUseChangeNumbers(useChangeNumbers).setFollowBranches(followBranches).setWsOpts(wsOpts));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public List<IFileAnnotation> getFileAnnotations(List<IFileSpec> fileSpecs, GetFileAnnotationsOptions opts) throws P4JavaException {
        ArrayList<IFileAnnotation> returnList = new ArrayList<IFileAnnotation>();
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.ANNOTATE, Parameters.processParameters(opts, fileSpecs, this), null);
        if (resultMaps != null) {
            String depotFile = null;
            for (Map<String, Object> map : resultMaps) {
                FileAnnotation dataAnnotation = null;
                if (map == null) continue;
                String errStr = this.getErrorStr(map);
                if (errStr != null) {
                    throw new RequestException(errStr, (String)map.get("code0"));
                }
                if (map.containsKey("depotFile")) {
                    depotFile = (String)map.get("depotFile");
                    continue;
                }
                dataAnnotation = new FileAnnotation(map, depotFile, this.client == null ? null : this.client.getLineEnd());
                returnList.add(dataAnnotation);
                int order = 0;
                while (map.containsKey("depotFile" + order)) {
                    try {
                        dataAnnotation.addIntegrationAnnotation(new FileAnnotation(order, (String)map.get("depotFile" + order), new Integer((String)map.get("upper" + order)), new Integer((String)map.get("lower" + order))));
                    }
                    catch (Throwable thr) {
                        Log.error("bad conversion in getFileAnnotations");
                        Log.exception(thr);
                    }
                    ++order;
                }
            }
        }
        return returnList;
    }

    @Override
    public List<IFileSpec> tagFiles(List<IFileSpec> fileSpecs, String labelName, boolean listOnly, boolean delete) throws ConnectionException, RequestException, AccessException {
        try {
            return this.tagFiles(fileSpecs, labelName, new TagFilesOptions().setDelete(delete).setListOnly(listOnly));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            Log.warn("Unexpected exception in IServer.getDepotFiles: " + exc);
            return new ArrayList<IFileSpec>();
        }
    }

    @Override
    public List<IFileSpec> tagFiles(List<IFileSpec> fileSpecs, String labelName, TagFilesOptions opts) throws P4JavaException {
        String labelOpt = labelName == null ? null : "-l" + labelName;
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.TAG, Parameters.processParameters((Options)opts, fileSpecs, labelOpt, (IServer)this), null);
        ArrayList<IFileSpec> fileList = new ArrayList<IFileSpec>();
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                fileList.add(this.handleFileReturn(map));
            }
        } else {
            Log.warn("null return map array in ServerImpl.tagFiles");
        }
        return fileList;
    }

    @Override
    public List<IUserSummary> getReviews(int changelistId, List<IFileSpec> fileSpecs) throws ConnectionException, RequestException, AccessException {
        try {
            return this.getReviews(fileSpecs, new GetReviewsOptions(changelistId));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public List<IUserSummary> getReviews(List<IFileSpec> fileSpecs, GetReviewsOptions opts) throws P4JavaException {
        ArrayList<IUserSummary> userList = new ArrayList<IUserSummary>();
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.REVIEWS, Parameters.processParameters(opts, fileSpecs, this), null);
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                this.handleErrorStr(map);
                try {
                    userList.add(new UserSummary((String)map.get("user"), (String)map.get("email"), (String)map.get("name"), null, null));
                }
                catch (Throwable thr) {
                    Log.error("Unexpected exception in getReviews: " + thr.getLocalizedMessage());
                    Log.exception(thr);
                }
            }
        }
        return userList;
    }

    @Override
    public List<IReviewChangelist> getReviewChangelists(GetReviewChangelistsOptions opts) throws P4JavaException {
        ArrayList<IReviewChangelist> reviewList = new ArrayList<IReviewChangelist>();
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.REVIEW, Parameters.processParameters(opts, this), null);
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                this.handleErrorStr(map);
                try {
                    reviewList.add(new ReviewChangelist(new Integer((String)map.get("change")), (String)map.get("user"), (String)map.get("email"), (String)map.get("name")));
                }
                catch (Throwable thr) {
                    Log.error("Unexpected exception in getReviews: " + thr.getLocalizedMessage());
                    Log.exception(thr);
                }
            }
        }
        return reviewList;
    }

    @Override
    public List<IFileSpec> moveFile(int changeListId, boolean listOnly, boolean noClientMove, String fileType, IFileSpec fromFile, IFileSpec toFile) throws ConnectionException, RequestException, AccessException {
        int MIN_SUPPORTED_SERVER = 20091;
        int MIN_SUPPORTED_SERVER_OPTION_K = 20092;
        if (this.serverVersion < 20091) {
            throw new RequestException("command requires a Perforce server version 2009.1 or later");
        }
        if (this.serverVersion < 20092 && noClientMove) {
            throw new RequestException("command option noClientMove requires a Perforce server version 2009.2 or later");
        }
        try {
            return this.moveFile(fromFile, toFile, new MoveFileOptions().setChangelistId(changeListId).setFileType(fileType).setForce(false).setListOnly(listOnly).setNoClientMove(noClientMove));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            Log.warn("Unexpected exception in IServer.moveFile: " + exc);
            return new ArrayList<IFileSpec>();
        }
    }

    @Override
    public List<IFileSpec> moveFile(IFileSpec fromFile, IFileSpec toFile, MoveFileOptions opts) throws P4JavaException {
        if (fromFile == null || toFile == null) {
            throw new RequestException("command requires both to and from files to be specified");
        }
        ArrayList<IFileSpec> fileList = new ArrayList<IFileSpec>();
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.MOVE, Parameters.processParameters((Options)opts, null, new String[]{fromFile.getPreferredPath().toString(), toFile.getPreferredPath().toString()}, (IServer)this), null);
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                fileList.add(this.handleFileReturn(map));
            }
        }
        return fileList;
    }

    @Override
    public IUser getUser(String userName) throws ConnectionException, RequestException, AccessException {
        String[] args = null;
        args = userName == null ? new String[]{"-o"} : new String[]{"-o", userName};
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.USER, args, null);
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                this.handleErrorStr(map);
                if (this.isInfoMessage(map) || !map.containsKey("Update") && !map.containsKey("Access")) continue;
                return new User(map, this);
            }
        }
        return null;
    }

    @Override
    public String createUser(IUser user, boolean force) throws ConnectionException, RequestException, AccessException {
        if (user == null) {
            throw new NullPointerError("Null user passed to IServer.createUser");
        }
        return this.updateUser(user, force);
    }

    @Override
    public String createUser(IUser user, UpdateUserOptions opts) throws P4JavaException {
        return this.updateUser(user, opts);
    }

    @Override
    public String updateUser(IUser user, boolean force) throws ConnectionException, RequestException, AccessException {
        try {
            return this.updateUser(user, new UpdateUserOptions(force));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public String updateUser(IUser user, UpdateUserOptions opts) throws P4JavaException {
        if (user == null) {
            throw new NullPointerError("Null user passed to IServer.updateUser");
        }
        if (user.getLoginName() == null) {
            throw new NullPointerError("Null user name in user passed to IServer.updateUser");
        }
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.USER, Parameters.processParameters((Options)opts, null, "-i", (IServer)this), InputMapper.map(user));
        String retVal = null;
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                this.handleErrorStr(map);
                if (retVal == null) {
                    retVal = this.getInfoStr(map);
                    continue;
                }
                retVal = retVal + "\n" + this.getInfoStr(map);
            }
        } else {
            Log.warn("null return map array in Server.updateUser");
        }
        return retVal;
    }

    @Override
    public String deleteUser(String userName, boolean force) throws ConnectionException, RequestException, AccessException {
        try {
            return this.deleteUser(userName, new UpdateUserOptions(force));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public String deleteUser(String userName, UpdateUserOptions opts) throws P4JavaException {
        if (userName == null) {
            throw new NullPointerError("Null user name passed to IServer.deleteUser");
        }
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.USER, Parameters.processParameters((Options)opts, null, new String[]{"-d", userName}, (IServer)this), null);
        String retStr = null;
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                this.handleErrorStr(map);
                if (!this.isInfoMessage(map)) continue;
                if (retStr == null) {
                    retStr = this.getInfoStr(map);
                    continue;
                }
                retStr = retStr + "\n" + this.getInfoStr(map);
            }
        } else {
            Log.warn("null return map array in Server.deleteUser");
        }
        return retStr;
    }

    @Override
    public List<IUserSummary> getUsers(List<String> userList, int maxUsers) throws ConnectionException, RequestException, AccessException {
        try {
            return this.getUsers(userList, new GetUsersOptions().setMaxUsers(maxUsers));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public List<IUserSummary> getUsers(List<String> userList, GetUsersOptions opts) throws P4JavaException {
        List<Map<String, Object>> resultMaps;
        ArrayList<IUserSummary> resultsList = new ArrayList<IUserSummary>();
        String[] users = null;
        if (userList != null) {
            users = userList.toArray(new String[userList.size()]);
        }
        if ((resultMaps = this.execMapCmdList(CmdSpec.USERS, Parameters.processParameters((Options)opts, null, users, (IServer)this), null)) != null) {
            for (Map<String, Object> map : resultMaps) {
                this.handleErrorStr(map);
                resultsList.add(new UserSummary(map, true));
            }
        }
        return resultsList;
    }

    @Override
    public List<IUserGroup> getUserGroups(String userOrGroupName, boolean indirect, boolean displayValues, int maxGroups) throws ConnectionException, RequestException, AccessException {
        try {
            return this.getUserGroups(userOrGroupName, new GetUserGroupsOptions().setIndirect(indirect).setDisplayValues(displayValues).setMaxGroups(maxGroups));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public List<IUserGroup> getUserGroups(String userOrGroupName, GetUserGroupsOptions opts) throws P4JavaException {
        ArrayList<IUserGroup> resultsList = new ArrayList<IUserGroup>();
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.GROUPS, Parameters.processParameters((Options)opts, null, userOrGroupName, (IServer)this), null);
        if (resultMaps != null) {
            UserGroup ugImpl = null;
            ArrayList<String> userList = null;
            ArrayList<String> subgroupList = null;
            for (Map<String, Object> map : resultMaps) {
                this.handleErrorStr(map);
                String groupName = (String)map.get("group");
                if (groupName == null) continue;
                if (ugImpl == null) {
                    ugImpl = new UserGroup();
                    userList = new ArrayList<String>();
                    ugImpl.setUsers(userList);
                    subgroupList = new ArrayList<String>();
                    ugImpl.setSubgroups(subgroupList);
                    ugImpl.setName(groupName);
                } else if (!ugImpl.getName().equals(groupName)) {
                    resultsList.add(ugImpl);
                    ugImpl = new UserGroup();
                    ugImpl.setName(groupName);
                    userList = new ArrayList();
                    ugImpl.setUsers(userList);
                    ugImpl.setSubgroups(subgroupList);
                }
                try {
                    String isSubGroup;
                    String userName = (String)map.get("user");
                    String maxScanRows = (String)map.get("maxScanRows");
                    String maxLockTime = (String)map.get("maxLockTime");
                    String timeout = (String)map.get("timeout");
                    String passwordTimeout = (String)map.get("passTimeout");
                    String maxResults = (String)map.get("maxResults");
                    String isOwner = (String)map.get("isOwner");
                    if (isOwner != null && isOwner.equalsIgnoreCase("1") && ugImpl.getOwners() == null) {
                        ugImpl.setOwners(new ArrayList<String>());
                        ugImpl.getOwners().add(userName);
                    }
                    if ((isSubGroup = (String)map.get("isSubGroup")) != null && isSubGroup.equals("1")) {
                        subgroupList.add(userName);
                    } else {
                        userList.add(userName);
                    }
                    if (maxScanRows != null) {
                        ugImpl.setMaxScanRows(new Integer(maxScanRows));
                    }
                    if (maxLockTime != null) {
                        ugImpl.setMaxLockTime(new Integer(maxLockTime));
                    }
                    if (timeout != null) {
                        ugImpl.setTimeout(new Integer(timeout));
                    }
                    if (maxResults != null) {
                        ugImpl.setMaxResults(new Integer(maxResults));
                    }
                    if (passwordTimeout == null) continue;
                    ugImpl.setPasswordTimeout(new Integer(passwordTimeout));
                }
                catch (Throwable thr) {
                    Log.warn("Unexpected exception in ServerImpl.getUserGroups: " + thr.getMessage());
                    Log.exception(thr);
                }
            }
            if (ugImpl != null) {
                resultsList.add(ugImpl);
            }
        }
        return resultsList;
    }

    @Override
    public IUserGroup getUserGroup(String name) throws ConnectionException, RequestException, AccessException {
        UserGroup ugImpl;
        block1: {
            Iterator<Map<String, Object>> i$;
            if (name == null) {
                throw new NullPointerError("null group name passed to Server.getUserGroup");
            }
            List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.GROUP, new String[]{"-o", name}, null);
            ugImpl = null;
            if (resultMaps == null || !(i$ = resultMaps.iterator()).hasNext()) break block1;
            Map<String, Object> map = i$.next();
            this.handleErrorStr(map);
            ugImpl = new UserGroup(map);
        }
        return ugImpl;
    }

    @Override
    public String createUserGroup(IUserGroup group) throws ConnectionException, RequestException, AccessException {
        if (group == null) {
            throw new NullPointerError("Null group passed to IServer.createUserGroup method");
        }
        return this.updateUserGroup(group, false);
    }

    @Override
    public String updateUserGroup(IUserGroup group, boolean updateIfOwner) throws ConnectionException, RequestException, AccessException {
        try {
            return this.updateUserGroup(group, new UpdateUserGroupOptions().setUpdateIfOwner(updateIfOwner));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public String deleteUserGroup(IUserGroup group) throws ConnectionException, RequestException, AccessException {
        try {
            return this.deleteUserGroup(group, new UpdateUserGroupOptions());
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public String createUserGroup(IUserGroup group, UpdateUserGroupOptions opts) throws P4JavaException {
        return this.updateUserGroup(group, opts);
    }

    @Override
    public String updateUserGroup(IUserGroup group, UpdateUserGroupOptions opts) throws P4JavaException {
        if (group == null) {
            throw new NullPointerError("Null group passed to IServer.updateUserGroup method");
        }
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.GROUP, Parameters.processParameters((Options)opts, null, "-i", (IServer)this), InputMapper.map(group));
        String retVal = null;
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                this.handleErrorStr(map);
                if (retVal == null) {
                    retVal = this.getInfoStr(map);
                    continue;
                }
                retVal = retVal + "\n" + this.getInfoStr(map);
            }
        } else {
            Log.warn("null return map array in Server.updateUserGroup");
        }
        return retVal;
    }

    @Override
    public String deleteUserGroup(IUserGroup group, UpdateUserGroupOptions opts) throws P4JavaException {
        if (group == null) {
            throw new NullPointerError("Null group passed to IServer.deleteUserGroup method");
        }
        if (group.getName() == null) {
            throw new NullPointerError("Null group name in user group passed to IServer.deleteUserGroup method");
        }
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.GROUP, Parameters.processParameters((Options)opts, null, new String[]{"-d", group.getName()}, (IServer)this), null);
        String retVal = null;
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                this.handleErrorStr(map);
                if (retVal == null) {
                    retVal = this.getInfoStr(map);
                    continue;
                }
                retVal = retVal + "\n" + this.getInfoStr(map);
            }
        } else {
            Log.warn("null return map array in Server.deleteUserGroup");
        }
        return retVal;
    }

    @Override
    public InputStream getProtectionsTable() throws P4JavaException {
        return this.execStreamCmd(CmdSpec.PROTECT, new String[]{"-o"});
    }

    @Override
    public List<IProtectionEntry> getProtectionEntries(boolean allUsers, String hostName, String userName, String groupName, List<IFileSpec> fileList) throws ConnectionException, RequestException, AccessException {
        try {
            return this.getProtectionEntries(fileList, new GetProtectionEntriesOptions().setAllUsers(allUsers).setHostName(hostName).setUserName(userName).setGroupName(groupName));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public List<IProtectionEntry> getProtectionEntries(List<IFileSpec> fileList, GetProtectionEntriesOptions opts) throws P4JavaException {
        ArrayList<IProtectionEntry> protectsList = new ArrayList<IProtectionEntry>();
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.PROTECTS, Parameters.processParameters((Options)opts, fileList, null, false, (IServer)this), null);
        if (resultMaps != null) {
            int order = 0;
            for (Map<String, Object> map : resultMaps) {
                if (map == null) continue;
                this.handleErrorStr(map);
                protectsList.add(new ProtectionEntry(map, order++));
            }
        }
        return protectsList;
    }

    @Override
    public String createProtectionEntries(List<IProtectionEntry> entryList) throws P4JavaException {
        if (entryList == null) {
            throw new NullPointerError("Null new protection entry list in createProtectionEntries method");
        }
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.PROTECT, new String[]{"-i"}, InputMapper.map(entryList));
        String retVal = null;
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                this.handleErrorStr(map);
                if (!this.isInfoMessage(map)) continue;
                if (retVal == null) {
                    retVal = this.getInfoStr(map);
                    continue;
                }
                retVal = retVal + " \n" + this.getInfoStr(map);
            }
        }
        return retVal;
    }

    @Override
    public String updateProtectionEntries(List<IProtectionEntry> entryList) throws P4JavaException {
        if (entryList == null) {
            throw new NullPointerError("Null new protection entry list in updateProtectionEntries method");
        }
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.PROTECT, new String[]{"-i"}, InputMapper.map(entryList));
        String retVal = null;
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                this.handleErrorStr(map);
                if (!this.isInfoMessage(map)) continue;
                if (retVal == null) {
                    retVal = this.getInfoStr(map);
                    continue;
                }
                retVal = retVal + " \n" + this.getInfoStr(map);
            }
        }
        return retVal;
    }

    @Override
    public List<IBranchSpecSummary> getBranchSpecs(String userName, String nameFilter, int maxReturns) throws ConnectionException, RequestException, AccessException {
        if (userName != null && this.getServerVersion() < 20062) {
            throw new RequestException("user restrictions for branch lists are not supported by this version of the Perforce server", 37, 3);
        }
        if (nameFilter != null && this.getServerVersion() < 20081) {
            throw new RequestException("query expressions for branch lists are not supported by this version of the Perforce server", 37, 3);
        }
        if (maxReturns > 0 && this.getServerVersion() < 20061) {
            throw new RequestException("max limit for branch lists are not supported by this version of the Perforce server", 37, 3);
        }
        try {
            return this.getBranchSpecs(new GetBranchSpecsOptions().setMaxResults(maxReturns).setNameFilter(nameFilter).setUserName(userName));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public List<IBranchSpecSummary> getBranchSpecs(GetBranchSpecsOptions opts) throws P4JavaException {
        ArrayList<IBranchSpecSummary> branchList = new ArrayList<IBranchSpecSummary>();
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.BRANCHES, Parameters.processParameters(opts, this), null);
        if (resultMaps != null) {
            for (Map<String, Object> branchMap : resultMaps) {
                this.handleErrorStr(branchMap);
                branchList.add(new BranchSpecSummary(branchMap, true));
            }
        }
        return branchList;
    }

    @Override
    public IBranchSpec getBranchSpec(String name) throws ConnectionException, RequestException, AccessException {
        try {
            return this.getBranchSpec(name, new GetBranchSpecOptions());
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public IBranchSpec getBranchSpec(String name, GetBranchSpecOptions opts) throws P4JavaException {
        if (name == null) {
            throw new NullPointerError("Null branch spec name passed to getBranchSpec");
        }
        BranchSpec branchSpec = null;
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.BRANCH, Parameters.processParameters((Options)opts, null, new String[]{"-o", name}, (IServer)this), null);
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                if (map == null) continue;
                this.handleErrorStr(map);
                if (this.isInfoMessage(map)) continue;
                branchSpec = new BranchSpec(map, this);
            }
        }
        return branchSpec;
    }

    @Override
    public String createBranchSpec(IBranchSpec branchSpec) throws ConnectionException, RequestException, AccessException {
        if (branchSpec == null) {
            throw new NullPointerError("null branch spec passed to ServerImpl.newBranchSpec()");
        }
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.BRANCH, new String[]{"-i"}, InputMapper.map(branchSpec));
        String retStr = null;
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                this.handleErrorStr(map);
                if (!this.isInfoMessage(map)) continue;
                if (retStr == null) {
                    retStr = this.getInfoStr(map);
                    continue;
                }
                retStr = retStr + "\n" + this.getInfoStr(map);
            }
        } else {
            Log.warn("null return map array in ServerImpl.newBranchSpec");
        }
        return retStr;
    }

    @Override
    public String updateBranchSpec(IBranchSpec branchSpec) throws ConnectionException, RequestException, AccessException {
        if (branchSpec == null) {
            throw new NullPointerError("null label passed to ServerImpl.updateBranchSpec()");
        }
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.BRANCH, new String[]{"-i"}, InputMapper.map(branchSpec));
        String retVal = null;
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                this.handleErrorStr(map);
                if (retVal == null) {
                    retVal = this.getInfoStr(map);
                    continue;
                }
                retVal = retVal + "\n" + this.getInfoStr(map);
            }
        } else {
            Log.warn("null return map array in ServerImpl.updateBranchSpec");
        }
        return retVal;
    }

    @Override
    public String deleteBranchSpec(String branchSpecName, boolean force) throws ConnectionException, RequestException, AccessException {
        try {
            return this.deleteBranchSpec(branchSpecName, new DeleteBranchSpecOptions(force));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public String deleteBranchSpec(String branchSpecName, DeleteBranchSpecOptions opts) throws P4JavaException {
        if (branchSpecName == null) {
            throw new NullPointerError("Null branch spec name passed to IServer.deleteBranchSpec method");
        }
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.BRANCH, Parameters.processParameters((Options)opts, null, new String[]{"-d", branchSpecName}, (IServer)this), null);
        String retVal = null;
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                this.handleErrorStr(map);
                if (retVal == null) {
                    retVal = this.getInfoStr(map);
                    continue;
                }
                retVal = retVal + "\n" + this.getInfoStr(map);
            }
        } else {
            Log.warn("null return map array in ServerImpl.deleteBranchSpec");
        }
        return retVal;
    }

    @Override
    public IClient getCurrentClient() {
        return this.client;
    }

    @Override
    public void setCurrentClient(IClient client) {
        this.client = client;
        this.clientName = this.client != null && client != null ? this.client.getName() : null;
    }

    @Override
    public IClient getClient(String clientName) throws ConnectionException, RequestException, AccessException {
        if (clientName == null) {
            throw new NullPointerError("Null client name passed to IServer.getClient()");
        }
        String[] args = new String[]{"-o", clientName};
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.CLIENT, args, null);
        Client client = null;
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                if (map == null) continue;
                this.handleErrorStr(map);
                if (this.isInfoMessage(map) || !map.containsKey("Update") && !map.containsKey("Access")) continue;
                client = new Client(this, map);
            }
        }
        return client;
    }

    @Override
    public IClient getClient(IClientSummary clientSummary) throws ConnectionException, RequestException, AccessException {
        if (clientSummary == null) {
            throw new NullPointerError("Null client summary passed to IServer.getClient()");
        }
        return this.getClient(clientSummary.getName());
    }

    @Override
    public IClient getClientTemplate(String clientName, boolean allowExistent) throws ConnectionException, RequestException, AccessException {
        try {
            return this.getClientTemplate(clientName, new GetClientTemplateOptions(allowExistent));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public IClient getClientTemplate(String clientName, GetClientTemplateOptions opts) throws P4JavaException {
        if (clientName == null) {
            throw new NullPointerError("Null client name passed to IServer.getClientTemplate()");
        }
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.CLIENT, Parameters.processParameters((Options)opts, null, new String[]{"-o", clientName}, (IServer)this), null);
        Client client = null;
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                boolean nonExistent;
                if (map == null) continue;
                this.handleErrorStr(map);
                if (this.isInfoMessage(map)) continue;
                boolean bl = nonExistent = !map.containsKey("Update") && !map.containsKey("Access");
                if (!nonExistent && (opts == null || !opts.isAllowExistent())) continue;
                client = new Client(this, map);
            }
        }
        return client;
    }

    @Override
    public IClient getClientTemplate(String clientName) throws ConnectionException, RequestException, AccessException {
        return this.getClientTemplate(clientName, false);
    }

    @Override
    public String createClient(IClient newClient) throws ConnectionException, RequestException, AccessException {
        if (newClient == null) {
            throw new NullPointerError("Null new client spec in newClient method");
        }
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.CLIENT, new String[]{"-i"}, InputMapper.map(newClient));
        String retVal = null;
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                this.handleErrorStr(map);
                if (!this.isInfoMessage(map)) continue;
                if (retVal == null) {
                    retVal = this.getInfoStr(map);
                    continue;
                }
                retVal = retVal + " \n" + this.getInfoStr(map);
            }
        }
        return retVal;
    }

    @Override
    public String updateClient(IClient client) throws ConnectionException, RequestException, AccessException {
        if (client == null) {
            throw new NullPointerError("Null client in IServer.updateClient method");
        }
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.CLIENT, new String[]{"-i"}, InputMapper.map(client));
        String retVal = null;
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                this.handleErrorStr(map);
                if (!this.isInfoMessage(map)) continue;
                if (retVal == null) {
                    retVal = this.getInfoStr(map);
                    continue;
                }
                retVal = retVal + " \n" + this.getInfoStr(map);
            }
        }
        return retVal;
    }

    @Override
    public String updateClient(IClient client, boolean force) throws ConnectionException, RequestException, AccessException {
        try {
            return this.updateClient(client, new UpdateClientOptions(force));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public String updateClient(IClient client, UpdateClientOptions opts) throws P4JavaException {
        if (client == null) {
            throw new NullPointerError("Null client passed to IOptionsServer.updateClient");
        }
        if (client.getName() == null) {
            throw new NullPointerError("Null client name in client passed to IOptionsServer.updateClient");
        }
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.CLIENT, Parameters.processParameters((Options)opts, null, "-i", (IServer)this), InputMapper.map(client));
        String retVal = null;
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                this.handleErrorStr(map);
                if (retVal == null) {
                    retVal = this.getInfoStr(map);
                    continue;
                }
                retVal = retVal + "\n" + this.getInfoStr(map);
            }
        } else {
            Log.warn("null return map array in Server.updateClient");
        }
        return retVal;
    }

    @Override
    public String deleteClient(String clientName, boolean force) throws ConnectionException, RequestException, AccessException {
        try {
            return this.deleteClient(clientName, new DeleteClientOptions(force));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public String deleteClient(String clientName, DeleteClientOptions opts) throws P4JavaException {
        if (clientName == null) {
            throw new NullPointerError("Null client name passed to ServerImpl.deleteClient");
        }
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.CLIENT, Parameters.processParameters((Options)opts, null, new String[]{"-d", clientName}, (IServer)this), null);
        String retVal = null;
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                this.handleErrorStr(map);
                if (!this.isInfoMessage(map)) continue;
                if (retVal == null) {
                    retVal = this.getInfoStr(map);
                    continue;
                }
                retVal = retVal + " \n" + this.getInfoStr(map);
            }
        }
        return retVal;
    }

    @Override
    public String switchClientView(String templateClientName, String targetClientName, SwitchClientViewOptions opts) throws P4JavaException {
        if (templateClientName == null) {
            throw new NullPointerError("Null template client name passed to ServerImpl.switchClientView");
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add("-s");
        args.add("-t");
        args.add(templateClientName);
        if (targetClientName != null) {
            args.add(targetClientName);
        }
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.CLIENT, Parameters.processParameters((Options)opts, null, args.toArray(new String[args.size()]), (IServer)this), null);
        String retVal = null;
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                this.handleErrorStr(map);
                if (!this.isInfoMessage(map)) continue;
                if (retVal == null) {
                    retVal = this.getInfoStr(map);
                    continue;
                }
                retVal = retVal + " \n" + this.getInfoStr(map);
            }
        }
        return retVal;
    }

    @Override
    public String switchStreamView(String streamPath, String targetClientName, SwitchClientViewOptions opts) throws P4JavaException {
        if (streamPath == null) {
            throw new NullPointerError("Null stream path passed to ServerImpl.switchStreamView");
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add("-s");
        args.add("-S");
        args.add(streamPath);
        if (targetClientName != null) {
            args.add(targetClientName);
        }
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.CLIENT, Parameters.processParameters((Options)opts, null, args.toArray(new String[args.size()]), (IServer)this), null);
        String retVal = null;
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                this.handleErrorStr(map);
                if (!this.isInfoMessage(map)) continue;
                if (retVal == null) {
                    retVal = this.getInfoStr(map);
                    continue;
                }
                retVal = retVal + " \n" + this.getInfoStr(map);
            }
        }
        return retVal;
    }

    @Override
    public List<IDepot> getDepots() throws ConnectionException, RequestException, AccessException {
        ArrayList<IDepot> metadataArray = new ArrayList<IDepot>();
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.DEPOTS, new String[0], null);
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                if (this.handleErrorStr(map)) continue;
                try {
                    metadataArray.add(new Depot(map));
                }
                catch (Exception exc) {
                    Log.exception(exc);
                    throw new P4JavaError("Unexpected conversion error in getDepotList: " + exc.getLocalizedMessage(), exc);
                }
            }
        }
        return metadataArray;
    }

    @Override
    public IDepot getDepot(String name) throws P4JavaException {
        if (name == null) {
            throw new NullPointerError("null depot name to getDepot method");
        }
        Depot depot = null;
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.DEPOT, new String[]{"-o", name}, null);
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                if (map == null) continue;
                this.handleErrorStr(map);
                if (this.isInfoMessage(map)) continue;
                depot = new Depot(map);
            }
        }
        return depot;
    }

    @Override
    public String createDepot(IDepot newDepot) throws P4JavaException {
        if (newDepot == null) {
            throw new NullPointerError("null depot passed to createDepot method");
        }
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.DEPOT, new String[]{"-i"}, InputMapper.map(newDepot));
        String retVal = null;
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                this.handleErrorStr(map);
                if (!this.isInfoMessage(map)) continue;
                if (retVal == null) {
                    retVal = this.getInfoStr(map);
                    continue;
                }
                retVal = retVal + " \n" + this.getInfoStr(map);
            }
        }
        return retVal;
    }

    @Override
    public String deleteDepot(String name) throws P4JavaException {
        if (name == null) {
            throw new NullPointerError("null depot name passed to deletDepot method");
        }
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.DEPOT, new String[]{"-d", name}, null);
        String retVal = null;
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                this.handleErrorStr(map);
                if (!this.isInfoMessage(map)) continue;
                if (retVal == null) {
                    retVal = this.getInfoStr(map);
                    continue;
                }
                retVal = retVal + " \n" + this.getInfoStr(map);
            }
        }
        return retVal;
    }

    @Override
    public List<IChangelistSummary> getChangelists(int maxMostRecent, List<IFileSpec> fileSpecs, String clientName, String userName, boolean includeIntegrated, IChangelist.Type type, boolean longDesc) throws ConnectionException, RequestException, AccessException {
        try {
            return this.getChangelists(fileSpecs, new GetChangelistsOptions().setClientName(clientName).setIncludeIntegrated(includeIntegrated).setLongDesc(longDesc).setMaxMostRecent(maxMostRecent).setType(type).setUserName(userName));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public List<IChangelistSummary> getChangelists(int maxMostRecent, List<IFileSpec> fileSpecs, String clientName, String userName, boolean includeIntegrated, boolean submittedOnly, boolean pendingOnly, boolean longDesc) throws ConnectionException, RequestException, AccessException {
        IChangelist.Type type = null;
        if (submittedOnly) {
            type = IChangelist.Type.SUBMITTED;
        } else if (pendingOnly) {
            type = IChangelist.Type.PENDING;
        }
        return this.getChangelists(maxMostRecent, fileSpecs, clientName, userName, includeIntegrated, type, longDesc);
    }

    @Override
    public List<IChangelistSummary> getChangelists(List<IFileSpec> fileSpecs, GetChangelistsOptions opts) throws P4JavaException {
        ArrayList<IChangelistSummary> changeListList = new ArrayList<IChangelistSummary>();
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.CHANGES, Parameters.processParameters(opts, fileSpecs, this), null);
        if (resultMaps != null) {
            for (Map<String, Object> result : resultMaps) {
                if (this.handleErrorStr(result)) continue;
                try {
                    changeListList.add(new ChangelistSummary(result, true));
                }
                catch (Exception exc) {
                    Log.exception(exc);
                    throw new P4JavaError("Unexpected conversion error in getChangelist: " + exc.getLocalizedMessage(), exc);
                }
            }
        }
        return changeListList;
    }

    @Override
    public IChangelist getChangelist(int id) throws ConnectionException, RequestException, AccessException {
        try {
            return this.getChangelist(id, null);
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public IChangelist getChangelist(int id, ChangelistOptions opts) throws P4JavaException {
        Changelist changeList = null;
        String[] args = null;
        args = id == 0 ? new String[]{"-o"} : new String[]{"-o", "" + id};
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.CHANGE, Parameters.processParameters((Options)opts, null, args, (IServer)this), null);
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                if (map == null) continue;
                this.handleErrorStr(map);
                if (this.isInfoMessage(map)) continue;
                changeList = new Changelist(map, this);
            }
        }
        return changeList;
    }

    @Override
    public String deletePendingChangelist(int id) throws ConnectionException, RequestException, AccessException {
        try {
            return this.deletePendingChangelist(id, null);
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public String deletePendingChangelist(int id, ChangelistOptions opts) throws P4JavaException {
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.CHANGE, Parameters.processParameters((Options)opts, null, new String[]{"-d", "" + id}, (IServer)this), null);
        String retVal = null;
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                this.handleErrorStr(map);
                if (!this.isInfoMessage(map)) continue;
                if (retVal == null) {
                    retVal = this.getInfoStr(map);
                    continue;
                }
                retVal = retVal + " \n" + this.getInfoStr(map);
            }
        }
        return retVal;
    }

    @Override
    public List<IFileSpec> getChangelistFiles(int id) throws ConnectionException, RequestException, AccessException {
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.DESCRIBE, new String[]{"-s", "" + id}, null);
        ArrayList<IFileSpec> fileList = new ArrayList<IFileSpec>();
        if (resultMaps != null && resultMaps.size() > 0 && resultMaps.get(0) != null) {
            Map<String, Object> map = resultMaps.get(0);
            int i = 0;
            while (map.get("rev" + i) != null) {
                FileSpec fSpec = new FileSpec(map, this, i);
                fSpec.setChangelistId(id);
                fileList.add(fSpec);
                ++i;
            }
        }
        return fileList;
    }

    @Override
    public InputStream getChangelistDiffs(int id, DiffType diffType) throws ConnectionException, RequestException, AccessException {
        return this.getChangelistDiffsStream(id, new DescribeOptions(diffType));
    }

    @Override
    public InputStream getChangelistDiffs(int id, GetChangelistDiffsOptions opts) throws P4JavaException {
        return this.execStreamCmd(CmdSpec.DESCRIBE, Parameters.processParameters((Options)opts, null, "" + id, (IServer)this));
    }

    @Override
    public InputStream getChangelistDiffsStream(int id, DescribeOptions options) throws ConnectionException, RequestException, AccessException {
        DiffType diffType = null;
        boolean shelvedDiffs = false;
        if (options != null) {
            diffType = options.getType();
            shelvedDiffs = options.isOutputShelvedDiffs();
        }
        if (shelvedDiffs && this.getServerVersion() < 20092) {
            throw new RequestException("Shelved file diffs are not supported by this version of the Perforce server", 37, 3);
        }
        try {
            GetChangelistDiffsOptions opts = new GetChangelistDiffsOptions();
            opts.setOutputShelvedDiffs(shelvedDiffs);
            if (diffType != null) {
                switch (diffType) {
                    case RCS_DIFF: {
                        opts.setRcsDiffs(true);
                        break;
                    }
                    case CONTEXT_DIFF: {
                        opts.setDiffContext(0);
                        break;
                    }
                    case SUMMARY_DIFF: {
                        opts.setSummaryDiff(true);
                        break;
                    }
                    case UNIFIED_DIFF: {
                        opts.setUnifiedDiff(0);
                        break;
                    }
                    case IGNORE_WS_CHANGES: {
                        opts.setIgnoreWhitespaceChanges(true);
                        break;
                    }
                    case IGNORE_WS: {
                        opts.setIgnoreWhitespace(true);
                        break;
                    }
                    case IGNORE_LINE_ENDINGS: {
                        opts.setIgnoreLineEndings(true);
                    }
                }
            }
            return this.getChangelistDiffs(id, opts);
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public Map<IFileSpec, List<IFileRevisionData>> getRevisionHistory(List<IFileSpec> fileSpecs, int maxRevs, boolean contentHistory, boolean includeInherited, boolean longOutput, boolean truncatedLongOutput) throws ConnectionException, AccessException {
        try {
            return this.getRevisionHistory(fileSpecs, new GetRevisionHistoryOptions().setContentHistory(contentHistory).setIncludeInherited(includeInherited).setLongOutput(longOutput).setTruncatedLongOutput(truncatedLongOutput).setMaxRevs(maxRevs));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            Log.warn("Unexpected exception in IServer.getRevisionHistory: " + exc);
            return new HashMap<IFileSpec, List<IFileRevisionData>>();
        }
    }

    @Override
    public Map<IFileSpec, List<IFileRevisionData>> getRevisionHistory(List<IFileSpec> fileSpecs, GetRevisionHistoryOptions opts) throws P4JavaException {
        HashMap<IFileSpec, List<IFileRevisionData>> revMap = new HashMap<IFileSpec, List<IFileRevisionData>>();
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.FILELOG, Parameters.processParameters(opts, fileSpecs, this), null);
        if (resultMaps != null) {
            for (Map<String, Object> result : resultMaps) {
                String errStr = this.handleFileErrorStr(result);
                if (errStr != null) {
                    FileSpec fSpec = new FileSpec(FileSpecOpStatus.ERROR, errStr, (String)result.get("code0"));
                    String depotPath = (String)result.get("depotFile");
                    fSpec.setDepotPath(depotPath);
                    revMap.put(fSpec, null);
                    continue;
                }
                int revNum = 0;
                ArrayList<FileRevisionData> revList = new ArrayList<FileRevisionData>();
                String depotFilePath = (String)result.get("depotFile");
                FileSpec fSpec = new FileSpec();
                fSpec.setDepotPath(depotFilePath);
                revMap.put(fSpec, revList);
                while (result.get("rev" + revNum) != null) {
                    revList.add(new FileRevisionData(result, revNum));
                    ++revNum;
                }
            }
        }
        return revMap;
    }

    @Override
    public List<IFileSpec> getOpenedFiles(List<IFileSpec> fileSpecs, boolean allClients, String clientName, int maxFiles, int changeListId) throws ConnectionException, AccessException {
        try {
            return this.getOpenedFiles(fileSpecs, new OpenedFilesOptions(allClients, clientName, maxFiles, null, changeListId));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            Log.warn("Unexpected exception in IServer.openedFiles: " + exc);
            return new ArrayList<IFileSpec>();
        }
    }

    @Override
    public List<IFileSpec> getOpenedFiles(List<IFileSpec> fileSpecs, OpenedFilesOptions opts) throws P4JavaException {
        ArrayList<IFileSpec> openedList = new ArrayList<IFileSpec>();
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.OPENED, Parameters.processParameters(opts, fileSpecs, this), null);
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                openedList.add(this.handleFileReturn(map));
            }
        }
        return openedList;
    }

    @Override
    public InputStream getFileContents(List<IFileSpec> fileSpecs, boolean allRevs, boolean noHeaderLine) throws ConnectionException, RequestException, AccessException {
        try {
            return this.getFileContents(fileSpecs, new GetFileContentsOptions(allRevs, noHeaderLine));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public InputStream getFileContents(List<IFileSpec> fileSpecs, GetFileContentsOptions opts) throws P4JavaException {
        boolean annotateFiles = opts == null || !opts.isDontAnnotateFiles();
        return this.execStreamCmd(CmdSpec.PRINT, Parameters.processParameters((Options)opts, fileSpecs, null, annotateFiles, (IServer)this));
    }

    @Override
    public List<IFileSpec> getDirectories(List<IFileSpec> fileSpecs, boolean clientOnly, boolean deletedOnly, boolean haveListOnly) throws ConnectionException, AccessException {
        if (fileSpecs == null) {
            throw new NullPointerError("Null fileSpecs in getDirectories");
        }
        try {
            return this.getDirectories(fileSpecs, new GetDirectoriesOptions().setClientOnly(clientOnly).setDeletedOnly(deletedOnly).setHaveListOnly(haveListOnly));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            Log.warn("Unexpected exception in IServer.getDirectories: " + exc);
            return new ArrayList<IFileSpec>();
        }
    }

    @Override
    public List<IFileSpec> getDirectories(List<IFileSpec> fileSpecs, GetDirectoriesOptions opts) throws P4JavaException {
        HashMap<String, Object> inMap = new HashMap<String, Object>();
        inMap.put(IN_MAP_USE_TAGS_KEY, "no");
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.DIRS, Parameters.processParameters(opts, fileSpecs, this), inMap);
        ArrayList<IFileSpec> specList = new ArrayList<IFileSpec>();
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                if (map == null) continue;
                String errStr = this.handleFileErrorStr(map);
                if (errStr == null) {
                    if (map.get("dirName") != null) {
                        specList.add(new FileSpec((String)map.get("dirName")));
                        continue;
                    }
                    if (map.get("dir") == null) continue;
                    specList.add(new FileSpec((String)map.get("dir")));
                    continue;
                }
                if (this.isInfoMessage(map)) {
                    if (map.get("dirName") != null) {
                        specList.add(new FileSpec((String)map.get("dirName")));
                        continue;
                    }
                    if (map.get("dir") != null) {
                        specList.add(new FileSpec((String)map.get("dir")));
                        continue;
                    }
                    specList.add(new FileSpec(FileSpecOpStatus.INFO, errStr, (String)map.get("code0")));
                    continue;
                }
                specList.add(new FileSpec(FileSpecOpStatus.ERROR, errStr, (String)map.get("code0")));
            }
        }
        return specList;
    }

    @Override
    public List<IFileSpec> getSubmittedIntegrations(List<IFileSpec> fileSpecs, String branchSpec, boolean reverseMappings) throws ConnectionException, RequestException, AccessException {
        try {
            return this.getSubmittedIntegrations(fileSpecs, new GetSubmittedIntegrationsOptions(branchSpec, reverseMappings));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public List<IFileSpec> getSubmittedIntegrations(List<IFileSpec> fileSpecs, GetSubmittedIntegrationsOptions opts) throws P4JavaException {
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.INTEGRATED, Parameters.processParameters(opts, fileSpecs, this), null);
        ArrayList<IFileSpec> integList = new ArrayList<IFileSpec>();
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                integList.add(this.handleIntegrationFileReturn(map, null));
            }
        }
        return integList;
    }

    @Override
    public List<IChangelist> getInterchanges(IFileSpec fromFile, IFileSpec toFile, boolean showFiles, boolean longDesc, int maxChangelistId) throws ConnectionException, RequestException, AccessException {
        try {
            return this.getInterchanges(fromFile, toFile, new GetInterchangesOptions().setShowFiles(showFiles).setLongDesc(longDesc).setMaxChangelistId(maxChangelistId));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public List<IChangelist> getInterchanges(String branchSpecName, List<IFileSpec> fromFileList, List<IFileSpec> toFileList, boolean showFiles, boolean longDesc, int maxChangelistId, boolean reverseMapping, boolean biDirectional) throws ConnectionException, RequestException, AccessException {
        try {
            return this.getInterchanges(branchSpecName, fromFileList, toFileList, new GetInterchangesOptions().setShowFiles(showFiles).setLongDesc(longDesc).setMaxChangelistId(maxChangelistId).setReverseMapping(reverseMapping).setBiDirectional(biDirectional));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public List<IChangelist> getInterchanges(IFileSpec fromFile, IFileSpec toFile, GetInterchangesOptions opts) throws P4JavaException {
        ArrayList<IFileSpec> files = new ArrayList<IFileSpec>();
        files.add(fromFile);
        files.add(toFile);
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.INTERCHANGES, Parameters.processParameters(opts, files, this), null);
        return this.processInterchangeMaps(resultMaps, opts == null ? false : opts.isShowFiles());
    }

    @Override
    public List<IChangelist> getInterchanges(String branchSpecName, List<IFileSpec> fromFileList, List<IFileSpec> toFileList, GetInterchangesOptions opts) throws P4JavaException {
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.INTERCHANGES, Parameters.processParameters((Options)opts, fromFileList, toFileList, branchSpecName, (IServer)this), null);
        return this.processInterchangeMaps(resultMaps, opts == null ? false : opts.isShowFiles());
    }

    @Override
    public List<IExtendedFileSpec> getExtendedFiles(List<IFileSpec> fileSpecs, int maxFiles, int sinceChangelist, int affectedByChangelist, FileStatOutputOptions outputOptions, FileStatAncilliaryOptions ancilliaryOptions) throws ConnectionException, AccessException {
        try {
            return this.getExtendedFiles(fileSpecs, new GetExtendedFilesOptions().setAncilliaryOptions(ancilliaryOptions).setMaxResults(maxFiles).setOutputOptions(outputOptions).setSinceChangelist(sinceChangelist).setAffectedByChangelist(affectedByChangelist));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            Log.warn("Unexpected exception in IServer.getExtendedFiles: " + exc);
            return new ArrayList<IExtendedFileSpec>();
        }
    }

    @Override
    public List<IExtendedFileSpec> getExtendedFiles(List<IFileSpec> fileSpecs, GetExtendedFilesOptions opts) throws P4JavaException {
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.FSTAT, Parameters.processParameters(opts, fileSpecs, this), null);
        ArrayList<IExtendedFileSpec> specList = new ArrayList<IExtendedFileSpec>();
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                String errStr = this.handleFileErrorStr(map);
                ExtendedFileSpec eSpec = null;
                if (errStr == null) {
                    if (map.containsKey("depotFile") && !map.containsKey("desc")) {
                        eSpec = new ExtendedFileSpec(map, this, -1);
                    }
                } else {
                    eSpec = this.isInfoMessage(map) ? new ExtendedFileSpec(FileSpecOpStatus.INFO, errStr) : new ExtendedFileSpec(FileSpecOpStatus.ERROR, errStr);
                }
                if (eSpec == null) continue;
                specList.add(eSpec);
            }
        }
        return specList;
    }

    @Override
    public List<String> searchJobs(String words, SearchJobsOptions opts) throws P4JavaException {
        if (words == null) {
            throw new NullPointerError("Null words passed to searchJobs method");
        }
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.SEARCH, Parameters.processParameters((Options)opts, null, new String[]{words}, (IServer)this), null);
        ArrayList<String> jobIdList = new ArrayList<String>();
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                if (map == null) continue;
                String errStr = this.getErrorStr(map);
                if (errStr != null) {
                    throw new RequestException(errStr, (String)map.get("code0"));
                }
                jobIdList.add(this.getInfoStr(map));
            }
        }
        return jobIdList;
    }

    @Override
    public List<IJob> getJobs(List<IFileSpec> fileSpecs, int maxJobs, boolean longDescriptions, boolean reverseOrder, boolean includeIntegrated, String jobView) throws ConnectionException, RequestException, AccessException {
        try {
            return this.getJobs(fileSpecs, new GetJobsOptions().setIncludeIntegrated(includeIntegrated).setLongDescriptions(longDescriptions).setMaxJobs(maxJobs).setReverseOrder(reverseOrder).setJobView(jobView));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public List<IJob> getJobs(List<IFileSpec> fileSpecs, GetJobsOptions opts) throws P4JavaException {
        ArrayList<IJob> jobList = new ArrayList<IJob>();
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.JOBS, Parameters.processParameters(opts, fileSpecs, this), null);
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                if (map == null) continue;
                String errStr = this.getErrorStr(map);
                if (errStr != null) {
                    throw new RequestException(errStr, (String)map.get("code0"));
                }
                jobList.add(new Job(this, map, opts == null ? false : opts.isLongDescriptions()));
            }
        }
        return jobList;
    }

    @Override
    public IJob getJob(String jobId) throws ConnectionException, RequestException, AccessException {
        if (jobId == null) {
            throw new P4JavaError("Null jobId in server.getJob()");
        }
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.JOB, new String[]{"-o", jobId}, null);
        Job job = null;
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                this.handleErrorStr(map);
                if (this.isInfoMessage(map)) continue;
                job = new Job(this, map);
            }
        }
        return job;
    }

    @Override
    public IJob createJob(Map<String, Object> fieldMap) throws ConnectionException, RequestException, AccessException {
        if (fieldMap == null) {
            throw new NullPointerError("Null field map passed to ServerImpl.createJob");
        }
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.JOB, new String[]{"-i"}, fieldMap);
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                String[] strs;
                this.handleErrorStr(map);
                String infoStr = this.getInfoStr(map);
                if (infoStr == null || !infoStr.contains("Job ") || !infoStr.contains(" saved") || (strs = infoStr.split(" ")).length != 3 || strs[1] == null) continue;
                return this.getJob(strs[1]);
            }
        }
        return null;
    }

    @Override
    public String updateJob(IJob job) throws ConnectionException, RequestException, AccessException {
        if (job == null) {
            throw new NullPointerError("Null job passed to Server.updateJob");
        }
        String retVal = null;
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.JOB, new String[]{"-i"}, job.getRawFields());
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                this.handleErrorStr(map);
                if (!this.isInfoMessage(map)) continue;
                if (retVal == null) {
                    retVal = this.getInfoStr(map);
                    continue;
                }
                retVal = retVal + "\n" + this.getInfoStr(map);
            }
        }
        return retVal;
    }

    @Override
    public String deleteJob(String jobId) throws ConnectionException, RequestException, AccessException {
        if (jobId == null) {
            throw new NullPointerError("Null job ID passed to Server.deleteJob");
        }
        String retVal = null;
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.JOB, new String[]{"-d", jobId}, null);
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                this.handleErrorStr(map);
                if (!this.isInfoMessage(map)) continue;
                if (retVal == null) {
                    retVal = this.getInfoStr(map);
                    continue;
                }
                retVal = retVal + "\n" + this.getInfoStr(map);
            }
        }
        return retVal;
    }

    @Override
    public IJobSpec getJobSpec() throws ConnectionException, RequestException, AccessException {
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.JOBSPEC, new String[]{"-o"}, null);
        JobSpec jobSpec = null;
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                if (map == null) continue;
                this.handleErrorStr(map);
                if (this.isInfoMessage(map)) continue;
                jobSpec = new JobSpec(map, this);
            }
        }
        return jobSpec;
    }

    @Override
    public List<IFix> getFixList(List<IFileSpec> fileSpecs, int changeListId, String jobId, boolean includeIntegrations, int maxFixes) throws ConnectionException, RequestException, AccessException {
        try {
            return this.getFixes(fileSpecs, new GetFixesOptions().setChangelistId(changeListId == 0 ? -1 : changeListId).setIncludeIntegrations(includeIntegrations).setJobId(jobId).setMaxFixes(maxFixes));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public List<IFix> getFixes(List<IFileSpec> fileSpecs, GetFixesOptions opts) throws P4JavaException {
        ArrayList<IFix> fixList = new ArrayList<IFix>();
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.FIXES, Parameters.processParameters(opts, fileSpecs, this), null);
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                if (map == null) continue;
                this.handleErrorStr(map);
                fixList.add(new Fix(map));
            }
        }
        return fixList;
    }

    @Override
    public List<IFix> fixJobs(List<String> jobIdList, int changeListId, String status, boolean delete) throws ConnectionException, RequestException, AccessException {
        try {
            return this.fixJobs(jobIdList, changeListId, new FixJobsOptions().setDelete(delete).setStatus(status));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public List<IFix> fixJobs(List<String> jobIds, int changelistId, FixJobsOptions opts) throws P4JavaException {
        if (jobIds == null) {
            throw new P4JavaError("Null jobIds list in fixJobs");
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add("-c" + (changelistId == 0 ? "default" : Integer.valueOf(changelistId)));
        args.addAll(jobIds);
        ArrayList<IFix> fixList = new ArrayList<IFix>();
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.FIX, Parameters.processParameters((Options)opts, null, args.toArray(new String[args.size()]), (IServer)this), null);
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                String errStr = this.getErrorStr(map);
                if (errStr != null) {
                    throw new RequestException(errStr, (String)map.get("code0"));
                }
                fixList.add(new Fix(map));
            }
        }
        return fixList;
    }

    @Override
    public String getCounter(String counterName) throws ConnectionException, RequestException, AccessException {
        try {
            return this.getCounter(counterName, null);
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public String getCounter(String counterName, CounterOptions opts) throws P4JavaException {
        if (counterName == null) {
            throw new NullPointerError("null counter name passed to getCounter method");
        }
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.COUNTER, Parameters.processParameters((Options)opts, null, new String[]{counterName}, (IServer)this), null);
        String retVal = "";
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                if (map == null || !map.containsKey("value")) continue;
                return (String)map.get("value");
            }
        }
        return retVal;
    }

    @Override
    public void setCounter(String counterName, String value, boolean perforceCounter) throws ConnectionException, RequestException, AccessException {
        if (counterName == null) {
            throw new NullPointerError("null counter name passed to setCounter method");
        }
        if (value == null) {
            throw new NullPointerError("null counter value passed to setCounter method");
        }
        try {
            this.setCounter(counterName, value, new CounterOptions().setPerforceCounter(perforceCounter));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public String setCounter(String counterName, String value, CounterOptions opts) throws P4JavaException {
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.COUNTER, Parameters.processParameters((Options)opts, null, new String[]{counterName, value}, (IServer)this), null);
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                this.handleErrorStr(map);
                if (!map.containsKey("value")) continue;
                return (String)map.get("value");
            }
        }
        return null;
    }

    @Override
    public void deleteCounter(String counterName, boolean perforceCounter) throws ConnectionException, RequestException, AccessException {
        if (counterName == null) {
            throw new NullPointerError("null counter name passed to setCounter method");
        }
        try {
            this.setCounter(counterName, null, new CounterOptions(perforceCounter, true, false));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public Map<String, String> getCounters() throws ConnectionException, RequestException, AccessException {
        try {
            return this.getCounters((GetCountersOptions)null);
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    @Deprecated
    public Map<String, String> getCounters(CounterOptions opts) throws P4JavaException {
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.COUNTERS, Parameters.processParameters(opts, this), null);
        HashMap<String, String> counterMap = new HashMap<String, String>();
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                String errStr = this.getErrorOrInfoStr(map);
                if (errStr != null) {
                    if (this.isAuthFail(errStr)) {
                        throw new AccessException(errStr);
                    }
                    throw new RequestException(errStr, (String)map.get("code0"));
                }
                try {
                    counterMap.put((String)map.get("counter"), (String)map.get("value"));
                }
                catch (Exception exc) {
                    Log.error("getCounter conversion error: " + exc.getLocalizedMessage());
                    Log.exception(exc);
                }
            }
        }
        return counterMap;
    }

    @Override
    public Map<String, String> getCounters(GetCountersOptions opts) throws P4JavaException {
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.COUNTERS, Parameters.processParameters(opts, this), null);
        HashMap<String, String> counterMap = new HashMap<String, String>();
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                String errStr = this.getErrorOrInfoStr(map);
                if (errStr != null) {
                    if (this.isAuthFail(errStr)) {
                        throw new AccessException(errStr);
                    }
                    throw new RequestException(errStr, (String)map.get("code0"));
                }
                try {
                    counterMap.put((String)map.get("counter"), (String)map.get("value"));
                }
                catch (Exception exc) {
                    Log.error("getCounter conversion error: " + exc.getLocalizedMessage());
                    Log.exception(exc);
                }
            }
        }
        return counterMap;
    }

    @Override
    public String getKey(String keyName) throws P4JavaException {
        if (keyName == null) {
            throw new NullPointerError("null counter name passed to getKey method");
        }
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.KEY, new String[]{keyName}, null);
        String retVal = "";
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                if (map == null || !map.containsKey("value")) continue;
                return (String)map.get("value");
            }
        }
        return retVal;
    }

    @Override
    public String setKey(String KeyName, String value, KeyOptions opts) throws P4JavaException {
        if (KeyName == null) {
            throw new NullPointerError("null key name passed to setKey method");
        }
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.KEY, Parameters.processParameters((Options)opts, null, new String[]{KeyName, value}, (IServer)this), null);
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                this.handleErrorStr(map);
                if (!map.containsKey("value")) continue;
                return (String)map.get("value");
            }
        }
        return null;
    }

    @Override
    public String deleteKey(String KeyName) throws P4JavaException {
        if (KeyName == null) {
            throw new NullPointerError("null key name passed to deleteKey method");
        }
        return this.setKey(KeyName, null, new KeyOptions(true, false));
    }

    @Override
    public Map<String, String> getKeys(GetKeysOptions opts) throws P4JavaException {
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.KEYS, Parameters.processParameters(opts, this), null);
        HashMap<String, String> keyMap = new HashMap<String, String>();
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                String errStr = this.getErrorOrInfoStr(map);
                if (errStr != null) {
                    if (this.isAuthFail(errStr)) {
                        throw new AccessException(errStr);
                    }
                    throw new RequestException(errStr, (String)map.get("code0"));
                }
                try {
                    keyMap.put((String)map.get("key"), (String)map.get("value"));
                }
                catch (Exception exc) {
                    Log.error("getKeys conversion error: " + exc.getLocalizedMessage());
                    Log.exception(exc);
                }
            }
        }
        return keyMap;
    }

    @Override
    public List<IProperty> getProperty(GetPropertyOptions opts) throws P4JavaException {
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.PROPERTY, Parameters.processParameters((Options)opts, null, new String[]{"-l"}, (IServer)this), null);
        ArrayList<IProperty> propertyList = new ArrayList<IProperty>();
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                String errStr = this.getErrorOrInfoStr(map);
                if (errStr != null) {
                    if (this.isAuthFail(errStr)) {
                        throw new AccessException(errStr);
                    }
                    throw new RequestException(errStr, (String)map.get("code0"));
                }
                try {
                    propertyList.add(new Property(map));
                }
                catch (Exception exc) {
                    Log.error("getProperty conversion error: " + exc.getLocalizedMessage());
                    Log.exception(exc);
                }
            }
        }
        return propertyList;
    }

    @Override
    public String setProperty(String name, String value, PropertyOptions opts) throws P4JavaException {
        if (name == null && (opts == null || opts.getName() == null)) {
            throw new NullPointerError("null property name passed to setProperty method");
        }
        if (value == null && (opts == null || opts.getValue() == null)) {
            throw new NullPointerError("null property value passed to setProperty method");
        }
        if (opts == null) {
            opts = new PropertyOptions();
        }
        if (name != null) {
            opts.setName(name);
        }
        if (value != null) {
            opts.setValue(value);
        }
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.PROPERTY, Parameters.processParameters((Options)opts, null, new String[]{"-a"}, (IServer)this), null);
        String retVal = null;
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                this.handleErrorStr(map);
                if (retVal == null) {
                    retVal = this.getInfoStr(map);
                    continue;
                }
                retVal = retVal + "\n" + this.getInfoStr(map);
            }
        } else {
            Log.warn("null return map array in ServerImpl.setProperty");
        }
        return retVal;
    }

    @Override
    public String deleteProperty(String name, PropertyOptions opts) throws P4JavaException {
        if (name == null && (opts == null || opts.getName() == null)) {
            throw new NullPointerError("null property name passed to deleteProperty method");
        }
        if (opts == null) {
            opts = new PropertyOptions();
        }
        if (name != null) {
            opts.setName(name);
        }
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.PROPERTY, Parameters.processParameters((Options)opts, null, new String[]{"-d"}, (IServer)this), null);
        String retVal = null;
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                this.handleErrorStr(map);
                if (retVal == null) {
                    retVal = this.getInfoStr(map);
                    continue;
                }
                retVal = retVal + "\n" + this.getInfoStr(map);
            }
        } else {
            Log.warn("null return map array in ServerImpl.deleteProperty");
        }
        return retVal;
    }

    @Override
    public List<IServerProcess> getServerProcesses() throws ConnectionException, RequestException, AccessException {
        try {
            return this.getServerProcesses(null);
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public List<IServerProcess> getServerProcesses(GetServerProcessesOptions opts) throws P4JavaException {
        List<Map<String, Object>> resultMaps;
        ArrayList<IServerProcess> processList = new ArrayList<IServerProcess>();
        ArrayList<String> args = new ArrayList<String>();
        args.add("show");
        String[] options = Parameters.processParameters(opts, this);
        if (options != null) {
            args.addAll(Arrays.asList(options));
        }
        if ((resultMaps = this.execMapCmdList(CmdSpec.MONITOR, args.toArray(new String[args.size()]), null)) != null) {
            for (Map<String, Object> map : resultMaps) {
                String errStr = this.getErrorStr(map);
                if (errStr != null) {
                    throw new RequestException(errStr, (String)map.get("code0"));
                }
                processList.add(new ServerProcess(map));
            }
        }
        return processList;
    }

    @Override
    public InputStream getServerFileDiffs(IFileSpec file1, IFileSpec file2, String branchSpecName, DiffType diffType, boolean quiet, boolean includeNonTextDiffs, boolean gnuDiffs) throws ConnectionException, RequestException, AccessException {
        try {
            GetFileDiffsOptions opts = new GetFileDiffsOptions().setQuiet(quiet).setIncludeNonTextDiffs(includeNonTextDiffs).setGnuDiffs(gnuDiffs);
            if (diffType != null) {
                switch (diffType) {
                    case RCS_DIFF: {
                        opts.setRcsDiffs(true);
                        break;
                    }
                    case CONTEXT_DIFF: {
                        opts.setDiffContext(0);
                        break;
                    }
                    case SUMMARY_DIFF: {
                        opts.setSummaryDiff(true);
                        break;
                    }
                    case UNIFIED_DIFF: {
                        opts.setUnifiedDiff(0);
                        break;
                    }
                    case IGNORE_WS_CHANGES: {
                        opts.setIgnoreWhitespaceChanges(true);
                        break;
                    }
                    case IGNORE_WS: {
                        opts.setIgnoreWhitespace(true);
                        break;
                    }
                    case IGNORE_LINE_ENDINGS: {
                        opts.setIgnoreLineEndings(true);
                    }
                }
            }
            return this.getFileDiffsStream(file1, file2, branchSpecName, opts);
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public List<IFileDiff> getFileDiffs(IFileSpec file1, IFileSpec file2, String branchSpecName, DiffType diffType, boolean quiet, boolean includeNonTextDiffs, boolean gnuDiffs) throws ConnectionException, RequestException, AccessException {
        try {
            GetFileDiffsOptions opts = new GetFileDiffsOptions().setQuiet(quiet).setIncludeNonTextDiffs(includeNonTextDiffs).setGnuDiffs(gnuDiffs);
            if (diffType != null) {
                switch (diffType) {
                    case RCS_DIFF: {
                        opts.setRcsDiffs(true);
                        break;
                    }
                    case CONTEXT_DIFF: {
                        opts.setDiffContext(0);
                        break;
                    }
                    case SUMMARY_DIFF: {
                        opts.setSummaryDiff(true);
                        break;
                    }
                    case UNIFIED_DIFF: {
                        opts.setUnifiedDiff(0);
                        break;
                    }
                    case IGNORE_WS_CHANGES: {
                        opts.setIgnoreWhitespaceChanges(true);
                        break;
                    }
                    case IGNORE_WS: {
                        opts.setIgnoreWhitespace(true);
                        break;
                    }
                    case IGNORE_LINE_ENDINGS: {
                        opts.setIgnoreLineEndings(true);
                    }
                }
            }
            return this.getFileDiffs(file1, file2, branchSpecName, opts);
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public InputStream getFileDiffsStream(IFileSpec file1, IFileSpec file2, String branchSpecName, GetFileDiffsOptions opts) throws P4JavaException {
        return this.execStreamCmd(CmdSpec.DIFF2, Parameters.processParameters((Options)opts, file1, file2, branchSpecName, (IServer)this));
    }

    @Override
    public List<IFileDiff> getFileDiffs(IFileSpec file1, IFileSpec file2, String branchSpecName, GetFileDiffsOptions opts) throws P4JavaException {
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.DIFF2, Parameters.processParameters((Options)opts, file1, file2, branchSpecName, (IServer)this), null);
        ArrayList<IFileDiff> diffs = new ArrayList<IFileDiff>();
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                if (map == null) continue;
                String errStr = this.getErrorStr(map);
                if (errStr != null) {
                    throw new RequestException(errStr, (String)map.get("code0"));
                }
                errStr = this.getErrorOrInfoStr(map);
                if (errStr != null) {
                    Log.info(errStr);
                    continue;
                }
                diffs.add(new FileDiff(map));
            }
        }
        return diffs;
    }

    @Override
    public List<IDbSchema> getDbSchema(List<String> tableSpecs) throws ConnectionException, RequestException, AccessException {
        String[] args = null;
        if (tableSpecs != null) {
            args = new String[tableSpecs.size()];
            int i = 0;
            for (String table : tableSpecs) {
                args[i++] = table;
            }
        }
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.DBSCHEMA, args, null);
        ArrayList<IDbSchema> schemaList = new ArrayList<IDbSchema>();
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                String errStr = this.getErrorStr(map);
                if (errStr != null) {
                    throw new RequestException(errStr, (String)map.get("code0"));
                }
                schemaList.add(new DbSchema(map));
            }
        }
        return schemaList;
    }

    @Override
    public List<Map<String, Object>> getExportRecords(boolean useJournal, long maxRecs, int sourceNum, long offset, boolean format, String journalPrefix, String filter) throws ConnectionException, RequestException, AccessException {
        try {
            return this.getExportRecords(new ExportRecordsOptions().setFormat(format).setFilter(filter).setJournalPrefix(journalPrefix).setMaxRecs(maxRecs).setOffset(offset).setSourceNum(sourceNum).setUseJournal(useJournal));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public List<Map<String, Object>> getExportRecords(ExportRecordsOptions opts) throws P4JavaException {
        HashMap<String, Object> inMap = new HashMap();
        if (opts != null) {
            inMap = opts.processFieldRules();
        }
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.EXPORT, Parameters.processParameters(opts, this), inMap);
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                String errStr = this.getErrorStr(map);
                if (errStr != null) {
                    throw new RequestException(errStr, (String)map.get("code0"));
                }
                if (map.containsKey("func")) {
                    map.remove("func");
                }
                mapList.add(map);
            }
        }
        return mapList;
    }

    @Override
    public void getStreamingExportRecords(ExportRecordsOptions opts, IStreamingCallback callback, int key) throws P4JavaException {
        if (callback == null) {
            throw new NullPointerError("null streaming callback passed to getStreamingExportRecords method");
        }
        HashMap<String, Object> inMap = new HashMap();
        if (opts != null) {
            inMap = opts.processFieldRules();
        }
        this.execStreamingMapCommand(CmdSpec.EXPORT.toString(), Parameters.processParameters(opts, this), inMap, callback, key);
    }

    @Override
    public List<IDiskSpace> getDiskSpace(List<String> filesystems) throws P4JavaException {
        ArrayList<IDiskSpace> diskSpaceList = new ArrayList<IDiskSpace>();
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.DISKSPACE, filesystems == null ? null : filesystems.toArray(new String[filesystems.size()]), null);
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                if (map == null) continue;
                this.handleErrorStr(map);
                diskSpaceList.add(new DiskSpace(map));
            }
        }
        return diskSpaceList;
    }

    @Override
    public List<IFileSpec> setFileAttributes(List<IFileSpec> files, Map<String, String> attributes, SetFileAttributesOptions opts) throws P4JavaException {
        if (attributes == null) {
            throw new NullPointerError("null attributes map passed to setFileAttributes");
        }
        ArrayList<String> args = new ArrayList<String>();
        if (attributes != null) {
            for (String name : attributes.keySet()) {
                args.add("-n" + name);
            }
            for (String name : attributes.keySet()) {
                String value = attributes.get(name);
                if (value == null) continue;
                args.add("-v" + value);
            }
        }
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.ATTRIBUTE, Parameters.processParameters((Options)opts, files, args == null ? null : args.toArray(new String[args.size()]), true, (IServer)this), null);
        ArrayList<IFileSpec> resultList = new ArrayList<IFileSpec>();
        if (resultMaps != null) {
            ArrayList<String> filesSeen = new ArrayList<String>();
            for (Map<String, Object> map : resultMaps) {
                IFileSpec spec = this.handleFileReturn(map);
                if (spec.getOpStatus() == FileSpecOpStatus.VALID) {
                    String file = spec.getAnnotatedPathString(FilePath.PathType.DEPOT);
                    if (file == null || filesSeen.contains(file)) continue;
                    filesSeen.add(file);
                    resultList.add(spec);
                    continue;
                }
                resultList.add(spec);
            }
        }
        return resultList;
    }

    @Override
    public List<IFileSpec> setFileAttributes(List<IFileSpec> files, String attributeName, InputStream inStream, SetFileAttributesOptions opts) throws P4JavaException {
        if (inStream == null) {
            throw new NullPointerError("null input stream passed to setFileAttributes");
        }
        if (attributeName == null) {
            throw new NullPointerError("null attribute name passed to setFileAttributes");
        }
        HashMap<String, Object> inputMap = new HashMap<String, Object>();
        inputMap.put(ATTRIBUTE_STREAM_MAP_KEY, inStream);
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.ATTRIBUTE, Parameters.processParameters((Options)opts, files, new String[]{"-i", "-n" + attributeName}, true, (IServer)this), inputMap);
        ArrayList<IFileSpec> resultList = new ArrayList<IFileSpec>();
        if (resultMaps != null) {
            ArrayList<String> filesSeen = new ArrayList<String>();
            for (Map<String, Object> map : resultMaps) {
                IFileSpec spec = this.handleFileReturn(map);
                if (spec.getOpStatus() == FileSpecOpStatus.VALID) {
                    String file = spec.getAnnotatedPathString(FilePath.PathType.DEPOT);
                    if (file == null || filesSeen.contains(file)) continue;
                    filesSeen.add(file);
                    resultList.add(spec);
                    continue;
                }
                resultList.add(spec);
            }
        }
        return resultList;
    }

    @Override
    public List<ServerConfigurationValue> showServerConfiguration(String serverName, String variableName) throws P4JavaException {
        String SHOW_CMD = "show";
        String[] args = null;
        args = serverName != null ? new String[]{"show", serverName} : (variableName != null ? new String[]{"show", variableName} : new String[]{"show"});
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.CONFIGURE, args, null);
        ArrayList<ServerConfigurationValue> configList = new ArrayList<ServerConfigurationValue>();
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                String errStr = this.getErrorStr(map);
                if (errStr != null) {
                    throw new RequestException(errStr, (String)map.get("code0"));
                }
                configList.add(new ServerConfigurationValue(map));
            }
        }
        return configList;
    }

    @Override
    public String setServerConfigurationValue(String name, String value) throws P4JavaException {
        if (name == null) {
            throw new NullPointerError("null config name passed to setServerConfigurationValue");
        }
        String[] args = null;
        args = value == null ? new String[]{"unset", name} : new String[]{"set", name + "=" + value};
        String retVal = null;
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.CONFIGURE, args, null);
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                if (map == null) continue;
                String str = this.getErrorOrInfoStr(map);
                if (str == null && map.containsKey("Name") && map.containsKey("Action") && map.get("Action") != null) {
                    String action = (String)map.get("Action");
                    if (action.equalsIgnoreCase("set")) {
                        str = "For server '%serverName%', configuration variable '%variableName%' set to '%variableValue%'";
                    } else if (action.equalsIgnoreCase("unset")) {
                        str = "For server '%serverName%', configuration variable '%variableName%' removed.";
                    }
                    str = str.replaceAll("%serverName%", (String)map.get("ServerName"));
                    str = str.replaceAll("%variableName%", (String)map.get("Name"));
                    str = str.replaceAll("%variableValue%", (String)map.get("Value"));
                    str = str + "\n";
                }
                if (str == null) continue;
                retVal = str;
            }
        }
        return retVal;
    }

    @Override
    public List<IFileSize> getFileSizes(List<IFileSpec> fileSpecs, GetFileSizesOptions opts) throws P4JavaException {
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.SIZES, Parameters.processParameters(opts, fileSpecs, this), null);
        ArrayList<IFileSize> fileSizesList = new ArrayList<IFileSize>();
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                String errStr = this.getErrorOrInfoStr(map);
                if (errStr != null) {
                    if (this.isAuthFail(errStr)) {
                        throw new AccessException(errStr);
                    }
                    throw new RequestException(errStr, (String)map.get("code0"));
                }
                try {
                    fileSizesList.add(new FileSize(map));
                }
                catch (Exception exc) {
                    Log.error("getFileSizes conversion error: " + exc.getLocalizedMessage());
                    Log.exception(exc);
                }
            }
        }
        return fileSizesList;
    }

    @Override
    public void journalWait(JournalWaitOptions opts) throws P4JavaException {
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.JOURNALWAIT, Parameters.processParameters(opts, this), null);
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                String errStr = this.getErrorStr(map);
                if (errStr == null) continue;
                throw new RequestException(errStr, (String)map.get("code0"));
            }
        }
    }

    public boolean handleErrorStr(Map<String, Object> map) throws RequestException, AccessException {
        String errStr = this.getErrorStr(map);
        if (errStr != null) {
            if (this.isAuthFail(errStr)) {
                throw new AccessException(errStr);
            }
            throw new RequestException(errStr, (String)map.get("code0"));
        }
        return false;
    }

    public IFileSpec handleFileReturn(Map<String, Object> map) throws AccessException, ConnectionException {
        return this.handleFileReturn(map, this.client);
    }

    public IFileSpec handleFileReturn(Map<String, Object> map, IClient client) throws AccessException, ConnectionException {
        if (map != null) {
            String errStr = this.handleFileErrorStr(map);
            if (errStr == null) {
                return new FileSpec(map, this, -1);
            }
            if (this.isInfoMessage(map)) {
                return new FileSpec(FileSpecOpStatus.INFO, errStr, (String)map.get("code0"));
            }
            return new FileSpec(FileSpecOpStatus.ERROR, errStr, (String)map.get("code0"));
        }
        return null;
    }

    public IFileSpec handleIntegrationFileReturn(Map<String, Object> map, IClient client) throws AccessException, ConnectionException {
        return this.handleIntegrationFileReturn(map, false);
    }

    public IFileSpec handleIntegrationFileReturn(Map<String, Object> map, boolean ignoreInfo) throws AccessException, ConnectionException {
        if (map != null) {
            String errStr = this.handleFileErrorStr(map);
            if (errStr == null) {
                return new FileSpec(map, this, -1);
            }
            if (this.isInfoMessage(map)) {
                if (ignoreInfo) {
                    return new FileSpec(map, this, -1);
                }
                return new FileSpec(FileSpecOpStatus.INFO, errStr, (String)map.get("code0"));
            }
            return new FileSpec(FileSpecOpStatus.ERROR, errStr, (String)map.get("code0"));
        }
        return null;
    }

    public String handleFileErrorStr(Map<String, Object> map) throws ConnectionException, AccessException {
        String errStr = this.getErrorOrInfoStr(map);
        if (errStr != null) {
            if (this.isAuthFail(errStr)) {
                throw new AccessException(errStr);
            }
            return errStr.trim();
        }
        return null;
    }

    public static String guardNull(String str) {
        String nullStr = "<null>";
        return str == null ? "<null>" : str;
    }

    public static String[] getPreferredPathArray(String[] preamble, List<IFileSpec> specList, boolean annotate) {
        String[] pathArray = new String[(preamble == null ? 0 : preamble.length) + (specList == null ? 0 : specList.size())];
        int i = 0;
        if (preamble != null) {
            for (String str : preamble) {
                pathArray[i++] = str;
            }
        }
        if (specList != null) {
            for (IFileSpec fSpec : specList) {
                if (fSpec != null && fSpec.getOpStatus() == FileSpecOpStatus.VALID) {
                    if (annotate) {
                        pathArray[i++] = fSpec.getAnnotatedPreferredPathString();
                        continue;
                    }
                    pathArray[i++] = fSpec.getPreferredPathString();
                    continue;
                }
                pathArray[i++] = null;
            }
        }
        return pathArray;
    }

    public static String[] getPreferredPathArray(String[] preamble, List<IFileSpec> specList) {
        return Server.getPreferredPathArray(preamble, specList, true);
    }

    public static String[] populatePathArray(String[] pathArray, int start, List<IFileSpec> fileSpecList) {
        if (pathArray == null) {
            return null;
        }
        if (fileSpecList == null) {
            return pathArray;
        }
        if (start < 0) {
            throw new P4JavaError("negative start index in populatePathArray: " + start);
        }
        if (start > pathArray.length || pathArray.length < start + fileSpecList.size()) {
            throw new P4JavaError("pathArray too small in populatePathArray");
        }
        int i = start;
        for (IFileSpec fSpec : fileSpecList) {
            pathArray[i] = fSpec != null && fSpec.getOpStatus() == FileSpecOpStatus.VALID ? fSpec.getAnnotatedPreferredPathString() : null;
            ++i;
        }
        return pathArray;
    }

    public Map<String, Object>[] execMapCmd(CmdSpec cmdSpec, String[] cmdArgs, Map<String, Object> inMap) throws ConnectionException, AccessException {
        List<Map<String, Object>> resultMaps = this.execMapCmdList(cmdSpec, cmdArgs, inMap);
        if (resultMaps != null) {
            return resultMaps.toArray(new HashMap[resultMaps.size()]);
        }
        return null;
    }

    public List<Map<String, Object>> execMapCmdList(CmdSpec cmdSpec, String[] cmdArgs, Map<String, Object> inMap) throws ConnectionException, AccessException {
        if (cmdSpec == null) {
            throw new NullPointerError("Null command spec in execMapCmd");
        }
        try {
            return this.execMapCmdList(cmdSpec.toString(), cmdArgs, inMap);
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            return null;
        }
        catch (P4JavaException exc) {
            return null;
        }
    }

    public InputStream execStreamCmd(CmdSpec cmdSpec, String[] cmdArgs) throws ConnectionException, RequestException, AccessException {
        if (cmdSpec == null) {
            throw new NullPointerError("Null command spec in execMapCmd");
        }
        return this.execStreamCmd(cmdSpec.toString(), cmdArgs);
    }

    protected boolean isUnicode() {
        return this.charsetName != null;
    }

    @Override
    public String getErrorStr(Map<String, Object> map) {
        throw new UnimplementedError("called IOptionsServer.getErrorStr(map)");
    }

    @Override
    public String getErrorOrInfoStr(Map<String, Object> map) {
        throw new UnimplementedError("called IOptionsServer.getErrorOrInfoStr(map)");
    }

    @Override
    public String getInfoStr(Map<String, Object> map) {
        throw new UnimplementedError("called IOptionsServer.getInfoStr(map)");
    }

    public abstract boolean isAuthFail(String var1);

    public abstract boolean isLoginNotRequired(String var1);

    public abstract boolean isInfoMessage(Map<String, Object> var1);

    protected abstract int getGenericCode(Map<String, Object> var1);

    protected abstract int getSeverityCode(Map<String, Object> var1);

    @Override
    public abstract Map<String, Object>[] execMapCmd(String var1, String[] var2, Map<String, Object> var3) throws ConnectionException, AccessException, RequestException;

    @Override
    public abstract List<Map<String, Object>> execMapCmdList(String var1, String[] var2, Map<String, Object> var3) throws P4JavaException;

    @Override
    public abstract List<Map<String, Object>> execMapCmdList(String var1, String[] var2, Map<String, Object> var3, IFilterCallback var4) throws P4JavaException;

    @Override
    public abstract Map<String, Object>[] execInputStringMapCmd(String var1, String[] var2, String var3) throws P4JavaException;

    @Override
    public abstract List<Map<String, Object>> execInputStringMapCmdList(String var1, String[] var2, String var3) throws P4JavaException;

    @Override
    public abstract List<Map<String, Object>> execInputStringMapCmdList(String var1, String[] var2, String var3, IFilterCallback var4) throws P4JavaException;

    @Override
    public abstract Map<String, Object>[] execQuietMapCmd(String var1, String[] var2, Map<String, Object> var3) throws ConnectionException, RequestException, AccessException;

    @Override
    public abstract List<Map<String, Object>> execQuietMapCmdList(String var1, String[] var2, Map<String, Object> var3) throws P4JavaException;

    @Override
    public abstract InputStream execStreamCmd(String var1, String[] var2) throws ConnectionException, RequestException, AccessException;

    @Override
    public abstract InputStream execStreamCmd(String var1, String[] var2, Map<String, Object> var3) throws P4JavaException;

    @Override
    public abstract InputStream execInputStringStreamCmd(String var1, String[] var2, String var3) throws P4JavaException;

    @Override
    public abstract InputStream execQuietStreamCmd(String var1, String[] var2) throws ConnectionException, RequestException, AccessException;

    @Override
    public abstract void execStreamingMapCommand(String var1, String[] var2, Map<String, Object> var3, IStreamingCallback var4, int var5) throws P4JavaException;

    @Override
    @Deprecated
    public abstract void execInputStringStreamingMapComd(String var1, String[] var2, String var3, IStreamingCallback var4, int var5) throws P4JavaException;

    @Override
    public abstract void execInputStringStreamingMapCmd(String var1, String[] var2, String var3, IStreamingCallback var4, int var5) throws P4JavaException;

    @Override
    public abstract void setAuthTicket(String var1, String var2);

    @Override
    public abstract String getAuthTicket(String var1);

    @Override
    public abstract void setTicketsFilePath(String var1);

    @Override
    public abstract String getTicketsFilePath();

    @Override
    public abstract void setTrustFilePath(String var1);

    @Override
    public abstract String getTrustFilePath();

    @Override
    public abstract String getTrust() throws P4JavaException;

    @Override
    public abstract String addTrust(TrustOptions var1) throws P4JavaException;

    @Override
    public abstract String addTrust(String var1) throws P4JavaException;

    @Override
    public abstract String removeTrust() throws P4JavaException;

    @Override
    public abstract List<Fingerprint> getTrusts() throws P4JavaException;

    protected boolean isSecure() {
        return this.secure;
    }

    protected void setSecure(boolean secure) {
        this.secure = secure;
    }

    public String getClientName() {
        return this.clientName;
    }

    @Override
    public String getWorkingDirectory() {
        if (this.usageOptions != null) {
            return this.usageOptions.getWorkingDirectory();
        }
        return null;
    }

    @Override
    public void setWorkingDirectory(String dirPath) {
        if (this.usageOptions != null) {
            this.usageOptions.setWorkingDirectory(dirPath);
        }
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    protected int getServerVersion() throws ConnectionException {
        if (this.serverVersion != -1) {
            return this.serverVersion;
        }
        try {
            List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.INFO.toString().toLowerCase(Locale.ENGLISH), new String[0], (Map<String, Object>)null);
            if (resultMaps != null) {
                this.serverInfo = new ServerInfo(resultMaps.toArray(new HashMap[resultMaps.size()]));
                this.serverAddress = this.serverInfo.getServerAddress();
                for (Map<String, Object> map : resultMaps) {
                    if (map.containsKey("serverVersion")) {
                        this.serverVersion = this.parseVersionString((String)map.get("serverVersion"));
                        return this.serverVersion;
                    }
                    String msg = this.getErrorStr(map);
                    if (msg == null || msg.isEmpty()) continue;
                    throw new ConnectionException(msg);
                }
            }
        }
        catch (Exception exc) {
            Log.exception(exc);
            throw new ConnectionException(exc.getLocalizedMessage(), exc);
        }
        return -1;
    }

    protected String getInfoServerAddress() {
        String address;
        block3: {
            address = null;
            try {
                List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.INFO.toString().toLowerCase(Locale.ENGLISH), new String[0], (Map<String, Object>)null);
                if (resultMaps == null) break block3;
                for (Map<String, Object> map : resultMaps) {
                    if (!map.containsKey("serverAddress")) continue;
                    address = map.get("serverAddress").toString();
                    break;
                }
            }
            catch (Exception exc) {
                Log.exception(exc);
            }
        }
        return address;
    }

    protected int parseVersionString(String versionString) {
        String candidate;
        String[] candParts;
        String[] subStrings;
        if (versionString != null && (subStrings = versionString.split("/")).length >= 3 && (candParts = (candidate = subStrings[2]).split("\\.")).length >= 2) {
            try {
                return new Integer(candParts[0] + candParts[1]);
            }
            catch (NumberFormatException nfe) {
                Log.error("Unexpected exception in P4CmdServerImpl.parseVersionString: " + nfe);
            }
        }
        return -1;
    }

    protected int getRandomInt() {
        return Math.abs(this.rand.nextInt());
    }

    public static boolean isRunningOnWindows() {
        return runningOnWindows;
    }

    protected String getP4TicketsOSLocation() {
        String location = null;
        String os = System.getProperty("os.name");
        String home = System.getProperty("user.home");
        if (home != null && os != null) {
            StringBuilder builtLocation = new StringBuilder(home);
            builtLocation.append(File.separatorChar);
            if (os.toLowerCase(Locale.ENGLISH).contains("windows")) {
                builtLocation.append(P4TICKETS_DEFAULT_WINDOWS);
            } else {
                builtLocation.append(P4TICKETS_DEFAULT_OTHER);
            }
            location = builtLocation.toString();
        }
        return location;
    }

    protected String getP4TrustOSLocation() {
        String location = null;
        String os = System.getProperty("os.name");
        String home = System.getProperty("user.home");
        if (home != null && os != null) {
            StringBuilder builtLocation = new StringBuilder(home);
            builtLocation.append(File.separatorChar);
            if (os.toLowerCase(Locale.ENGLISH).contains("windows")) {
                builtLocation.append(P4TRUST_DEFAULT_WINDOWS);
            } else {
                builtLocation.append(P4TRUST_DEFAULT_OTHER);
            }
            location = builtLocation.toString();
        }
        return location;
    }

    protected List<IChangelist> processInterchangeMaps(List<Map<String, Object>> resultMaps, boolean showFiles) throws ConnectionException, AccessException, RequestException {
        ArrayList<IChangelist> interchangeList = new ArrayList<IChangelist>();
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                if (map == null) continue;
                String errStr = this.handleFileErrorStr(map);
                if (errStr != null) {
                    if (this.getGenericCode(map) == 17 || this.getSeverityCode(map) == 2 || errStr.contains("all revision(s) already integrated")) continue;
                    throw new RequestException(errStr, (String)map.get("code0"));
                }
                Changelist changelist = new Changelist(new ChangelistSummary(map, true, (IServer)this), this, false);
                interchangeList.add(changelist);
                if (!showFiles) continue;
                ArrayList<IFileSpec> fileSpecs = new ArrayList<IFileSpec>();
                int i = 0;
                String depotKey = "depotFile";
                while (map.get("depotFile" + i) != null) {
                    FileSpec fileSpec = new FileSpec(map, this, i);
                    fileSpec.setChangelistId(changelist.getId());
                    fileSpecs.add(fileSpec);
                    ++i;
                }
                changelist.setFileSpecs(fileSpecs);
            }
        }
        return interchangeList;
    }

    protected boolean isDontWriteTicket(String cmd, String[] cmdArgs) {
        if (cmd != null && cmd.equalsIgnoreCase(CmdSpec.LOGIN.toString()) && cmdArgs != null) {
            for (String arg : cmdArgs) {
                if (arg == null || !arg.equals("-p")) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public List<IFileLineMatch> getMatchingLines(List<IFileSpec> fileSpecs, String pattern, MatchingLinesOptions options) throws P4JavaException {
        return this.getMatchingLines(fileSpecs, pattern, null, options);
    }

    @Override
    public List<IFileLineMatch> getMatchingLines(List<IFileSpec> fileSpecs, String pattern, List<String> infoLines, MatchingLinesOptions options) throws P4JavaException {
        if (fileSpecs == null) {
            throw new NullPointerError("Null file specification list passed to IOptionsServer.getMatchingLines");
        }
        if (pattern == null) {
            throw new NullPointerError("Null pattern string passed to IOptionsServer.getMatchingLines");
        }
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.GREP, Parameters.processParameters((Options)options, fileSpecs, "-e" + pattern, (IServer)this), null);
        if (resultMaps == null) {
            throw new P4JavaError("Null resultMaps in Server.getMatchingLines call");
        }
        ArrayList<IFileLineMatch> specList = new ArrayList<IFileLineMatch>();
        for (Map<String, Object> map : resultMaps) {
            String message = this.getErrorStr(map);
            if (message != null) {
                throw new RequestException(message, (String)map.get("code0"));
            }
            message = this.getErrorOrInfoStr(map);
            if (message == null) {
                specList.add(new FileLineMatch(map));
                continue;
            }
            if (infoLines == null) continue;
            infoLines.add(message);
        }
        return specList;
    }

    @Override
    public List<IObliterateResult> obliterateFiles(List<IFileSpec> fileSpecs, ObliterateFilesOptions opts) throws P4JavaException {
        if (fileSpecs == null) {
            throw new NullPointerError("null fileSpecs passed to Server.obliterateFiles()");
        }
        ArrayList<IObliterateResult> obliterateResults = new ArrayList<IObliterateResult>();
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.OBLITERATE, Parameters.processParameters(opts, fileSpecs, this), null);
        if (resultMaps != null) {
            Map<String, Object> lastMap;
            boolean reportOnly = false;
            if (resultMaps.size() > 1 && (lastMap = resultMaps.get(resultMaps.size() - 1)) != null && lastMap.containsKey("reportOnly")) {
                reportOnly = true;
            }
            try {
                ObliterateResult result = null;
                ArrayList<IFileSpec> fsList = new ArrayList<IFileSpec>();
                for (Map<String, Object> map : resultMaps) {
                    String errStr = this.handleFileErrorStr(map);
                    FileSpec fs = null;
                    if (errStr == null) {
                        if (map.containsKey("purgeFile")) {
                            fs = new FileSpec();
                            fs.setDepotPath((String)map.get("purgeFile"));
                            fs.setEndRevision(new Integer((String)map.get("purgeRev")));
                            fsList.add(fs);
                            continue;
                        }
                        if (!map.containsKey("revisionRecDeleted")) continue;
                        result = new ObliterateResult(fsList, new Integer((String)map.get("integrationRecAdded")), new Integer((String)map.get("labelRecDeleted")), new Integer((String)map.get("clientRecDeleted")), new Integer((String)map.get("integrationRecDeleted")), new Integer((String)map.get("workingRecDeleted")), new Integer((String)map.get("revisionRecDeleted")), reportOnly);
                        obliterateResults.add(result);
                        fsList = new ArrayList();
                        continue;
                    }
                    fs = this.isInfoMessage(map) ? new FileSpec(FileSpecOpStatus.INFO, errStr) : new FileSpec(FileSpecOpStatus.ERROR, errStr);
                    fsList.add(fs);
                    result = new ObliterateResult(fsList, 0, 0, 0, 0, 0, 0, reportOnly);
                    obliterateResults.add(result);
                }
            }
            catch (Exception exc) {
                Log.error("Unexpected exception in ObliterateFileSpec constructor" + exc.getLocalizedMessage());
                Log.exception(exc);
            }
        }
        return obliterateResults;
    }

    @Override
    public List<IStreamSummary> getStreams(List<String> streamPaths, GetStreamsOptions opts) throws P4JavaException {
        ArrayList<IStreamSummary> streamList = new ArrayList<IStreamSummary>();
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.STREAMS, Parameters.processParameters((Options)opts, null, streamPaths != null ? streamPaths.toArray(new String[streamPaths.size()]) : null, (IServer)this), null);
        if (resultMaps != null) {
            for (Map<String, Object> streamMap : resultMaps) {
                String errStr = this.handleFileErrorStr(streamMap);
                if (errStr != null) {
                    Log.error(errStr);
                    continue;
                }
                streamList.add(new StreamSummary(streamMap, true));
            }
        }
        return streamList;
    }

    @Override
    public String createStream(IStream stream) throws P4JavaException {
        if (stream == null) {
            throw new NullPointerError("null stream passed to createStream method");
        }
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.STREAM, new String[]{"-i"}, InputMapper.map(stream));
        String retVal = null;
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                this.handleErrorStr(map);
                if (!this.isInfoMessage(map)) continue;
                if (retVal == null) {
                    retVal = this.getInfoStr(map);
                    continue;
                }
                retVal = retVal + " \n" + this.getInfoStr(map);
            }
        }
        return retVal;
    }

    @Override
    public IStream getStream(String streamPath) throws P4JavaException {
        return this.getStream(streamPath, new GetStreamOptions());
    }

    @Override
    public IStream getStream(String streamPath, GetStreamOptions opts) throws P4JavaException {
        if (streamPath == null) {
            throw new NullPointerError("null stream name to getStream method");
        }
        Stream stream = null;
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.STREAM, Parameters.processParameters((Options)opts, null, new String[]{"-o", streamPath}, (IServer)this), null);
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                if (map == null) continue;
                this.handleErrorStr(map);
                if (this.isInfoMessage(map)) continue;
                stream = new Stream(map, this);
            }
        }
        return stream;
    }

    @Override
    public String updateStream(IStream stream, StreamOptions opts) throws P4JavaException {
        if (stream == null) {
            throw new NullPointerError("Null stream in IOptioinsServer.updateStream method");
        }
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.STREAM, Parameters.processParameters((Options)opts, null, "-i", (IServer)this), InputMapper.map(stream));
        String retVal = null;
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                this.handleErrorStr(map);
                if (!this.isInfoMessage(map)) continue;
                if (retVal == null) {
                    retVal = this.getInfoStr(map);
                    continue;
                }
                retVal = retVal + " \n" + this.getInfoStr(map);
            }
        }
        return retVal;
    }

    @Override
    public String deleteStream(String streamPath, StreamOptions opts) throws P4JavaException {
        if (streamPath == null) {
            throw new NullPointerError("Null stream path passed to IOptionsServer.deleteStream");
        }
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.STREAM, Parameters.processParameters((Options)opts, null, new String[]{"-d", streamPath}, (IServer)this), null);
        String retStr = null;
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                this.handleErrorStr(map);
                if (!this.isInfoMessage(map)) continue;
                if (retStr == null) {
                    retStr = this.getInfoStr(map);
                    continue;
                }
                retStr = retStr + "\n" + this.getInfoStr(map);
            }
        } else {
            Log.warn("null return map array in Server.deleteStream");
        }
        return retStr;
    }

    @Override
    public IStreamIntegrationStatus getStreamIntegrationStatus(String stream, StreamIntegrationStatusOptions opts) throws P4JavaException {
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.ISTAT, Parameters.processParameters((Options)opts, null, new String[]{stream}, (IServer)this), null);
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                if (map == null) continue;
                this.handleErrorStr(map);
                return new StreamIntegrationStatus(map);
            }
        }
        return null;
    }

    @Override
    public ILogTail getLogTail(LogTailOptions opts) throws P4JavaException {
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.LOGTAIL, Parameters.processParameters(opts, this), null);
        String logFile = null;
        long offset = -1L;
        ArrayList<String> data = new ArrayList<String>();
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                if (map == null) continue;
                String errStr = this.getErrorStr(map);
                if (errStr != null) {
                    throw new RequestException(errStr, (String)map.get("code0"));
                }
                try {
                    if (map.containsKey("file")) {
                        logFile = (String)map.get("file");
                    }
                    if (map.containsKey("data")) {
                        data.add((String)map.get("data"));
                    }
                    if (!map.containsKey("offset")) continue;
                    offset = new Long((String)map.get("offset"));
                }
                catch (Throwable thr) {
                    Log.exception(thr);
                }
            }
        }
        if (logFile != null && data.size() > 0 && offset > -1L) {
            return new LogTail(logFile, offset, data);
        }
        return null;
    }

    @Override
    public List<IFileSpec> duplicateRevisions(IFileSpec fromFile, IFileSpec toFile, DuplicateRevisionsOptions opts) throws P4JavaException {
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.DUPLICATE, Parameters.processParameters((Options)opts, fromFile, toFile, null, (IServer)this), null);
        ArrayList<IFileSpec> integList = new ArrayList<IFileSpec>();
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                integList.add(this.handleIntegrationFileReturn(map, null));
            }
        }
        return integList;
    }

    @Override
    public String unload(UnloadOptions opts) throws P4JavaException {
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.UNLOAD, Parameters.processParameters(opts, this), null);
        String retVal = null;
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                this.handleErrorStr(map);
                if (retVal == null) {
                    retVal = this.getInfoStr(map);
                    continue;
                }
                retVal = retVal + "\n" + this.getInfoStr(map);
            }
        } else {
            Log.warn("null return map array in Server.unload");
        }
        return retVal;
    }

    @Override
    public String reload(ReloadOptions opts) throws P4JavaException {
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.RELOAD, Parameters.processParameters(opts, this), null);
        String retVal = null;
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                this.handleErrorStr(map);
                if (retVal == null) {
                    retVal = this.getInfoStr(map);
                    continue;
                }
                retVal = retVal + "\n" + this.getInfoStr(map);
            }
        } else {
            Log.warn("null return map array in Server.unload");
        }
        return retVal;
    }

    public ISSOCallback getSSOCallback() {
        return this.ssoCallback;
    }

    public String getSSOKey() {
        return this.ssoKey;
    }

    @Override
    public UsageOptions getUsageOptions() {
        return this.usageOptions;
    }

    @Override
    public Server setUsageOptions(UsageOptions usageOptions) {
        this.usageOptions = usageOptions;
        return this;
    }

    public boolean isNonCheckedSyncs() {
        return this.nonCheckedSyncs;
    }

    public void setNonCheckedSyncs(boolean nonCheckedSyncs) {
        this.nonCheckedSyncs = nonCheckedSyncs;
    }

    public boolean isEnableTracking() {
        return this.enableTracking;
    }

    public void setEnableTracking(boolean enableTracking) {
        this.enableTracking = enableTracking;
    }

    public boolean isEnableProgress() {
        return this.enableProgress;
    }

    public void setEnableProgress(boolean enableProgress) {
        this.enableProgress = enableProgress;
    }

    public boolean isQuietMode() {
        return this.quietMode;
    }

    public void setQuietMode(boolean quietMode) {
        this.quietMode = quietMode;
    }

    public String getIgnoreFileName() {
        return this.ignoreFileName;
    }

    public void setIgnoreFileName(String ignoreFileName) {
        this.ignoreFileName = ignoreFileName;
    }
}

