/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.generic.client;

import com.perforce.p4java.impl.mapbased.rpc.func.helper.StringHelper;
import com.perforce.p4java.impl.mapbased.rpc.sys.RpcPerforceFileType;
import java.util.Arrays;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ClientLineEnding {
    FST_L_LOCAL,
    FST_L_LF,
    FST_L_CR,
    FST_L_CRLF,
    FST_L_LFCRLF;

    public static final String LINESEP_PROPS_KEY = "line.separator";
    public static final String localLineEndStr;
    public static final byte PERFORCE_SERVER_LINE_END_BYTE = 10;
    public static final byte[] FST_L_LOCAL_BYTES;
    public static final char FST_L_LF_CHAR = '\n';
    public static final char FST_L_CR_CHAR = '\r';
    public static final byte[] FST_L_LF_BYTES;
    public static final byte[] FST_L_CR_BYTES;
    public static final byte[] FST_L_CRLF_BYTES;
    public static final byte[] FST_L_LFCRLF_BYTES;
    public static final boolean CONVERT_TEXT;

    public static ClientLineEnding decodeFromServerString(String str, RpcPerforceFileType fileType) {
        if (fileType != null && fileType == RpcPerforceFileType.FST_RTEXT) {
            return FST_L_LF;
        }
        if (str == null) {
            return FST_L_LOCAL;
        }
        int tl = 0;
        if (str.length() >= 2) {
            tl = StringHelper.hexcharToInt(str.charAt(1));
        }
        switch (tl) {
            case 1: {
                return FST_L_LF;
            }
            case 2: {
                return FST_L_CR;
            }
            case 3: {
                return FST_L_CRLF;
            }
            case 4: {
                return FST_L_LFCRLF;
            }
        }
        return FST_L_LOCAL;
    }

    public static boolean needsLineEndFiltering(ClientLineEnding lineEndSpec) {
        if (lineEndSpec != null) {
            switch (lineEndSpec) {
                case FST_L_LOCAL: {
                    if (localLineEndStr.equals("\n")) break;
                    return true;
                }
                case FST_L_LF: {
                    break;
                }
                case FST_L_CR: 
                case FST_L_CRLF: 
                case FST_L_LFCRLF: {
                    return true;
                }
            }
        }
        return false;
    }

    public static byte[] getLineEndBytes(ClientLineEnding lineEndSpec) {
        if (lineEndSpec != null) {
            switch (lineEndSpec) {
                case FST_L_LOCAL: {
                    return FST_L_LOCAL_BYTES;
                }
                case FST_L_LF: {
                    return FST_L_LF_BYTES;
                }
                case FST_L_CR: {
                    return FST_L_CR_BYTES;
                }
                case FST_L_CRLF: {
                    return FST_L_CRLF_BYTES;
                }
                case FST_L_LFCRLF: {
                    return FST_L_LFCRLF_BYTES;
                }
            }
        }
        return FST_L_LOCAL_BYTES;
    }

    public static void convertMap(Map<String, Object> map) {
        if (map != null) {
            String convertTo = new String(FST_L_LF_BYTES);
            for (String key : map.keySet()) {
                Object value = map.get(key);
                if (!(value instanceof String)) continue;
                value = ((String)value).replace(localLineEndStr, convertTo);
                map.put(key, value);
            }
        }
    }

    static {
        localLineEndStr = System.getProperty(LINESEP_PROPS_KEY, "\n");
        FST_L_LOCAL_BYTES = localLineEndStr.getBytes();
        FST_L_LF_BYTES = new byte[]{10};
        FST_L_CR_BYTES = new byte[]{13};
        FST_L_CRLF_BYTES = new byte[]{13, 10};
        FST_L_LFCRLF_BYTES = new byte[]{10, 13, 10};
        CONVERT_TEXT = !Arrays.equals(FST_L_LOCAL_BYTES, FST_L_LF_BYTES);
    }
}

