/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.server;

import java.util.HashMap;
import java.util.Map;

public class PerforceCharsets {
    private static final String[] knownCharsets = new String[]{"eucjp", "iso8859-1", "iso8859-5", "iso8859-15", "macosroman", "shiftjis", "koi8-r", "utf8", "utf8-bom", "utf16", "utf16-nobom", "utf16le", "utf16le-bom", "utf16be", "utf16be-bom", "utf32", "utf32-nobom", "utf32le", "utf32le-bom", "utf32be", "utf32be-bom", "cp936", "cp949", "cp950", "cp1251", "winansi", "none"};
    private static final Map<String, String> p4ToJavaCharsets = new HashMap<String, String>();

    public static String[] getKnownCharsets() {
        return knownCharsets;
    }

    public static String getJavaCharsetName(String p4CharsetName) {
        String javaCharsetName = null;
        if (p4CharsetName != null) {
            javaCharsetName = p4ToJavaCharsets.get(p4CharsetName);
        }
        return javaCharsetName;
    }

    public static boolean isSupported(String p4CharsetName) {
        boolean supported = false;
        if (p4CharsetName != null) {
            supported = p4ToJavaCharsets.containsKey(p4CharsetName);
        }
        return supported;
    }

    static {
        int count = 0;
        p4ToJavaCharsets.put(knownCharsets[count++], "EUC-JP");
        p4ToJavaCharsets.put(knownCharsets[count++], "ISO-8859-1");
        p4ToJavaCharsets.put(knownCharsets[count++], "ISO-8859-5");
        p4ToJavaCharsets.put(knownCharsets[count++], "ISO-8859-15");
        p4ToJavaCharsets.put(knownCharsets[count++], "x-MacRoman");
        p4ToJavaCharsets.put(knownCharsets[count++], "P4-ShiftJIS");
        p4ToJavaCharsets.put(knownCharsets[count++], "KOI8-R");
        p4ToJavaCharsets.put(knownCharsets[count++], "UTF-8");
        p4ToJavaCharsets.put(knownCharsets[count++], "UTF-8");
        p4ToJavaCharsets.put(knownCharsets[count++], "UTF-16");
        p4ToJavaCharsets.put(knownCharsets[count++], "UTF-16");
        p4ToJavaCharsets.put(knownCharsets[count++], "UTF-16LE");
        p4ToJavaCharsets.put(knownCharsets[count++], "UTF-16LE");
        p4ToJavaCharsets.put(knownCharsets[count++], "UTF-16BE");
        p4ToJavaCharsets.put(knownCharsets[count++], "UTF-16BE");
        p4ToJavaCharsets.put(knownCharsets[count++], "UTF-32");
        p4ToJavaCharsets.put(knownCharsets[count++], "UTF-32");
        p4ToJavaCharsets.put(knownCharsets[count++], "UTF-32LE");
        p4ToJavaCharsets.put(knownCharsets[count++], "UTF-32LE");
        p4ToJavaCharsets.put(knownCharsets[count++], "UTF-32BE");
        p4ToJavaCharsets.put(knownCharsets[count++], "UTF-32BE");
        p4ToJavaCharsets.put(knownCharsets[count++], "x-mswin-936");
        p4ToJavaCharsets.put(knownCharsets[count++], "x-windows-949");
        p4ToJavaCharsets.put(knownCharsets[count++], "x-windows-950");
        p4ToJavaCharsets.put(knownCharsets[count++], "windows-1251");
        p4ToJavaCharsets.put(knownCharsets[count++], "windows-1252");
        p4ToJavaCharsets.put(knownCharsets[count++], "none");
    }
}

