/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc;

import com.perforce.p4java.Log;
import java.util.Properties;

public class RpcPropertyDefs {
    public static final String RPC_PROPERTY_PREFIX = "com.perforce.p4java.rpc.";
    public static final int RPC_DEFAULT_SEND_BYTE_BUF_SIZE = 40960;
    public static final int RPC_DEFAULT_RECV_BYTE_BUF_SIZE = 10240;
    public static final String RPC_DEFAULT_SEND_BYTE_BUF_SIZE_NICK = "defByteSendBufSize";
    public static final String RPC_DEFAULT_RECV_BYTE_BUF_SIZE_NICK = "defByteRecvBufSize";
    public static final int RPC_DEFAULT_FILE_BUF_SIZE = 10240;
    public static final String RPC_DEFAULT_FILE_BUF_SIZE_NICK = "defFileBufSize";
    public static final int RPC_DEFAULT_FILETYPE_PEEK_SIZE = 1024;
    public static final boolean RPC_SOCKET_TCP_NO_DELAY_DEFAULT = true;
    public static final String RPC_SOCKET_TCP_NO_DELAY_NICK = "tcpNoDelay";
    public static final String RPC_SOCKET_USE_KEEPALIVE_NICK = "useKeepAlive";
    public static final int RPC_SOCKET_SO_TIMEOUT_DEFAULT = 30000;
    public static final String RPC_SOCKET_SO_TIMEOUT_NICK = "sockSoTimeout";
    public static final String RPC_SOCKET_RECV_BUF_SIZE_NICK = "sockRecvBufSize";
    public static final String RPC_SOCKET_SEND_BUF_SIZE_NICK = "sockSendBufSize";
    public static final int RPC_DEFAULT_QUEUE_SIZE = 10;
    public static final String RPC_DEFAULT_QUEUE_SIZE_NICK = "defQueueSize";
    public static final String RPC_SOCKET_POOL_SIZE_NICK = "socketPoolSize";
    public static final int RPC_SOCKET_POOL_DEFAULT_SIZE = 0;
    public static final String RPC_SECURE_SOCKET_TRUST_ALL_NICK = "secureSocketTrustAll";
    public static final boolean RPC_DEFAULT_SECURE_SOCKET_TRUST_ALL = true;
    public static final String RPC_SECURE_SOCKET_PROTOCOL_NICK = "secureSocketProtocol";
    public static final String RPC_DEFAULT_SECURE_SOCKET_PROTOCOL = "TLS";
    public static final String RPC_SECURE_SOCKET_SET_ENABLED_PROTOCOLS_NICK = "secureSocketSetEnabledProptocols";
    public static final boolean RPC_DEFAULT_SECURE_SOCKET_SET_ENABLED_PROTOCOLS = true;
    public static final String RPC_SECURE_SOCKET_ENABLED_PROTOCOLS_NICK = "secureSocketEnabledProtocols";
    public static final String RPC_DEFAULT_SECURE_SOCKET_ENABLED_PROTOCOLS = "TLSv1";
    public static final String RPC_RELAX_CMD_NAME_CHECKS_NICK = "relaxCmdNameChecks";
    public static final String RPC_APPLICATION_NAME_NICK = "applicationName";

    public static String getProperty(Properties props, String nick) {
        return RpcPropertyDefs.getProperty(props, nick, null);
    }

    public static String getProperty(Properties props, String nick, String defaultValue) {
        if (props != null && nick != null) {
            String propStr = null;
            if (props.get(nick) != null) {
                propStr = String.valueOf(props.get(nick));
            }
            if (propStr == null && props.get(RPC_PROPERTY_PREFIX + nick) != null) {
                propStr = String.valueOf(props.get(RPC_PROPERTY_PREFIX + nick));
            }
            if (propStr != null) {
                return propStr;
            }
        }
        return defaultValue;
    }

    public static int getPropertyAsInt(Properties props, String nick, int defaultValue) {
        String propStr = RpcPropertyDefs.getProperty(props, nick, null);
        int retVal = defaultValue;
        if (propStr != null) {
            try {
                retVal = new Integer(propStr);
            }
            catch (Exception exc) {
                Log.warn("Integer property conversion error; prop name: '" + nick + "'; prop value: " + propStr);
                Log.exception(exc);
            }
        }
        return retVal;
    }

    public static boolean getPropertyAsBoolean(Properties props, String nick, boolean defaultValue) {
        String propStr = RpcPropertyDefs.getProperty(props, nick, null);
        boolean retVal = defaultValue;
        if (propStr != null) {
            try {
                return new Boolean(propStr);
            }
            catch (Exception exc) {
                Log.warn("Integer property conversion error; prop name: '" + nick + "'; prop value: " + propStr);
                Log.exception(exc);
            }
        }
        return retVal;
    }
}

