/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc;

import com.perforce.p4java.Log;
import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.ConfigException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.ConnectionNotConnectedException;
import com.perforce.p4java.exception.NullPointerError;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.exception.RequestException;
import com.perforce.p4java.impl.generic.core.TempFileInputStream;
import com.perforce.p4java.impl.mapbased.rpc.CommandEnv;
import com.perforce.p4java.impl.mapbased.rpc.ExternalEnv;
import com.perforce.p4java.impl.mapbased.rpc.RpcCmdSpec;
import com.perforce.p4java.impl.mapbased.rpc.RpcServer;
import com.perforce.p4java.impl.mapbased.rpc.connection.RpcConnection;
import com.perforce.p4java.impl.mapbased.rpc.func.RpcFunctionSpec;
import com.perforce.p4java.impl.mapbased.rpc.func.proto.ProtocolCommand;
import com.perforce.p4java.impl.mapbased.rpc.packet.RpcPacket;
import com.perforce.p4java.impl.mapbased.rpc.packet.RpcPacketDispatcher;
import com.perforce.p4java.impl.mapbased.rpc.stream.RpcStreamConnection;
import com.perforce.p4java.impl.mapbased.rpc.sys.RpcOutputStream;
import com.perforce.p4java.option.UsageOptions;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.IServerAddress;
import com.perforce.p4java.server.ServerStatus;
import com.perforce.p4java.server.callback.IStreamingCallback;
import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferOverflowException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NtsServerImpl
extends RpcServer {
    public static final String SCREEN_NAME = "Native RPC (Experimental)";
    public static final String IMPL_COMMENTS = "Experimental Java-native RPC standalone P4Java implementation. Requires JDK 6 or later, full Java NIO support, and external thread synchronization. Not for the faint-hearted.";
    public static final String PROTOCOL_NAME = IServerAddress.Protocol.P4JRPCNTS.toString();
    public static final String SSL_PROTOCOL_NAME = IServerAddress.Protocol.P4JRPCNTSSSL.toString();
    public static final int MINIMUM_SUPPORTED_SERVER_LEVEL = 20052;
    public static final boolean DEFAULT_STATUS = false;
    public static final String TRACE_PREFIX = "NtsServerImpl";
    private boolean currentUseTags = true;
    private boolean haveSentProtocolSpecs = false;
    protected ProtocolCommand protocolSpecs = null;
    protected RpcPacketDispatcher dispatcher = null;
    protected RpcConnection rpcConnection = null;

    @Override
    public ServerStatus init(String host, int port, Properties props, UsageOptions opts, boolean secure) throws ConfigException, ConnectionException {
        super.init(host, port, props, opts, secure);
        this.minumumSupportedServerVersion = 20052;
        return this.status;
    }

    @Override
    public ServerStatus init(String host, int port, Properties props, UsageOptions opts) throws ConfigException, ConnectionException {
        return this.init(host, port, props, opts, false);
    }

    @Override
    public ServerStatus init(String host, int port, Properties props) throws ConfigException, ConnectionException {
        return this.init(host, port, props, null);
    }

    @Override
    public void connect() throws ConnectionException, AccessException, RequestException, ConfigException {
        this.rpcConnection = new RpcStreamConnection(this.serverHost, this.serverPort, this.props, this.serverStats, this.charset, this.secure);
        this.dispatcher = new RpcPacketDispatcher(this.props, this);
        Log.info("RPC connection to Perforce server " + this.serverHost + ":" + this.serverPort + " established");
        super.connect();
    }

    @Override
    public void disconnect() throws ConnectionException, AccessException {
        Log.info("Disconnected RPC connection to Perforce server " + this.serverHost + ":" + this.serverPort);
        this.dispatcher.shutdown(this.rpcConnection);
        this.rpcConnection.disconnect(this.dispatcher);
        this.haveSentProtocolSpecs = false;
        this.protocolSpecs = null;
        super.disconnect();
    }

    @Override
    public boolean setCharsetName(String charsetName) throws UnsupportedCharsetException {
        boolean retVal = super.setCharsetName(charsetName);
        this.rpcConnection.setClientCharset(this.charset);
        return retVal;
    }

    @Override
    public Map<String, Object>[] execMapCmd(String cmdName, String[] cmdArgs, Map<String, Object> inMap) throws ConnectionException, AccessException, RequestException {
        return this.execMapCmd(cmdName, cmdArgs, inMap, false);
    }

    @Override
    public Map<String, Object>[] execQuietMapCmd(String cmdName, String[] cmdArgs, Map<String, Object> inMap) throws ConnectionException, RequestException, AccessException {
        return this.execMapCmd(cmdName, cmdArgs, inMap, true);
    }

    protected Map<String, Object>[] execMapCmd(String cmdName, String[] cmdArgs, Map<String, Object> inMap, boolean ignoreCallbacks) throws ConnectionException, AccessException, RequestException {
        return this.execMapCmd(cmdName, cmdArgs, inMap, null, ignoreCallbacks, null, 0);
    }

    @Override
    public Map<String, Object>[] execInputStringMapCmd(String cmdName, String[] cmdArgs, String inString) throws P4JavaException {
        return this.execMapCmd(cmdName, cmdArgs, null, inString, true, null, 0);
    }

    @Override
    public void execInputStringStreamingMapComd(String cmdName, String[] cmdArgs, String inString, IStreamingCallback callback, int key) throws P4JavaException {
        this.execMapCmd(cmdName, cmdArgs, null, inString, false, callback, key);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Map<String, Object>[] execMapCmd(String cmdName, String[] cmdArgs, Map<String, Object> inMap, String inString, boolean ignoreCallbacks, IStreamingCallback callback, int callbackKey) throws ConnectionException, AccessException, RequestException {
        try {
            try {
                RpcOutputStream outStream;
                int cmdCallBackKey = this.nextCmdCallBackKey.incrementAndGet();
                long startTime = System.currentTimeMillis();
                ExternalEnv env = this.setupCmd(cmdName.toLowerCase(Locale.ENGLISH), cmdArgs, inMap, ignoreCallbacks, cmdCallBackKey, false);
                CommandEnv cmdEnv = new CommandEnv(new RpcCmdSpec(cmdName, cmdArgs, this.authTicket, inMap, inString, env), this.rpcConnection, this.protocolSpecs, this.serverProtocolMap, this.progressCallback, cmdCallBackKey, this.writeInPlace(cmdName), this.isNonCheckedSyncs());
                cmdEnv.setDontWriteTicket(this.isDontWriteTicket(cmdName.toLowerCase(Locale.ENGLISH), cmdArgs));
                cmdEnv.setFieldRule(this.getRpcPacketFieldRule(inMap, CmdSpec.getValidP4JCmdSpec(cmdName)));
                cmdEnv.setStreamingCallback(callback);
                cmdEnv.setStreamingCallbackKey(callbackKey);
                if (callback != null) {
                    try {
                        callback.startResults(callbackKey);
                    }
                    catch (P4JavaException exc) {
                        Log.error("streaming callback startResults method threw exception: " + exc.getLocalizedMessage());
                        Log.exception(exc);
                    }
                }
                Map<String, Object>[] retMap = this.dispatcher.dispatch(cmdEnv);
                long endTime = System.currentTimeMillis();
                if (callback != null) {
                    try {
                        callback.endResults(callbackKey);
                    }
                    catch (P4JavaException exc) {
                        Log.error("streaming callback endResults method threw exception: " + exc.getLocalizedMessage());
                        Log.exception(exc);
                    }
                }
                if (this.caseSensitive && cmdEnv.getServerProtocolSpecsMap().containsKey("nocase")) {
                    this.caseSensitive = false;
                }
                if (!ignoreCallbacks && this.commandCallback != null) {
                    this.processCmdCallbacks(cmdCallBackKey, endTime - startTime, retMap);
                }
                if ((outStream = (RpcOutputStream)cmdEnv.getStateMap().get("")) == null) return retMap;
                outStream.close();
                return retMap;
            }
            catch (BufferOverflowException exc) {
                Log.error("RPC Buffer overflow: " + exc.getLocalizedMessage());
                Log.exception(exc);
                throw new P4JavaError("RPC Buffer overflow: " + exc.getLocalizedMessage(), exc);
            }
            catch (ConnectionNotConnectedException cnce) {
                this.connected = false;
                this.status = ServerStatus.ERROR;
                throw cnce;
            }
            catch (IOException ioexc) {
                Log.error("I/O error encountered in stream command: " + ioexc.getLocalizedMessage());
                Log.exception(ioexc);
                throw new RequestException("I/O error encountered in stream command: " + ioexc.getLocalizedMessage(), ioexc);
            }
        }
        catch (Throwable throwable) {
            Object var19_22 = null;
            throw throwable;
        }
    }

    @Override
    public void execStreamingMapCommand(String cmdName, String[] cmdArgs, Map<String, Object> inMap, IStreamingCallback callback, int key) throws P4JavaException {
        if (callback == null) {
            throw new NullPointerError("null streaming callback passed to execStreamingMapCommand method");
        }
        this.execMapCmd(cmdName, cmdArgs, inMap, null, false, callback, key);
    }

    @Override
    public InputStream execQuietStreamCmd(String cmdName, String[] cmdArgs) throws ConnectionException, RequestException, AccessException {
        return this.execStreamCmd(cmdName, cmdArgs, true);
    }

    @Override
    public InputStream execStreamCmd(String cmdName, String[] cmdArgs) throws ConnectionException, RequestException, AccessException {
        return this.execStreamCmd(cmdName, cmdArgs, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected InputStream execStreamCmd(String cmdName, String[] cmdArgs, boolean ignoreCallbacks) throws ConnectionException, RequestException, AccessException {
        if (cmdName == null) {
            throw new NullPointerError("Null command name passed to execStreamCmd");
        }
        if (!this.connected) {
            throw new ConnectionNotConnectedException("Not currently connected to a Perforce server");
        }
        try {
            try {
                RpcOutputStream outStream;
                int cmdCallBackKey = this.nextCmdCallBackKey.incrementAndGet();
                long startTime = System.currentTimeMillis();
                ExternalEnv env = this.setupCmd(cmdName, cmdArgs, null, ignoreCallbacks, cmdCallBackKey, true);
                CommandEnv cmdEnv = new CommandEnv(new RpcCmdSpec(cmdName, cmdArgs, this.authTicket, null, null, env), this.rpcConnection, this.protocolSpecs, this.serverProtocolMap, this.progressCallback, cmdCallBackKey, this.writeInPlace(cmdName), this.isNonCheckedSyncs());
                cmdEnv.setDontWriteTicket(this.isDontWriteTicket(cmdName.toLowerCase(Locale.ENGLISH), cmdArgs));
                cmdEnv.setStreamCmd(true);
                Map<String, Object>[] retMap = this.dispatcher.dispatch(cmdEnv);
                long endTime = System.currentTimeMillis();
                if (!ignoreCallbacks && this.commandCallback != null) {
                    this.processCmdCallbacks(cmdCallBackKey, endTime - startTime, retMap);
                }
                if (retMap != null && retMap.length != 0) {
                    for (Map<String, Object> map : retMap) {
                        String errStr;
                        if (map == null || (errStr = this.getErrorStr(map)) == null) continue;
                        if (!this.isAuthFail(errStr)) throw new RequestException(errStr, (String)map.get("code0"));
                        throw new AccessException(errStr);
                    }
                }
                if ((outStream = (RpcOutputStream)cmdEnv.getStateMap().get("")) == null) return null;
                outStream.close();
                TempFileInputStream inStream = new TempFileInputStream(outStream.getFile());
                return inStream;
            }
            catch (BufferOverflowException exc) {
                Log.error("RPC Buffer overflow: " + exc.getLocalizedMessage());
                Log.exception(exc);
                throw new P4JavaError("RPC Buffer overflow: " + exc.getLocalizedMessage(), exc);
            }
            catch (ConnectionNotConnectedException cnce) {
                this.connected = false;
                this.status = ServerStatus.ERROR;
                throw cnce;
            }
            catch (IOException ioexc) {
                Log.error("I/O error encountered in stream command: " + ioexc.getLocalizedMessage());
                Log.exception(ioexc);
                throw new RequestException("I/O error encountered in stream command: " + ioexc.getLocalizedMessage(), ioexc);
            }
        }
        catch (Throwable throwable) {
            Object var18_23 = null;
            throw throwable;
        }
    }

    protected ExternalEnv setupCmd(String cmdName, String[] cmdArgs, Map<String, Object> inMap, boolean ignoreCallbacks, int cmdCallBackKey, boolean isStream) throws ConnectionException, AccessException, RequestException {
        if (this.rpcConnection == null) {
            throw new NullPointerError("Null RPC connection in execMapCmd call");
        }
        if (this.dispatcher == null) {
            throw new NullPointerError("Null RPC dispatcher in execMapCmd call");
        }
        if (!this.isRelaxCmdNameValidationChecks() && !CmdSpec.isValidP4JCmdSpec(cmdName)) {
            throw new RequestException("command name '" + cmdName + "' unimplemented or unrecognized by p4java");
        }
        boolean useTags = this.useTags(cmdName, cmdArgs, inMap, isStream);
        this.checkFingerprint(this.rpcConnection);
        ExternalEnv env = new ExternalEnv(this.getUsageOptions().getProgramName(), this.getUsageOptions().getProgramVersion(), this.getClientNameForEnv(), this.getUsageOptions().getWorkingDirectory(), this.getHostForEnv(), this.getUsageOptions().getTextLanguage(), this.getOsTypeForEnv(), this.getUserForEnv(), this.charsetName != null, this.charset);
        if (!ignoreCallbacks && this.commandCallback != null) {
            StringBuilder cmd = new StringBuilder(cmdName);
            for (String argStr : cmdArgs) {
                if (argStr == null) continue;
                cmd.append(" ");
                cmd.append(argStr);
            }
            this.commandCallback.issuingServerCommand(cmdCallBackKey, cmd.toString());
        }
        RpcPacket protPacket = null;
        if (!this.haveSentProtocolSpecs || this.currentUseTags != useTags) {
            this.protocolSpecs = new ProtocolCommand();
            this.protocolSpecs.setClientApiLevel(this.clientApiLevel);
            this.protocolSpecs.setClientCmpFile(false);
            this.protocolSpecs.setServerApiLevel(this.serverApiLevel);
            this.protocolSpecs.setApplicationName(this.applicationName);
            this.protocolSpecs.setSendBufSize(this.rpcConnection.getSystemSendBufferSize());
            this.protocolSpecs.setRecvBufSize(this.rpcConnection.getSystemRecvBufferSize());
            this.protocolSpecs.setUseTags(useTags);
            this.protocolSpecs.setEnableStreams(true);
            this.protocolSpecs.setEnableTracking(this.enableTracking);
            this.protocolSpecs.setEnableProgress(this.enableProgress);
            protPacket = RpcPacket.constructRpcPacket(RpcFunctionSpec.PROTOCOL_PROTOCOL, this.protocolSpecs.asMap(), null);
            this.currentUseTags = useTags;
            this.haveSentProtocolSpecs = true;
        }
        RpcFunctionSpec name = RpcFunctionSpec.decodeFromEndUserCmd(cmdName, this.isRelaxCmdNameValidationChecks());
        RpcPacket cmdPacket = RpcPacket.constructRpcPacket(name, cmdName, cmdArgs, env);
        if (useTags) {
            cmdPacket.setMapArgs(this.cmdMapArgs);
        }
        if (this.enableProgress) {
            HashMap<String, Object> valMap = new HashMap<String, Object>();
            if (cmdPacket.getMapArgs() != null) {
                valMap.putAll(cmdPacket.getMapArgs());
            }
            valMap.put("progress", "1");
            cmdPacket.setMapArgs(valMap);
        }
        if (protPacket == null) {
            this.rpcConnection.putRpcPacket(cmdPacket);
        } else {
            this.rpcConnection.putRpcPackets(new RpcPacket[]{protPacket, cmdPacket});
        }
        return env;
    }

    public RpcConnection getRpcConnection() {
        return this.rpcConnection;
    }

    public void setRpcConnection(RpcConnection rpcConnection) {
        this.rpcConnection = rpcConnection;
    }
}

