/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.generic.core.file;

import com.perforce.p4java.Log;
import com.perforce.p4java.client.IClient;
import com.perforce.p4java.core.file.DiffType;
import com.perforce.p4java.core.file.FileAction;
import com.perforce.p4java.core.file.FileSpecBuilder;
import com.perforce.p4java.core.file.FileSpecOpStatus;
import com.perforce.p4java.core.file.IFileAnnotation;
import com.perforce.p4java.core.file.IFileRevisionData;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.NullPointerError;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.exception.RequestException;
import com.perforce.p4java.impl.generic.core.ServerResource;
import com.perforce.p4java.impl.generic.core.file.FilePath;
import com.perforce.p4java.impl.generic.core.file.PathAnnotations;
import com.perforce.p4java.option.server.GetFileAnnotationsOptions;
import com.perforce.p4java.option.server.GetFileContentsOptions;
import com.perforce.p4java.option.server.GetRevisionHistoryOptions;
import com.perforce.p4java.option.server.MoveFileOptions;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.IServer;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSpec
extends ServerResource
implements IFileSpec {
    protected FileSpecOpStatus opStatus = FileSpecOpStatus.VALID;
    protected String statusMessage = null;
    protected int genericCode = 0;
    protected int severityCode = 0;
    protected int rawCode = 0;
    protected int uniqueCode = 0;
    protected int subCode = 0;
    protected int subSystem = 0;
    protected FilePath originalPath = null;
    protected FilePath depotPath = null;
    protected FilePath clientPath = null;
    protected FilePath localPath = null;
    protected String fileType = null;
    protected int startRevision = -1;
    protected int endRevision = -1;
    protected int changeListId = -1;
    protected String label = null;
    protected Date date = null;
    protected FileAction action = null;
    protected String userName = null;
    protected String clientName = null;
    protected int baseRev = -1;
    protected String baseName = null;
    protected String baseFile = null;
    protected boolean unmap = false;
    private String fromFile = null;
    private int endFromRev = -1;
    private int startFromRev = -1;
    private String toFile = null;
    private int endToRev = -1;
    private int startToRev = -1;
    private int workRev = -1;
    private String howResolved = null;
    private FileAction otherAction = null;
    private boolean locked = false;
    private String diffStatus = null;
    private String resolveType = null;
    private String contentResolveType = null;
    private int shelvedChange = -1;
    protected IServer server = null;
    protected IClient client = null;

    public FileSpec() {
        super(false, false);
    }

    public FileSpec(String pathStr) {
        this(pathStr, true);
    }

    public FileSpec(String pathStr, boolean parseAnnotations) {
        super(false, false);
        this.originalPath = new FilePath(FilePath.PathType.ORIGINAL, pathStr);
        if (parseAnnotations && pathStr != null && PathAnnotations.hasPerforceAnnotations(pathStr)) {
            PathAnnotations annotations = new PathAnnotations(pathStr);
            this.startRevision = annotations.getStartRevision();
            this.endRevision = annotations.getEndRevision();
            this.changeListId = annotations.getChangelistId();
            this.label = annotations.getLabel();
            this.date = annotations.getDate();
        }
    }

    public FileSpec(FilePath path) {
        super(false, false);
        this.setPath(path);
    }

    public FileSpec(FileSpecOpStatus status, String errStr) {
        super(false, false);
        this.opStatus = status;
        this.statusMessage = errStr;
    }

    public FileSpec(FileSpecOpStatus status, String errStr, int genericCode, int severityCode) {
        super(false, false);
        this.opStatus = status;
        this.statusMessage = errStr;
        this.genericCode = genericCode;
        this.severityCode = severityCode;
    }

    public FileSpec(FileSpecOpStatus status, String errStr, String codeStr) {
        super(false, false);
        this.opStatus = status;
        this.statusMessage = errStr;
        try {
            this.setCodes(new Integer(codeStr));
        }
        catch (Throwable thr) {
            Log.exception(thr);
        }
    }

    public FileSpec(FileSpecOpStatus status, String errStr, int rawCode) {
        super(false, false);
        this.opStatus = status;
        this.statusMessage = errStr;
        this.setCodes(rawCode);
    }

    public FileSpec(FileSpec impl) {
        super(false, false);
        if (impl == null) {
            throw new NullPointerError("null impl passed to FileSpec constructor");
        }
        this.opStatus = impl.opStatus;
        this.statusMessage = impl.statusMessage;
        this.genericCode = impl.genericCode;
        this.severityCode = impl.severityCode;
        this.originalPath = impl.originalPath;
        this.depotPath = impl.depotPath;
        this.clientPath = impl.clientPath;
        this.localPath = impl.localPath;
        this.fileType = impl.fileType;
        this.startRevision = impl.startRevision;
        this.endRevision = impl.endRevision;
        this.changeListId = impl.changeListId;
        this.label = impl.label;
        this.date = impl.date;
        this.action = impl.action;
        this.userName = impl.userName;
        this.clientName = impl.clientName;
        this.unmap = impl.unmap;
        this.fromFile = impl.fromFile;
        this.endFromRev = impl.endFromRev;
        this.startFromRev = impl.startFromRev;
        this.toFile = impl.toFile;
        this.endToRev = impl.endToRev;
        this.startToRev = impl.startToRev;
        this.workRev = impl.workRev;
        this.howResolved = impl.howResolved;
        this.otherAction = impl.otherAction;
        this.locked = impl.locked;
        this.diffStatus = impl.diffStatus;
        this.resolveType = impl.resolveType;
        this.contentResolveType = impl.contentResolveType;
        this.shelvedChange = impl.shelvedChange;
        this.server = impl.server;
        this.client = impl.client;
        this.baseFile = impl.baseFile;
    }

    public FileSpec(Map<String, Object> map, IServer server, int index) {
        super(false, false);
        if (map != null) {
            this.setOpStatus(FileSpecOpStatus.VALID);
            String indexStr = "";
            if (index >= 0) {
                indexStr = indexStr + index;
            }
            this.setServer(server);
            if (map.containsKey("dir" + indexStr)) {
                this.setDepotPath(new FilePath(FilePath.PathType.DEPOT, (String)map.get("dir" + indexStr), true));
            }
            if (map.containsKey("depotFile" + indexStr)) {
                this.setDepotPath(new FilePath(FilePath.PathType.DEPOT, (String)map.get("depotFile" + indexStr), true));
            }
            if (map.containsKey("clientFile" + indexStr)) {
                this.setClientPath(new FilePath(FilePath.PathType.CLIENT, (String)map.get("clientFile" + indexStr), true));
            }
            if (map.containsKey("path" + indexStr)) {
                this.setLocalPath(new FilePath(FilePath.PathType.LOCAL, (String)map.get("path" + indexStr), true));
            }
            this.setFileType((String)map.get("type" + indexStr));
            this.setAction(FileAction.fromString((String)map.get("action" + indexStr)));
            this.setUserName((String)map.get("user" + indexStr));
            this.setClientName((String)map.get("client" + indexStr));
            String cid = (String)map.get("change" + indexStr);
            String revStr = (String)map.get("rev" + indexStr);
            if (revStr == null) {
                revStr = (String)map.get("haveRev" + indexStr);
            }
            this.setLocked(map.get("ourLock") != null || map.get("otherLock") != null);
            this.setEndRevision(FileSpec.getRevFromString(revStr));
            if (cid == null) {
                this.setChangelistId(-1);
            } else if (cid.equalsIgnoreCase("default") || cid.equalsIgnoreCase("default change")) {
                this.setChangelistId(0);
            } else {
                int i = cid.indexOf(" ");
                if (i < 0) {
                    this.setChangelistId(new Integer(cid));
                } else {
                    this.setChangelistId(new Integer(cid.substring(i + 1)));
                }
            }
            this.setEndFromRev(FileSpec.getRevFromString((String)map.get("endFromRev" + indexStr)));
            this.setStartFromRev(FileSpec.getRevFromString((String)map.get("startFromRev" + indexStr)));
            this.setWorkRev(FileSpec.getRevFromString((String)map.get("workRev" + indexStr)));
            this.setHowResolved((String)map.get("how"));
            this.setFromFile((String)map.get("fromFile" + indexStr));
            this.setEndToRev(FileSpec.getRevFromString((String)map.get("endToRev" + indexStr)));
            this.setStartToRev(FileSpec.getRevFromString((String)map.get("startToRev" + indexStr)));
            this.setToFile((String)map.get("toFile" + indexStr));
            this.setBaseRev(FileSpec.getRevFromString((String)map.get("baseRev" + indexStr)));
            this.setBaseName((String)map.get("baseName" + indexStr));
            this.setBaseFile((String)map.get("baseFile" + indexStr));
            this.setOtherAction(FileAction.fromString((String)map.get("otherAction" + indexStr)));
            this.setDiffStatus((String)map.get("status"));
            this.setResolveType((String)map.get("resolveType"));
            this.setContentResolveType((String)map.get("contentResolveType"));
            if (map.containsKey("shelvedChange")) {
                try {
                    this.setShelvedChange(new Integer((String)map.get("shelvedChange")));
                }
                catch (NumberFormatException nfe) {
                    Log.error("Error parsing the 'shelvedChange' in the FileSpec constructor: " + nfe.getLocalizedMessage());
                    Log.exception(nfe);
                }
            }
            if ((String)map.get("unmap" + indexStr) != null) {
                this.unmap = true;
            }
            this.setUnmap((String)map.get("unmap" + indexStr) != null);
        }
    }

    public FileSpec setCodes(int rawCode) {
        this.rawCode = rawCode;
        this.subCode = rawCode >> 0 & 0x3FF;
        this.subSystem = rawCode >> 10 & 0x3F;
        this.uniqueCode = rawCode & 0xFFFF;
        this.genericCode = rawCode >> 16 & 0xFF;
        this.severityCode = rawCode >> 28 & 0xF;
        return this;
    }

    @Override
    public FilePath getPath(FilePath.PathType pathType) {
        if (pathType != null) {
            switch (pathType) {
                case DEPOT: {
                    return this.depotPath;
                }
                case CLIENT: {
                    return this.clientPath;
                }
                case LOCAL: {
                    return this.localPath;
                }
            }
        }
        return this.originalPath;
    }

    @Override
    public void setPath(FilePath filePath) {
        if (filePath != null && filePath.getPathType() != null) {
            switch (filePath.getPathType()) {
                case DEPOT: {
                    this.depotPath = filePath;
                    return;
                }
                case CLIENT: {
                    this.clientPath = filePath;
                    return;
                }
                case LOCAL: {
                    this.localPath = filePath;
                    return;
                }
            }
        }
        this.originalPath = filePath;
    }

    @Override
    public FileAction getAction() {
        return this.action;
    }

    @Override
    public int getChangelistId() {
        return this.changeListId;
    }

    @Override
    public String getClientName() {
        return this.clientName;
    }

    @Override
    public FilePath getClientPath() {
        return this.getPath(FilePath.PathType.CLIENT);
    }

    @Override
    public InputStream getContents(boolean noHeaderLine) throws ConnectionException, RequestException, AccessException {
        this.checkServer();
        ArrayList<IFileSpec> fList = new ArrayList<IFileSpec>();
        fList.add(this);
        return this.server.getFileContents(fList, false, noHeaderLine);
    }

    @Override
    public InputStream getContents(GetFileContentsOptions opts) throws P4JavaException {
        this.checkServer();
        ArrayList<IFileSpec> fList = new ArrayList<IFileSpec>();
        fList.add(this);
        return ((IOptionsServer)this.server).getFileContents(fList, opts);
    }

    @Override
    public FilePath getDepotPath() {
        return this.getPath(FilePath.PathType.DEPOT);
    }

    @Override
    public int getEndRevision() {
        return this.endRevision;
    }

    @Override
    public String getFileType() {
        return this.fileType;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public FilePath getLocalPath() {
        return this.getPath(FilePath.PathType.LOCAL);
    }

    @Override
    public FileSpecOpStatus getOpStatus() {
        return this.opStatus;
    }

    @Override
    public FilePath getPreferredPath() {
        if (this.originalPath != null) {
            return this.originalPath;
        }
        if (this.depotPath != null) {
            return this.depotPath;
        }
        if (this.clientPath != null) {
            return this.clientPath;
        }
        if (this.localPath != null) {
            return this.localPath;
        }
        return null;
    }

    @Override
    public Map<IFileSpec, List<IFileRevisionData>> getRevisionHistory(int maxRevs, boolean contentHistory, boolean includeInherited, boolean longOutput, boolean truncatedLongOutput) throws ConnectionException, RequestException, AccessException {
        this.checkServer();
        return this.server.getRevisionHistory(FileSpecBuilder.makeFileSpecList(new String[]{this.getAnnotatedPreferredPathString()}), maxRevs, contentHistory, includeInherited, longOutput, truncatedLongOutput);
    }

    @Override
    public Map<IFileSpec, List<IFileRevisionData>> getRevisionHistory(GetRevisionHistoryOptions opts) throws P4JavaException {
        this.checkServer();
        return ((IOptionsServer)this.server).getRevisionHistory(FileSpecBuilder.makeFileSpecList(new String[]{this.getAnnotatedPreferredPathString()}), opts);
    }

    @Override
    public List<IFileAnnotation> getAnnotations(DiffType wsOptions, boolean allResults, boolean useChangeNumbers, boolean followBranches) throws ConnectionException, RequestException, AccessException {
        this.checkServer();
        ArrayList<IFileSpec> specList = new ArrayList<IFileSpec>();
        specList.add(this);
        return this.server.getFileAnnotations(specList, wsOptions, allResults, useChangeNumbers, followBranches);
    }

    @Override
    public List<IFileAnnotation> getAnnotations(GetFileAnnotationsOptions opts) throws P4JavaException {
        this.checkServer();
        ArrayList<IFileSpec> specList = new ArrayList<IFileSpec>();
        specList.add(this);
        return ((IOptionsServer)this.server).getFileAnnotations(specList, opts);
    }

    @Override
    public List<IFileSpec> move(int changelistId, boolean listOnly, boolean noClientMove, String fileType, IFileSpec toFile) throws ConnectionException, RequestException, AccessException {
        this.checkServer();
        return this.server.moveFile(changelistId, listOnly, noClientMove, fileType, this, toFile);
    }

    @Override
    public List<IFileSpec> move(IFileSpec toFile, MoveFileOptions opts) throws P4JavaException {
        this.checkServer();
        return ((IOptionsServer)this.server).moveFile(this, toFile, opts);
    }

    private void checkServer() throws P4JavaError {
        if (this.server == null) {
            throw new P4JavaError("File specification is not associated with any server");
        }
        if (!(this.server instanceof IOptionsServer)) {
            throw new P4JavaError("File specification is not associated with an options server");
        }
    }

    @Override
    public int getStartRevision() {
        return this.startRevision;
    }

    @Override
    public String getStatusMessage() {
        return this.statusMessage;
    }

    @Override
    public int getSeverityCode() {
        return this.severityCode;
    }

    @Override
    public int getGenericCode() {
        return this.genericCode;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public String getDiffStatus() {
        return this.diffStatus;
    }

    @Override
    public String getResolveType() {
        return this.resolveType;
    }

    @Override
    public String getContentResolveType() {
        return this.contentResolveType;
    }

    @Override
    public int getShelvedChange() {
        return this.shelvedChange;
    }

    public void setOpStatus(FileSpecOpStatus opStatus) {
        this.opStatus = opStatus;
    }

    public void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }

    public void setOriginalPath(FilePath path) {
        this.originalPath = path;
    }

    public void setDepotPath(FilePath depotPath) {
        this.depotPath = depotPath;
    }

    public void setClientPath(FilePath clientPath) {
        this.clientPath = clientPath;
    }

    public void setLocalPath(FilePath localPath) {
        this.localPath = localPath;
    }

    @Override
    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    @Override
    public void setStartRevision(int startRevision) {
        this.startRevision = startRevision;
    }

    @Override
    public void setEndRevision(int endRevision) {
        this.endRevision = endRevision;
    }

    @Override
    public void setChangelistId(int changeListId) {
        this.changeListId = changeListId;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public void setAction(FileAction action) {
        this.action = action;
    }

    @Override
    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Override
    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    @Override
    public void setServer(IServer server) {
        this.server = server;
    }

    public void setClient(IClient client) {
        this.client = client;
    }

    @Override
    public int getEndFromRev() {
        return this.endFromRev;
    }

    @Override
    public int getEndToRev() {
        return this.endToRev;
    }

    @Override
    public String getFromFile() {
        return this.fromFile;
    }

    @Override
    public String getHowResolved() {
        return this.howResolved;
    }

    @Override
    public FileAction getOtherAction() {
        return this.otherAction;
    }

    @Override
    public int getStartFromRev() {
        return this.startFromRev;
    }

    @Override
    public int getStartToRev() {
        return this.startToRev;
    }

    @Override
    public String getToFile() {
        return this.toFile;
    }

    @Override
    public int getWorkRev() {
        return this.workRev;
    }

    @Override
    public boolean isUnmap() {
        return this.unmap;
    }

    @Override
    public void setDate(Date date) {
        this.date = date;
    }

    @Override
    public void setFromFile(String fromFile) {
        this.fromFile = fromFile;
    }

    @Override
    public void setEndFromRev(int endFromRev) {
        this.endFromRev = endFromRev;
    }

    @Override
    public void setStartFromRev(int startFromRev) {
        this.startFromRev = startFromRev;
    }

    @Override
    public void setToFile(String toFile) {
        this.toFile = toFile;
    }

    @Override
    public void setEndToRev(int endToRev) {
        this.endToRev = endToRev;
    }

    @Override
    public void setStartToRev(int startToRev) {
        this.startToRev = startToRev;
    }

    @Override
    public void setWorkRev(int workRev) {
        this.workRev = workRev;
    }

    @Override
    public void setHowResolved(String howResolved) {
        this.howResolved = howResolved;
    }

    @Override
    public void setOtherAction(FileAction otherAction) {
        this.otherAction = otherAction;
    }

    @Override
    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    @Override
    public void setDiffStatus(String diffStatus) {
        this.diffStatus = diffStatus;
    }

    @Override
    public void setResolveType(String resolveType) {
        this.resolveType = resolveType;
    }

    @Override
    public void setContentResolveType(String contentResolveType) {
        this.contentResolveType = contentResolveType;
    }

    @Override
    public void setShelvedChange(int shelvedChange) {
        this.shelvedChange = shelvedChange;
    }

    @Override
    public void setUnmap(boolean unmap) {
        this.unmap = unmap;
    }

    public static int getRevFromString(String str) {
        int rev = -1;
        if (str != null) {
            if (str.contains("head")) {
                return -17;
            }
            if (str.contains("none")) {
                return -1;
            }
            try {
                if (str.startsWith("#") && str.length() > 1) {
                    rev = new Integer(str.substring(1));
                } else if (str.length() > 0) {
                    rev = new Integer(str);
                }
            }
            catch (Exception exc) {
                Log.error("Conversion error in FileSpec.getRevFromString: " + exc.getLocalizedMessage());
                Log.exception(exc);
            }
        }
        return rev;
    }

    @Override
    public String getClientPathString() {
        return this.getPathString(FilePath.PathType.CLIENT);
    }

    @Override
    public String getDepotPathString() {
        return this.getPathString(FilePath.PathType.DEPOT);
    }

    @Override
    public String getLocalPathString() {
        return this.getPathString(FilePath.PathType.LOCAL);
    }

    @Override
    public FilePath getOriginalPath() {
        return this.getPath(FilePath.PathType.CLIENT);
    }

    @Override
    public String getOriginalPathString() {
        return this.getPathString(FilePath.PathType.ORIGINAL);
    }

    @Override
    public String getPathString(FilePath.PathType pathType) {
        FilePath fPath = this.getPath(pathType);
        if (fPath != null) {
            return fPath.toString();
        }
        return null;
    }

    @Override
    public String getAnnotatedPathString(FilePath.PathType pathType) {
        FilePath path = this.getPath(pathType);
        if (path != null) {
            return path.annotate(this);
        }
        return null;
    }

    @Override
    public String getPreferredPathString() {
        FilePath prefPath = this.getPreferredPath();
        if (prefPath != null && prefPath.getPathString() != null) {
            return prefPath.toString();
        }
        return null;
    }

    @Override
    public String getAnnotatedPreferredPathString() {
        FilePath prefPath = this.getPreferredPath();
        if (prefPath != null && prefPath.getPathString() != null) {
            return prefPath.annotate(this);
        }
        return null;
    }

    @Override
    public String toString() {
        return this.getAnnotatedPreferredPathString();
    }

    @Override
    public void setPathFromString(FilePath.PathType pathType, String pathStr) {
        FilePath path = new FilePath(pathType, pathStr);
        this.setPath(path);
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    @Override
    public void setClientPath(String pathStr) {
        this.setPath(new FilePath(FilePath.PathType.CLIENT, pathStr));
    }

    @Override
    public void setDepotPath(String pathStr) {
        this.setPath(new FilePath(FilePath.PathType.DEPOT, pathStr));
    }

    @Override
    public void setLocalPath(String pathStr) {
        this.setPath(new FilePath(FilePath.PathType.LOCAL, pathStr));
    }

    @Override
    public void setOriginalPath(String pathStr) {
        this.setPath(new FilePath(FilePath.PathType.ORIGINAL, pathStr));
    }

    @Override
    public int getBaseRev() {
        return this.baseRev;
    }

    @Override
    public void setBaseRev(int baseRev) {
        this.baseRev = baseRev;
    }

    @Override
    public String getBaseName() {
        return this.baseName;
    }

    @Override
    public void setBaseName(String baseName) {
        this.baseName = baseName;
    }

    @Override
    public String getBaseFile() {
        return this.baseFile;
    }

    @Override
    public void setBaseFile(String baseFile) {
        this.baseFile = baseFile;
    }

    @Override
    public int getRawCode() {
        return this.rawCode;
    }

    @Override
    public int getUniqueCode() {
        return this.uniqueCode;
    }

    @Override
    public int getSubCode() {
        return this.subCode;
    }

    @Override
    public int getSubSystem() {
        return this.subSystem;
    }
}

