/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.func.client;

import com.perforce.p4java.CharsetDefs;
import com.perforce.p4java.Log;
import com.perforce.p4java.exception.ConfigException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.NullPointerError;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.impl.mapbased.rpc.CommandEnv;
import com.perforce.p4java.impl.mapbased.rpc.RpcServer;
import com.perforce.p4java.impl.mapbased.rpc.connection.RpcConnection;
import com.perforce.p4java.impl.mapbased.rpc.func.client.Mangle;
import com.perforce.p4java.impl.mapbased.rpc.func.helper.MD5Digester;
import com.perforce.p4java.impl.mapbased.rpc.func.helper.MapUnmapper;
import com.perforce.p4java.impl.mapbased.rpc.packet.RpcPacket;
import com.perforce.p4java.impl.mapbased.rpc.packet.RpcPacketDispatcher;
import com.perforce.p4java.server.callback.ISSOCallback;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientUserInteraction {
    public static final String TRACE_PREFIX = "ClientUserInteraction";
    protected static final int RESP_LENGTH = 32;
    protected static final int TRUNCATE_LENGTH = 16;
    private Properties props = null;
    private RpcServer server = null;

    protected ClientUserInteraction(Properties props, RpcServer server) {
        this.props = props;
        this.server = server;
    }

    protected RpcPacketDispatcher.RpcPacketDispatcherResult clientPrompt(RpcConnection rpcConnection, CommandEnv cmdEnv, Map<String, Object> resultsMap) throws ConnectionException {
        String digest = null;
        String func2 = null;
        String state = null;
        String userName = null;
        String confirm = null;
        String mangle = null;
        boolean truncate = false;
        boolean noecho = false;
        MD5Digester digester = null;
        String passwd = null;
        String resp = null;
        try {
            digest = (String)resultsMap.get("digest");
            truncate = resultsMap.containsKey("truncate");
            func2 = (String)resultsMap.get("func2");
            userName = (String)resultsMap.get("user");
            state = (String)resultsMap.get("state");
            confirm = (String)resultsMap.get("confirm");
            noecho = resultsMap.containsKey("noecho");
            mangle = (String)resultsMap.get("mangle");
            Map<String, Object> inMap = cmdEnv.getCmdSpec().getInMap();
            if (inMap == null || inMap.size() < 1 || inMap.get("password") == null) {
                throw new NullPointerError("No login password passed to client login");
            }
            passwd = ((String)inMap.get("password")).trim();
            if (truncate && passwd.length() > 16) {
                passwd = passwd.substring(0, 16);
            }
            if (digest != null) {
                digester = new MD5Digester();
                digester.update(passwd.getBytes(CharsetDefs.UTF8.name()));
                resp = digester.digestAs32ByteHex();
                this.server.setSecretKey(resp);
                digester.reset();
                digester.update(resp.getBytes(CharsetDefs.UTF8.name()));
                digester.update(digest.getBytes(CharsetDefs.UTF8.name()));
                resp = digester.digestAs32ByteHex();
            }
            HashMap<String, Object> respMap = new HashMap<String, Object>();
            respMap.put("digest", digest);
            if (mangle != null) {
                respMap.put("mangle", mangle);
                MD5Digester mangleDigester = new MD5Digester();
                mangleDigester.update(mangle);
                mangleDigester.update(userName);
                Mangle jMangle = new Mangle();
                String toMangle = resp;
                if (toMangle == null) {
                    toMangle = passwd;
                }
                String digestedMangle = mangleDigester.digestAs32ByteHex();
                resp = jMangle.mangle(toMangle, digestedMangle, false);
            }
            respMap.put("data", resp);
            if (truncate) {
                respMap.put("truncate", "");
            }
            respMap.put("func2", func2);
            respMap.put("state", state);
            if (noecho) {
                respMap.put("noecho", "");
            }
            respMap.put("user", userName);
            respMap.put("confirm", confirm);
            RpcPacket respPacket = RpcPacket.constructRpcPacket(confirm, respMap, null);
            rpcConnection.putRpcPacket(respPacket);
        }
        catch (Exception exc) {
            Log.exception(exc);
            throw new P4JavaError("Unexpected exception in ClientUserInteraction.clientPrompt:" + exc.getLocalizedMessage(), exc);
        }
        return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE;
    }

    protected RpcPacketDispatcher.RpcPacketDispatcherResult clientSetPassword(RpcConnection rpcConnection, CommandEnv cmdEnv, Map<String, Object> resultsMap) throws ConnectionException {
        if (this.server != null) {
            boolean sameUser;
            String data2 = (String)resultsMap.get("data2");
            String userName = (String)resultsMap.get("user");
            String serverId = (String)resultsMap.get("serverAddress");
            String ticket = null;
            if (serverId != null) {
                this.server.setServerId(serverId);
            }
            boolean bl = sameUser = userName == null || userName.equalsIgnoreCase(this.server.getUserName());
            if ("logout".equals(data2)) {
                try {
                    this.server.saveTicket(null);
                }
                catch (ConfigException e) {
                    throw new ConnectionException(e);
                }
            }
            if ("login".equals(data2)) {
                byte[] data = (byte[])resultsMap.get("data");
                String digest = (String)resultsMap.get("digest");
                if (digest != null) {
                    if (digest.length() != 32) {
                        throw new P4JavaError("bad digest size");
                    }
                    String secretKey = null;
                    secretKey = sameUser ? this.server.getSecretKey() : this.server.getAuthTicket();
                    ticket = new String(data);
                    Mangle mangler = new Mangle();
                    String token2 = mangler.mangle(digest, secretKey, true);
                    ticket = mangler.xor32(ticket, token2);
                }
                this.server.setSecretKey(null);
                if (data != null) {
                    if (ticket == null) {
                        ticket = new String(data);
                    }
                    this.server.setAuthTicket(ticket);
                    try {
                        this.server.saveTicket(ticket);
                    }
                    catch (ConfigException e) {
                        throw new ConnectionException(e);
                    }
                }
            }
        }
        return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
    }

    protected RpcPacketDispatcher.RpcPacketDispatcherResult clientSingleSignon(RpcConnection rpcConnection, CommandEnv cmdEnv, Map<String, Object> resultsMap) throws ConnectionException {
        String confirm = (String)resultsMap.get("confirm");
        ISSOCallback.Status status = null;
        StringBuffer credBuf = new StringBuffer();
        if (this.server != null) {
            ISSOCallback ssoCallback = this.server.getSSOCallback();
            if (ssoCallback != null) {
                status = ssoCallback.getSSOCredentials(credBuf, this.server.getSSOKey(), this.server.getUserName());
            }
        } else {
            Log.error("null server object in ClientUserInteraction.clientSingleSignon method");
        }
        if (status == null) {
            status = ISSOCallback.Status.UNSET;
        }
        if (confirm != null) {
            HashMap<String, Object> respMap = new HashMap<String, Object>();
            for (String key : resultsMap.keySet()) {
                if (key == null || key.equalsIgnoreCase("func")) continue;
                respMap.put(key, resultsMap.get(key));
            }
            respMap.put("status", status.toString().toLowerCase());
            String sso = null;
            if (status != ISSOCallback.Status.UNSET) {
                sso = credBuf != null && credBuf.length() > 131072 ? credBuf.substring(0, 131072) : credBuf.toString();
            }
            respMap.put("sso", sso);
            RpcPacket respPacket = RpcPacket.constructRpcPacket(confirm, respMap, null);
            rpcConnection.putRpcPacket(respPacket);
        }
        return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
    }

    protected RpcPacketDispatcher.RpcPacketDispatcherResult clientAck(RpcConnection rpcConnection, CommandEnv cmdEnv, Map<String, Object> resultsMap) throws ConnectionException {
        String confirm = (String)resultsMap.get("confirm");
        String decline = (String)resultsMap.get("decline");
        String handle = (String)resultsMap.get("handle");
        CommandEnv.RpcHandler handler = cmdEnv.getHandler(handle);
        if (handler != null && handler.isError()) {
            confirm = decline;
        }
        if (confirm != null) {
            HashMap<String, Object> respMap = new HashMap<String, Object>();
            for (String key : resultsMap.keySet()) {
                if (key == null || key.equalsIgnoreCase("func")) continue;
                respMap.put(key, resultsMap.get(key));
            }
            RpcPacket respPacket = RpcPacket.constructRpcPacket(confirm, respMap, null);
            rpcConnection.putRpcPacket(respPacket);
        }
        return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
    }

    protected RpcPacketDispatcher.RpcPacketDispatcherResult clientCrypto(RpcConnection rpcConnection, CommandEnv cmdEnv, Map<String, Object> resultsMap) throws ConnectionException {
        String ticketStr = cmdEnv.getCmdSpec().getCmdTicket();
        MD5Digester digester = null;
        String token = null;
        String resp = null;
        String confirm = (String)resultsMap.get("confirm");
        HashMap<String, Object> respMap = null;
        try {
            if (ticketStr == null && this.server != null) {
                String serverId = (String)resultsMap.get("serverAddress");
                if (serverId != null) {
                    this.server.setServerId(serverId);
                }
                if ((ticketStr = this.server.loadTicket(serverId)) != null) {
                    this.server.setAuthTicket(ticketStr);
                }
            }
            if (ticketStr == null) {
                ticketStr = "";
            }
            token = (String)resultsMap.get("token");
            digester = new MD5Digester();
            digester.reset();
            digester.update(token.getBytes(CharsetDefs.UTF8.name()));
            digester.update(ticketStr.getBytes());
            resp = digester.digestAs32ByteHex();
            respMap = new HashMap<String, Object>();
            respMap.put("token", resp);
            RpcPacket respPacket = RpcPacket.constructRpcPacket(confirm, respMap, null);
            rpcConnection.putRpcPacket(respPacket);
        }
        catch (Exception exc) {
            Log.exception(exc);
            throw new P4JavaError("Unexpected exception in ClientUserInteraction.clientCrypto:" + exc.getLocalizedMessage(), exc);
        }
        return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
    }

    protected RpcPacketDispatcher.RpcPacketDispatcherResult clientInputData(RpcConnection rpcConnection, CommandEnv cmdEnv, Map<String, Object> resultsMap) throws ConnectionException {
        String JOB_CMD_NAME = "job";
        String CHANGE_CMD_NAME = "change";
        String SUBMIT_CMD_NAME = "submit";
        String LABEL_CMD_NAME = "label";
        String CLIENT_CMD_NAME = "client";
        String BRANCH_CMD_NAME = "branch";
        String SHELVE_CMD_NAME = "shelve";
        String USER_CMD_NAME = "user";
        String GROUP_CMD_NAME = "group";
        String DEPOT_CMD_NAME = "depot";
        String ATTRIBUTE_CMD_NAME = "attribute";
        cmdEnv.newHandler();
        String confirm = (String)resultsMap.get("confirm");
        Map<String, Object> inMap = cmdEnv.getCmdSpec().getInMap();
        String inString = cmdEnv.getCmdSpec().getInString();
        HashMap<String, Object> respMap = new HashMap<String, Object>();
        if (inString == null) {
            StringBuffer strBuf = new StringBuffer();
            byte[] bytes = null;
            String cmdName = cmdEnv.getCmdSpec().getCmdName();
            if (cmdName == null) {
                throw new NullPointerError("null command name");
            }
            if (cmdName.equalsIgnoreCase("job")) {
                MapUnmapper.unmapJobMap(inMap, strBuf);
            } else if (cmdName.equalsIgnoreCase("change")) {
                MapUnmapper.unmapChangelistMap(inMap, strBuf);
            } else if (cmdName.equalsIgnoreCase("submit")) {
                MapUnmapper.unmapChangelistMap(inMap, strBuf);
            } else if (cmdName.equalsIgnoreCase("label")) {
                MapUnmapper.unmapLabelMap(inMap, strBuf);
            } else if (cmdName.equalsIgnoreCase("client")) {
                MapUnmapper.unmapClientMap(inMap, strBuf);
            } else if (cmdName.equalsIgnoreCase("branch")) {
                MapUnmapper.unmapBranchMap(inMap, strBuf);
            } else if (cmdName.equalsIgnoreCase("shelve")) {
                MapUnmapper.unmapChangelistMap(inMap, strBuf);
            } else if (cmdName.equalsIgnoreCase("user")) {
                MapUnmapper.unmapUserMap(inMap, strBuf);
            } else if (cmdName.equalsIgnoreCase("group")) {
                MapUnmapper.unmapUserGroupMap(inMap, strBuf);
            } else if (cmdName.equalsIgnoreCase("depot")) {
                MapUnmapper.unmapDepotMap(inMap, strBuf);
            } else if (cmdName.equalsIgnoreCase("attribute")) {
                InputStream inStream = (InputStream)inMap.get("attributeInstream");
                if (inStream == null) {
                    throw new NullPointerError("null input stream in getStreamBytes.inMap");
                }
                bytes = this.getStreamBytes(cmdName, inStream);
            }
            if (bytes != null) {
                respMap.put("data", bytes);
            } else {
                respMap.put("data", strBuf);
            }
        } else {
            respMap.put("data", inString);
        }
        if (resultsMap != null) {
            for (String key : resultsMap.keySet()) {
                if (key == null || key.equalsIgnoreCase("func")) continue;
                respMap.put(key, resultsMap.get(key));
            }
        }
        RpcPacket respPacket = RpcPacket.constructRpcPacket(confirm, respMap, null);
        rpcConnection.putRpcPacket(respPacket);
        return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
    }

    protected byte[] getStreamBytes(String cmdName, InputStream inStream) {
        try {
            byte[] bytes = new byte[8192];
            int bytesRead = 0;
            int bytePos = 0;
            while ((bytesRead = inStream.read(bytes, bytePos, bytes.length - bytePos)) > 0) {
                if ((bytePos += bytesRead) < bytes.length) continue;
                byte[] newBytes = new byte[bytes.length * 4];
                System.arraycopy(bytes, 0, newBytes, 0, bytes.length);
                bytes = newBytes;
            }
            byte[] retBytes = new byte[bytePos];
            System.arraycopy(bytes, 0, retBytes, 0, bytePos);
            return retBytes;
        }
        catch (Throwable thr) {
            Log.warn("problem reading input stream for user input for " + cmdName + " operation");
            Log.exception(thr);
            return null;
        }
    }
}

