/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.generic.core.file;

import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.impl.generic.core.file.PathAnnotations;

public class FilePath {
    protected String pathString = null;
    protected PathType pathType = PathType.UNKNOWN;

    public FilePath() {
    }

    public FilePath(PathType pathType, String pathString) {
        this(pathType, pathString, false);
    }

    public FilePath(PathType pathType, String pathString, boolean ignoreAnnotations) {
        this.pathType = pathType;
        this.pathString = ignoreAnnotations ? pathString : PathAnnotations.stripAnnotations(pathString);
    }

    public String annotate(PathAnnotations annotations) {
        if (annotations != null && this.pathString != null) {
            return this.pathString + annotations.toString();
        }
        return this.pathString;
    }

    public String annotate(IFileSpec fileSpec) {
        if (fileSpec != null && this.pathString != null) {
            return this.pathString + new PathAnnotations(fileSpec);
        }
        return this.pathString;
    }

    public PathType getPathType() {
        return this.pathType;
    }

    public String toString() {
        return this.pathString;
    }

    public String getPathString() {
        return this.pathString;
    }

    public void setPathString(String pathString) {
        this.pathString = pathString;
    }

    public void setPathType(PathType pathType) {
        this.pathType = pathType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PathType {
        UNKNOWN,
        ORIGINAL,
        DEPOT,
        CLIENT,
        LOCAL;

    }
}

