/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.generic.core;

import com.perforce.p4java.Log;
import com.perforce.p4java.client.IClient;
import com.perforce.p4java.client.IClientSummary;
import com.perforce.p4java.client.IClientViewMapping;
import com.perforce.p4java.core.IBranchMapping;
import com.perforce.p4java.core.IBranchSpec;
import com.perforce.p4java.core.IChangelist;
import com.perforce.p4java.core.IDepot;
import com.perforce.p4java.core.ILabel;
import com.perforce.p4java.core.ILabelMapping;
import com.perforce.p4java.core.IReviewSubscription;
import com.perforce.p4java.core.IUser;
import com.perforce.p4java.core.IUserGroup;
import com.perforce.p4java.core.ViewMap;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.impl.generic.client.ClientView;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InputMapper {
    public static Map<String, Object> map(IChangelist change, boolean allowUnknownFiles) {
        HashMap<String, Object> changeMap = new HashMap<String, Object>();
        if (change != null) {
            if (change.getId() == -1) {
                changeMap.put("Change", "new");
            } else {
                changeMap.put("Change", "" + change.getId());
            }
            changeMap.put("Description", change.getDescription());
            if (change.getClientId() != null) {
                changeMap.put("Client", change.getClientId());
            }
            if (change.getUsername() != null) {
                changeMap.put("User", change.getUsername());
            }
            if (change.getVisibility() != null) {
                changeMap.put("Type", change.getVisibility().toString().toLowerCase());
            }
            try {
                List<String> jobIdList;
                if ((allowUnknownFiles || change.getId() != -1) && change.getFiles(false) != null) {
                    int i = 0;
                    for (IFileSpec spec : change.getFiles(false)) {
                        changeMap.put("Files" + i++, spec.getDepotPathString());
                    }
                }
                if ((jobIdList = change.getJobIds()) != null && jobIdList.size() > 0) {
                    int i = 0;
                    for (String jobId : jobIdList) {
                        changeMap.put("Jobs" + i++, jobId);
                    }
                }
            }
            catch (P4JavaException exc) {
                Log.error("Unexpected exception in InputMapper.map(IChangelist change): " + exc.getLocalizedMessage());
            }
        }
        return changeMap;
    }

    public static Map<String, Object> map(IChangelist change) {
        return InputMapper.map(change, false);
    }

    public static Map<String, Object> map(IClient client) {
        HashMap<String, Object> clientMap = new HashMap<String, Object>();
        if (client != null) {
            clientMap.put("Client", client.getName());
            clientMap.put("Owner", client.getOwnerName());
            clientMap.put("Description", client.getDescription());
            if (client.getHostName() != null) {
                clientMap.put("Host", client.getHostName());
            }
            clientMap.put("Root", client.getRoot());
            if (client.getAlternateRoots() != null) {
                int i = 0;
                for (String altRoot : client.getAlternateRoots()) {
                    if (altRoot == null) continue;
                    clientMap.put("AltRoots" + i++, altRoot);
                }
            }
            if (client.getLineEnd() != null) {
                clientMap.put("LineEnd", client.getLineEnd().toString().toLowerCase(Locale.ENGLISH));
            }
            IClientSummary.IClientOptions opts = client.getOptions();
            IClientSummary.IClientSubmitOptions subOpts = client.getSubmitOptions();
            ClientView view = client.getClientView();
            if (opts != null) {
                String optStr = "" + (opts.isAllWrite() ? "allwrite " : "noallwrite ") + (opts.isClobber() ? "clobber " : "noclobber ") + (opts.isCompress() ? "compress " : "nocompress ") + (opts.isLocked() ? "locked " : "unlocked ") + (opts.isModtime() ? "modtime " : "nomodtime ") + (opts.isRmdir() ? "rmdir" : "normdir");
                clientMap.put("Options", optStr);
            }
            if (subOpts != null) {
                String subOptsStr = "";
                if (subOpts.isSubmitunchanged()) {
                    subOptsStr = "submitunchanged";
                } else if (subOpts.isSubmitunchangedReopen()) {
                    subOptsStr = "submitunchanged+reopen";
                } else if (subOpts.isLeaveunchanged()) {
                    subOptsStr = "leaveunchanged";
                } else if (subOpts.isLeaveunchangedReopen()) {
                    subOptsStr = "leaveunchanged+reopen";
                } else if (subOpts.isRevertunchanged()) {
                    subOptsStr = "revertunchanged";
                } else if (subOpts.isRevertunchangedReopen()) {
                    subOptsStr = "revertunchanged+reopen";
                }
                clientMap.put("SubmitOptions", subOptsStr);
            }
            if (view != null && view.getEntryList() != null) {
                List viewList = view.getEntryList();
                for (IClientViewMapping mapping : viewList) {
                    clientMap.put("View" + mapping.getOrder(), mapping.toString(" ", true));
                }
            }
        }
        return clientMap;
    }

    public static Map<String, Object> map(ILabel label) {
        String LOCKED = "locked";
        String UNLOCKED = "unlocked";
        HashMap<String, Object> labelMap = new HashMap<String, Object>();
        if (label != null) {
            List<ILabelMapping> viewMaps;
            labelMap.put("Label", label.getName());
            labelMap.put("Owner", label.getOwnerName());
            labelMap.put("Description", label.getDescription());
            labelMap.put("Options", label.isLocked() ? "locked" : "unlocked");
            if (label.getRevisionSpec() != null) {
                labelMap.put("Revision", label.getRevisionSpec());
            }
            if (label.getLastUpdate() != null) {
                labelMap.put("Update", label.getLastUpdate().toString());
            }
            if (label.getLastAccess() != null) {
                labelMap.put("Access", label.getLastAccess().toString());
            }
            if ((viewMaps = label.getViewMapping().getEntryList()) != null) {
                int i = 0;
                for (ILabelMapping mapping : viewMaps) {
                    labelMap.put("View" + i, mapping.getLeft());
                    ++i;
                }
            }
        }
        return labelMap;
    }

    public static Map<String, Object> map(IUser user) {
        HashMap<String, Object> userMap = new HashMap<String, Object>();
        if (user != null) {
            List<IReviewSubscription> reviewSubs;
            userMap.put("User", user.getLoginName());
            userMap.put("Email", user.getEmail());
            if (user.getFullName() != null) {
                userMap.put("FullName", user.getFullName());
            }
            if (user.getJobView() != null) {
                userMap.put("JobView", user.getJobView());
            }
            if (user.getPassword() != null) {
                userMap.put("Password", user.getPassword());
            }
            if (user.getType() != null) {
                userMap.put("Type", user.getType().toString().toLowerCase());
            }
            if (user.getReviewSubscriptions() != null && (reviewSubs = user.getReviewSubscriptions().getEntryList()) != null) {
                int i = 0;
                for (IReviewSubscription mapping : reviewSubs) {
                    userMap.put("Reviews" + i, mapping.getSubscription());
                    ++i;
                }
            }
        }
        return userMap;
    }

    public static Map<String, Object> map(IUserGroup group) {
        HashMap<String, Object> groupMap = new HashMap<String, Object>();
        if (group != null) {
            int i;
            if (group.getName() != null) {
                groupMap.put("Group", group.getName());
            }
            groupMap.put("MaxResults", InputMapper.getUGValue(group.getMaxResults()));
            groupMap.put("Timeout", InputMapper.getUGValue(group.getTimeout()));
            groupMap.put("MaxScanRows", InputMapper.getUGValue(group.getMaxScanRows()));
            groupMap.put("MaxLockTime", InputMapper.getUGValue(group.getMaxLockTime()));
            groupMap.put("PasswordTimeout", InputMapper.getUGValue(group.getPasswordTimeout()));
            if (group.getSubgroups() != null) {
                i = 0;
                for (String subGroup : group.getSubgroups()) {
                    groupMap.put("Subgroups" + i, subGroup);
                    ++i;
                }
            }
            if (group.getOwners() != null) {
                i = 0;
                for (String owner : group.getOwners()) {
                    groupMap.put("Owners" + i, owner);
                    ++i;
                }
            }
            if (group.getUsers() != null) {
                i = 0;
                for (String user : group.getUsers()) {
                    groupMap.put("Users" + i, user);
                    ++i;
                }
            }
        }
        return groupMap;
    }

    public static Map<String, Object> map(IBranchSpec branchSpec) {
        String LOCKED = "locked";
        String UNLOCKED = "unlocked";
        HashMap<String, Object> branchMap = new HashMap<String, Object>();
        if (branchSpec != null) {
            ViewMap<IBranchMapping> viewMaps;
            branchMap.put("Branch", branchSpec.getName());
            branchMap.put("Owner", branchSpec.getOwnerName());
            branchMap.put("Description", branchSpec.getDescription());
            branchMap.put("Options", branchSpec.isLocked() ? "locked" : "unlocked");
            if (branchSpec.getUpdated() != null) {
                branchMap.put("Update", branchSpec.getUpdated().toString());
            }
            if (branchSpec.getAccessed() != null) {
                branchMap.put("Access", branchSpec.getAccessed().toString());
            }
            if ((viewMaps = branchSpec.getBranchView()) != null) {
                for (IBranchMapping mapping : viewMaps.getEntryList()) {
                    if (mapping == null) continue;
                    branchMap.put("View" + mapping.getOrder(), mapping.toString(" ", true));
                }
            }
        }
        return branchMap;
    }

    public static Map<String, Object> map(IDepot depotSpec) {
        HashMap<String, Object> depotMap = new HashMap<String, Object>();
        if (depotSpec != null) {
            depotMap.put("Depot", depotSpec.getName());
            depotMap.put("Owner", depotSpec.getOwnerName());
            depotMap.put("Description", depotSpec.getDescription());
            if (depotSpec.getDepotType() != null) {
                depotMap.put("Type", depotSpec.getDepotType().toString().toLowerCase());
            }
            if (depotSpec.getModDate() != null) {
                depotMap.put("Date", depotSpec.getModDate());
            }
            if (depotSpec.getAddress() != null) {
                depotMap.put("Address", depotSpec.getAddress());
            }
            if (depotSpec.getSuffix() != null) {
                depotMap.put("Suffix", depotSpec.getSuffix());
            }
            depotMap.put("Map", depotSpec.getMap());
        }
        return depotMap;
    }

    private static String getUGValue(int val) {
        if (val == -1) {
            return "unlimited";
        }
        if (val == 0) {
            return "unset";
        }
        return "" + val;
    }
}

