/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.server;

import com.perforce.p4java.Log;
import com.perforce.p4java.admin.IDbSchema;
import com.perforce.p4java.admin.IProtectionEntry;
import com.perforce.p4java.client.IClient;
import com.perforce.p4java.client.IClientSummary;
import com.perforce.p4java.core.IBranchSpec;
import com.perforce.p4java.core.IBranchSpecSummary;
import com.perforce.p4java.core.IChangelist;
import com.perforce.p4java.core.IChangelistSummary;
import com.perforce.p4java.core.IDepot;
import com.perforce.p4java.core.IFileDiff;
import com.perforce.p4java.core.IFileLineMatch;
import com.perforce.p4java.core.IFix;
import com.perforce.p4java.core.IJob;
import com.perforce.p4java.core.IJobSpec;
import com.perforce.p4java.core.ILabel;
import com.perforce.p4java.core.ILabelSummary;
import com.perforce.p4java.core.IServerProcess;
import com.perforce.p4java.core.IUser;
import com.perforce.p4java.core.IUserGroup;
import com.perforce.p4java.core.IUserSummary;
import com.perforce.p4java.core.file.DiffType;
import com.perforce.p4java.core.file.FileDiff;
import com.perforce.p4java.core.file.FileSpecOpStatus;
import com.perforce.p4java.core.file.FileStatAncilliaryOptions;
import com.perforce.p4java.core.file.FileStatOutputOptions;
import com.perforce.p4java.core.file.IExtendedFileSpec;
import com.perforce.p4java.core.file.IFileAnnotation;
import com.perforce.p4java.core.file.IFileRevisionData;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.ConfigException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.NullPointerError;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.exception.RequestException;
import com.perforce.p4java.impl.generic.admin.DbSchema;
import com.perforce.p4java.impl.generic.admin.ProtectionEntry;
import com.perforce.p4java.impl.generic.core.BranchSpec;
import com.perforce.p4java.impl.generic.core.BranchSpecSummary;
import com.perforce.p4java.impl.generic.core.Changelist;
import com.perforce.p4java.impl.generic.core.ChangelistSummary;
import com.perforce.p4java.impl.generic.core.Depot;
import com.perforce.p4java.impl.generic.core.FileLineMatch;
import com.perforce.p4java.impl.generic.core.Fix;
import com.perforce.p4java.impl.generic.core.InputMapper;
import com.perforce.p4java.impl.generic.core.Job;
import com.perforce.p4java.impl.generic.core.JobSpec;
import com.perforce.p4java.impl.generic.core.Label;
import com.perforce.p4java.impl.generic.core.LabelSummary;
import com.perforce.p4java.impl.generic.core.ServerProcess;
import com.perforce.p4java.impl.generic.core.User;
import com.perforce.p4java.impl.generic.core.UserGroup;
import com.perforce.p4java.impl.generic.core.UserSummary;
import com.perforce.p4java.impl.generic.core.file.ExtendedFileSpec;
import com.perforce.p4java.impl.generic.core.file.FileAnnotation;
import com.perforce.p4java.impl.generic.core.file.FileRevisionData;
import com.perforce.p4java.impl.generic.core.file.FileSpec;
import com.perforce.p4java.impl.mapbased.client.Client;
import com.perforce.p4java.impl.mapbased.client.ClientSummary;
import com.perforce.p4java.impl.mapbased.rpc.RpcPropertyDefs;
import com.perforce.p4java.impl.mapbased.server.IServerControl;
import com.perforce.p4java.impl.mapbased.server.Parameters;
import com.perforce.p4java.impl.mapbased.server.ServerInfo;
import com.perforce.p4java.option.Options;
import com.perforce.p4java.option.UsageOptions;
import com.perforce.p4java.option.server.CounterOptions;
import com.perforce.p4java.option.server.DeleteBranchSpecOptions;
import com.perforce.p4java.option.server.DeleteClientOptions;
import com.perforce.p4java.option.server.DeleteLabelOptions;
import com.perforce.p4java.option.server.DescribeOptions;
import com.perforce.p4java.option.server.ExportRecordsOptions;
import com.perforce.p4java.option.server.FixJobsOptions;
import com.perforce.p4java.option.server.GetBranchSpecsOptions;
import com.perforce.p4java.option.server.GetChangelistDiffsOptions;
import com.perforce.p4java.option.server.GetChangelistsOptions;
import com.perforce.p4java.option.server.GetClientTemplateOptions;
import com.perforce.p4java.option.server.GetClientsOptions;
import com.perforce.p4java.option.server.GetDepotFilesOptions;
import com.perforce.p4java.option.server.GetDirectoriesOptions;
import com.perforce.p4java.option.server.GetExtendedFilesOptions;
import com.perforce.p4java.option.server.GetFileAnnotationsOptions;
import com.perforce.p4java.option.server.GetFileContentsOptions;
import com.perforce.p4java.option.server.GetFileDiffsOptions;
import com.perforce.p4java.option.server.GetFixesOptions;
import com.perforce.p4java.option.server.GetInterchangesOptions;
import com.perforce.p4java.option.server.GetJobsOptions;
import com.perforce.p4java.option.server.GetLabelsOptions;
import com.perforce.p4java.option.server.GetProtectionEntriesOptions;
import com.perforce.p4java.option.server.GetReviewsOptions;
import com.perforce.p4java.option.server.GetRevisionHistoryOptions;
import com.perforce.p4java.option.server.GetSubmittedIntegrationsOptions;
import com.perforce.p4java.option.server.GetUserGroupsOptions;
import com.perforce.p4java.option.server.GetUsersOptions;
import com.perforce.p4java.option.server.LoginOptions;
import com.perforce.p4java.option.server.MatchingLinesOptions;
import com.perforce.p4java.option.server.MoveFileOptions;
import com.perforce.p4java.option.server.OpenedFilesOptions;
import com.perforce.p4java.option.server.TagFilesOptions;
import com.perforce.p4java.option.server.UpdateUserGroupOptions;
import com.perforce.p4java.option.server.UpdateUserOptions;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.IServer;
import com.perforce.p4java.server.IServerInfo;
import com.perforce.p4java.server.PerforceCharsets;
import com.perforce.p4java.server.ServerStatus;
import com.perforce.p4java.server.callback.ICommandCallback;
import com.perforce.p4java.server.callback.IProgressCallback;
import com.perforce.p4java.server.callback.ISSOCallback;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Server
implements IServerControl,
IOptionsServer {
    public static final String SCREEN_NAME_FIELD_NAME = "SCREEN_NAME";
    public static final String IMPL_COMMENTS_FIELD_NAME = "IMPL_COMMENTS";
    public static final String IMPL_TYPE_FIELD_NAME = "IMPL_TYPE";
    public static final String MINIMUM_SUPPORTED_SERVER_LEVEL_FIELD_NAME = "MINIMUM_SUPPORTED_SERVER_LEVEL";
    public static final String PROTOCOL_NAME_FIELD_NAME = "PROTOCOL_NAME";
    public static final String DEFAULT_STATUS_FIELD_NAME = "DEFAULT_STATUS";
    protected static final String CORE_AUTH_FAIL_STRING_1 = "Perforce password (P4PASSWD)";
    protected static final String CORE_AUTH_FAIL_STRING_2 = "Access for user";
    protected static final String CORE_AUTH_FAIL_STRING_3 = "Your session has expired";
    protected static final String CORE_AUTH_FAIL_STRING_4 = "Your session was logged out";
    public static final String P4TICKETS_ENV_VAR = "P4TICKETS";
    public static final String P4TICKETS_DEFAULT_WINDOWS = "p4tickets.txt";
    public static final String P4TICKETS_DEFAULT_OTHER = ".p4tickets";
    protected UsageOptions usageOptions = null;
    protected static final int UNKNOWN_SERVER_VERSION = -1;
    protected static final String UNKNOWN_SERVER_HOST = null;
    protected static final int UNKNOWN_SERVER_PORT = -1;
    protected ServerStatus status = ServerStatus.UNKNOWN;
    protected Properties props = null;
    protected boolean caseSensitive = true;
    protected int serverVersion = -1;
    protected String serverHost = UNKNOWN_SERVER_HOST;
    protected int serverPort = -1;
    protected String userName = null;
    protected String password = null;
    protected String authTicket = null;
    protected IClient client = null;
    protected String clientName = null;
    protected String clientUnsetName = "noclient";
    protected boolean setupOnConnect = false;
    protected boolean loginOnConnect = false;
    protected ICommandCallback commandCallback = null;
    protected IProgressCallback progressCallback = null;
    protected ISSOCallback ssoCallback = null;
    protected String ssoKey = null;
    protected String charsetName = null;
    protected Charset charset = null;
    protected boolean connected = false;
    protected int minumumSupportedServerVersion = 20052;
    protected String tmpDirName = null;
    protected AtomicInteger nextCmdCallBackKey = new AtomicInteger();
    protected AtomicInteger nextProgressCallbackKey = new AtomicInteger();
    protected static boolean isRunningOnWindows = false;

    @Override
    public ICommandCallback registerCallback(ICommandCallback callback) {
        ICommandCallback oldCallback = this.commandCallback;
        this.commandCallback = callback;
        return oldCallback;
    }

    @Override
    public IProgressCallback registerProgressCallback(IProgressCallback progressCallback) {
        IProgressCallback oldCallback = this.progressCallback;
        this.progressCallback = progressCallback;
        return oldCallback;
    }

    @Override
    public ISSOCallback registerSSOCallback(ISSOCallback callback, String ssoKey) {
        ISSOCallback oldCallback = this.ssoCallback;
        this.ssoCallback = callback;
        this.ssoKey = ssoKey;
        return oldCallback;
    }

    @Override
    public ServerStatus getStatus() {
        return this.status;
    }

    @Override
    public int getServerVersionNumber() {
        return this.serverVersion;
    }

    @Override
    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean setCharsetName(String charsetName) throws UnsupportedCharsetException {
        if (charsetName != null && !PerforceCharsets.isSupported(charsetName)) {
            throw new UnsupportedCharsetException(charsetName);
        }
        this.charsetName = charsetName;
        if (this.charsetName != null) {
            if (!Charset.isSupported(charsetName = PerforceCharsets.getJavaCharsetName(charsetName))) return false;
            this.charset = Charset.forName(charsetName);
            return true;
        } else {
            this.charset = null;
        }
        return true;
    }

    @Override
    public String getCharsetName() {
        return this.charsetName;
    }

    @Override
    public boolean supportsUnicode() throws ConnectionException, RequestException, AccessException {
        IServerInfo info = this.getServerInfo();
        if (info != null) {
            return info.isUnicodeEnabled();
        }
        return false;
    }

    @Override
    public String[] getKnownCharsets() {
        return PerforceCharsets.getKnownCharsets();
    }

    @Override
    public Properties getProperties() {
        return this.props;
    }

    @Override
    public ServerStatus init(String host, int port, Properties props) throws ConfigException, ConnectionException {
        return this.init(host, port, props, null);
    }

    @Override
    public ServerStatus init(String host, int port, Properties props, UsageOptions opts) throws ConfigException, ConnectionException {
        this.serverHost = host;
        this.serverPort = port;
        this.props = props != null ? props : new Properties();
        this.usageOptions = opts == null ? new UsageOptions(this.props) : opts;
        this.tmpDirName = RpcPropertyDefs.getProperty(this.props, "com.perforce.p4java.tmpDir", System.getProperty("java.io.tmpdir"));
        if (this.tmpDirName == null) {
            this.tmpDirName = "/tmp";
            Log.warn("Unable to get tmp name from P4 props or System; using " + this.tmpDirName + " instead");
        }
        Log.info("Using program name: '" + this.getUsageOptions().getProgramName() + "'; progam version: '" + this.getUsageOptions().getProgramVersion() + "'");
        Log.info("Using tmp file directory: " + this.tmpDirName);
        this.userName = this.props.getProperty("userName", this.props.getProperty("com.perforce.p4java.userName", null));
        this.password = this.props.getProperty("password", this.props.getProperty("com.perforce.p4java.password", null));
        this.clientName = this.props.getProperty("clientName", this.props.getProperty("com.perforce.p4java.clientName", null));
        this.setupOnConnect = this.props.getProperty("autoConnect", this.props.getProperty("com.perforce.p4java.autoConnect", null)) != null;
        this.loginOnConnect = this.props.getProperty("autoLogin", this.props.getProperty("com.perforce.p4java.autoLogin", null)) != null;
        return this.status;
    }

    @Override
    public void connect() throws ConnectionException, AccessException, RequestException, ConfigException {
        this.connected = true;
        this.status = ServerStatus.READY;
        Log.info("connected to Perforce server at " + this.serverHost + ":" + this.serverPort);
        int serverVersion = this.getServerVersion();
        if (serverVersion == -1) {
            throw new ConnectionException("Unable to determine Perforce server version for connection; check network connection, connection character set setting, and / or server status");
        }
        if (serverVersion < this.minumumSupportedServerVersion) {
            throw new ConnectionException("Attempted to connect to an unsupported Perforce server version; target server version: " + serverVersion + "; minimum supported version: " + this.minumumSupportedServerVersion);
        }
        if (this.loginOnConnect && this.userName != null && this.password != null) {
            this.login(this.password);
        }
        if (this.setupOnConnect && this.clientName != null) {
            this.client = this.getClient(this.clientName);
        }
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public void disconnect() throws ConnectionException, AccessException {
        this.connected = false;
        this.status = ServerStatus.DISCONNECTED;
        Log.info("disconnected from Perforce server at " + this.serverHost + ":" + this.serverPort);
    }

    @Override
    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public void setAuthTicket(String authTicket) {
        this.authTicket = authTicket;
    }

    @Override
    public String getAuthTicket() {
        return this.authTicket;
    }

    @Override
    public IServerInfo getServerInfo() throws ConnectionException, RequestException, AccessException {
        Map<String, Object>[] resultsMap = this.execMapCmd(CmdSpec.INFO, new String[0], null);
        if (resultsMap != null && resultsMap.length > 0) {
            return new ServerInfo(resultsMap[0]);
        }
        return new ServerInfo();
    }

    @Override
    public void login(String password) throws ConnectionException, RequestException, AccessException, ConfigException {
        this.login(password, false);
    }

    @Override
    public void login(String password, boolean allHosts) throws ConnectionException, RequestException, AccessException, ConfigException {
        try {
            this.login(password, new LoginOptions().setAllHosts(allHosts));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public String getLoginStatus() throws P4JavaException {
        String statusStr = null;
        Map<String, Object>[] resultsMap = this.execMapCmd(CmdSpec.LOGIN, new String[]{"-s"}, null);
        if (resultsMap != null && resultsMap.length > 0 && (statusStr = this.getInfoStr(resultsMap[0])) == null) {
            statusStr = this.getErrorStr(resultsMap[0]);
        }
        return statusStr == null ? "" : statusStr;
    }

    @Override
    public void login(String password, LoginOptions opts) throws P4JavaException {
        if (password != null) {
            password = password + "\n";
        }
        HashMap<String, Object> pwdMap = new HashMap<String, Object>();
        pwdMap.put("password", password);
        Map<String, Object>[] resultsMap = this.execMapCmd(CmdSpec.LOGIN, Parameters.processParameters(opts, this), pwdMap);
        if (resultsMap[0] != null) {
            this.handleErrorStr(resultsMap[0]);
        }
    }

    @Override
    public void logout() throws ConnectionException, RequestException, AccessException, ConfigException {
        try {
            this.logout(new LoginOptions());
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public void logout(LoginOptions opts) throws P4JavaException {
        if (this.authTicket == null) {
            return;
        }
        Map<String, Object>[] resultsMap = this.execMapCmd(CmdSpec.LOGOUT, new String[0], null);
        this.authTicket = null;
    }

    @Override
    public List<IClientSummary> getClients(String userName, String queryString, int maxResults) throws ConnectionException, RequestException, AccessException {
        if (userName != null && this.getServerVersion() < 20062) {
            throw new RequestException("user restrictions for client lists are not supported by this version of the Perforce server", 37, 3);
        }
        if (queryString != null && this.getServerVersion() < 20081) {
            throw new RequestException("query expressions for client lists are not supported by this version of the Perforce server", 37, 3);
        }
        if (maxResults > 0 && this.getServerVersion() < 20061) {
            throw new RequestException("user restrictions for client lists are not supported by this version of the Perforce server", 37, 3);
        }
        try {
            return this.getClients(new GetClientsOptions().setMaxResults(maxResults).setUserName(userName).setNameFilter(queryString));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public List<IClientSummary> getClients(GetClientsOptions opts) throws P4JavaException {
        Map<String, Object>[] resultsMap = this.execMapCmd(CmdSpec.CLIENTS, Parameters.processParameters(opts, this), null);
        if (resultsMap == null) {
            throw new P4JavaError("Null resultsMap in getClientList call");
        }
        ArrayList<IClientSummary> specList = new ArrayList<IClientSummary>();
        for (Map<String, Object> map : resultsMap) {
            String errStr = this.getErrorStr(map);
            if (errStr != null) {
                throw new RequestException(errStr, this.getGenericCode(map), this.getSeverityCode(map));
            }
            specList.add(new ClientSummary(map, true));
        }
        return specList;
    }

    @Override
    public List<ILabelSummary> getLabels(String user, int maxLabels, String nameFilter, List<IFileSpec> fileList) throws ConnectionException, RequestException, AccessException {
        if (user != null && this.getServerVersion() < 20062) {
            throw new RequestException("user restrictions for label lists are not supported by this version of the Perforce server", 37, 3);
        }
        if (maxLabels > 0 && this.getServerVersion() < 20061) {
            throw new RequestException("max limit for label lists are not supported by this version of the Perforce server", 37, 3);
        }
        if (nameFilter != null && this.getServerVersion() < 20081) {
            throw new RequestException("query expressions for label lists are not supported by this version of the Perforce server", 37, 3);
        }
        try {
            return this.getLabels(fileList, new GetLabelsOptions().setMaxResults(maxLabels).setUserName(user).setNameFilter(nameFilter));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public List<ILabelSummary> getLabels(List<IFileSpec> fileList, GetLabelsOptions opts) throws P4JavaException {
        ArrayList<ILabelSummary> labelList = new ArrayList<ILabelSummary>();
        Map<String, Object>[] resultsMaps = this.execMapCmd(CmdSpec.LABELS, Parameters.processParameters(opts, fileList, this), null);
        if (resultsMaps != null) {
            for (Map<String, Object> map : resultsMaps) {
                if (map == null || this.handleErrorStr(map)) continue;
                labelList.add(new LabelSummary(map));
            }
        }
        return labelList;
    }

    @Override
    public ILabel getLabel(String labelName) throws ConnectionException, RequestException, AccessException {
        if (labelName == null) {
            throw new NullPointerError("Null label name passed to ServerImpl.labelName");
        }
        String OFLAG = "-o";
        Map<String, Object>[] resultsMaps = this.execMapCmd(CmdSpec.LABEL, new String[]{"-o", labelName}, null);
        Label label = null;
        if (resultsMaps == null) {
            Log.warn("Unexpected null map array returned to ServerImpl.getLabel()");
        } else {
            for (Map<String, Object> map : resultsMaps) {
                if (map == null) continue;
                this.handleErrorStr(map);
                if (this.isInfoMessage(map) || !map.containsKey("Update") && !map.containsKey("Access")) continue;
                label = new Label(map, this);
            }
        }
        return label;
    }

    @Override
    public String createLabel(ILabel label) throws ConnectionException, RequestException, AccessException {
        if (label == null) {
            throw new NullPointerError("null label passed to ServerImpl.newLabel()");
        }
        Map<String, Object>[] retMaps = this.execMapCmd(CmdSpec.LABEL, new String[]{"-i"}, InputMapper.map(label));
        String retStr = null;
        if (retMaps != null) {
            for (Map<String, Object> map : retMaps) {
                this.handleErrorStr(map);
                if (!this.isInfoMessage(map)) continue;
                retStr = retStr == null ? this.getInfoStr(map) : retStr + "\n" + this.getInfoStr(map);
            }
        } else {
            Log.warn("null return map array in ServerImpl.newLabel");
        }
        return retStr;
    }

    @Override
    public String deleteLabel(String labelName, boolean force) throws ConnectionException, RequestException, AccessException {
        try {
            return this.deleteLabel(labelName, new DeleteLabelOptions().setForce(force));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public String deleteLabel(String labelName, DeleteLabelOptions opts) throws P4JavaException {
        if (labelName == null) {
            throw new NullPointerError("null label name passed to Server.deleteLabel()");
        }
        Map<String, Object>[] retMaps = this.execMapCmd(CmdSpec.LABEL, Parameters.processParameters((Options)opts, null, new String[]{"-d", labelName}, (IServer)this), null);
        String retStr = null;
        if (retMaps != null) {
            for (Map<String, Object> map : retMaps) {
                this.handleErrorStr(map);
                if (!this.isInfoMessage(map)) continue;
                retStr = retStr == null ? this.getInfoStr(map) : retStr + "\n" + this.getInfoStr(map);
            }
        } else {
            Log.warn("null return map array in Server.deleteLabel");
        }
        return retStr;
    }

    @Override
    public String updateLabel(ILabel label) throws ConnectionException, RequestException, AccessException {
        if (label == null) {
            throw new NullPointerError("null label passed to ServerImpl.updateLabel()");
        }
        Map<String, Object>[] retMaps = this.execMapCmd(CmdSpec.LABEL, new String[]{"-i"}, InputMapper.map(label));
        String retVal = null;
        if (retMaps != null) {
            for (Map<String, Object> map : retMaps) {
                this.handleErrorStr(map);
                retVal = retVal == null ? this.getInfoStr(map) : retVal + "\n" + this.getInfoStr(map);
            }
        } else {
            Log.warn("null return map array in ServerImpl.updateLabel");
        }
        return retVal;
    }

    @Override
    public List<IFileSpec> getDepotFiles(List<IFileSpec> fileSpecs, boolean allRevs) throws ConnectionException, AccessException {
        try {
            return this.getDepotFiles(fileSpecs, new GetDepotFilesOptions().setAllRevs(allRevs));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            Log.warn("Unexpected exception in IServer.getDepotFiles: " + exc);
            return new ArrayList<IFileSpec>();
        }
    }

    @Override
    public List<IFileSpec> getDepotFiles(List<IFileSpec> fileSpecs, GetDepotFilesOptions opts) throws P4JavaException {
        if (fileSpecs == null) {
            throw new NullPointerError("Null file specification list passed to getDepotFiles");
        }
        ArrayList<IFileSpec> fileList = new ArrayList<IFileSpec>();
        Map<String, Object>[] resultsMap = this.execMapCmd(CmdSpec.FILES, Parameters.processParameters(opts, fileSpecs, this), null);
        if (resultsMap != null) {
            for (Map<String, Object> map : resultsMap) {
                fileList.add(this.handleFileReturn(map));
            }
        }
        return fileList;
    }

    @Override
    public List<IFileAnnotation> getFileAnnotations(List<IFileSpec> fileSpecs, DiffType wsOpts, boolean allResults, boolean useChangeNumbers, boolean followBranches) throws ConnectionException, RequestException, AccessException {
        if (wsOpts != null && !wsOpts.isWsOption()) {
            throw new RequestException("Bad whitespace option in getFileAnnotations");
        }
        try {
            return this.getFileAnnotations(fileSpecs, new GetFileAnnotationsOptions().setAllResults(allResults).setUseChangeNumbers(useChangeNumbers).setFollowBranches(followBranches).setWsOpts(wsOpts));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public List<IFileAnnotation> getFileAnnotations(List<IFileSpec> fileSpecs, GetFileAnnotationsOptions opts) throws P4JavaException {
        ArrayList<IFileAnnotation> returnList = new ArrayList<IFileAnnotation>();
        Map<String, Object>[] retMaps = this.execMapCmd(CmdSpec.ANNOTATE, Parameters.processParameters(opts, fileSpecs, this), null);
        if (retMaps != null) {
            String depotFile = null;
            for (Map<String, Object> map : retMaps) {
                if (map == null) continue;
                String errStr = this.getErrorOrInfoStr(map);
                if (errStr != null) {
                    throw new RequestException(errStr, this.getGenericCode(map), this.getSeverityCode(map));
                }
                if (map.containsKey("depotFile")) {
                    depotFile = (String)map.get("depotFile");
                    continue;
                }
                returnList.add(new FileAnnotation(map, depotFile, this.client == null ? null : this.client.getLineEnd()));
            }
        }
        return returnList;
    }

    @Override
    public List<IFileSpec> tagFiles(List<IFileSpec> fileSpecs, String labelName, boolean listOnly, boolean delete) throws ConnectionException, RequestException, AccessException {
        try {
            return this.tagFiles(fileSpecs, labelName, new TagFilesOptions().setDelete(delete).setListOnly(listOnly));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            Log.warn("Unexpected exception in IServer.getDepotFiles: " + exc);
            return new ArrayList<IFileSpec>();
        }
    }

    @Override
    public List<IFileSpec> tagFiles(List<IFileSpec> fileSpecs, String labelName, TagFilesOptions opts) throws P4JavaException {
        String labelOpt = labelName == null ? null : "-l" + labelName;
        Map<String, Object>[] retMaps = this.execMapCmd(CmdSpec.TAG, Parameters.processParameters((Options)opts, fileSpecs, labelOpt, (IServer)this), null);
        ArrayList<IFileSpec> fileList = new ArrayList<IFileSpec>();
        if (retMaps != null) {
            for (Map<String, Object> map : retMaps) {
                fileList.add(this.handleFileReturn(map));
            }
        } else {
            Log.warn("null return map array in ServerImpl.tagFiles");
        }
        return fileList;
    }

    @Override
    public List<IUserSummary> getReviews(int changelistId, List<IFileSpec> fileSpecs) throws ConnectionException, RequestException, AccessException {
        try {
            return this.getReviews(fileSpecs, new GetReviewsOptions(changelistId));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public List<IUserSummary> getReviews(List<IFileSpec> fileSpecs, GetReviewsOptions opts) throws P4JavaException {
        ArrayList<IUserSummary> userList = new ArrayList<IUserSummary>();
        Map<String, Object>[] retMaps = this.execMapCmd(CmdSpec.REVIEWS, Parameters.processParameters(opts, fileSpecs, this), null);
        if (retMaps != null) {
            for (Map<String, Object> map : retMaps) {
                this.handleErrorStr(map);
                try {
                    userList.add(new UserSummary((String)map.get("user"), (String)map.get("email"), (String)map.get("name"), null, null));
                }
                catch (Throwable thr) {
                    Log.error("Unexpected exception in getReviews: " + thr.getLocalizedMessage());
                    Log.exception(thr);
                }
            }
        }
        return userList;
    }

    @Override
    public List<IFileSpec> moveFile(int changeListId, boolean listOnly, boolean noClientMove, String fileType, IFileSpec fromFile, IFileSpec toFile) throws ConnectionException, RequestException, AccessException {
        int MIN_SUPPORTED_SERVER = 20091;
        int MIN_SUPPORTED_SERVER_OPTION_K = 20092;
        if (this.serverVersion < 20091) {
            throw new RequestException("command requires a Perforce server version 2009.1 or later");
        }
        if (this.serverVersion < 20092 && noClientMove) {
            throw new RequestException("command option noClientMove requires a Perforce server version 2009.2 or later");
        }
        try {
            return this.moveFile(fromFile, toFile, new MoveFileOptions().setChangelistId(changeListId).setFileType(fileType).setForce(false).setListOnly(listOnly).setNoClientMove(noClientMove));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            Log.warn("Unexpected exception in IServer.moveFile: " + exc);
            return new ArrayList<IFileSpec>();
        }
    }

    @Override
    public List<IFileSpec> moveFile(IFileSpec fromFile, IFileSpec toFile, MoveFileOptions opts) throws P4JavaException {
        if (fromFile == null || toFile == null) {
            throw new RequestException("command requires both to and from files to be specified");
        }
        ArrayList<IFileSpec> fileList = new ArrayList<IFileSpec>();
        Map<String, Object>[] resultsArray = this.execMapCmd(CmdSpec.MOVE, Parameters.processParameters((Options)opts, null, new String[]{fromFile.getPreferredPath().toString(), toFile.getPreferredPath().toString()}, (IServer)this), null);
        if (resultsArray != null) {
            for (Map<String, Object> map : resultsArray) {
                fileList.add(this.handleFileReturn(map));
            }
        }
        return fileList;
    }

    @Override
    public IUser getUser(String userName) throws ConnectionException, RequestException, AccessException {
        String[] args = null;
        args = userName == null ? new String[]{"-o"} : new String[]{"-o", userName};
        Map<String, Object>[] resultsArray = this.execMapCmd(CmdSpec.USER, args, null);
        if (resultsArray != null) {
            for (Map<String, Object> map : resultsArray) {
                this.handleErrorStr(map);
                if (this.isInfoMessage(map) || !map.containsKey("Update") && !map.containsKey("Access")) continue;
                return new User(map, this);
            }
        }
        return null;
    }

    @Override
    public String createUser(IUser user, boolean force) throws ConnectionException, RequestException, AccessException {
        if (user == null) {
            throw new NullPointerError("Null user passed to IServer.createUser");
        }
        return this.updateUser(user, force);
    }

    @Override
    public String createUser(IUser user, UpdateUserOptions opts) throws P4JavaException {
        return this.updateUser(user, opts);
    }

    @Override
    public String updateUser(IUser user, boolean force) throws ConnectionException, RequestException, AccessException {
        try {
            return this.updateUser(user, new UpdateUserOptions(force));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public String updateUser(IUser user, UpdateUserOptions opts) throws P4JavaException {
        if (user == null) {
            throw new NullPointerError("Null user passed to IServer.updateUser");
        }
        if (user.getLoginName() == null) {
            throw new NullPointerError("Null user name in user passed to IServer.updateUser");
        }
        Map<String, Object>[] retMaps = this.execMapCmd(CmdSpec.USER, Parameters.processParameters((Options)opts, null, "-i", (IServer)this), InputMapper.map(user));
        String retVal = null;
        if (retMaps != null) {
            for (Map<String, Object> map : retMaps) {
                this.handleErrorStr(map);
                retVal = retVal == null ? this.getInfoStr(map) : retVal + "\n" + this.getInfoStr(map);
            }
        } else {
            Log.warn("null return map array in Server.updateUser");
        }
        return retVal;
    }

    @Override
    public String deleteUser(String userName, boolean force) throws ConnectionException, RequestException, AccessException {
        try {
            return this.deleteUser(userName, new UpdateUserOptions(force));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public String deleteUser(String userName, UpdateUserOptions opts) throws P4JavaException {
        if (userName == null) {
            throw new NullPointerError("Null user name passed to IServer.deleteUser");
        }
        Map<String, Object>[] retMaps = this.execMapCmd(CmdSpec.USER, Parameters.processParameters((Options)opts, null, new String[]{"-d", userName}, (IServer)this), null);
        String retStr = null;
        if (retMaps != null) {
            for (Map<String, Object> map : retMaps) {
                this.handleErrorStr(map);
                if (!this.isInfoMessage(map)) continue;
                retStr = retStr == null ? this.getInfoStr(map) : retStr + "\n" + this.getInfoStr(map);
            }
        } else {
            Log.warn("null return map array in Server.deleteUser");
        }
        return retStr;
    }

    @Override
    public List<IUserSummary> getUsers(List<String> userList, int maxUsers) throws ConnectionException, RequestException, AccessException {
        try {
            return this.getUsers(userList, new GetUsersOptions().setMaxUsers(maxUsers));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public List<IUserSummary> getUsers(List<String> userList, GetUsersOptions opts) throws P4JavaException {
        Map<String, Object>[] resultsArray;
        ArrayList<IUserSummary> resultsList = new ArrayList<IUserSummary>();
        String[] users = null;
        if (userList != null) {
            users = userList.toArray(new String[userList.size()]);
        }
        if ((resultsArray = this.execMapCmd(CmdSpec.USERS, Parameters.processParameters((Options)opts, null, users, (IServer)this), null)) != null) {
            for (Map<String, Object> map : resultsArray) {
                String errStr = this.getErrorOrInfoStr(map);
                if (errStr != null) continue;
                resultsList.add(new UserSummary(map, true));
            }
        }
        return resultsList;
    }

    @Override
    public List<IUserGroup> getUserGroups(String userOrGroupName, boolean indirect, boolean displayValues, int maxGroups) throws ConnectionException, RequestException, AccessException {
        try {
            return this.getUserGroups(userOrGroupName, new GetUserGroupsOptions().setIndirect(indirect).setDisplayValues(displayValues).setMaxGroups(maxGroups));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public List<IUserGroup> getUserGroups(String userOrGroupName, GetUserGroupsOptions opts) throws P4JavaException {
        ArrayList<IUserGroup> resultsList = new ArrayList<IUserGroup>();
        Map<String, Object>[] resultsArray = this.execMapCmd(CmdSpec.GROUPS, Parameters.processParameters((Options)opts, null, userOrGroupName, (IServer)this), null);
        if (resultsArray != null) {
            UserGroup ugImpl = null;
            ArrayList<String> userList = null;
            for (Map<String, Object> map : resultsArray) {
                this.handleErrorStr(map);
                String groupName = (String)map.get("group");
                if (groupName == null) continue;
                if (ugImpl == null) {
                    ugImpl = new UserGroup();
                    userList = new ArrayList<String>();
                    ugImpl.setName(groupName);
                } else if (!ugImpl.getName().equals(groupName)) {
                    ugImpl.setUsers(userList);
                    resultsList.add(ugImpl);
                    ugImpl = new UserGroup();
                    ugImpl.setName(groupName);
                    userList = new ArrayList();
                    ugImpl.setUsers(userList);
                }
                try {
                    String isSubGroup;
                    String userName = (String)map.get("user");
                    String maxScanRows = (String)map.get("maxScanRows");
                    String maxLockTime = (String)map.get("maxLockTime");
                    String timeout = (String)map.get("timeout");
                    String maxResults = (String)map.get("maxResults");
                    userList.add(userName);
                    String isOwner = (String)map.get("isOwner");
                    if (isOwner != null && isOwner.equalsIgnoreCase("1") && ugImpl.getOwners() == null) {
                        ugImpl.setOwners(new ArrayList<String>());
                        ugImpl.getOwners().add(userName);
                    }
                    if ((isSubGroup = (String)map.get("isSubGroup")) != null && isSubGroup.equals("1")) {
                        ugImpl.setSubGroup(true);
                    }
                    if (maxScanRows != null) {
                        ugImpl.setMaxScanRows(new Integer(maxScanRows));
                    }
                    if (maxLockTime != null) {
                        ugImpl.setMaxLockTime(new Integer(maxLockTime));
                    }
                    if (timeout != null) {
                        ugImpl.setTimeout(new Integer(timeout));
                    }
                    if (maxResults == null) continue;
                    ugImpl.setMaxResults(new Integer(maxResults));
                }
                catch (Throwable thr) {
                    Log.warn("Unexpected exception in ServerImpl.getUserGroupList: " + thr.getMessage());
                    Log.exception(thr);
                }
            }
            if (ugImpl != null) {
                ugImpl.setUsers(userList);
                resultsList.add(ugImpl);
            }
        }
        return resultsList;
    }

    @Override
    public IUserGroup getUserGroup(String name) throws ConnectionException, RequestException, AccessException {
        UserGroup ugImpl;
        block1: {
            Map<String, Object>[] arr$;
            int len$;
            int i$;
            if (name == null) {
                throw new NullPointerError("null group name passed to Server.getUserGroup");
            }
            Map<String, Object>[] resultsArray = this.execMapCmd(CmdSpec.GROUP, new String[]{"-o", name}, null);
            ugImpl = null;
            if (resultsArray == null || (i$ = 0) >= (len$ = (arr$ = resultsArray).length)) break block1;
            Map<String, Object> map = arr$[i$];
            this.handleErrorStr(map);
            ugImpl = new UserGroup(map);
        }
        return ugImpl;
    }

    @Override
    public String createUserGroup(IUserGroup group) throws ConnectionException, RequestException, AccessException {
        if (group == null) {
            throw new NullPointerError("Null group passed to IServer.createUserGroup method");
        }
        return this.updateUserGroup(group, false);
    }

    @Override
    public String updateUserGroup(IUserGroup group, boolean updateIfOwner) throws ConnectionException, RequestException, AccessException {
        try {
            return this.updateUserGroup(group, new UpdateUserGroupOptions().setUpdateIfOwner(updateIfOwner));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public String deleteUserGroup(IUserGroup group) throws ConnectionException, RequestException, AccessException {
        try {
            return this.deleteUserGroup(group, new UpdateUserGroupOptions());
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public String createUserGroup(IUserGroup group, UpdateUserGroupOptions opts) throws P4JavaException {
        return this.updateUserGroup(group, opts);
    }

    @Override
    public String updateUserGroup(IUserGroup group, UpdateUserGroupOptions opts) throws P4JavaException {
        if (group == null) {
            throw new NullPointerError("Null group passed to IServer.updateUserGroup method");
        }
        Map<String, Object>[] retMaps = this.execMapCmd(CmdSpec.GROUP, Parameters.processParameters((Options)opts, null, "-i", (IServer)this), InputMapper.map(group));
        String retVal = null;
        if (retMaps != null) {
            for (Map<String, Object> map : retMaps) {
                this.handleErrorStr(map);
                retVal = retVal == null ? this.getInfoStr(map) : retVal + "\n" + this.getInfoStr(map);
            }
        } else {
            Log.warn("null return map array in Server.updateUserGroup");
        }
        return retVal;
    }

    @Override
    public String deleteUserGroup(IUserGroup group, UpdateUserGroupOptions opts) throws P4JavaException {
        if (group == null) {
            throw new NullPointerError("Null group passed to IServer.deleteUserGroup method");
        }
        if (group.getName() == null) {
            throw new NullPointerError("Null group name in user group passed to IServer.deleteUserGroup method");
        }
        Map<String, Object>[] retMaps = this.execMapCmd(CmdSpec.GROUP, Parameters.processParameters((Options)opts, null, new String[]{"-d", group.getName()}, (IServer)this), null);
        String retVal = null;
        if (retMaps != null) {
            for (Map<String, Object> map : retMaps) {
                this.handleErrorStr(map);
                retVal = retVal == null ? this.getInfoStr(map) : retVal + "\n" + this.getInfoStr(map);
            }
        } else {
            Log.warn("null return map array in Server.deleteUserGroup");
        }
        return retVal;
    }

    @Override
    public List<IProtectionEntry> getProtectionEntries(boolean allUsers, String hostName, String userName, String groupName, List<IFileSpec> fileList) throws ConnectionException, RequestException, AccessException {
        try {
            return this.getProtectionEntries(fileList, new GetProtectionEntriesOptions().setAllUsers(allUsers).setHostName(hostName).setUserName(userName).setGroupName(groupName));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public List<IProtectionEntry> getProtectionEntries(List<IFileSpec> fileList, GetProtectionEntriesOptions opts) throws P4JavaException {
        ArrayList<IProtectionEntry> protectsList = new ArrayList<IProtectionEntry>();
        Map<String, Object>[] protectsMaps = this.execMapCmd(CmdSpec.PROTECTS, Parameters.processParameters((Options)opts, fileList, null, false, (IServer)this), null);
        if (protectsMaps != null) {
            int order = 0;
            for (Map<String, Object> map : protectsMaps) {
                if (map == null) continue;
                this.handleErrorStr(map);
                protectsList.add(new ProtectionEntry(map, order++));
            }
        }
        return protectsList;
    }

    @Override
    public List<IBranchSpecSummary> getBranchSpecs(String userName, String nameFilter, int maxReturns) throws ConnectionException, RequestException, AccessException {
        if (userName != null && this.getServerVersion() < 20062) {
            throw new RequestException("user restrictions for branch lists are not supported by this version of the Perforce server", 37, 3);
        }
        if (nameFilter != null && this.getServerVersion() < 20081) {
            throw new RequestException("query expressions for branch lists are not supported by this version of the Perforce server", 37, 3);
        }
        if (maxReturns > 0 && this.getServerVersion() < 20061) {
            throw new RequestException("max limit for branch lists are not supported by this version of the Perforce server", 37, 3);
        }
        try {
            return this.getBranchSpecs(new GetBranchSpecsOptions().setMaxResults(maxReturns).setNameFilter(nameFilter).setUserName(userName));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public List<IBranchSpecSummary> getBranchSpecs(GetBranchSpecsOptions opts) throws P4JavaException {
        ArrayList<IBranchSpecSummary> branchList = new ArrayList<IBranchSpecSummary>();
        Map<String, Object>[] branchMaps = this.execMapCmd(CmdSpec.BRANCHES, Parameters.processParameters(opts, this), null);
        if (branchMaps != null) {
            for (Map<String, Object> branchMap : branchMaps) {
                this.handleErrorStr(branchMap);
                branchList.add(new BranchSpecSummary(branchMap, true));
            }
        }
        return branchList;
    }

    @Override
    public IBranchSpec getBranchSpec(String name) throws ConnectionException, RequestException, AccessException {
        if (name == null) {
            throw new NullPointerError("Null branch spec name passed to getBranchSpec");
        }
        BranchSpec branchSpec = null;
        Map<String, Object>[] branchMaps = this.execMapCmd(CmdSpec.BRANCH, new String[]{"-o", name}, null);
        if (branchMaps != null) {
            for (Map<String, Object> map : branchMaps) {
                if (map == null) continue;
                this.handleErrorStr(map);
                if (this.isInfoMessage(map)) continue;
                branchSpec = new BranchSpec(map, this);
            }
        }
        return branchSpec;
    }

    @Override
    public String createBranchSpec(IBranchSpec branchSpec) throws ConnectionException, RequestException, AccessException {
        if (branchSpec == null) {
            throw new NullPointerError("null branch spec passed to ServerImpl.newBranchSpec()");
        }
        Map<String, Object>[] retMaps = this.execMapCmd(CmdSpec.BRANCH, new String[]{"-i"}, InputMapper.map(branchSpec));
        String retStr = null;
        if (retMaps != null) {
            for (Map<String, Object> map : retMaps) {
                this.handleErrorStr(map);
                if (!this.isInfoMessage(map)) continue;
                retStr = retStr == null ? this.getInfoStr(map) : retStr + "\n" + this.getInfoStr(map);
            }
        } else {
            Log.warn("null return map array in ServerImpl.newBranchSpec");
        }
        return retStr;
    }

    @Override
    public String updateBranchSpec(IBranchSpec branchSpec) throws ConnectionException, RequestException, AccessException {
        if (branchSpec == null) {
            throw new NullPointerError("null label passed to ServerImpl.updateBranchSpec()");
        }
        Map<String, Object>[] retMaps = this.execMapCmd(CmdSpec.BRANCH, new String[]{"-i"}, InputMapper.map(branchSpec));
        String retVal = null;
        if (retMaps != null) {
            for (Map<String, Object> map : retMaps) {
                this.handleErrorStr(map);
                retVal = retVal == null ? this.getInfoStr(map) : retVal + "\n" + this.getInfoStr(map);
            }
        } else {
            Log.warn("null return map array in ServerImpl.updateBranchSpec");
        }
        return retVal;
    }

    @Override
    public String deleteBranchSpec(String branchSpecName, boolean force) throws ConnectionException, RequestException, AccessException {
        try {
            return this.deleteBranchSpec(branchSpecName, new DeleteBranchSpecOptions(force));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public String deleteBranchSpec(String branchSpecName, DeleteBranchSpecOptions opts) throws P4JavaException {
        if (branchSpecName == null) {
            throw new NullPointerError("Null branch spec name passed to IServer.deleteBranchSpec method");
        }
        Map<String, Object>[] retMaps = this.execMapCmd(CmdSpec.BRANCH, Parameters.processParameters((Options)opts, null, new String[]{"-d", branchSpecName}, (IServer)this), null);
        String retVal = null;
        if (retMaps != null) {
            for (Map<String, Object> map : retMaps) {
                this.handleErrorStr(map);
                retVal = retVal == null ? this.getInfoStr(map) : retVal + "\n" + this.getInfoStr(map);
            }
        } else {
            Log.warn("null return map array in ServerImpl.deleteBranchSpec");
        }
        return retVal;
    }

    @Override
    public IClient getCurrentClient() {
        return this.client;
    }

    @Override
    public void setCurrentClient(IClient client) {
        this.client = client;
        this.clientName = this.client != null && client != null ? this.client.getName() : null;
    }

    @Override
    public IClient getClient(String clientName) throws ConnectionException, RequestException, AccessException {
        if (clientName == null) {
            throw new NullPointerError("Null client name passed to IServer.getClient()");
        }
        String[] args = new String[]{"-o", clientName};
        Map<String, Object>[] resultsMap = this.execMapCmd(CmdSpec.CLIENT, args, null);
        Client client = null;
        if (resultsMap != null) {
            for (Map<String, Object> map : resultsMap) {
                if (map == null) continue;
                this.handleErrorStr(map);
                if (this.isInfoMessage(map) || !map.containsKey("Update") && !map.containsKey("Access")) continue;
                client = new Client(this, map);
            }
        }
        return client;
    }

    @Override
    public IClient getClient(IClientSummary clientSummary) throws ConnectionException, RequestException, AccessException {
        if (clientSummary == null) {
            throw new NullPointerError("Null client summary passed to IServer.getClient()");
        }
        return this.getClient(clientSummary.getName());
    }

    @Override
    public IClient getClientTemplate(String clientName, boolean allowExistent) throws ConnectionException, RequestException, AccessException {
        try {
            return this.getClientTemplate(clientName, new GetClientTemplateOptions(allowExistent));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public IClient getClientTemplate(String clientName, GetClientTemplateOptions opts) throws P4JavaException {
        if (clientName == null) {
            throw new NullPointerError("Null client name passed to IServer.getClientTemplate()");
        }
        String[] args = new String[]{"-o", clientName};
        Map<String, Object>[] resultsMap = this.execMapCmd(CmdSpec.CLIENT, args, null);
        Client client = null;
        if (resultsMap != null) {
            for (Map<String, Object> map : resultsMap) {
                boolean nonExistent;
                if (map == null) continue;
                this.handleErrorStr(map);
                if (this.isInfoMessage(map)) continue;
                boolean bl = nonExistent = !map.containsKey("Update") && !map.containsKey("Access");
                if (!nonExistent && (opts == null || !opts.isAllowExistent())) continue;
                client = new Client(this, map);
            }
        }
        return client;
    }

    @Override
    public IClient getClientTemplate(String clientName) throws ConnectionException, RequestException, AccessException {
        return this.getClientTemplate(clientName, false);
    }

    @Override
    public String createClient(IClient newClient) throws ConnectionException, RequestException, AccessException {
        if (newClient == null) {
            throw new NullPointerError("Null new client spec in newClient method");
        }
        Map<String, Object>[] retMaps = this.execMapCmd(CmdSpec.CLIENT, new String[]{"-i"}, InputMapper.map(newClient));
        String retVal = null;
        if (retMaps != null) {
            for (Map<String, Object> map : retMaps) {
                this.handleErrorStr(map);
                if (!this.isInfoMessage(map)) continue;
                retVal = retVal == null ? this.getInfoStr(map) : retVal + " \n" + this.getInfoStr(map);
            }
        }
        return retVal;
    }

    @Override
    public String updateClient(IClient client) throws ConnectionException, RequestException, AccessException {
        if (client == null) {
            throw new NullPointerError("Null client in IServer.updateClient method");
        }
        Map<String, Object>[] retMaps = this.execMapCmd(CmdSpec.CLIENT, new String[]{"-i"}, InputMapper.map(client));
        String retVal = null;
        if (retMaps != null) {
            for (Map<String, Object> map : retMaps) {
                this.handleErrorStr(map);
                if (!this.isInfoMessage(map)) continue;
                retVal = retVal == null ? this.getInfoStr(map) : retVal + " \n" + this.getInfoStr(map);
            }
        }
        return retVal;
    }

    @Override
    public String deleteClient(String clientName, boolean force) throws ConnectionException, RequestException, AccessException {
        try {
            return this.deleteClient(clientName, new DeleteClientOptions(force));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public String deleteClient(String clientName, DeleteClientOptions opts) throws P4JavaException {
        if (clientName == null) {
            throw new NullPointerError("Null client name passed to ServerImpl.deleteClient");
        }
        Map<String, Object>[] retMaps = this.execMapCmd(CmdSpec.CLIENT, Parameters.processParameters((Options)opts, null, new String[]{"-d", clientName}, (IServer)this), null);
        String retVal = null;
        if (retMaps != null) {
            for (Map<String, Object> map : retMaps) {
                this.handleErrorStr(map);
                if (!this.isInfoMessage(map)) continue;
                retVal = retVal == null ? this.getInfoStr(map) : retVal + " \n" + this.getInfoStr(map);
            }
        }
        return retVal;
    }

    @Override
    public List<IDepot> getDepots() throws ConnectionException, RequestException, AccessException {
        Map<String, Object>[] resultsMap;
        ArrayList<IDepot> metadataArray = new ArrayList<IDepot>();
        for (Map<String, Object> map : resultsMap = this.execMapCmd(CmdSpec.DEPOTS, new String[0], null)) {
            if (this.handleErrorStr(map)) continue;
            try {
                metadataArray.add(new Depot(map));
            }
            catch (Exception exc) {
                Log.exception(exc);
                throw new P4JavaError("Unexpected conversion error in getDepotList: " + exc.getLocalizedMessage(), exc);
            }
        }
        return metadataArray;
    }

    @Override
    public List<IChangelistSummary> getChangelists(int maxMostRecent, List<IFileSpec> fileSpecs, String clientName, String userName, boolean includeIntegrated, IChangelist.Type type, boolean longDesc) throws ConnectionException, RequestException, AccessException {
        try {
            return this.getChangelists(fileSpecs, new GetChangelistsOptions().setClientName(clientName).setIncludeIntegrated(includeIntegrated).setLongDesc(longDesc).setMaxMostRecent(maxMostRecent).setType(type).setUserName(userName));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public List<IChangelistSummary> getChangelists(int maxMostRecent, List<IFileSpec> fileSpecs, String clientName, String userName, boolean includeIntegrated, boolean submittedOnly, boolean pendingOnly, boolean longDesc) throws ConnectionException, RequestException, AccessException {
        IChangelist.Type type = null;
        if (submittedOnly) {
            type = IChangelist.Type.SUBMITTED;
        } else if (pendingOnly) {
            type = IChangelist.Type.PENDING;
        }
        return this.getChangelists(maxMostRecent, fileSpecs, clientName, userName, includeIntegrated, type, longDesc);
    }

    @Override
    public List<IChangelistSummary> getChangelists(List<IFileSpec> fileSpecs, GetChangelistsOptions opts) throws P4JavaException {
        ArrayList<IChangelistSummary> changeListList = new ArrayList<IChangelistSummary>();
        Map<String, Object>[] resultsMap = this.execMapCmd(CmdSpec.CHANGES, Parameters.processParameters(opts, fileSpecs, this), null);
        if (resultsMap != null) {
            for (Map<String, Object> result : resultsMap) {
                if (this.handleErrorStr(result)) continue;
                try {
                    changeListList.add(new ChangelistSummary(result, true));
                }
                catch (Exception exc) {
                    Log.exception(exc);
                    throw new P4JavaError("Unexpected conversion error in getChangelist: " + exc.getLocalizedMessage(), exc);
                }
            }
        }
        return changeListList;
    }

    @Override
    public IChangelist getChangelist(int id) throws ConnectionException, RequestException, AccessException {
        Changelist changeList = null;
        String[] args = null;
        args = id == 0 ? new String[]{"-o"} : new String[]{"-o", "" + id};
        Map<String, Object>[] resultsMap = this.execMapCmd(CmdSpec.CHANGE, args, null);
        if (resultsMap != null) {
            for (Map<String, Object> map : resultsMap) {
                if (map == null) continue;
                this.handleErrorStr(map);
                if (this.isInfoMessage(map)) continue;
                changeList = new Changelist(map, this);
            }
        }
        return changeList;
    }

    @Override
    public String deletePendingChangelist(int id) throws ConnectionException, RequestException, AccessException {
        Map<String, Object>[] resultsMap = this.execMapCmd(CmdSpec.CHANGE, new String[]{"-d", "" + id}, null);
        String retVal = null;
        if (resultsMap != null) {
            for (Map<String, Object> map : resultsMap) {
                this.handleErrorStr(map);
                if (!this.isInfoMessage(map)) continue;
                retVal = retVal == null ? this.getInfoStr(map) : retVal + " \n" + this.getInfoStr(map);
            }
        }
        return retVal;
    }

    @Override
    public List<IFileSpec> getChangelistFiles(int id) throws ConnectionException, RequestException, AccessException {
        Map<String, Object>[] resultsMap = this.execMapCmd(CmdSpec.DESCRIBE, new String[]{"-s", "" + id}, null);
        ArrayList<IFileSpec> fileList = new ArrayList<IFileSpec>();
        if (resultsMap != null && resultsMap.length > 0 && resultsMap[0] != null) {
            Map<String, Object> map = resultsMap[0];
            int i = 0;
            while (map.get("rev" + i) != null) {
                FileSpec fSpec = new FileSpec(map, this, i);
                fSpec.setChangelistId(id);
                fileList.add(fSpec);
                ++i;
            }
        }
        return fileList;
    }

    @Override
    public InputStream getChangelistDiffs(int id, DiffType diffType) throws ConnectionException, RequestException, AccessException {
        return this.getChangelistDiffsStream(id, new DescribeOptions(diffType));
    }

    @Override
    public InputStream getChangelistDiffs(int id, GetChangelistDiffsOptions opts) throws P4JavaException {
        return this.execStreamCmd(CmdSpec.DESCRIBE, Parameters.processParameters((Options)opts, null, "" + id, (IServer)this));
    }

    @Override
    public InputStream getChangelistDiffsStream(int id, DescribeOptions options) throws ConnectionException, RequestException, AccessException {
        DiffType diffType = null;
        boolean shelvedDiffs = false;
        if (options != null) {
            diffType = options.getType();
            shelvedDiffs = options.isOutputShelvedDiffs();
        }
        if (shelvedDiffs && this.getServerVersion() < 20092) {
            throw new RequestException("Shelved file diffs are not supported by this version of the Perforce server", 37, 3);
        }
        try {
            GetChangelistDiffsOptions opts = new GetChangelistDiffsOptions();
            opts.setOutputShelvedDiffs(shelvedDiffs);
            if (diffType != null) {
                switch (diffType) {
                    case RCS_DIFF: {
                        opts.setRcsDiffs(true);
                        break;
                    }
                    case CONTEXT_DIFF: {
                        opts.setDiffContext(0);
                        break;
                    }
                    case SUMMARY_DIFF: {
                        opts.setSummaryDiff(true);
                        break;
                    }
                    case UNIFIED_DIFF: {
                        opts.setUnifiedDiff(0);
                        break;
                    }
                    case IGNORE_WS_CHANGES: {
                        opts.setIgnoreWhitespaceChanges(true);
                        break;
                    }
                    case IGNORE_WS: {
                        opts.setIgnoreWhitespace(true);
                        break;
                    }
                    case IGNORE_LINE_ENDINGS: {
                        opts.setIgnoreLineEndings(true);
                    }
                }
            }
            return this.getChangelistDiffs(id, opts);
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public Map<IFileSpec, List<IFileRevisionData>> getRevisionHistory(List<IFileSpec> fileSpecs, int maxRevs, boolean contentHistory, boolean includeInherited, boolean longOutput, boolean truncatedLongOutput) throws ConnectionException, AccessException {
        try {
            return this.getRevisionHistory(fileSpecs, new GetRevisionHistoryOptions().setContentHistory(contentHistory).setIncludeInherited(includeInherited).setLongOutput(longOutput).setTruncatedLongOutput(truncatedLongOutput).setMaxRevs(maxRevs));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            Log.warn("Unexpected exception in IServer.getRevisionHistory: " + exc);
            return new HashMap<IFileSpec, List<IFileRevisionData>>();
        }
    }

    @Override
    public Map<IFileSpec, List<IFileRevisionData>> getRevisionHistory(List<IFileSpec> fileSpecs, GetRevisionHistoryOptions opts) throws P4JavaException {
        HashMap<IFileSpec, List<IFileRevisionData>> revMap = new HashMap<IFileSpec, List<IFileRevisionData>>();
        Map<String, Object>[] historyMap = this.execMapCmd(CmdSpec.FILELOG, Parameters.processParameters(opts, fileSpecs, this), null);
        if (historyMap != null) {
            for (Map<String, Object> result : historyMap) {
                String errStr = this.handleFileErrorStr(result);
                if (errStr != null) {
                    FileSpec fSpec = new FileSpec(FileSpecOpStatus.ERROR, errStr, this.getGenericCode(result), this.getSeverityCode(result));
                    String depotPath = (String)result.get("depotFile");
                    fSpec.setDepotPath(depotPath);
                    revMap.put(fSpec, null);
                    continue;
                }
                int revNum = 0;
                ArrayList<FileRevisionData> revList = new ArrayList<FileRevisionData>();
                String depotFilePath = (String)result.get("depotFile");
                FileSpec fSpec = new FileSpec();
                fSpec.setDepotPath(depotFilePath);
                revMap.put(fSpec, revList);
                while (result.get("rev" + revNum) != null) {
                    revList.add(new FileRevisionData(result, revNum));
                    ++revNum;
                }
            }
        }
        return revMap;
    }

    @Override
    public List<IFileSpec> getOpenedFiles(List<IFileSpec> fileSpecs, boolean allClients, String clientName, int maxFiles, int changeListId) throws ConnectionException, AccessException {
        try {
            return this.getOpenedFiles(fileSpecs, new OpenedFilesOptions(allClients, clientName, maxFiles, null, changeListId));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            Log.warn("Unexpected exception in IServer.openedFiles: " + exc);
            return new ArrayList<IFileSpec>();
        }
    }

    @Override
    public List<IFileSpec> getOpenedFiles(List<IFileSpec> fileSpecs, OpenedFilesOptions opts) throws P4JavaException {
        ArrayList<IFileSpec> openedList = new ArrayList<IFileSpec>();
        Map<String, Object>[] resultsMap = this.execMapCmd(CmdSpec.OPENED, Parameters.processParameters(opts, fileSpecs, this), null);
        if (resultsMap != null) {
            for (Map<String, Object> map : resultsMap) {
                openedList.add(this.handleFileReturn(map));
            }
        }
        return openedList;
    }

    @Override
    public InputStream getFileContents(List<IFileSpec> fileSpecs, boolean allRevs, boolean noHeaderLine) throws ConnectionException, RequestException, AccessException {
        try {
            return this.getFileContents(fileSpecs, new GetFileContentsOptions(allRevs, noHeaderLine));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public InputStream getFileContents(List<IFileSpec> fileSpecs, GetFileContentsOptions opts) throws P4JavaException {
        return this.execStreamCmd(CmdSpec.PRINT, Parameters.processParameters(opts, fileSpecs, this));
    }

    @Override
    public List<IFileSpec> getDirectories(List<IFileSpec> fileSpecs, boolean clientOnly, boolean deletedOnly, boolean haveListOnly) throws ConnectionException, AccessException {
        if (fileSpecs == null) {
            throw new NullPointerError("Null fileSpecs in getDirectories");
        }
        try {
            return this.getDirectories(fileSpecs, new GetDirectoriesOptions().setClientOnly(clientOnly).setDeletedOnly(deletedOnly).setHaveListOnly(haveListOnly));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            Log.warn("Unexpected exception in IServer.getDirectories: " + exc);
            return new ArrayList<IFileSpec>();
        }
    }

    @Override
    public List<IFileSpec> getDirectories(List<IFileSpec> fileSpecs, GetDirectoriesOptions opts) throws P4JavaException {
        Map<String, Object>[] dirMaps = this.execMapCmd(CmdSpec.DIRS, Parameters.processParameters(opts, fileSpecs, this), null);
        ArrayList<IFileSpec> specList = new ArrayList<IFileSpec>();
        if (dirMaps != null) {
            for (Map<String, Object> map : dirMaps) {
                if (map == null) continue;
                String errStr = this.handleFileErrorStr(map);
                if (errStr == null) {
                    specList.add(new FileSpec((String)map.get("dir")));
                    continue;
                }
                if (this.isInfoMessage(map)) {
                    specList.add(new FileSpec(FileSpecOpStatus.INFO, errStr, this.getGenericCode(map), this.getSeverityCode(map)));
                    continue;
                }
                specList.add(new FileSpec(FileSpecOpStatus.ERROR, errStr, this.getGenericCode(map), this.getSeverityCode(map)));
            }
        }
        return specList;
    }

    @Override
    public List<IFileSpec> getSubmittedIntegrations(List<IFileSpec> fileSpecs, String branchSpec, boolean reverseMappings) throws ConnectionException, RequestException, AccessException {
        try {
            return this.getSubmittedIntegrations(fileSpecs, new GetSubmittedIntegrationsOptions(branchSpec, reverseMappings));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public List<IFileSpec> getSubmittedIntegrations(List<IFileSpec> fileSpecs, GetSubmittedIntegrationsOptions opts) throws P4JavaException {
        Map<String, Object>[] mapArray = this.execMapCmd(CmdSpec.INTEGRATED, Parameters.processParameters(opts, fileSpecs, this), null);
        ArrayList<IFileSpec> integList = new ArrayList<IFileSpec>();
        if (mapArray != null) {
            for (Map<String, Object> map : mapArray) {
                integList.add(this.handleIntegrationFileReturn(map, null));
            }
        }
        return integList;
    }

    @Override
    public List<IChangelist> getInterchanges(IFileSpec fromFile, IFileSpec toFile, boolean showFiles, boolean longDesc, int maxChangelistId) throws ConnectionException, RequestException, AccessException {
        try {
            return this.getInterchanges(fromFile, toFile, new GetInterchangesOptions().setShowFiles(showFiles).setLongDesc(longDesc).setMaxChangelistId(maxChangelistId));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public List<IChangelist> getInterchanges(String branchSpecName, List<IFileSpec> fromFileList, List<IFileSpec> toFileList, boolean showFiles, boolean longDesc, int maxChangelistId, boolean reverseMapping, boolean biDirectional) throws ConnectionException, RequestException, AccessException {
        try {
            return this.getInterchanges(branchSpecName, fromFileList, toFileList, new GetInterchangesOptions().setShowFiles(showFiles).setLongDesc(longDesc).setMaxChangelistId(maxChangelistId).setReverseMapping(reverseMapping).setBiDirectional(biDirectional));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public List<IChangelist> getInterchanges(IFileSpec fromFile, IFileSpec toFile, GetInterchangesOptions opts) throws P4JavaException {
        if (fromFile == null || toFile == null) {
            throw new NullPointerError("Null file spec passed to IServer.getInterchanges");
        }
        ArrayList<IFileSpec> files = new ArrayList<IFileSpec>();
        files.add(fromFile);
        files.add(toFile);
        Map<String, Object>[] mapArray = this.execMapCmd(CmdSpec.INTERCHANGES, Parameters.processParameters(opts, files, this), null);
        return this.processInterchangeMaps(mapArray, opts == null ? false : opts.isShowFiles());
    }

    @Override
    public List<IChangelist> getInterchanges(String branchSpecName, List<IFileSpec> fromFileList, List<IFileSpec> toFileList, GetInterchangesOptions opts) throws P4JavaException {
        if (branchSpecName == null || branchSpecName.trim().length() == 0) {
            throw new NullPointerError("Null or empty branchspec name passed to IServer.getInterchanges");
        }
        Map<String, Object>[] mapArray = this.execMapCmd(CmdSpec.INTERCHANGES, Parameters.processParameters((Options)opts, fromFileList, toFileList, branchSpecName, (IServer)this), null);
        return this.processInterchangeMaps(mapArray, opts == null ? false : opts.isShowFiles());
    }

    @Override
    public List<IExtendedFileSpec> getExtendedFiles(List<IFileSpec> fileSpecs, int maxFiles, int sinceChangelist, int affectedByChangelist, FileStatOutputOptions outputOptions, FileStatAncilliaryOptions ancilliaryOptions) throws ConnectionException, AccessException {
        try {
            return this.getExtendedFiles(fileSpecs, new GetExtendedFilesOptions().setAncilliaryOptions(ancilliaryOptions).setMaxResults(maxFiles).setOutputOptions(outputOptions).setSinceChangelist(sinceChangelist).setAffectedByChangelist(affectedByChangelist));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            Log.warn("Unexpected exception in IServer.getExtendedFiles: " + exc);
            return new ArrayList<IExtendedFileSpec>();
        }
    }

    @Override
    public List<IExtendedFileSpec> getExtendedFiles(List<IFileSpec> fileSpecs, GetExtendedFilesOptions opts) throws P4JavaException {
        Map<String, Object>[] resultsMap = this.execMapCmd(CmdSpec.FSTAT, Parameters.processParameters(opts, fileSpecs, this), null);
        ArrayList<IExtendedFileSpec> specList = new ArrayList<IExtendedFileSpec>();
        if (resultsMap != null) {
            for (Map<String, Object> map : resultsMap) {
                String errStr = this.handleFileErrorStr(map);
                ExtendedFileSpec eSpec = null;
                if (errStr == null) {
                    if (map.containsKey("depotFile") && !map.containsKey("desc")) {
                        eSpec = new ExtendedFileSpec(map, this, -1);
                    }
                } else {
                    eSpec = this.isInfoMessage(map) ? new ExtendedFileSpec(FileSpecOpStatus.INFO, errStr) : new ExtendedFileSpec(FileSpecOpStatus.ERROR, errStr);
                }
                if (eSpec == null) continue;
                specList.add(eSpec);
            }
        }
        return specList;
    }

    @Override
    public List<IJob> getJobs(List<IFileSpec> fileSpecs, int maxJobs, boolean longDescriptions, boolean reverseOrder, boolean includeIntegrated, String jobView) throws ConnectionException, RequestException, AccessException {
        try {
            return this.getJobs(fileSpecs, new GetJobsOptions().setIncludeIntegrated(includeIntegrated).setLongDescriptions(longDescriptions).setMaxJobs(maxJobs).setReverseOrder(reverseOrder).setJobView(jobView));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public List<IJob> getJobs(List<IFileSpec> fileSpecs, GetJobsOptions opts) throws P4JavaException {
        ArrayList<IJob> jobList = new ArrayList<IJob>();
        Map<String, Object>[] jobMaps = this.execMapCmd(CmdSpec.JOBS, Parameters.processParameters(opts, fileSpecs, this), null);
        if (jobMaps != null) {
            for (Map<String, Object> map : jobMaps) {
                if (map == null) continue;
                String errStr = this.getErrorStr(map);
                if (errStr != null) {
                    throw new RequestException(errStr, this.getGenericCode(map), this.getSeverityCode(map));
                }
                jobList.add(new Job(this, map, opts == null ? false : opts.isLongDescriptions()));
            }
        }
        return jobList;
    }

    @Override
    public IJob getJob(String jobId) throws ConnectionException, RequestException, AccessException {
        if (jobId == null) {
            throw new P4JavaError("Null jobId in server.getJob()");
        }
        Map<String, Object>[] resultsMap = this.execMapCmd(CmdSpec.JOB, new String[]{"-o", jobId}, null);
        Job job = null;
        if (resultsMap != null) {
            for (Map<String, Object> map : resultsMap) {
                this.handleErrorStr(map);
                if (this.isInfoMessage(map)) continue;
                job = new Job(this, map);
            }
        }
        return job;
    }

    @Override
    public IJob createJob(Map<String, Object> fieldMap) throws ConnectionException, RequestException, AccessException {
        if (fieldMap == null) {
            throw new NullPointerError("Null field map passed to ServerImpl.createJob");
        }
        Map<String, Object>[] retMaps = this.execMapCmd(CmdSpec.JOB, new String[]{"-i"}, fieldMap);
        if (retMaps != null) {
            for (Map<String, Object> map : retMaps) {
                String[] strs;
                this.handleErrorStr(map);
                String infoStr = this.getInfoStr(map);
                if (infoStr == null || !infoStr.contains("Job ") || !infoStr.contains(" saved") || (strs = infoStr.split(" ")).length != 3 || strs[1] == null) continue;
                return this.getJob(strs[1]);
            }
        }
        return null;
    }

    @Override
    public String updateJob(IJob job) throws ConnectionException, RequestException, AccessException {
        if (job == null) {
            throw new NullPointerError("Null job passed to Server.updateJob");
        }
        String retVal = null;
        Map<String, Object>[] retMaps = this.execMapCmd(CmdSpec.JOB, new String[]{"-i"}, job.getRawFields());
        if (retMaps != null) {
            for (Map<String, Object> map : retMaps) {
                this.handleErrorStr(map);
                if (!this.isInfoMessage(map)) continue;
                retVal = retVal == null ? this.getInfoStr(map) : retVal + "\n" + this.getInfoStr(map);
            }
        }
        return retVal;
    }

    @Override
    public String deleteJob(String jobId) throws ConnectionException, RequestException, AccessException {
        if (jobId == null) {
            throw new NullPointerError("Null job ID passed to Server.deleteJob");
        }
        String retVal = null;
        Map<String, Object>[] retMaps = this.execMapCmd(CmdSpec.JOB, new String[]{"-d", jobId}, null);
        if (retMaps != null) {
            for (Map<String, Object> map : retMaps) {
                this.handleErrorStr(map);
                if (!this.isInfoMessage(map)) continue;
                retVal = retVal == null ? this.getInfoStr(map) : retVal + "\n" + this.getInfoStr(map);
            }
        }
        return retVal;
    }

    @Override
    public IJobSpec getJobSpec() throws ConnectionException, RequestException, AccessException {
        Map<String, Object>[] specMaps = this.execMapCmd(CmdSpec.JOBSPEC, new String[]{"-o"}, null);
        JobSpec jobSpec = null;
        if (specMaps != null) {
            for (Map<String, Object> map : specMaps) {
                if (map == null) continue;
                this.handleErrorStr(map);
                if (this.isInfoMessage(map)) continue;
                jobSpec = new JobSpec(map, this);
            }
        }
        return jobSpec;
    }

    @Override
    public List<IFix> getFixList(List<IFileSpec> fileSpecs, int changeListId, String jobId, boolean includeIntegrations, int maxFixes) throws ConnectionException, RequestException, AccessException {
        try {
            return this.getFixes(fileSpecs, new GetFixesOptions().setChangelistId(changeListId == 0 ? -1 : changeListId).setIncludeIntegrations(includeIntegrations).setJobId(jobId).setMaxFixes(maxFixes));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public List<IFix> getFixes(List<IFileSpec> fileSpecs, GetFixesOptions opts) throws P4JavaException {
        ArrayList<IFix> fixList = new ArrayList<IFix>();
        Map<String, Object>[] fixMaps = this.execMapCmd(CmdSpec.FIXES, Parameters.processParameters(opts, fileSpecs, this), null);
        if (fixMaps != null) {
            for (Map<String, Object> map : fixMaps) {
                if (map == null) continue;
                this.handleErrorStr(map);
                fixList.add(new Fix(map));
            }
        }
        return fixList;
    }

    @Override
    public List<IFix> fixJobs(List<String> jobIdList, int changeListId, String status, boolean delete) throws ConnectionException, RequestException, AccessException {
        try {
            return this.fixJobs(jobIdList, changeListId, new FixJobsOptions().setDelete(delete).setStatus(status));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public List<IFix> fixJobs(List<String> jobIds, int changelistId, FixJobsOptions opts) throws P4JavaException {
        if (jobIds == null) {
            throw new P4JavaError("Null jobIds list in fixJobs");
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add("-c" + (changelistId == 0 ? "default" : Integer.valueOf(changelistId)));
        args.addAll(jobIds);
        ArrayList<IFix> fixList = new ArrayList<IFix>();
        Map<String, Object>[] fixMap = this.execMapCmd(CmdSpec.FIX, Parameters.processParameters((Options)opts, null, args.toArray(new String[args.size()]), (IServer)this), null);
        if (fixMap != null) {
            for (Map<String, Object> map : fixMap) {
                String errStr = this.getErrorStr(map);
                if (errStr != null) {
                    throw new RequestException(errStr, this.getGenericCode(map), this.getSeverityCode(map));
                }
                fixList.add(new Fix(map));
            }
        }
        return fixList;
    }

    @Override
    public String getCounter(String counterName) throws ConnectionException, RequestException, AccessException {
        if (counterName == null) {
            throw new NullPointerError("null counter name passed to getCounter method");
        }
        Map<String, Object>[] counterMapArray = this.execMapCmd(CmdSpec.COUNTER, new String[]{counterName}, null);
        String retVal = "";
        if (counterMapArray != null) {
            for (Map<String, Object> map : counterMapArray) {
                if (map == null || !map.containsKey("value")) continue;
                return (String)map.get("value");
            }
        }
        return retVal;
    }

    @Override
    public void setCounter(String counterName, String value, boolean perforceCounter) throws ConnectionException, RequestException, AccessException {
        if (counterName == null) {
            throw new NullPointerError("null counter name passed to setCounter method");
        }
        if (value == null) {
            throw new NullPointerError("null counter value passed to setCounter method");
        }
        try {
            this.setCounter(counterName, value, new CounterOptions().setPerforceCounter(perforceCounter));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public String setCounter(String counterName, String value, CounterOptions opts) throws P4JavaException {
        Map<String, Object>[] retMaps = this.execMapCmd(CmdSpec.COUNTER, Parameters.processParameters((Options)opts, null, new String[]{counterName, value}, (IServer)this), null);
        if (retMaps != null) {
            for (Map<String, Object> map : retMaps) {
                this.handleErrorStr(map);
                if (!map.containsKey("value")) continue;
                return (String)map.get("value");
            }
        }
        return null;
    }

    @Override
    public void deleteCounter(String counterName, boolean perforceCounter) throws ConnectionException, RequestException, AccessException {
        if (counterName == null) {
            throw new NullPointerError("null counter name passed to setCounter method");
        }
        try {
            this.setCounter(counterName, null, new CounterOptions(perforceCounter, true, false));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public Map<String, String> getCounters() throws ConnectionException, RequestException, AccessException {
        Map<String, Object>[] counterMapArray = this.execMapCmd(CmdSpec.COUNTERS, null, null);
        HashMap<String, String> counterMap = new HashMap<String, String>();
        if (counterMapArray != null) {
            for (Map<String, Object> map : counterMapArray) {
                String errStr = this.getErrorOrInfoStr(map);
                if (errStr != null) {
                    if (this.isAuthFail(errStr)) {
                        throw new AccessException(errStr);
                    }
                    throw new RequestException(errStr, this.getGenericCode(map), this.getSeverityCode(map));
                }
                try {
                    counterMap.put((String)map.get("counter"), (String)map.get("value"));
                }
                catch (Exception exc) {
                    Log.error("getCounter conversion error: " + exc.getLocalizedMessage());
                    Log.exception(exc);
                }
            }
        }
        return counterMap;
    }

    @Override
    public List<IServerProcess> getServerProcesses() throws ConnectionException, RequestException, AccessException {
        ArrayList<IServerProcess> processList = new ArrayList<IServerProcess>();
        Map<String, Object>[] monitorMaps = this.execMapCmd(CmdSpec.MONITOR, new String[]{"show"}, null);
        if (monitorMaps != null) {
            for (Map<String, Object> map : monitorMaps) {
                String errStr = this.getErrorStr(map);
                if (errStr != null) {
                    throw new RequestException(errStr, this.getGenericCode(map), this.getSeverityCode(map));
                }
                processList.add(new ServerProcess(map));
            }
        }
        return processList;
    }

    @Override
    public InputStream getServerFileDiffs(IFileSpec file1, IFileSpec file2, String branchSpecName, DiffType diffType, boolean quiet, boolean includeNonTextDiffs, boolean gnuDiffs) throws ConnectionException, RequestException, AccessException {
        try {
            GetFileDiffsOptions opts = new GetFileDiffsOptions().setQuiet(quiet).setIncludeNonTextDiffs(includeNonTextDiffs).setGnuDiffs(gnuDiffs);
            if (diffType != null) {
                switch (diffType) {
                    case RCS_DIFF: {
                        opts.setRcsDiffs(true);
                        break;
                    }
                    case CONTEXT_DIFF: {
                        opts.setDiffContext(0);
                        break;
                    }
                    case SUMMARY_DIFF: {
                        opts.setSummaryDiff(true);
                        break;
                    }
                    case UNIFIED_DIFF: {
                        opts.setUnifiedDiff(0);
                        break;
                    }
                    case IGNORE_WS_CHANGES: {
                        opts.setIgnoreWhitespaceChanges(true);
                        break;
                    }
                    case IGNORE_WS: {
                        opts.setIgnoreWhitespace(true);
                        break;
                    }
                    case IGNORE_LINE_ENDINGS: {
                        opts.setIgnoreLineEndings(true);
                    }
                }
            }
            return this.getFileDiffsStream(file1, file2, branchSpecName, opts);
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public List<IFileDiff> getFileDiffs(IFileSpec file1, IFileSpec file2, String branchSpecName, DiffType diffType, boolean quiet, boolean includeNonTextDiffs, boolean gnuDiffs) throws ConnectionException, RequestException, AccessException {
        try {
            GetFileDiffsOptions opts = new GetFileDiffsOptions().setQuiet(quiet).setIncludeNonTextDiffs(includeNonTextDiffs).setGnuDiffs(gnuDiffs);
            if (diffType != null) {
                switch (diffType) {
                    case RCS_DIFF: {
                        opts.setRcsDiffs(true);
                        break;
                    }
                    case CONTEXT_DIFF: {
                        opts.setDiffContext(0);
                        break;
                    }
                    case SUMMARY_DIFF: {
                        opts.setSummaryDiff(true);
                        break;
                    }
                    case UNIFIED_DIFF: {
                        opts.setUnifiedDiff(0);
                        break;
                    }
                    case IGNORE_WS_CHANGES: {
                        opts.setIgnoreWhitespaceChanges(true);
                        break;
                    }
                    case IGNORE_WS: {
                        opts.setIgnoreWhitespace(true);
                        break;
                    }
                    case IGNORE_LINE_ENDINGS: {
                        opts.setIgnoreLineEndings(true);
                    }
                }
            }
            return this.getFileDiffs(file1, file2, branchSpecName, opts);
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public InputStream getFileDiffsStream(IFileSpec file1, IFileSpec file2, String branchSpecName, GetFileDiffsOptions opts) throws P4JavaException {
        return this.execStreamCmd(CmdSpec.DIFF2, Parameters.processParameters((Options)opts, file1, file2, branchSpecName, (IServer)this));
    }

    @Override
    public List<IFileDiff> getFileDiffs(IFileSpec file1, IFileSpec file2, String branchSpecName, GetFileDiffsOptions opts) throws P4JavaException {
        Map<String, Object>[] diffMap = this.execMapCmd(CmdSpec.DIFF2, Parameters.processParameters((Options)opts, file1, file2, branchSpecName, (IServer)this), null);
        ArrayList<IFileDiff> diffs = new ArrayList<IFileDiff>();
        if (diffMap != null) {
            for (Map<String, Object> map : diffMap) {
                if (map == null) continue;
                String errStr = this.getErrorStr(map);
                if (errStr != null) {
                    throw new RequestException(errStr, this.getGenericCode(map), this.getSeverityCode(map));
                }
                diffs.add(new FileDiff(map));
            }
        }
        return diffs;
    }

    @Override
    public List<IDbSchema> getDbSchema(List<String> tableSpecs) throws ConnectionException, RequestException, AccessException {
        String[] args = null;
        if (tableSpecs != null) {
            args = new String[tableSpecs.size()];
            int i = 0;
            for (String table : tableSpecs) {
                args[i++] = table;
            }
        }
        Map<String, Object>[] maps = this.execMapCmd(CmdSpec.DBSCHEMA, args, null);
        ArrayList<IDbSchema> schemaList = new ArrayList<IDbSchema>();
        if (maps != null) {
            for (Map<String, Object> map : maps) {
                String errStr = this.getErrorStr(map);
                if (errStr != null) {
                    throw new RequestException(errStr, this.getGenericCode(map), this.getSeverityCode(map));
                }
                schemaList.add(new DbSchema(map));
            }
        }
        return schemaList;
    }

    @Override
    public List<Map<String, Object>> getExportRecords(boolean useJournal, long maxRecs, int sourceNum, long offset, boolean format, String journalPrefix, String filter) throws ConnectionException, RequestException, AccessException {
        try {
            return this.getExportRecords(new ExportRecordsOptions().setFormat(format).setFilter(filter).setJournalPrefix(journalPrefix).setMaxRecs(maxRecs).setOffset(offset).setSourceNum(sourceNum).setUseJournal(useJournal));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public List<Map<String, Object>> getExportRecords(ExportRecordsOptions opts) throws P4JavaException {
        Map<String, Object>[] mapArray = this.execMapCmd(CmdSpec.EXPORT, Parameters.processParameters(opts, this), null);
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        if (mapArray != null) {
            for (Map<String, Object> map : mapArray) {
                String errStr = this.getErrorStr(map);
                if (errStr != null) {
                    throw new RequestException(errStr, this.getGenericCode(map), this.getSeverityCode(map));
                }
                if (map.containsKey("func")) {
                    map.remove("func");
                }
                mapList.add(map);
            }
        }
        return mapList;
    }

    public boolean handleErrorStr(Map<String, Object> map) throws RequestException, AccessException {
        String errStr = this.getErrorStr(map);
        if (errStr != null) {
            if (this.isAuthFail(errStr)) {
                throw new AccessException(errStr);
            }
            throw new RequestException(errStr, this.getGenericCode(map), this.getSeverityCode(map));
        }
        return false;
    }

    public IFileSpec handleFileReturn(Map<String, Object> map) throws AccessException, ConnectionException {
        return this.handleFileReturn(map, this.client);
    }

    public IFileSpec handleFileReturn(Map<String, Object> map, IClient client) throws AccessException, ConnectionException {
        if (map != null) {
            String errStr = this.handleFileErrorStr(map);
            if (errStr == null) {
                return new FileSpec(map, this, -1);
            }
            if (this.isInfoMessage(map)) {
                return new FileSpec(FileSpecOpStatus.INFO, errStr, this.getGenericCode(map), this.getSeverityCode(map));
            }
            return new FileSpec(FileSpecOpStatus.ERROR, errStr, this.getGenericCode(map), this.getSeverityCode(map));
        }
        return null;
    }

    public IFileSpec handleIntegrationFileReturn(Map<String, Object> map, IClient client) throws AccessException, ConnectionException {
        return this.handleIntegrationFileReturn(map, false);
    }

    public IFileSpec handleIntegrationFileReturn(Map<String, Object> map, boolean ignoreInfo) throws AccessException, ConnectionException {
        if (map != null) {
            String errStr = this.handleFileErrorStr(map);
            if (errStr == null) {
                return new FileSpec(map, this, -1);
            }
            if (this.isInfoMessage(map)) {
                if (ignoreInfo) {
                    return new FileSpec(map, this, -1);
                }
                return new FileSpec(FileSpecOpStatus.INFO, errStr);
            }
            return new FileSpec(FileSpecOpStatus.ERROR, errStr, this.getGenericCode(map), this.getSeverityCode(map));
        }
        return null;
    }

    public String handleFileErrorStr(Map<String, Object> map) throws ConnectionException, AccessException {
        String errStr = this.getErrorOrInfoStr(map);
        if (errStr != null) {
            if (this.isAuthFail(errStr)) {
                throw new AccessException(errStr);
            }
            return errStr.trim();
        }
        return null;
    }

    public static String guardNull(String str) {
        String nullStr = "<null>";
        return str == null ? "<null>" : str;
    }

    public static String[] getPreferredPathArray(String[] preamble, List<IFileSpec> specList, boolean annotate) {
        String[] pathArray = new String[(preamble == null ? 0 : preamble.length) + (specList == null ? 0 : specList.size())];
        int i = 0;
        if (preamble != null) {
            for (String str : preamble) {
                pathArray[i++] = str;
            }
        }
        if (specList != null) {
            for (IFileSpec fSpec : specList) {
                if (fSpec != null && fSpec.getOpStatus() == FileSpecOpStatus.VALID) {
                    if (annotate) {
                        pathArray[i++] = fSpec.getAnnotatedPreferredPathString();
                        continue;
                    }
                    pathArray[i++] = fSpec.getPreferredPathString();
                    continue;
                }
                pathArray[i++] = null;
            }
        }
        return pathArray;
    }

    public static String[] getPreferredPathArray(String[] preamble, List<IFileSpec> specList) {
        return Server.getPreferredPathArray(preamble, specList, true);
    }

    public static String[] populatePathArray(String[] pathArray, int start, List<IFileSpec> fileSpecList) {
        if (pathArray == null) {
            return null;
        }
        if (fileSpecList == null) {
            return pathArray;
        }
        if (start < 0) {
            throw new P4JavaError("negative start index in populatePathArray: " + start);
        }
        if (start > pathArray.length || pathArray.length < start + fileSpecList.size()) {
            throw new P4JavaError("pathArray too small in populatePathArray");
        }
        int i = start;
        for (IFileSpec fSpec : fileSpecList) {
            pathArray[i] = fSpec != null && fSpec.getOpStatus() == FileSpecOpStatus.VALID ? fSpec.getAnnotatedPreferredPathString() : null;
            ++i;
        }
        return pathArray;
    }

    public Map<String, Object>[] execMapCmd(CmdSpec cmdSpec, String[] cmdArgs, Map<String, Object> inMap) throws ConnectionException, AccessException {
        if (cmdSpec == null) {
            throw new NullPointerError("Null command spec in execMapCmd");
        }
        try {
            return this.execMapCmd(cmdSpec.toString(), cmdArgs, inMap);
        }
        catch (RequestException exc) {
            return null;
        }
    }

    public InputStream execStreamCmd(CmdSpec cmdSpec, String[] cmdArgs) throws ConnectionException, RequestException, AccessException {
        if (cmdSpec == null) {
            throw new NullPointerError("Null command spec in execMapCmd");
        }
        return this.execStreamCmd(cmdSpec.toString(), cmdArgs);
    }

    protected boolean isUnicode() {
        return this.charsetName != null;
    }

    public abstract String getErrorStr(Map<String, Object> var1);

    public abstract String getErrorOrInfoStr(Map<String, Object> var1);

    public abstract String getInfoStr(Map<String, Object> var1);

    public abstract boolean isAuthFail(String var1);

    public abstract boolean isInfoMessage(Map<String, Object> var1);

    protected abstract int getGenericCode(Map<String, Object> var1);

    protected abstract int getSeverityCode(Map<String, Object> var1);

    @Override
    public abstract Map<String, Object>[] execMapCmd(String var1, String[] var2, Map<String, Object> var3) throws ConnectionException, AccessException, RequestException;

    @Override
    public abstract Map<String, Object>[] execQuietMapCmd(String var1, String[] var2, Map<String, Object> var3) throws ConnectionException, RequestException, AccessException;

    @Override
    public abstract InputStream execStreamCmd(String var1, String[] var2) throws ConnectionException, RequestException, AccessException;

    @Override
    public abstract InputStream execQuietStreamCmd(String var1, String[] var2) throws ConnectionException, RequestException, AccessException;

    public String getClientName() {
        return this.clientName;
    }

    @Override
    public String getWorkingDirectory() {
        if (this.usageOptions != null) {
            return this.usageOptions.getWorkingDirectory();
        }
        return null;
    }

    @Override
    public void setWorkingDirectory(String dirPath) {
        if (this.usageOptions != null) {
            this.usageOptions.setWorkingDirectory(dirPath);
        }
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    protected int getServerVersion() throws ConnectionException {
        if (this.serverVersion != -1) {
            return this.serverVersion;
        }
        try {
            Map<String, Object>[] resultMap = this.execMapCmd(CmdSpec.INFO.toString().toLowerCase(Locale.ENGLISH), new String[0], null);
            if (resultMap != null) {
                for (Map<String, Object> map : resultMap) {
                    if (!map.containsKey("serverVersion")) continue;
                    this.serverVersion = this.parseVersionString((String)map.get("serverVersion"));
                    return this.serverVersion;
                }
            }
        }
        catch (Exception exc) {
            Log.exception(exc);
            throw new ConnectionException(exc.getLocalizedMessage());
        }
        return -1;
    }

    protected String getInfoServerAddress() {
        String address;
        block3: {
            address = null;
            try {
                Map<String, Object>[] resultMap = this.execMapCmd(CmdSpec.INFO.toString().toLowerCase(Locale.ENGLISH), new String[0], null);
                if (resultMap == null) break block3;
                for (Map<String, Object> map : resultMap) {
                    if (!map.containsKey("serverAddress")) continue;
                    address = map.get("serverAddress").toString();
                    break;
                }
            }
            catch (Exception exc) {
                Log.exception(exc);
            }
        }
        return address;
    }

    protected int parseVersionString(String versionString) {
        String candidate;
        String[] candParts;
        String[] subStrings;
        if (versionString != null && (subStrings = versionString.split("/")).length >= 3 && (candParts = (candidate = subStrings[2]).split("\\.")).length >= 2) {
            try {
                return new Integer(candParts[0] + candParts[1]);
            }
            catch (NumberFormatException nfe) {
                Log.error("Unexpected exception in P4CmdServerImpl.parseVersionString: " + nfe);
            }
        }
        return -1;
    }

    public static boolean isRunningOnWindows() {
        return isRunningOnWindows;
    }

    protected String getP4TicketsOSLocation() {
        String location = null;
        String os = System.getProperty("os.name");
        String home = System.getProperty("user.home");
        if (home != null && os != null) {
            StringBuilder builtLocation = new StringBuilder(home);
            builtLocation.append(File.separatorChar);
            if (os.toLowerCase(Locale.ENGLISH).contains("windows")) {
                builtLocation.append(P4TICKETS_DEFAULT_WINDOWS);
            } else {
                builtLocation.append(P4TICKETS_DEFAULT_OTHER);
            }
            location = builtLocation.toString();
        }
        return location;
    }

    protected List<IChangelist> processInterchangeMaps(Map<String, Object>[] mapArray, boolean showFiles) throws ConnectionException, AccessException, RequestException {
        ArrayList<IChangelist> interchangeList = new ArrayList<IChangelist>();
        if (mapArray != null) {
            for (Map<String, Object> map : mapArray) {
                if (map == null) continue;
                String errStr = this.handleFileErrorStr(map);
                if (errStr != null) {
                    if (this.getGenericCode(map) == 17 || this.getSeverityCode(map) == 2 || errStr.contains("all revision(s) already integrated")) continue;
                    throw new RequestException(errStr, this.getGenericCode(map), this.getSeverityCode(map));
                }
                Changelist changelist = new Changelist(new ChangelistSummary(map, true, (IServer)this), this, false);
                interchangeList.add(changelist);
                if (!showFiles) continue;
                ArrayList<IFileSpec> fileSpecs = new ArrayList<IFileSpec>();
                int i = 0;
                String depotKey = "depotFile";
                while (map.get("depotFile" + i) != null) {
                    FileSpec fileSpec = new FileSpec(map, this, i);
                    fileSpec.setChangelistId(changelist.getId());
                    fileSpecs.add(fileSpec);
                    ++i;
                }
                changelist.setFileSpecs(fileSpecs);
            }
        }
        return interchangeList;
    }

    @Override
    public List<IFileLineMatch> getMatchingLines(List<IFileSpec> fileSpecs, String pattern, MatchingLinesOptions options) throws P4JavaException {
        if (fileSpecs == null) {
            throw new NullPointerError("Null file specification list passed to IOptionsServer.getMatchingLines");
        }
        if (pattern == null) {
            throw new NullPointerError("Null pattern string passed to IOptionsServer.getMatchingLines");
        }
        Map<String, Object>[] matches = this.execMapCmd(CmdSpec.GREP, Parameters.processParameters((Options)options, fileSpecs, "-e" + pattern, (IServer)this), null);
        if (matches == null) {
            throw new P4JavaError("Null resultsMap in Server.getMatchingLines call");
        }
        ArrayList<IFileLineMatch> specList = new ArrayList<IFileLineMatch>();
        for (Map<String, Object> map : matches) {
            String message = this.getErrorStr(map);
            if (message != null) {
                throw new RequestException(message, this.getGenericCode(map), this.getSeverityCode(map));
            }
            message = this.getErrorOrInfoStr(map);
            if (message != null) continue;
            specList.add(new FileLineMatch(map));
        }
        return specList;
    }

    public ISSOCallback getSSOCallback() {
        return this.ssoCallback;
    }

    public String getSSOKey() {
        return this.ssoKey;
    }

    @Override
    public UsageOptions getUsageOptions() {
        return this.usageOptions;
    }

    @Override
    public Server setUsageOptions(UsageOptions usageOptions) {
        this.usageOptions = usageOptions;
        return this;
    }

    static {
        String osName = System.getProperty("os.name");
        if (osName != null && (osName.contains("Windows") || osName.contains("windows"))) {
            isRunningOnWindows = true;
        }
    }
}

