/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.server;

import com.perforce.p4java.core.file.FileSpecOpStatus;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.NullPointerError;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.option.Options;
import com.perforce.p4java.server.IServer;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parameters {
    public static String[] processParameters(Options opts, List<IFileSpec> fileSpecs, IServer server) throws P4JavaException {
        return Parameters.processParameters(opts, fileSpecs, null, true, server);
    }

    public static String[] processParameters(Options opts, IServer server) throws P4JavaException {
        return Parameters.processParameters(opts, null, null, true, server);
    }

    public static String[] processParameters(Options opts, List<IFileSpec> fileSpecs, String[] stringParams, IServer server) throws P4JavaException {
        return Parameters.processParameters(opts, fileSpecs, stringParams, true, server);
    }

    public static String[] processParameters(Options opts, List<IFileSpec> fileSpecs, String stringParam, IServer server) throws P4JavaException {
        return Parameters.processParameters(opts, fileSpecs, new String[]{stringParam}, true, server);
    }

    public static String[] processParameters(Options opts, List<IFileSpec> fileSpecs, String[] stringParams, boolean annotateFiles, IServer server) throws P4JavaException {
        ArrayList<String> args = new ArrayList<String>();
        Parameters.addOpts(args, opts, server);
        if (stringParams != null) {
            for (String param : stringParams) {
                if (param == null) continue;
                args.add(param);
            }
        }
        if (annotateFiles) {
            return Parameters.addFileSpecs(args, fileSpecs);
        }
        return Parameters.addUnannotatedFileSpecs(args, fileSpecs);
    }

    public static String[] processParameters(Options opts, IFileSpec fromFile, IFileSpec toFile, String branchSpec, IServer server) throws P4JavaException {
        ArrayList<IFileSpec> fromFiles = new ArrayList<IFileSpec>();
        ArrayList<IFileSpec> toFiles = new ArrayList<IFileSpec>();
        if (fromFile != null) {
            fromFiles.add(fromFile);
        }
        if (toFile != null) {
            toFiles.add(toFile);
        }
        return Parameters.processParameters(opts, fromFiles, toFiles, branchSpec, server);
    }

    public static String[] processParameters(Options opts, List<IFileSpec> fromFiles, List<IFileSpec> toFiles, String branchSpec, IServer server) throws P4JavaException {
        ArrayList<String> args = new ArrayList<String>();
        Parameters.addOpts(args, opts, server);
        boolean hadS = false;
        if (args.contains("-s")) {
            args.remove("-s");
            hadS = true;
        }
        if (branchSpec != null) {
            args.add("-b" + branchSpec);
        }
        if (hadS) {
            args.add("-s");
        }
        if (fromFiles != null) {
            for (IFileSpec fromFile : fromFiles) {
                if (fromFile.getOpStatus() != FileSpecOpStatus.VALID) continue;
                args.add(fromFile.getAnnotatedPreferredPathString());
            }
        }
        if (toFiles != null) {
            for (IFileSpec toFile : toFiles) {
                if (toFile.getOpStatus() != FileSpecOpStatus.VALID) continue;
                args.add(toFile.getAnnotatedPreferredPathString());
            }
        }
        return args.toArray(new String[args.size()]);
    }

    protected static String[] addFileSpecs(List<String> args, List<IFileSpec> fileSpecs) {
        if (args == null) {
            throw new NullPointerError("Null args array passed to Parameters.addFileSpecs");
        }
        if (fileSpecs != null) {
            for (IFileSpec fSpec : fileSpecs) {
                if (fSpec == null || fSpec.getOpStatus() != FileSpecOpStatus.VALID) continue;
                args.add(fSpec.getAnnotatedPreferredPathString());
            }
        }
        return args.toArray(new String[args.size()]);
    }

    protected static String[] addUnannotatedFileSpecs(List<String> args, List<IFileSpec> fileSpecs) {
        if (args == null) {
            throw new NullPointerError("Null args array passed to Parameters.addUnannotatedFileSpecs");
        }
        if (fileSpecs != null) {
            for (IFileSpec fSpec : fileSpecs) {
                if (fSpec == null || fSpec.getOpStatus() != FileSpecOpStatus.VALID) continue;
                args.add(fSpec.getPreferredPathString());
            }
        }
        return args.toArray(new String[args.size()]);
    }

    protected static void addOpts(List<String> args, Options opts, IServer server) throws P4JavaException {
        if (opts != null) {
            if (opts.isImmutable() && opts.getOptions() != null) {
                args.addAll(opts.getOptions());
            } else {
                args.addAll(opts.processOptions(server));
            }
        }
    }
}

