/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc;

import com.perforce.p4java.Log;
import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.ConfigException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.ConnectionNotConnectedException;
import com.perforce.p4java.exception.NullPointerError;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.exception.RequestException;
import com.perforce.p4java.impl.generic.core.TempFileInputStream;
import com.perforce.p4java.impl.mapbased.rpc.CommandEnv;
import com.perforce.p4java.impl.mapbased.rpc.ExternalEnv;
import com.perforce.p4java.impl.mapbased.rpc.RpcCmdSpec;
import com.perforce.p4java.impl.mapbased.rpc.RpcPropertyDefs;
import com.perforce.p4java.impl.mapbased.rpc.RpcServer;
import com.perforce.p4java.impl.mapbased.rpc.connection.RpcConnection;
import com.perforce.p4java.impl.mapbased.rpc.func.RpcFunctionSpec;
import com.perforce.p4java.impl.mapbased.rpc.func.proto.ProtocolCommand;
import com.perforce.p4java.impl.mapbased.rpc.packet.RpcPacket;
import com.perforce.p4java.impl.mapbased.rpc.packet.RpcPacketDispatcher;
import com.perforce.p4java.impl.mapbased.rpc.stream.RpcStreamConnection;
import com.perforce.p4java.impl.mapbased.rpc.sys.RpcOutputStream;
import com.perforce.p4java.impl.mapbased.rpc.sys.RpcPerforceFile;
import com.perforce.p4java.impl.mapbased.rpc.sys.RpcPerforceFileType;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.ServerStatus;
import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferOverflowException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NtsServerImpl
extends RpcServer {
    public static final String SCREEN_NAME = "Native RPC (Experimental)";
    public static final String IMPL_COMMENTS = "Experimental Java-native RPC standalone P4Java implementation. Requires JDK 6 or later, full Java NIO support, and external thread synchronization. Not for the faint-hearted.";
    public static final String PROTOCOL_NAME = "p4jrpcnts";
    public static final int MINIMUM_SUPPORTED_SERVER_LEVEL = 20052;
    public static final boolean DEFAULT_STATUS = false;
    public static final String TRACE_PREFIX = "NtsServerImpl";
    private boolean haveSentProtocolSpecs = false;
    protected ProtocolCommand protocolSpecs = null;
    protected RpcPacketDispatcher dispatcher = null;
    protected RpcConnection rpcConnection = null;

    @Override
    public ServerStatus init(String host, int port, Properties props) throws ConfigException, ConnectionException {
        this.minumumSupportedServerVersion = 20052;
        return super.init(host, port, props);
    }

    @Override
    public void connect() throws ConnectionException, AccessException, RequestException, ConfigException {
        this.rpcConnection = new RpcStreamConnection(this.serverHost, this.serverPort, this.props, this.serverStats, this.charset);
        this.dispatcher = new RpcPacketDispatcher(this.props, this);
        Log.info("RPC connection to Perforce server " + this.serverHost + ":" + this.serverPort + " established");
        super.connect();
    }

    @Override
    public void disconnect() throws ConnectionException, AccessException {
        Log.info("Disconnected RPC connection to Perforce server " + this.serverHost + ":" + this.serverPort);
        this.dispatcher.shutdown(this.rpcConnection);
        this.rpcConnection.disconnect(this.dispatcher);
        this.haveSentProtocolSpecs = false;
        this.protocolSpecs = null;
        super.disconnect();
    }

    @Override
    public boolean setCharsetName(String charsetName) throws UnsupportedCharsetException {
        boolean retVal = super.setCharsetName(charsetName);
        this.rpcConnection.setClientCharset(this.charset);
        return retVal;
    }

    @Override
    public Map<String, Object>[] execMapCmd(String cmdName, String[] cmdArgs, Map<String, Object> inMap) throws ConnectionException, AccessException, RequestException {
        return this.execMapCmd(cmdName, cmdArgs, inMap, false);
    }

    @Override
    public Map<String, Object>[] execQuietMapCmd(String cmdName, String[] cmdArgs, Map<String, Object> inMap) throws ConnectionException, RequestException, AccessException {
        return this.execMapCmd(cmdName, cmdArgs, inMap, true);
    }

    protected Map<String, Object>[] execMapCmd(String cmdName, String[] cmdArgs, Map<String, Object> inMap, boolean ignoreCallbacks) throws ConnectionException, AccessException, RequestException {
        try {
            int cmdCallBackKey = this.nextCmdCallBackKey.incrementAndGet();
            long startTime = System.currentTimeMillis();
            ExternalEnv env = this.setupCmd(cmdName, cmdArgs, inMap, ignoreCallbacks, cmdCallBackKey);
            Map<String, Object>[] retMap = this.dispatcher.dispatch(new CommandEnv(new RpcCmdSpec(cmdName, cmdArgs, this.authTicket, inMap, env), this.rpcConnection, this.protocolSpecs, this.serverProtocolMap, this.progressCallback, cmdCallBackKey, this.writeInPlace(cmdName)));
            long endTime = System.currentTimeMillis();
            if (!ignoreCallbacks && this.commandCallback != null) {
                this.processCmdCallbacks(cmdCallBackKey, endTime - startTime, retMap);
            }
            return retMap;
        }
        catch (BufferOverflowException exc) {
            Log.error("RPC Buffer overflow: " + exc.getLocalizedMessage());
            Log.exception(exc);
            throw new P4JavaError("RPC Buffer overflow: " + exc.getLocalizedMessage(), exc);
        }
        catch (ConnectionNotConnectedException cnce) {
            this.connected = false;
            this.status = ServerStatus.ERROR;
            throw cnce;
        }
    }

    @Override
    public InputStream execQuietStreamCmd(String cmdName, String[] cmdArgs) throws ConnectionException, RequestException, AccessException {
        return this.execStreamCmd(cmdName, cmdArgs, true);
    }

    @Override
    public InputStream execStreamCmd(String cmdName, String[] cmdArgs) throws ConnectionException, RequestException, AccessException {
        return this.execStreamCmd(cmdName, cmdArgs, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected InputStream execStreamCmd(String cmdName, String[] cmdArgs, boolean ignoreCallbacks) throws ConnectionException, RequestException, AccessException {
        try {
            try {
                int cmdCallBackKey = this.nextCmdCallBackKey.incrementAndGet();
                long startTime = System.currentTimeMillis();
                ExternalEnv env = this.setupCmd(cmdName, cmdArgs, null, ignoreCallbacks, cmdCallBackKey);
                String tmpFileName = null;
                RpcPerforceFile tmpFile = null;
                RpcOutputStream tmpOutStream = null;
                try {
                    tmpFileName = RpcPerforceFile.createTempFileName(RpcPropertyDefs.getProperty(this.props, "com.perforce.p4java.tmpDir", System.getProperty("java.io.tmpdir")));
                    tmpFile = new RpcPerforceFile(tmpFileName, RpcPerforceFileType.FST_BINARY);
                    tmpOutStream = new RpcOutputStream(tmpFile);
                }
                catch (IOException ioexc) {
                    Log.error("tmp file creation error: " + ioexc.getLocalizedMessage());
                    Log.exception(ioexc);
                    throw new RequestException("Unable to create temporary file for Perforce file retrieval; reason: " + ioexc.getLocalizedMessage(), ioexc);
                }
                CommandEnv cmdEnv = new CommandEnv(new RpcCmdSpec(cmdName, cmdArgs, this.authTicket, null, env), this.rpcConnection, this.protocolSpecs, this.serverProtocolMap, this.progressCallback, cmdCallBackKey, this.writeInPlace(cmdName));
                cmdEnv.getStateMap().put("", tmpOutStream);
                Map<String, Object>[] retMap = this.dispatcher.dispatch(cmdEnv);
                long endTime = System.currentTimeMillis();
                if (!ignoreCallbacks && this.commandCallback != null) {
                    this.processCmdCallbacks(cmdCallBackKey, endTime - startTime, retMap);
                }
                if (retMap != null && retMap.length != 0) {
                    for (Map<String, Object> map : retMap) {
                        String errStr;
                        if (map == null || (errStr = this.getErrorStr(map)) == null) continue;
                        if (!this.isAuthFail(errStr)) throw new RequestException(errStr, this.getGenericCode(map), this.getSeverityCode(map));
                        throw new AccessException(errStr);
                    }
                }
                if (tmpOutStream == null) return null;
                tmpOutStream.close();
                TempFileInputStream inStream = new TempFileInputStream(tmpFile);
                return inStream;
            }
            catch (BufferOverflowException exc) {
                Log.error("RPC Buffer overflow: " + exc.getLocalizedMessage());
                Log.exception(exc);
                throw new P4JavaError("RPC Buffer overflow: " + exc.getLocalizedMessage(), exc);
            }
            catch (ConnectionNotConnectedException cnce) {
                this.connected = false;
                this.status = ServerStatus.ERROR;
                throw cnce;
            }
            catch (IOException ioexc) {
                Log.error("I/O error encountered in stream command: " + ioexc.getLocalizedMessage());
                Log.exception(ioexc);
                throw new RequestException("I/O error encountered in stream command: " + ioexc.getLocalizedMessage(), ioexc);
            }
        }
        catch (Throwable throwable) {
            Object var21_25 = null;
            throw throwable;
        }
    }

    protected ExternalEnv setupCmd(String cmdName, String[] cmdArgs, Map<String, Object> inMap, boolean ignoreCallbacks, int cmdCallBackKey) throws ConnectionException, AccessException, RequestException {
        if (this.rpcConnection == null) {
            throw new NullPointerError("Null RPC connection in execMapCmd call");
        }
        if (!this.connected) {
            throw new ConnectionNotConnectedException("Not currently connected to a Perforce server");
        }
        if (!CmdSpec.isValidP4JCmdSpec(cmdName)) {
            throw new RequestException("command name '" + cmdName + "' unimplemented or unrecognized by p4java");
        }
        ExternalEnv env = new ExternalEnv(this.getUsageOptions().getProgramName(), this.getUsageOptions().getProgramVersion(), this.getClientNameForEnv(), this.getUsageOptions().getWorkingDirectory(), this.getHostForEnv(), this.getUsageOptions().getTextLanguage(), this.getOsTypeForEnv(), this.getUserForEnv(), this.charsetName != null, this.charset);
        if (!ignoreCallbacks && this.commandCallback != null) {
            String cmd = cmdName;
            for (String argStr : cmdArgs) {
                if (argStr == null) continue;
                cmd = cmd + " " + argStr;
            }
            this.commandCallback.issuingServerCommand(cmdCallBackKey, cmd);
        }
        RpcPacket protPacket = null;
        if (!this.haveSentProtocolSpecs) {
            this.protocolSpecs = new ProtocolCommand(this.clientApiLevel, false, this.serverApiLevel, this.rpcConnection.getSystemSendBufferSize(), this.rpcConnection.getSystemRecvBufferSize(), true);
            this.protocolSpecs.setUseTags(true);
            protPacket = RpcPacket.constructRpcPacket(RpcFunctionSpec.PROTOCOL_PROTOCOL, this.protocolSpecs.asMap(), null);
            this.haveSentProtocolSpecs = true;
        }
        RpcFunctionSpec name = RpcFunctionSpec.decodeFromEndUserCmd(cmdName);
        RpcPacket cmdPacket = null;
        if (name == RpcFunctionSpec.USER_LOGIN) {
            String[] loginCmdArgs = new String[]{"-p"};
            cmdPacket = RpcPacket.constructRpcPacket(name, loginCmdArgs, env);
        } else {
            cmdPacket = RpcPacket.constructRpcPacket(name, cmdArgs, env);
        }
        if (protPacket == null) {
            this.rpcConnection.putRpcPacket(cmdPacket);
        } else {
            this.rpcConnection.putRpcPackets(new RpcPacket[]{protPacket, cmdPacket});
        }
        return env;
    }

    public RpcConnection getRpcConnection() {
        return this.rpcConnection;
    }

    public void setRpcConnection(RpcConnection rpcConnection) {
        this.rpcConnection = rpcConnection;
    }
}

