/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.sys;

import com.perforce.p4java.Log;
import com.perforce.p4java.exception.NullPointerError;
import com.perforce.p4java.impl.generic.client.ClientLineEnding;
import com.perforce.p4java.impl.generic.sys.ISystemFileCommandsHelper;
import com.perforce.p4java.impl.mapbased.rpc.sys.RpcPerforceFileType;
import com.perforce.p4java.impl.mapbased.rpc.sys.helper.SysFileHelperBridge;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;

public class RpcPerforceFile
extends File {
    public static String TRACE_PREFIX = "RpcPerforceFile";
    public static String systemTmpDirName = null;
    public static final String TMP_FILE_PFX = "p4j";
    public static final String TMP_FILE_SFX = ".tmp";
    private static final long serialVersionUID = 1L;
    private RpcPerforceFileType fileType = null;
    private ClientLineEnding lineEnding = null;

    public static String createTempFileName(String tmpDirName) {
        File tmpDir = null;
        try {
            if (tmpDirName != null) {
                tmpDir = new File(tmpDirName);
            }
            File tmpFile = File.createTempFile(TMP_FILE_PFX, TMP_FILE_SFX, tmpDir);
            return tmpFile.getPath();
        }
        catch (IOException ioexc) {
            Log.error("Unable to create temporary file: " + ioexc.getLocalizedMessage());
            return null;
        }
    }

    public RpcPerforceFile(String fileName, String fileTypeStr) {
        super(fileName);
        if (fileName == null) {
            throw new NullPointerError("Null file name passed to RpcPerforceFile constructor");
        }
        this.fileType = RpcPerforceFileType.decodeFromServerString(fileTypeStr);
        this.lineEnding = ClientLineEnding.decodeFromServerString(fileTypeStr, this.fileType);
    }

    public RpcPerforceFile(String fileName, RpcPerforceFileType fileType) {
        super(fileName);
        if (fileName == null) {
            throw new NullPointerError("Null file name passed to RpcPerforceFile constructor");
        }
        this.fileType = fileType;
        this.lineEnding = ClientLineEnding.FST_L_LOCAL;
    }

    public boolean renameTo(File targetFile) {
        return this.renameTo(targetFile, false);
    }

    public boolean renameTo(File targetFile, boolean alwaysCopyUnMunged) {
        if (targetFile == null) {
            throw new NullPointerError("Null target file in RpcPerforceFile.renameTo");
        }
        try {
            if (this.fileType == null || alwaysCopyUnMunged || this.canCopyAsIs()) {
                if (super.renameTo(targetFile)) {
                    return true;
                }
                return this.copyTo(targetFile);
            }
            return this.decodeTo(targetFile);
        }
        catch (IOException ioexc) {
            Log.error("Unexpected problem with renaming / copying file '" + targetFile.getName() + "': " + ioexc.getLocalizedMessage());
            Log.exception(ioexc);
            return false;
        }
    }

    private boolean setWritable(String filePath) {
        boolean writable = false;
        ISystemFileCommandsHelper helper = SysFileHelperBridge.getSysFileCommands();
        if (helper != null) {
            writable = helper.setWritable(filePath, true);
        }
        return writable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean copyTo(File targetFile) throws IOException {
        if (targetFile == null) {
            throw new NullPointerError("Null target file in RpcPerforceFile.copyTo");
        }
        if (targetFile.exists() && !targetFile.delete()) {
            if (!targetFile.canWrite() && this.setWritable(targetFile.getAbsolutePath())) {
                targetFile.delete();
            }
            if (targetFile.exists()) {
                Log.warn("Unable to delete target file for copy in RpcPerforceFile.copyTo; target: '" + targetFile.getPath());
            }
        }
        FileInputStream inStream = null;
        FileOutputStream outStream = null;
        AbstractInterruptibleChannel sourceChannel = null;
        AbstractInterruptibleChannel targetChannel = null;
        try {
            long bytesTransferred = 0L;
            inStream = new FileInputStream(this);
            outStream = new FileOutputStream(targetFile);
            sourceChannel = inStream.getChannel();
            targetChannel = outStream.getChannel();
            if (sourceChannel != null && targetChannel != null) {
                bytesTransferred = ((FileChannel)sourceChannel).transferTo(0L, ((FileChannel)sourceChannel).size(), (WritableByteChannel)((Object)targetChannel));
                if (bytesTransferred != ((FileChannel)sourceChannel).size()) {
                    Log.error("channel copy for copyTo operation failed with fewer bytes transferred than expected; expected: " + ((FileChannel)sourceChannel).size() + "; saw: " + bytesTransferred);
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
        }
        finally {
            try {
                if (sourceChannel != null) {
                    sourceChannel.close();
                }
                if (targetChannel != null) {
                    targetChannel.close();
                }
                if (inStream != null) {
                    inStream.close();
                }
                if (outStream != null) {
                    outStream.close();
                }
            }
            catch (Exception exc) {
                Log.warn("Unexpected exception in RpcPerforceFile.copyTo() final clause: " + exc.getLocalizedMessage());
                Log.exception(exc);
            }
        }
        return false;
    }

    public boolean decodeTo(File targetFile) throws IOException {
        if (targetFile == null) {
            throw new NullPointerError("Null target file in RpcPerforceFile.decodeTo");
        }
        return this.copyTo(targetFile);
    }

    public RpcPerforceFileType getFileType() {
        return this.fileType;
    }

    public void setFileType(RpcPerforceFileType fileType) {
        this.fileType = fileType;
    }

    public ClientLineEnding getLineEnding() {
        return this.lineEnding;
    }

    public void setLineEnding(ClientLineEnding lineEnding) {
        this.lineEnding = lineEnding;
    }

    public boolean canCopyAsIs() {
        return true;
    }
}

