/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.stream;

import com.perforce.p4java.Log;
import com.perforce.p4java.impl.mapbased.rpc.RpcPropertyDefs;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Queue;

public class RpcSocketPool {
    private static PoolManager MANAGER = new PoolManager();
    private Properties socketProperties;
    private String host;
    private int port;
    private int size;
    private ShutdownHandler shutdownHandler;
    private Queue<SocketEntry> pool;

    public static void configureSocket(Socket socket, Properties properties) {
        if (socket == null || properties == null) {
            return;
        }
        try {
            String keepAlive = RpcPropertyDefs.getProperty(properties, "useKeepAlive");
            int timeouts = RpcPropertyDefs.getPropertyAsInt(properties, "sockSoTimeout", 0);
            socket.setSoTimeout(timeouts);
            if (keepAlive != null && (keepAlive.startsWith("n") || keepAlive.startsWith("N"))) {
                socket.setKeepAlive(false);
            } else {
                socket.setKeepAlive(true);
            }
            int sockRecvBufSize = RpcPropertyDefs.getPropertyAsInt(properties, "sockRecvBufSize", 0);
            int sockSendBufSize = RpcPropertyDefs.getPropertyAsInt(properties, "sockSendBufSize", 0);
            if (sockRecvBufSize != 0) {
                socket.setReceiveBufferSize(sockRecvBufSize);
            }
            if (sockSendBufSize != 0) {
                socket.setSendBufferSize(sockSendBufSize);
            }
        }
        catch (Throwable exc) {
            Log.warn("Unexpected exception while setting Perforce RPC socket options: " + exc.getLocalizedMessage());
            Log.exception(exc);
        }
    }

    public RpcSocketPool(int poolSize, String host, int port, Properties socketProperties, ShutdownHandler shutdownHandler) {
        this.size = poolSize;
        this.host = host;
        this.port = port;
        this.socketProperties = socketProperties;
        this.pool = new LinkedList<SocketEntry>();
        this.shutdownHandler = shutdownHandler;
        MANAGER.register(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Socket acquire() throws IOException {
        Socket socket = null;
        Queue<SocketEntry> queue = this.pool;
        synchronized (queue) {
            SocketEntry entry = this.pool.poll();
            if (entry != null) {
                socket = entry.socket;
            }
        }
        if (!this.isAlive(socket)) {
            this.quietClose(socket);
            socket = this.configureSocket(this.host, this.port);
        }
        return socket;
    }

    private void quietClose(Socket socket) {
        if (socket != null) {
            try {
                socket.getInputStream().close();
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                socket.getOutputStream().close();
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private boolean isAlive(Socket socket) {
        return socket != null && socket.isBound() && !socket.isClosed() && socket.isConnected() && !socket.isInputShutdown() && !socket.isOutputShutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(Socket socket, ShutdownHandler shutdownHandler) throws IOException {
        if (this.isAlive(socket)) {
            boolean close = false;
            Queue<SocketEntry> queue = this.pool;
            synchronized (queue) {
                if (this.pool.size() < this.size) {
                    this.pool.add(new SocketEntry(socket));
                } else {
                    close = true;
                }
            }
            if (close) {
                if (shutdownHandler != null) {
                    shutdownHandler.shutdown(socket);
                }
                if (!socket.isClosed()) {
                    socket.getInputStream().close();
                }
                if (!socket.isClosed()) {
                    socket.getOutputStream().close();
                }
                socket.close();
            }
        }
    }

    private void close(Socket socket) throws IOException {
        if (socket != null) {
            if (!socket.isClosed()) {
                socket.getInputStream().close();
            }
            if (!socket.isClosed()) {
                socket.getOutputStream().close();
            }
            socket.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        Socket[] sockets = null;
        try {
            Queue<SocketEntry> queue = this.pool;
            synchronized (queue) {
                sockets = new Socket[this.pool.size()];
                int count = 0;
                for (SocketEntry entry : this.pool) {
                    sockets[count] = entry.socket;
                    ++count;
                }
                this.pool.clear();
            }
            for (Socket socket : sockets) {
                if (this.shutdownHandler != null) {
                    this.shutdownHandler.shutdown(socket);
                }
                try {
                    this.close(socket);
                }
                catch (IOException e) {
                    Log.exception(e);
                }
            }
        }
        finally {
            MANAGER.unregister(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timeout(int idleDuration) {
        Queue<SocketEntry> queue = this.pool;
        synchronized (queue) {
            ArrayList<SocketEntry> closed = new ArrayList<SocketEntry>();
            for (SocketEntry entry : this.pool) {
                long openTime = System.currentTimeMillis() - entry.releaseTime;
                if (openTime < (long)idleDuration) continue;
                if (this.shutdownHandler != null) {
                    this.shutdownHandler.shutdown(entry.socket);
                }
                this.quietClose(entry.socket);
                closed.add(entry);
            }
            this.pool.removeAll(closed);
        }
    }

    private Socket configureSocket(String host, int port) throws IOException {
        Socket socket = new Socket();
        RpcSocketPool.configureSocket(socket, this.socketProperties);
        socket.bind(new InetSocketAddress(0));
        socket.connect(new InetSocketAddress(host, port));
        return socket;
    }

    private class SocketEntry {
        Socket socket;
        long releaseTime;

        public SocketEntry(Socket socket) {
            this.socket = socket;
            this.releaseTime = System.currentTimeMillis();
        }
    }

    private static class PoolManager
    implements Runnable {
        private static final String RPC_SOCKET_IDLE_TIME = "com.perforce.p4java.RPC_SOCKET_IDLE_TIME";
        private static final int DEFAULT_SOCKET_IDLE_TIME = 30000;
        private int idleTime;
        private List<RpcSocketPool> pools = new ArrayList<RpcSocketPool>();
        private boolean started = false;

        public PoolManager() {
            int time = 30000;
            String configuredTime = System.getProperty(RPC_SOCKET_IDLE_TIME);
            if (configuredTime != null) {
                try {
                    time = Integer.parseInt(configuredTime);
                }
                catch (NumberFormatException nfe) {
                    time = 30000;
                }
            }
            this.idleTime = time;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void register(RpcSocketPool pool) {
            if (pool != null) {
                Object object = this;
                synchronized (object) {
                    this.pools.add(pool);
                }
                if (this.started) {
                    object = this.pools;
                    synchronized (object) {
                        this.pools.notify();
                    }
                } else {
                    this.start();
                }
            }
        }

        public void start() {
            this.started = true;
            Thread thread = new Thread(this);
            thread.setName("P4Java Socket Pool Manager");
            thread.setPriority(1);
            thread.setDaemon(true);
            thread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregister(RpcSocketPool pool) {
            if (pool != null) {
                PoolManager poolManager = this;
                synchronized (poolManager) {
                    this.pools.remove(pool);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                if (this.pools.isEmpty()) {
                    List<RpcSocketPool> list = this.pools;
                    synchronized (list) {
                        try {
                            this.pools.wait();
                        }
                        catch (InterruptedException e) {
                        }
                    }
                }
                RpcSocketPool[] pools = null;
                PoolManager e = this;
                synchronized (e) {
                    pools = this.pools.toArray(new RpcSocketPool[this.pools.size()]);
                }
                for (RpcSocketPool pool : pools) {
                    pool.timeout(this.idleTime);
                }
                try {
                    Thread.sleep(this.idleTime);
                }
                catch (InterruptedException e2) {
                    return;
                }
            }
        }
    }

    public static interface ShutdownHandler {
        public void shutdown(Socket var1);
    }
}

