/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.client;

import com.perforce.p4java.Log;
import com.perforce.p4java.client.IClient;
import com.perforce.p4java.client.IClientSummary;
import com.perforce.p4java.core.IChangelist;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.core.file.IntegrationOptions;
import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.NullPointerError;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.exception.RequestException;
import com.perforce.p4java.impl.generic.client.ClientView;
import com.perforce.p4java.impl.generic.core.InputMapper;
import com.perforce.p4java.impl.generic.core.MapEntry;
import com.perforce.p4java.impl.mapbased.client.ClientSummary;
import com.perforce.p4java.impl.mapbased.rpc.RpcServer;
import com.perforce.p4java.impl.mapbased.server.Server;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.IServer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Client
extends ClientSummary
implements IClient {
    public static final String MERGE_TMP_FILENAME_KEY = "P4JMergeTmpFile";
    private Server serverImpl = null;
    private ClientView clientView = null;

    public Client() {
        this.refreshable = true;
        this.updateable = true;
    }

    public Client(IServer server) {
        this.refreshable = true;
        this.updateable = true;
        this.serverImpl = (Server)server;
    }

    public Client(String name, Date accessed, Date updated, String description, String hostName, String ownerName, String root, IClientSummary.ClientLineEnd lineEnd, IClientSummary.IClientOptions options, IClientSummary.IClientSubmitOptions submitOptions, List<String> alternateRoots, IServer serverImpl, ClientView clientView) {
        super(name, accessed, updated, description, hostName, ownerName, root, lineEnd, options, submitOptions, alternateRoots);
        this.serverImpl = (Server)serverImpl;
        this.clientView = clientView;
    }

    public Client(IServer serverImpl, Map<String, Object> map) {
        super(map, false);
        this.refreshable = true;
        this.updateable = true;
        this.serverImpl = (Server)serverImpl;
        if (map != null) {
            this.name = (String)map.get("Client");
            ClientView viewImpl = new ClientView();
            ArrayList<ClientView.ClientViewMapping> mappingList = new ArrayList<ClientView.ClientViewMapping>();
            viewImpl.setEntryList(mappingList);
            this.clientView = viewImpl;
            String pfx = "View";
            int i = 0;
            while (map.containsKey(pfx + i)) {
                String key = pfx + i;
                String[] parts = MapEntry.parseViewMappingString((String)map.get(key));
                if (parts.length < 2) {
                    throw new P4JavaError("bad client view mapping string in Client constructor: " + (String)map.get(key));
                }
                mappingList.add(new ClientView.ClientViewMapping(i, parts[0], parts[1]));
                ++i;
            }
            this.description = (String)map.get("Description");
            if (this.description != null && this.description.length() > 1 && this.description.endsWith("\n")) {
                this.description = this.description.substring(0, this.description.length() - 1);
            }
            try {
                this.accessed = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").parse((String)map.get("Access"));
                this.updated = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").parse((String)map.get("Update"));
                viewImpl.setClient(this);
            }
            catch (Exception exc) {
                Log.error("Date parse error in Client constructor " + exc.getLocalizedMessage());
                Log.exception(exc);
            }
        }
    }

    public Client(IClientSummary clientSummary, boolean refresh) throws ConnectionException, RequestException, AccessException {
        this(clientSummary, null, refresh);
    }

    public Client(IClientSummary clientSummary, IServer serverImpl, boolean refresh) throws ConnectionException, RequestException, AccessException {
        super(false);
        this.serverImpl = (Server)serverImpl;
        if (clientSummary != null) {
            if (refresh) {
                if (clientSummary.getName() == null) {
                    throw new NullPointerError("Null label name in client summary object passed to Client constructor");
                }
                this.name = clientSummary.getName();
                this.refresh();
            } else {
                this.name = clientSummary.getName();
                this.accessed = clientSummary.getAccessed();
                this.updated = clientSummary.getUpdated();
                this.description = clientSummary.getDescription();
                this.hostName = clientSummary.getHostName();
                this.ownerName = clientSummary.getOwnerName();
                this.root = clientSummary.getRoot();
                this.lineEnd = clientSummary.getLineEnd();
                this.options = clientSummary.getOptions();
                this.submitOptions = clientSummary.getSubmitOptions();
                this.alternateRoots = clientSummary.getAlternateRoots();
            }
        }
    }

    @Override
    public IServer getServer() {
        return this.serverImpl;
    }

    @Override
    public void complete() throws ConnectionException, RequestException, AccessException {
    }

    @Override
    public void refresh() throws ConnectionException, RequestException, AccessException {
        IClient refreshedClient;
        Server refreshServer = this.serverImpl;
        String refreshName = null;
        refreshName = this.getName();
        if (refreshServer != null && refreshName != null && (refreshedClient = refreshServer.getClient(refreshName)) != null) {
            this.setName(refreshName);
            this.setAccessed(refreshedClient.getAccessed());
            this.setUpdated(refreshedClient.getUpdated());
            this.setAlternateRoots(refreshedClient.getAlternateRoots());
            this.setClientView(refreshedClient.getClientView());
            this.setDescription(refreshedClient.getDescription());
            this.setHostName(refreshedClient.getHostName());
            this.setLineEnd(refreshedClient.getLineEnd());
            this.setOptions(refreshedClient.getOptions());
            this.setOwnerName(refreshedClient.getOwnerName());
            this.setRoot(refreshedClient.getRoot());
            this.setSubmitOptions(refreshedClient.getSubmitOptions());
            this.setUpdated(refreshedClient.getUpdated());
        }
    }

    @Override
    public void update() throws ConnectionException, RequestException, AccessException {
        if (this.serverImpl == null) {
            throw new NullPointerError("Attempted to update client with no associated server set on client");
        }
        this.serverImpl.updateClient(this);
    }

    @Override
    public ClientView getClientView() {
        return this.clientView;
    }

    @Override
    public void setClientView(ClientView clientView) {
        this.clientView = clientView;
    }

    @Override
    public void setServer(IServer server) {
        this.serverImpl = (Server)server;
    }

    @Override
    public List<IFileSpec> sync(List<IFileSpec> fileSpecs, boolean forceUpdate, boolean noUpdate, boolean clientBypass, boolean serverBypass) throws ConnectionException, RequestException, AccessException {
        Map<String, Object>[] syncMap;
        int argSize = 0;
        ArrayList<IFileSpec> specList = new ArrayList<IFileSpec>();
        if (forceUpdate) {
            ++argSize;
        }
        if (noUpdate) {
            ++argSize;
        }
        if (clientBypass) {
            ++argSize;
        }
        if (serverBypass) {
            ++argSize;
        }
        String[] args = new String[argSize];
        int i = 0;
        if (forceUpdate) {
            args[i++] = "-f";
        }
        if (noUpdate) {
            args[i++] = "-n";
        }
        if (clientBypass) {
            args[i++] = "-k";
        }
        if (serverBypass) {
            args[i++] = "-p";
        }
        if ((syncMap = this.serverImpl.execMapCmd(CmdSpec.SYNC, Server.getPreferredPathArray(args, fileSpecs), null)) != null) {
            for (Map<String, Object> map : syncMap) {
                specList.add(this.serverImpl.handleFileReturn(map, this));
            }
        }
        return specList;
    }

    @Override
    public List<IFileSpec> labelSync(List<IFileSpec> fileSpecs, String labelName, boolean noUpdate, boolean addFiles, boolean deleteFiles) throws ConnectionException, RequestException, AccessException {
        if (labelName == null) {
            throw new NullPointerError("null label name passed to Client.labelSync()");
        }
        String[] args = null;
        int argNum = 1;
        if (noUpdate) {
            ++argNum;
        }
        if (addFiles) {
            ++argNum;
        }
        if (deleteFiles) {
            ++argNum;
        }
        if (fileSpecs != null) {
            argNum += fileSpecs.size();
        }
        args = new String[argNum];
        int i = 0;
        if (noUpdate) {
            args[i++] = "-n";
        }
        if (addFiles) {
            args[i++] = "-a";
        }
        if (deleteFiles) {
            args[i++] = "-d";
        }
        args[i++] = "-l" + labelName;
        ArrayList<IFileSpec> specList = new ArrayList<IFileSpec>();
        Map<String, Object>[] syncMap = this.serverImpl.execMapCmd(CmdSpec.LABELSYNC, Server.populatePathArray(args, i, fileSpecs), null);
        if (syncMap != null) {
            for (Map<String, Object> map : syncMap) {
                specList.add(this.serverImpl.handleFileReturn(map, this));
            }
        }
        return specList;
    }

    @Override
    public IChangelist createChangelist(IChangelist newChangelist) throws ConnectionException, RequestException, AccessException {
        if (this.getName() == null) {
            throw new NullPointerError("Null client name in newChangelist method call");
        }
        if (newChangelist == null) {
            throw new NullPointerError("Null new change list specification in newChangelist method call");
        }
        if (newChangelist.getId() != -1) {
            throw new RequestException("New changelist ID must be set to IChangelist.UNKNOWN");
        }
        Map<String, Object>[] changeMap = this.serverImpl.execMapCmd(CmdSpec.CHANGE, new String[]{"-i"}, InputMapper.map(newChangelist));
        if (changeMap != null) {
            int id = -1;
            for (Map<String, Object> map : changeMap) {
                if (!this.serverImpl.handleErrorStr(map)) {
                    if (map.containsKey("change")) {
                        int i;
                        String changeStr = (String)map.get("change");
                        if (changeStr != null && (i = changeStr.indexOf(" ")) > 0 && i < changeStr.length()) {
                            try {
                                id = new Integer(changeStr.substring(i + 1));
                            }
                            catch (Exception exc) {
                                Log.error("Unexpected exception in Client.newChangelist: " + exc.getLocalizedMessage());
                                Log.exception(exc);
                            }
                        }
                    } else {
                        String[] strs;
                        String infoStr = this.serverImpl.getInfoStr(map);
                        if (infoStr != null && infoStr.contains("Change ") && infoStr.contains(" created") && (strs = infoStr.split(" ")).length >= 3 && strs[1] != null) {
                            id = -1;
                            try {
                                id = new Integer(strs[1]);
                            }
                            catch (Exception exc) {
                                Log.error("Unexpected exception in Client.newChangelist: " + exc.getLocalizedMessage());
                                Log.exception(exc);
                            }
                        }
                    }
                }
                if (id == -1) continue;
                return this.serverImpl.getChangelist(id);
            }
        }
        return null;
    }

    @Override
    public List<IFileSpec> addFiles(List<IFileSpec> fileSpecs, boolean noUpdate, int changeListId, String fileType, boolean useWildcards) throws ConnectionException, AccessException {
        Map<String, Object>[] addMap;
        int argCount = 0;
        String[] args = null;
        ArrayList<IFileSpec> resultList = new ArrayList<IFileSpec>();
        if (noUpdate) {
            ++argCount;
        }
        if (changeListId > 0) {
            ++argCount;
        }
        if (fileType != null) {
            ++argCount;
        }
        if (useWildcards) {
            ++argCount;
        }
        args = new String[argCount];
        int i = 0;
        if (noUpdate) {
            args[i++] = "-n";
        }
        if (changeListId > 0) {
            args[i++] = "-c" + changeListId;
        }
        if (fileType != null) {
            args[i++] = "-t" + fileType;
        }
        if (useWildcards) {
            args[i++] = "-f";
        }
        if ((addMap = this.serverImpl.execMapCmd(CmdSpec.ADD, Server.getPreferredPathArray(args, fileSpecs), null)) != null) {
            for (Map<String, Object> map : addMap) {
                resultList.add(this.serverImpl.handleFileReturn(map, this));
            }
        }
        return resultList;
    }

    @Override
    public List<IFileSpec> deleteFiles(List<IFileSpec> fileSpecs, int changeListId, boolean noUpdate) throws ConnectionException, AccessException {
        Map<String, Object>[] deleteMap;
        int argCount = 0;
        String[] args = null;
        ArrayList<IFileSpec> resultList = new ArrayList<IFileSpec>();
        if (noUpdate) {
            ++argCount;
        }
        if (changeListId > 0) {
            ++argCount;
        }
        args = new String[argCount];
        int i = 0;
        if (noUpdate) {
            args[i++] = "-n";
        }
        if (changeListId > 0) {
            args[i++] = "-c" + changeListId;
        }
        if ((deleteMap = this.serverImpl.execMapCmd(CmdSpec.DELETE, Server.getPreferredPathArray(args, fileSpecs), null)) != null) {
            for (Map<String, Object> map : deleteMap) {
                resultList.add(this.serverImpl.handleFileReturn(map, this));
            }
        }
        return resultList;
    }

    @Override
    public List<IFileSpec> editFiles(List<IFileSpec> fileSpecs, boolean noUpdate, boolean bypassClientUpdate, int changeListId, String fileType) throws RequestException, ConnectionException, AccessException {
        Map<String, Object>[] editMap;
        int MINIMUM_OPTION_K_SERVER_VERSION = 20092;
        int argCount = 0;
        String[] args = null;
        ArrayList<IFileSpec> resultList = new ArrayList<IFileSpec>();
        if (noUpdate) {
            ++argCount;
        }
        if (bypassClientUpdate) {
            if (this.serverImpl.getServerVersionNumber() < 20092) {
                throw new RequestException("edit option 'bypassClientUpdate' only supported on servers 2009.2 and later");
            }
            ++argCount;
        }
        if (changeListId > 0) {
            ++argCount;
        }
        if (fileType != null) {
            ++argCount;
        }
        args = new String[argCount];
        int i = 0;
        if (noUpdate) {
            args[i++] = "-n";
        }
        if (bypassClientUpdate) {
            args[i++] = "-k";
        }
        if (changeListId > 0) {
            args[i++] = "-c" + changeListId;
        }
        if (fileType != null) {
            args[i++] = "-t" + fileType;
        }
        if ((editMap = this.serverImpl.execMapCmd(CmdSpec.EDIT, Server.getPreferredPathArray(args, fileSpecs, false), null)) != null) {
            for (Map<String, Object> result : editMap) {
                resultList.add(this.serverImpl.handleFileReturn(result, this));
            }
        }
        return resultList;
    }

    @Override
    public List<IFileSpec> revertFiles(List<IFileSpec> fileSpecs, boolean noUpdate, int changeListId, boolean revertOnlyUnchanged, boolean noRefresh) throws ConnectionException, AccessException {
        Map<String, Object>[] revertMap;
        int argCount = 0;
        String[] args = null;
        ArrayList<IFileSpec> resultList = new ArrayList<IFileSpec>();
        if (noUpdate) {
            ++argCount;
        }
        if (changeListId > 0 || changeListId == 0) {
            ++argCount;
        }
        if (revertOnlyUnchanged) {
            ++argCount;
        }
        if (noRefresh) {
            ++argCount;
        }
        args = new String[argCount];
        int i = 0;
        if (noUpdate) {
            args[i++] = "-n";
        }
        if (changeListId == 0) {
            args[i++] = "-cdefault";
        } else if (changeListId > 0) {
            args[i++] = "-c" + changeListId;
        }
        if (revertOnlyUnchanged) {
            args[i++] = "-a";
        }
        if (noRefresh) {
            args[i++] = "-k";
        }
        if ((revertMap = this.serverImpl.execMapCmd(CmdSpec.REVERT, Server.getPreferredPathArray(args, fileSpecs), null)) != null) {
            for (Map<String, Object> result : revertMap) {
                resultList.add(this.serverImpl.handleFileReturn(result, this));
            }
        }
        return resultList;
    }

    @Override
    public List<IFileSpec> haveList(List<IFileSpec> fileSpecs) throws ConnectionException, AccessException {
        ArrayList<IFileSpec> haveList = new ArrayList<IFileSpec>();
        Map<String, Object>[] haveMap = this.serverImpl.execMapCmd(CmdSpec.HAVE, Server.getPreferredPathArray(null, fileSpecs), null);
        if (haveMap != null) {
            for (Map<String, Object> result : haveMap) {
                haveList.add(this.serverImpl.handleFileReturn(result, this));
            }
        }
        return haveList;
    }

    @Override
    public List<IFileSpec> reopenFiles(List<IFileSpec> fileSpecs, int changeListId, String fileType) throws ConnectionException, AccessException {
        Map<String, Object>[] resultsMap;
        int argCount = 0;
        if (changeListId > 0 || changeListId == 0) {
            ++argCount;
        }
        if (fileType != null) {
            ++argCount;
        }
        ArrayList<IFileSpec> resultList = new ArrayList<IFileSpec>();
        String[] args = new String[argCount];
        int i = 0;
        if (changeListId == 0) {
            args[i++] = "-cdefault";
        } else if (changeListId > 0) {
            args[i++] = "-c" + changeListId;
        }
        if (fileType != null) {
            args[i++] = "-t" + fileType;
        }
        if ((resultsMap = this.serverImpl.execMapCmd(CmdSpec.REOPEN, Server.getPreferredPathArray(args, fileSpecs), null)) != null) {
            for (Map<String, Object> result : resultsMap) {
                resultList.add(this.serverImpl.handleFileReturn(result, this));
            }
        }
        return resultList;
    }

    @Override
    public List<IFileSpec> where(List<IFileSpec> fileSpecs) throws ConnectionException, AccessException {
        ArrayList<IFileSpec> resultList = new ArrayList<IFileSpec>();
        Map<String, Object>[] whereMap = this.serverImpl.execMapCmd(CmdSpec.WHERE, Server.getPreferredPathArray(null, fileSpecs), null);
        if (whereMap != null) {
            for (Map<String, Object> result : whereMap) {
                resultList.add(this.serverImpl.handleFileReturn(result, this));
            }
        }
        return resultList;
    }

    @Override
    public List<IFileSpec> openedFiles(List<IFileSpec> fileSpecs, int maxFiles, int changeListId) throws ConnectionException, AccessException {
        return this.serverImpl.getOpenedFiles(fileSpecs, false, this.getName(), maxFiles, changeListId);
    }

    @Override
    public List<IFileSpec> integrateFiles(int changeListId, boolean showActionsOnly, IntegrationOptions integOpts, String branchSpec, IFileSpec fromFile, IFileSpec toFile) throws ConnectionException, AccessException {
        if (integOpts == null) {
            integOpts = new IntegrationOptions();
        }
        int argSize = 0;
        if (fromFile != null) {
            ++argSize;
        }
        if (toFile != null) {
            ++argSize;
        }
        if (changeListId != 0 && changeListId != -1) {
            ++argSize;
        }
        if (showActionsOnly) {
            ++argSize;
        }
        if (branchSpec != null && branchSpec.trim().length() > 0) {
            ++argSize;
        }
        if (integOpts.isUseHaveRev()) {
            ++argSize;
        }
        if (integOpts.isBaselessMerge()) {
            ++argSize;
        }
        if (integOpts.isDisplayBaseDetails()) {
            ++argSize;
        }
        if (integOpts.isPropagateType()) {
            ++argSize;
        }
        if (integOpts.isDontCopyToClient()) {
            ++argSize;
        }
        if (integOpts.isForce()) {
            ++argSize;
        }
        if (integOpts.getDeletedOptions() != null) {
            argSize += integOpts.getDeletedOptions().length;
        }
        if (integOpts.isBidirectionalInteg()) {
            ++argSize;
        }
        if (integOpts.isReverseMapping()) {
            ++argSize;
        }
        String[] args = new String[argSize];
        int i = 0;
        if (changeListId != 0 && changeListId != -1) {
            args[i++] = "-c" + changeListId;
        }
        if (showActionsOnly) {
            args[i++] = "-n";
        }
        if (integOpts.isUseHaveRev()) {
            args[i++] = "-h";
        }
        if (integOpts.isBaselessMerge()) {
            args[i++] = "-i";
        }
        if (integOpts.isDisplayBaseDetails()) {
            args[i++] = "-o";
        }
        if (integOpts.isPropagateType()) {
            args[i++] = "-t";
        }
        if (integOpts.isDontCopyToClient()) {
            args[i++] = "-v";
        }
        if (integOpts.isForce()) {
            args[i++] = "-f";
        }
        if (integOpts.getDeletedOptions() != null) {
            for (String str : integOpts.getDeletedOptions()) {
                if (str == null) {
                    throw new NullPointerError("Null entry in integrateFiles delete option array");
                }
                args[i++] = "-" + str;
            }
        }
        if (integOpts.isReverseMapping()) {
            args[i++] = "-r";
        }
        if (branchSpec != null && branchSpec.trim().length() > 0) {
            args[i++] = "-b" + branchSpec.trim();
        }
        if (integOpts.isBidirectionalInteg()) {
            args[i++] = "-s";
        }
        if (fromFile != null) {
            args[i++] = fromFile.getAnnotatedPreferredPathString();
        }
        if (toFile != null) {
            args[i++] = toFile.getAnnotatedPreferredPathString();
        }
        ArrayList<IFileSpec> integList = new ArrayList<IFileSpec>();
        Map<String, Object>[] resultsMap = this.serverImpl.execMapCmd(CmdSpec.INTEG, args, null);
        if (resultsMap != null) {
            for (Map<String, Object> result : resultsMap) {
                integList.add(this.serverImpl.handleIntegrationFileReturn(result, this));
            }
        }
        return integList;
    }

    @Override
    public List<IFileSpec> resolveFilesAuto(List<IFileSpec> fileSpecs, boolean safeMerge, boolean acceptTheirs, boolean acceptYours, boolean showActionsOnly, boolean forceResolve) throws ConnectionException, AccessException {
        int argSize = 0;
        if (safeMerge) {
            ++argSize;
        }
        if (showActionsOnly) {
            ++argSize;
        }
        if (acceptTheirs) {
            ++argSize;
        }
        if (acceptYours) {
            ++argSize;
        }
        if (!(forceResolve || acceptYours || acceptTheirs || safeMerge)) {
            ++argSize;
        }
        if (forceResolve) {
            ++argSize;
        }
        if (fileSpecs != null) {
            argSize += fileSpecs.size();
        }
        String[] args = new String[argSize];
        int i = 0;
        if (!(forceResolve || acceptTheirs || acceptYours || safeMerge)) {
            args[i++] = "-am";
        }
        if (safeMerge) {
            args[i++] = "-as";
        }
        if (acceptYours) {
            args[i++] = "-ay";
        }
        if (acceptTheirs) {
            args[i++] = "-at";
        }
        if (showActionsOnly) {
            args[i++] = "-n";
        }
        if (forceResolve) {
            args[i++] = "-af";
        }
        ArrayList<IFileSpec> resolveList = new ArrayList<IFileSpec>();
        Map<String, Object>[] resultsMap = this.serverImpl.execMapCmd(CmdSpec.RESOLVE, Server.populatePathArray(args, i, fileSpecs), null);
        if (resultsMap != null) {
            for (Map<String, Object> result : resultsMap) {
                resolveList.add(this.serverImpl.handleIntegrationFileReturn(result, this));
            }
        }
        return resolveList;
    }

    @Override
    public IFileSpec resolveFile(IFileSpec targetFile, InputStream sourceStream) throws ConnectionException, RequestException, AccessException {
        if (targetFile == null) {
            throw new NullPointerError("Null target file spec passed to IClient.resolveFile");
        }
        if (sourceStream == null) {
            throw new NullPointerError("Null source stream passed to IClient.resolveFile");
        }
        if (!(this.serverImpl instanceof RpcServer)) {
            throw new RequestException("Request not supported by the current P4Java implementation; use an RPC-based pure Java implementation if possible");
        }
        HashMap<String, Object> resolveMap = new HashMap<String, Object>();
        IFileSpec fileSpec = null;
        if (this.serverImpl != null) {
            File tmpFile = null;
            try {
                Map<String, Object>[] resultMaps;
                File tmpDir = new File(this.serverImpl.getProperties().getProperty("com.perforce.p4java.tmpDir", System.getProperty("java.io.tmpdir")));
                tmpFile = File.createTempFile("p4java", ".tmp", tmpDir);
                if (tmpFile != null) {
                    FileOutputStream outStream = new FileOutputStream(tmpFile);
                    byte[] bytes = new byte[1024];
                    int bytesRead = 0;
                    while ((bytesRead = sourceStream.read(bytes)) > 0) {
                        outStream.write(bytes, 0, bytesRead);
                    }
                    outStream.close();
                    resolveMap.put(MERGE_TMP_FILENAME_KEY, tmpFile.getPath());
                }
                if ((resultMaps = this.serverImpl.execMapCmd(CmdSpec.RESOLVE, new String[]{targetFile.getAnnotatedPreferredPathString()}, resolveMap)) != null) {
                    IFileSpec iFileSpec;
                    if (resultMaps.length > 1) {
                        iFileSpec = this.serverImpl.handleIntegrationFileReturn(resultMaps[1], true);
                        return iFileSpec;
                    }
                    iFileSpec = this.serverImpl.handleIntegrationFileReturn(resultMaps[0], false);
                    return iFileSpec;
                }
            }
            catch (IOException exc) {
                Log.error("local file I/O error on resolve: " + exc.getMessage());
                Log.exception(exc);
                throw new P4JavaError("local file I/O error on resolve: " + exc.getMessage());
            }
            finally {
                if (tmpFile != null) {
                    tmpFile.delete();
                }
            }
        }
        return fileSpec;
    }

    @Override
    public List<IFileSpec> resolvedFiles(List<IFileSpec> fileSpecs, boolean showBaseRevision) throws ConnectionException, AccessException {
        int argSize = 0;
        if (showBaseRevision) {
            ++argSize;
        }
        if (fileSpecs != null) {
            argSize += fileSpecs.size();
        }
        String[] args = new String[argSize];
        int i = 0;
        if (showBaseRevision) {
            args[i++] = "-o";
        }
        ArrayList<IFileSpec> resolvedList = new ArrayList<IFileSpec>();
        Map<String, Object>[] resultsMap = this.serverImpl.execMapCmd(CmdSpec.RESOLVED, Server.getPreferredPathArray(args, fileSpecs), null);
        if (resultsMap != null) {
            for (Map<String, Object> result : resultsMap) {
                resolvedList.add(this.serverImpl.handleIntegrationFileReturn(result, this));
            }
        }
        return resolvedList;
    }

    @Override
    public List<IFileSpec> lockFiles(List<IFileSpec> fileSpecs, int changeListId) throws ConnectionException, AccessException {
        int argSize = 0;
        if (changeListId == 0 || changeListId > 0) {
            ++argSize;
        }
        if (fileSpecs != null) {
            argSize += fileSpecs.size();
        }
        String[] args = new String[argSize];
        int i = 0;
        if (changeListId == 0 || changeListId > 0) {
            args[i++] = "-c" + (changeListId == 0 ? "default" : Integer.valueOf(changeListId));
        }
        ArrayList<IFileSpec> lockedList = new ArrayList<IFileSpec>();
        Map<String, Object>[] resultsMap = this.serverImpl.execMapCmd(CmdSpec.LOCK, Server.getPreferredPathArray(args, fileSpecs), null);
        if (resultsMap != null) {
            for (Map<String, Object> result : resultsMap) {
                lockedList.add(this.serverImpl.handleFileReturn(result, this));
            }
        }
        return lockedList;
    }

    @Override
    public List<IFileSpec> unlockFiles(List<IFileSpec> fileSpecs, int changeListId, boolean force) throws ConnectionException, AccessException {
        int argSize = 0;
        if (changeListId == 0 || changeListId > 0) {
            ++argSize;
        }
        if (force) {
            ++argSize;
        }
        if (fileSpecs != null) {
            argSize += fileSpecs.size();
        }
        String[] args = new String[argSize];
        int i = 0;
        if (changeListId == 0 || changeListId > 0) {
            args[i++] = "-c" + (changeListId == 0 ? "default" : Integer.valueOf(changeListId));
        }
        if (force) {
            args[i++] = "-f";
        }
        ArrayList<IFileSpec> unlockedList = new ArrayList<IFileSpec>();
        Map<String, Object>[] resultsMap = this.serverImpl.execMapCmd(CmdSpec.UNLOCK, Server.getPreferredPathArray(args, fileSpecs), null);
        if (resultsMap != null) {
            for (Map<String, Object> result : resultsMap) {
                unlockedList.add(this.serverImpl.handleFileReturn(result, this));
            }
        }
        return unlockedList;
    }

    @Override
    public List<IFileSpec> getDiffFiles(List<IFileSpec> fileSpecs, int maxFiles, boolean diffNonTextFiles, boolean openedDifferentMissing, boolean openedForIntegrate, boolean unopenedMissing, boolean unopenedDifferent, boolean unopenedWithStatus, boolean openedSame) throws ConnectionException, RequestException, AccessException {
        int argSize = 0;
        boolean sFlag = false;
        if (maxFiles > 0) {
            ++argSize;
        }
        if (diffNonTextFiles) {
            ++argSize;
            sFlag = true;
        }
        if (openedDifferentMissing) {
            ++argSize;
            sFlag = true;
        }
        if (openedForIntegrate) {
            ++argSize;
            sFlag = true;
        }
        if (unopenedMissing) {
            ++argSize;
            sFlag = true;
        }
        if (unopenedDifferent) {
            ++argSize;
            sFlag = true;
        }
        if (unopenedWithStatus) {
            ++argSize;
            sFlag = true;
        }
        if (openedSame) {
            ++argSize;
            sFlag = true;
        }
        if (fileSpecs != null) {
            argSize += fileSpecs.size();
        }
        if (!sFlag) {
            throw new RequestException("No 's' option set for IClient.getDiffFileList method");
        }
        String[] args = new String[argSize];
        int i = 0;
        if (maxFiles > 0) {
            args[i++] = "-m" + maxFiles;
        }
        if (diffNonTextFiles) {
            args[i++] = "-t";
        }
        if (openedDifferentMissing) {
            args[i++] = "-sa";
        }
        if (openedForIntegrate) {
            args[i++] = "-sb";
        }
        if (unopenedMissing) {
            args[i++] = "-sd";
        }
        if (unopenedDifferent) {
            args[i++] = "-se";
        }
        if (unopenedWithStatus) {
            args[i++] = "-sl";
        }
        if (openedSame) {
            args[i++] = "-sr";
        }
        ArrayList<IFileSpec> diffList = new ArrayList<IFileSpec>();
        Map<String, Object>[] resultsMap = this.serverImpl.execMapCmd(CmdSpec.DIFF, Server.getPreferredPathArray(args, fileSpecs), null);
        if (resultsMap != null) {
            for (Map<String, Object> result : resultsMap) {
                diffList.add(this.serverImpl.handleFileReturn(result, this));
            }
        }
        return diffList;
    }

    @Override
    public List<IFileSpec> shelveChangelist(int changelistId, List<IFileSpec> fileSpecs, boolean forceUpdate, boolean replace, boolean discard) throws ConnectionException, RequestException, AccessException {
        int argCount = 0;
        if (changelistId > 0 || changelistId == 0) {
            ++argCount;
        }
        if (forceUpdate) {
            ++argCount;
        }
        if (replace) {
            ++argCount;
        }
        if (discard) {
            ++argCount;
        }
        String[] args = new String[argCount];
        int i = 0;
        if (changelistId == 0) {
            args[i++] = "-cdefault";
        } else if (changelistId > 0) {
            args[i++] = "-c" + changelistId;
        }
        if (forceUpdate) {
            args[i++] = "-f";
        }
        if (replace) {
            args[i++] = "-r";
        }
        if (discard) {
            args[i++] = "-d";
        }
        Map<String, Object>[] resultsMap = this.serverImpl.execMapCmd(CmdSpec.SHELVE, Server.getPreferredPathArray(args, fileSpecs), null);
        ArrayList<IFileSpec> resultList = new ArrayList<IFileSpec>();
        if (resultsMap != null) {
            for (Map<String, Object> result : resultsMap) {
                resultList.add(this.serverImpl.handleFileReturn(result, this));
            }
        }
        return resultList;
    }

    @Override
    public List<IFileSpec> shelveChangelist(IChangelist list) throws ConnectionException, RequestException, AccessException {
        if (list == null) {
            throw new NullPointerError("Null changelist specification in shelveChangelist method call");
        }
        Map<String, Object>[] resultsMap = this.serverImpl.execMapCmd(CmdSpec.SHELVE, new String[]{"-i"}, InputMapper.map(list, true));
        ArrayList<IFileSpec> resultList = new ArrayList<IFileSpec>();
        if (resultsMap != null) {
            for (Map<String, Object> result : resultsMap) {
                resultList.add(this.serverImpl.handleFileReturn(result, this));
            }
        }
        return resultList;
    }

    @Override
    public List<IFileSpec> unshelveChangelist(int shelveChangelistId, List<IFileSpec> fileSpecs, int clientChangelistId, boolean forceOverwrite, boolean previewOnly) throws ConnectionException, RequestException, AccessException {
        int argCount = 1;
        if (shelveChangelistId <= 0) {
            throw new RequestException("Shelve changelist ID must be greater than zero");
        }
        if (clientChangelistId > 0 || clientChangelistId == 0) {
            ++argCount;
        }
        if (previewOnly) {
            ++argCount;
        }
        if (forceOverwrite) {
            ++argCount;
        }
        String[] args = new String[argCount];
        args[0] = "-s" + shelveChangelistId;
        int i = 1;
        if (clientChangelistId == 0) {
            args[i++] = "-cdefault";
        } else if (clientChangelistId > 0) {
            args[i++] = "-c" + clientChangelistId;
        }
        if (forceOverwrite) {
            args[i++] = "-f";
        }
        if (previewOnly) {
            args[i++] = "-n";
        }
        Map<String, Object>[] resultsMap = this.serverImpl.execMapCmd(CmdSpec.UNSHELVE, Server.getPreferredPathArray(args, fileSpecs), null);
        ArrayList<IFileSpec> resultList = new ArrayList<IFileSpec>();
        if (resultsMap != null) {
            for (Map<String, Object> result : resultsMap) {
                resultList.add(this.serverImpl.handleFileReturn(result, this));
            }
        }
        return resultList;
    }
}

