/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.generic.core;

import com.perforce.p4java.core.IJob;
import com.perforce.p4java.core.IJobSpec;
import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.NullPointerError;
import com.perforce.p4java.exception.RequestException;
import com.perforce.p4java.impl.generic.core.ServerResource;
import com.perforce.p4java.server.IServer;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Job
extends ServerResource
implements IJob {
    public int SHORT_DESCR_LENGTH = 128;
    private String id = null;
    private Map<String, Object> rawFields = null;
    private String description = null;
    private IJobSpec jobSpec = null;

    public Job(IServer server, Map<String, Object> map) {
        this(server, map, false);
    }

    public Job(IServer server, Map<String, Object> map, boolean longDescriptions) {
        super(true, true);
        this.server = server;
        this.rawFields = map;
        if (map != null) {
            this.id = this.getJobIdString(map);
            this.description = this.getDescriptionString(map, longDescriptions);
        }
    }

    @Override
    public void refresh() throws ConnectionException, RequestException, AccessException {
        IJob refreshedJob;
        IServer refreshServer = this.server;
        String refreshId = this.id;
        if (refreshServer != null && refreshId != null && (refreshedJob = refreshServer.getJob(refreshId)) != null) {
            this.description = refreshedJob.getDescription();
            this.rawFields = refreshedJob.getRawFields();
        }
    }

    @Override
    public String updateOnServer() throws ConnectionException, RequestException, AccessException {
        if (this.server == null) {
            throw new NullPointerError("Null server field in Job.updateOnServer");
        }
        return this.server.updateJob(this);
    }

    @Override
    public void update() throws ConnectionException, RequestException, AccessException {
        this.server.updateJob(this);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public IJobSpec getJobSpec() {
        return this.jobSpec;
    }

    @Override
    public Map<String, Object> getRawFields() {
        return this.rawFields;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void setRawFields(Map<String, Object> rawFields) {
        this.rawFields = rawFields;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void setJobSpec(IJobSpec jobSpec) {
        this.jobSpec = jobSpec;
    }

    protected String getJobIdString(Map<String, Object> map) {
        String candidate = (String)map.get("Job");
        if (candidate == null && (candidate = (String)map.get("job")) == null) {
            candidate = (String)map.get("JobId");
        }
        return candidate;
    }

    protected String getDescriptionString(Map<String, Object> map, boolean longDescriptions) {
        String candidate = (String)map.get("Description");
        if (candidate == null && (candidate = (String)map.get("description")) == null) {
            candidate = (String)map.get("Desc");
        }
        if (candidate != null && !longDescriptions && candidate.length() > this.SHORT_DESCR_LENGTH) {
            return candidate.substring(0, this.SHORT_DESCR_LENGTH - 1);
        }
        return candidate;
    }
}

