/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.generic.core;

import com.perforce.p4java.Log;
import com.perforce.p4java.core.IBranchMapping;
import com.perforce.p4java.core.IBranchSpec;
import com.perforce.p4java.core.IBranchSpecSummary;
import com.perforce.p4java.core.ViewMap;
import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.RequestException;
import com.perforce.p4java.impl.generic.core.BranchSpecSummary;
import com.perforce.p4java.impl.generic.core.MapEntry;
import com.perforce.p4java.server.IServer;
import java.util.Date;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BranchSpec
extends BranchSpecSummary
implements IBranchSpec {
    protected ViewMap<IBranchMapping> branchView = null;

    public BranchSpec() {
    }

    public BranchSpec(String name, String ownerName, String description, boolean locked, Date accessed, Date updated, ViewMap<IBranchMapping> branchView) {
        this.accessed = accessed;
        this.updated = updated;
        this.name = name;
        this.ownerName = ownerName;
        this.description = description;
        this.locked = locked;
        this.branchView = branchView;
    }

    public BranchSpec(Map<String, Object> map, IServer server) {
        super(map, false);
        this.server = server;
        this.branchView = new ViewMap();
        if (map != null) {
            String key = "View";
            int i = 0;
            while (map.containsKey(key + i)) {
                if (map.get(key + i) != null) {
                    try {
                        String[] matchStrs = MapEntry.parseViewMappingString((String)map.get(key + i));
                        this.branchView.getEntryList().add(new BranchViewMapping(i, matchStrs[0], matchStrs[1]));
                    }
                    catch (Throwable thr) {
                        Log.error("Unexpected exception in BranchSpec map-based constructor: " + thr.getLocalizedMessage());
                        Log.exception(thr);
                    }
                }
                ++i;
            }
        }
    }

    public BranchSpec(IBranchSpecSummary summary) throws ConnectionException, RequestException, AccessException {
        super(false);
        this.branchView = new ViewMap();
        if (summary != null) {
            this.setName(summary.getName());
            if (this.getName() != null) {
                this.refresh();
            }
        }
    }

    private void updateFlags() {
    }

    @Override
    public void refresh() throws ConnectionException, RequestException, AccessException {
        IBranchSpec refreshedBranch;
        IServer refreshServer = this.server;
        String refreshName = this.name;
        if (refreshServer != null && refreshName != null && (refreshedBranch = refreshServer.getBranchSpec(refreshName)) != null) {
            this.name = refreshedBranch.getName();
            this.accessed = refreshedBranch.getAccessed();
            this.updated = refreshedBranch.getUpdated();
            this.branchView = refreshedBranch.getBranchView();
            this.description = refreshedBranch.getDescription();
            this.ownerName = refreshedBranch.getOwnerName();
            this.locked = refreshedBranch.isLocked();
        }
        this.updateFlags();
    }

    @Override
    public void update() throws ConnectionException, RequestException, AccessException {
        this.server.updateBranchSpec(this);
    }

    @Override
    public ViewMap<IBranchMapping> getBranchView() {
        return this.branchView;
    }

    @Override
    public void setBranchView(ViewMap<IBranchMapping> branchView) {
        this.branchView = branchView;
    }

    public static class BranchViewMapping
    extends MapEntry
    implements IBranchMapping {
        public BranchViewMapping() {
        }

        public BranchViewMapping(int order, String sourceSpec, String targetSpec) {
            super(order, sourceSpec, targetSpec);
        }

        public BranchViewMapping(int order, String viewString) {
            super(order, viewString);
        }

        public String getSourceSpec() {
            return this.left;
        }

        public void setSourceSpec(String sourceSpec) {
            this.left = sourceSpec;
        }

        public String getTargetSpec() {
            return this.right;
        }

        public void setTargetSpec(String targetSpec) {
            this.right = targetSpec;
        }
    }
}

