package com.paystack.android.ui.utilities

import kotlinx.coroutines.delay
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow

internal class CountdownTimer {

    /**
     * Starts a flow that emits the remaining time in milliseconds until the duration is reached.
     *
     * @param durationMs The duration in milliseconds.
     * @param interval The interval in milliseconds at which the flow emits.
     * @return A flow that emits the remaining time in milliseconds until the duration is reached.
     */
    fun start(durationMs: Int, intervalMs: Int = 1000): Flow<Int> {
        return flow {
            var remainingTimeMs = durationMs
            while (true) {
                delay(intervalMs.toLong())
                remainingTimeMs -= intervalMs

                if (remainingTimeMs < intervalMs) {
                    emit(0)
                    break
                }

                emit(remainingTimeMs)
            }
        }
    }
}
