package com.paystack.android.ui.theme

import androidx.compose.foundation.shape.CornerBasedShape
import androidx.compose.foundation.shape.RoundedCornerShape
import androidx.compose.runtime.Composable
import androidx.compose.runtime.Immutable
import androidx.compose.runtime.ReadOnlyComposable
import androidx.compose.runtime.staticCompositionLocalOf
import androidx.compose.ui.unit.dp
import com.paystack.androiddesignsystem.PaystackTheme

internal val PaymentSheetShape: CornerBasedShape
    @Composable get() = LocalPaystackShapes.current.modal

internal val PaystackTheme.shapes: PaystackShapes
    @Composable
    @ReadOnlyComposable
    get() = LocalPaystackShapes.current

@Immutable
internal data class PaystackShapes(
    val small: CornerBasedShape = RoundedCornerShape(2.dp),
    val medium: CornerBasedShape = RoundedCornerShape(4.dp),
    val large: CornerBasedShape = RoundedCornerShape(8.dp),
    val modal: CornerBasedShape = RoundedCornerShape(6.dp),
    val textField: CornerBasedShape = RoundedCornerShape(8.dp),
    val badge: CornerBasedShape = RoundedCornerShape(3.dp)
)

internal val LocalPaystackShapes = staticCompositionLocalOf { PaystackShapes() }
