package com.paystack.android.ui.paymentchannels.mobilemoney.mpesa

import androidx.compose.foundation.layout.padding
import androidx.compose.runtime.Composable
import androidx.compose.runtime.CompositionLocalProvider
import androidx.compose.runtime.collectAsState
import androidx.compose.runtime.getValue
import androidx.compose.ui.Modifier
import androidx.compose.ui.res.stringResource
import androidx.lifecycle.viewmodel.compose.LocalViewModelStoreOwner
import androidx.lifecycle.viewmodel.compose.viewModel
import com.paystack.android.ui.R
import com.paystack.android.ui.components.LoadingScreen
import com.paystack.android.ui.components.PaymentErrorUi
import com.paystack.android.ui.paymentchannels.mobilemoney.MobileMoneyViewModelProviderFactory
import com.paystack.android.ui.paymentchannels.mobilemoney.mpesa.inprogress.MpesaProgressUi
import com.paystack.android.ui.paymentchannels.mobilemoney.mpesa.numberform.MpesaNumberFormUi
import com.paystack.androiddesignsystem.PaystackTheme

@Composable
internal fun MpesaScreen(
    viewModelsProviderFactory: MobileMoneyViewModelProviderFactory,
    modifier: Modifier = Modifier,
) {
    val viewModel: MpesaViewModel = viewModel(factory = viewModelsProviderFactory)
    val mpesaPaymentsState by viewModel.mpesaPaymentsState.collectAsState()

    CompositionLocalProvider(
        LocalViewModelStoreOwner provides viewModel.mpesaFlowViewModelStoreOwner
    ) {

        when (val state = mpesaPaymentsState) {
            MpesaPaymentState.EnterNumber -> MpesaNumberFormUi(
                viewModelsProviderFactory = viewModelsProviderFactory,
                modifier = modifier.padding(horizontal = PaystackTheme.dimensions.spacing.double),
                onResult = viewModel::processResult
            )

            is MpesaPaymentState.InProgress -> MpesaProgressUi(
                phoneNumber = state.phoneNumber,
                instruction = state.instruction,
                timeLeftMs = state.timeLeftMs,
                timeAllowedMs = state.requeryDelayMs,
                modifier = modifier
            )

            MpesaPaymentState.VerifyingPayment -> LoadingScreen(
                message = stringResource(R.string.pstk_checking_transaction_status),
                modifier = modifier,
            )

            is MpesaPaymentState.Error -> PaymentErrorUi(
                message = state.message,
                modifier = modifier
            )
        }
    }
}
