package com.paystack.android.ui.paymentchannels.card.cardform.views

import com.paystack.android.ui.paymentchannels.card.cardform.models.CardFormData
import com.paystack.android.ui.paymentchannels.card.cardform.models.TestCard

internal data class CardDetailsState(
    val currency: String,
    val amount: Long,
    val cardData: CardFormData = CardFormData(),
    val isTestTransaction: Boolean = false,
    val showTestCards: Boolean = false,
    val selectedTestCardIndex: Int? = null,
    val isSubmitting: Boolean = false,
) {
    val testCards: List<TestCard> = TestCard.all()

    val selectedTestCard: TestCard?
        get() = selectedTestCardIndex?.let { testCards[it] }

    val payButtonEnabled: Boolean
        get() = if (showTestCards) {
            selectedTestCardIndex != null
        } else {
            cardData.isValid
        }
}
