package com.paystack.android.ui.paymentchannels.card.cardform

import androidx.compose.animation.AnimatedVisibility
import androidx.compose.animation.fadeIn
import androidx.compose.animation.fadeOut
import androidx.compose.foundation.Image
import androidx.compose.foundation.border
import androidx.compose.foundation.clickable
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.width
import androidx.compose.foundation.shape.RoundedCornerShape
import androidx.compose.material3.RadioButton
import androidx.compose.material3.RadioButtonDefaults
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.draw.clip
import androidx.compose.ui.res.painterResource
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.unit.dp
import com.paystack.android.ui.components.views.inputs.validators.CardType
import com.paystack.android.ui.paymentchannels.card.cardform.models.TestCard
import com.paystack.androiddesignsystem.PaystackTheme

@Composable
internal fun TestCardList(
    testCards: List<TestCard>,
    selectedIndex: Int?,
    onCardSelected: (index: Int) -> Unit,
    modifier: Modifier = Modifier,
) {
    Column(
        modifier = modifier,
        verticalArrangement = Arrangement.spacedBy(PaystackTheme.dimensions.spacing.double)
    ) {
        testCards.forEachIndexed { index, card ->
            TestCardItem(
                testCard = card,
                isSelected = index == selectedIndex,
                modifier = Modifier.clickable { onCardSelected(index) }
            )
        }
    }
}

@Composable
private fun TestCardItem(
    testCard: TestCard,
    isSelected: Boolean,
    modifier: Modifier = Modifier,
) {
    val shape = RoundedCornerShape(PaystackTheme.dimensions.borderRadius.large)
    Row(
        horizontalArrangement = Arrangement.spacedBy(PaystackTheme.dimensions.spacing.single),
        verticalAlignment = Alignment.CenterVertically,
        modifier = Modifier
            .border(1.dp, PaystackTheme.colors.neutralColors.silver, shape)
            .clip(shape)
            .then(modifier)
            .padding(PaystackTheme.dimensions.spacing.double),
    ) {
        RadioButton(
            selected = isSelected,
            onClick = null,
            colors = RadioButtonDefaults.colors(
                selectedColor = PaystackTheme.colors.secondaryColors.stackGreen,
                unselectedColor = PaystackTheme.colors.primaryColors.navy01,
            )
        )
        Text(
            text = stringResource(testCard.nameRes),
            modifier = Modifier.weight(1f),
            style = PaystackTheme.typography.body.body14R,
        )
        AnimatedVisibility(
            visible = isSelected && testCard.cardScheme != CardType.UNKNOWN,
            enter = fadeIn(),
            exit = fadeOut(),
        ) {
            Image(
                painter = painterResource(testCard.cardScheme.logoRes),
                contentDescription = stringResource(testCard.cardScheme.nameRes),
                modifier = Modifier.width(PaystackTheme.dimensions.spacing.quad)
            )
        }
    }
}
